/*
 * Copyright 2010-2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics;

import com.amazonaws.AmazonClientException;

/**
 * An error which represents that MobileAnalyticsManager could not be initialized for any reason.
 */
public class InitializationException extends AmazonClientException {
    private static final long serialVersionUID = 2413377589460950524L;
    
    public InitializationException(String message) {
        super(message);
    }
    public InitializationException(String message, Throwable cause) {
        super(message, cause);
    }
}
