/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.IBinder;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.mobileconnectors.s3.transferutility.S3ClientReference;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferRecord;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferStatusUpdater;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferType;
import com.amazonaws.services.s3.AmazonS3;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;

public class TransferService
extends Service {
    private static final Log LOGGER = LogFactory.getLog(TransferService.class);
    static NetworkInfoReceiver networkInfoReceiver;
    boolean isReceiverNotRegistered = true;
    private TransferDBUtil dbUtil;
    TransferStatusUpdater updater;
    private static final Object LOCK;

    public IBinder onBind(Intent intent) {
        throw new UnsupportedOperationException("Can't bind to TransferService");
    }

    public void onCreate() {
        super.onCreate();
        LOGGER.info((Object)"Starting Transfer Service to listen for network connectivity changes");
        this.dbUtil = new TransferDBUtil((Context)this);
        this.updater = TransferStatusUpdater.getInstance((Context)this);
        networkInfoReceiver = new NetworkInfoReceiver(this.getApplicationContext());
        if (this.isReceiverNotRegistered) {
            try {
                LOGGER.info((Object)"Registering the network receiver");
                this.registerReceiver(networkInfoReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
            }
            catch (IllegalArgumentException iae) {
                LOGGER.warn((Object)"Ignoring the exception trying to register the receiver for connectivity change.");
            }
            catch (IllegalStateException ise) {
                LOGGER.warn((Object)"Ignoring the leak in registering the receiver.");
            }
            finally {
                this.isReceiverNotRegistered = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onStartCommand(Intent intent, int flags, int startId) {
        if (this.isReceiverNotRegistered) {
            try {
                LOGGER.info((Object)"Registering the network receiver");
                this.registerReceiver(networkInfoReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
            }
            catch (IllegalArgumentException iae) {
                LOGGER.warn((Object)"Ignoring the exception trying to register the receiver for connectivity change.");
            }
            catch (IllegalStateException ise) {
                LOGGER.warn((Object)"Ignoring the leak in registering the receiver.");
            }
            finally {
                this.isReceiverNotRegistered = false;
            }
        }
        return 1;
    }

    public void onDestroy() {
        try {
            if (networkInfoReceiver != null) {
                LOGGER.info((Object)"Unregistering the network receiver");
                this.unregisterReceiver(networkInfoReceiver);
                this.isReceiverNotRegistered = true;
                networkInfoReceiver = null;
            }
        }
        catch (IllegalArgumentException iae) {
            LOGGER.warn((Object)"Exception trying to unregister the service");
        }
        super.onDestroy();
    }

    void checkTransfersOnNetworkReconnect() {
        if (networkInfoReceiver.isNetworkConnected()) {
            this.loadAndResumeTransfersFromDB(new TransferState[]{TransferState.WAITING_FOR_NETWORK});
        } else {
            LOGGER.error((Object)"Network Connect message received but not connected to network.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadAndResumeTransfersFromDB(TransferState[] transferStates) {
        LOGGER.debug((Object)"Loading transfers from database...");
        Object object = LOCK;
        synchronized (object) {
            Cursor c = null;
            int count = 0;
            ArrayList<Integer> transferIds = new ArrayList<Integer>();
            try {
                c = this.dbUtil.queryTransfersWithTypeAndStates(TransferType.ANY, transferStates);
                while (c.moveToNext()) {
                    int id = c.getInt(c.getColumnIndexOrThrow("_id"));
                    if (this.updater.getTransfer(id) == null) {
                        TransferRecord transfer = new TransferRecord(id);
                        transfer.updateFromDB(c);
                        this.updater.addTransfer(transfer);
                        ++count;
                    }
                    transferIds.add(id);
                }
            }
            finally {
                if (c != null) {
                    LOGGER.debug((Object)"Closing the cursor for loadAndResumeTransfersFromDB");
                    c.close();
                }
            }
            try {
                for (Integer id : transferIds) {
                    TransferRecord transfer;
                    AmazonS3 s3 = S3ClientReference.get(id);
                    if (s3 == null || (transfer = this.updater.getTransfer(id)) == null || transfer.isRunning()) continue;
                    transfer.start(s3, this.dbUtil, this.updater);
                }
            }
            catch (Exception exception) {
                LOGGER.error((Object)("Error in resuming the transfers." + exception.getMessage()));
            }
            LOGGER.debug((Object)(count + " transfers are loaded from database."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pauseAllForNetwork() {
        Object object = LOCK;
        synchronized (object) {
            for (TransferRecord transferRecord : this.updater.getTransfers().values()) {
                AmazonS3 s3 = S3ClientReference.get(transferRecord.id);
                if (s3 == null || transferRecord == null || !transferRecord.pause(s3, this.updater)) continue;
                this.updater.updateState(transferRecord.id, TransferState.WAITING_FOR_NETWORK);
            }
        }
    }

    protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        if ((this.getApplicationInfo().flags & 2) == 0) {
            return;
        }
        writer.printf("network status: %s\n", networkInfoReceiver.isNetworkConnected());
        Map<Integer, TransferRecord> transfers = this.updater.getTransfers();
        writer.printf("# of active transfers: %d\n", transfers.size());
        for (TransferRecord transfer : transfers.values()) {
            writer.printf("bucket: %s, key: %s, status: %s, total size: %d, current: %d\n", new Object[]{transfer.bucketName, transfer.key, transfer.state, transfer.bytesTotal, transfer.bytesCurrent});
        }
        writer.flush();
    }

    static {
        LOCK = new Object();
    }

    class NetworkInfoReceiver
    extends BroadcastReceiver {
        private final ConnectivityManager connManager;

        public NetworkInfoReceiver(Context context) {
            this.connManager = (ConnectivityManager)context.getSystemService("connectivity");
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
                LOGGER.info((Object)"Network connectivity changed detected.");
                final boolean networkConnected = this.isNetworkConnected();
                LOGGER.info((Object)("Network connected: " + networkConnected));
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (networkConnected) {
                            TransferService.this.checkTransfersOnNetworkReconnect();
                        } else {
                            TransferService.this.pauseAllForNetwork();
                        }
                    }
                }).start();
            }
        }

        boolean isNetworkConnected() {
            NetworkInfo info = this.connManager.getActiveNetworkInfo();
            return info != null && info.isConnected();
        }
    }
}

