/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticache.model.CreateCacheClusterRequest;
import com.amazonaws.services.elasticache.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateCacheClusterRequestMarshaller
implements Marshaller<Request<CreateCacheClusterRequest>, CreateCacheClusterRequest> {
    public Request<CreateCacheClusterRequest> marshall(CreateCacheClusterRequest createCacheClusterRequest) {
        if (createCacheClusterRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createCacheClusterRequest, "AmazonElastiCache");
        request.addParameter("Action", "CreateCacheCluster");
        request.addParameter("Version", "2015-02-02");
        if (createCacheClusterRequest.getCacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringUtils.fromString((String)createCacheClusterRequest.getCacheClusterId()));
        }
        if (createCacheClusterRequest.getReplicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString((String)createCacheClusterRequest.getReplicationGroupId()));
        }
        if (createCacheClusterRequest.getAZMode() != null) {
            request.addParameter("AZMode", StringUtils.fromString((String)createCacheClusterRequest.getAZMode()));
        }
        if (createCacheClusterRequest.getPreferredAvailabilityZone() != null) {
            request.addParameter("PreferredAvailabilityZone", StringUtils.fromString((String)createCacheClusterRequest.getPreferredAvailabilityZone()));
        }
        List<String> preferredAvailabilityZonesList = createCacheClusterRequest.getPreferredAvailabilityZones();
        int preferredAvailabilityZonesListIndex = 1;
        for (String preferredAvailabilityZonesListValue : preferredAvailabilityZonesList) {
            if (preferredAvailabilityZonesListValue != null) {
                request.addParameter("PreferredAvailabilityZones.PreferredAvailabilityZone." + preferredAvailabilityZonesListIndex, StringUtils.fromString((String)preferredAvailabilityZonesListValue));
            }
            ++preferredAvailabilityZonesListIndex;
        }
        if (createCacheClusterRequest.getNumCacheNodes() != null) {
            request.addParameter("NumCacheNodes", StringUtils.fromInteger((Integer)createCacheClusterRequest.getNumCacheNodes()));
        }
        if (createCacheClusterRequest.getCacheNodeType() != null) {
            request.addParameter("CacheNodeType", StringUtils.fromString((String)createCacheClusterRequest.getCacheNodeType()));
        }
        if (createCacheClusterRequest.getEngine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)createCacheClusterRequest.getEngine()));
        }
        if (createCacheClusterRequest.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)createCacheClusterRequest.getEngineVersion()));
        }
        if (createCacheClusterRequest.getCacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringUtils.fromString((String)createCacheClusterRequest.getCacheParameterGroupName()));
        }
        if (createCacheClusterRequest.getCacheSubnetGroupName() != null) {
            request.addParameter("CacheSubnetGroupName", StringUtils.fromString((String)createCacheClusterRequest.getCacheSubnetGroupName()));
        }
        List<String> cacheSecurityGroupNamesList = createCacheClusterRequest.getCacheSecurityGroupNames();
        int cacheSecurityGroupNamesListIndex = 1;
        for (String cacheSecurityGroupNamesListValue : cacheSecurityGroupNamesList) {
            if (cacheSecurityGroupNamesListValue != null) {
                request.addParameter("CacheSecurityGroupNames.CacheSecurityGroupName." + cacheSecurityGroupNamesListIndex, StringUtils.fromString((String)cacheSecurityGroupNamesListValue));
            }
            ++cacheSecurityGroupNamesListIndex;
        }
        List<String> securityGroupIdsList = createCacheClusterRequest.getSecurityGroupIds();
        int securityGroupIdsListIndex = 1;
        for (String securityGroupIdsListValue : securityGroupIdsList) {
            if (securityGroupIdsListValue != null) {
                request.addParameter("SecurityGroupIds.SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString((String)securityGroupIdsListValue));
            }
            ++securityGroupIdsListIndex;
        }
        List<Tag> tagsList = createCacheClusterRequest.getTags();
        int tagsListIndex = 1;
        for (Tag tagsListValue : tagsList) {
            Tag tagMember = tagsListValue;
            if (tagMember != null) {
                if (tagMember.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagMember.getKey()));
                }
                if (tagMember.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagMember.getValue()));
                }
            }
            ++tagsListIndex;
        }
        List<String> snapshotArnsList = createCacheClusterRequest.getSnapshotArns();
        int snapshotArnsListIndex = 1;
        for (String snapshotArnsListValue : snapshotArnsList) {
            if (snapshotArnsListValue != null) {
                request.addParameter("SnapshotArns.SnapshotArn." + snapshotArnsListIndex, StringUtils.fromString((String)snapshotArnsListValue));
            }
            ++snapshotArnsListIndex;
        }
        if (createCacheClusterRequest.getSnapshotName() != null) {
            request.addParameter("SnapshotName", StringUtils.fromString((String)createCacheClusterRequest.getSnapshotName()));
        }
        if (createCacheClusterRequest.getPreferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)createCacheClusterRequest.getPreferredMaintenanceWindow()));
        }
        if (createCacheClusterRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)createCacheClusterRequest.getPort()));
        }
        if (createCacheClusterRequest.getNotificationTopicArn() != null) {
            request.addParameter("NotificationTopicArn", StringUtils.fromString((String)createCacheClusterRequest.getNotificationTopicArn()));
        }
        if (createCacheClusterRequest.isAutoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean((Boolean)createCacheClusterRequest.isAutoMinorVersionUpgrade()));
        }
        if (createCacheClusterRequest.getSnapshotRetentionLimit() != null) {
            request.addParameter("SnapshotRetentionLimit", StringUtils.fromInteger((Integer)createCacheClusterRequest.getSnapshotRetentionLimit()));
        }
        if (createCacheClusterRequest.getSnapshotWindow() != null) {
            request.addParameter("SnapshotWindow", StringUtils.fromString((String)createCacheClusterRequest.getSnapshotWindow()));
        }
        return request;
    }
}

