/*
 * Decompiled with CFR 0.152.
 */
package com.amplitude.api;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.location.Location;
import android.os.Build;
import android.util.Pair;
import com.amplitude.api.AmplitudeCallbacks;
import com.amplitude.api.AmplitudeDeviceIdCallback;
import com.amplitude.api.AmplitudeLog;
import com.amplitude.api.AmplitudeLogCallback;
import com.amplitude.api.AmplitudeServerZone;
import com.amplitude.api.ConfigManager;
import com.amplitude.api.CursorWindowAllocationException;
import com.amplitude.api.DatabaseHelper;
import com.amplitude.api.DatabaseResetListener;
import com.amplitude.api.DeviceInfo;
import com.amplitude.api.Identify;
import com.amplitude.api.Middleware;
import com.amplitude.api.MiddlewareExtra;
import com.amplitude.api.MiddlewarePayload;
import com.amplitude.api.MiddlewareRunner;
import com.amplitude.api.Plan;
import com.amplitude.api.Revenue;
import com.amplitude.api.TrackingOptions;
import com.amplitude.api.Utils;
import com.amplitude.api.WorkerThread;
import com.amplitude.eventexplorer.EventExplorer;
import com.amplitude.security.MD5;
import com.amplitude.util.DoubleCheck;
import com.amplitude.util.Provider;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AmplitudeClient {
    private static final String TAG = AmplitudeClient.class.getName();
    public static final String START_SESSION_EVENT = "session_start";
    public static final String END_SESSION_EVENT = "session_end";
    public static final String DEVICE_ID_KEY = "device_id";
    public static final String USER_ID_KEY = "user_id";
    public static final String OPT_OUT_KEY = "opt_out";
    public static final String SEQUENCE_NUMBER_KEY = "sequence_number";
    public static final String LAST_EVENT_TIME_KEY = "last_event_time";
    public static final String LAST_EVENT_ID_KEY = "last_event_id";
    public static final String LAST_IDENTIFY_ID_KEY = "last_identify_id";
    public static final String PREVIOUS_SESSION_ID_KEY = "previous_session_id";
    private static final AmplitudeLog logger = AmplitudeLog.getLogger();
    protected Context context;
    protected Call.Factory callFactory;
    protected DatabaseHelper dbHelper;
    protected String apiKey;
    protected String instanceName;
    protected String userId;
    protected String deviceId;
    private boolean newDeviceIdPerInstall = false;
    private boolean useAdvertisingIdForDeviceId = false;
    private boolean useAppSetIdForDeviceId = false;
    protected boolean initialized = false;
    private AmplitudeDeviceIdCallback deviceIdCallback;
    private boolean optOut = false;
    private boolean offline = false;
    TrackingOptions inputTrackingOptions = new TrackingOptions();
    TrackingOptions appliedTrackingOptions = TrackingOptions.copyOf(this.inputTrackingOptions);
    JSONObject apiPropertiesTrackingOptions = this.appliedTrackingOptions.getApiPropertiesTrackingOptions();
    private boolean coppaControlEnabled = false;
    private boolean locationListening = true;
    private EventExplorer eventExplorer;
    private Plan plan;
    private AmplitudeServerZone serverZone = AmplitudeServerZone.US;
    protected String platform;
    long sessionId = -1L;
    long sequenceNumber = 0L;
    long lastEventId = -1L;
    long lastIdentifyId = -1L;
    long lastEventTime = -1L;
    long previousSessionId = -1L;
    protected DeviceInfo deviceInfo;
    private int eventUploadThreshold = 30;
    private int eventUploadMaxBatchSize = 50;
    private int eventMaxCount = 1000;
    private long eventUploadPeriodMillis = 30000L;
    private long minTimeBetweenSessionsMillis = 300000L;
    private long sessionTimeoutMillis = 1800000L;
    private boolean backoffUpload = false;
    private int backoffUploadBatchSize = this.eventUploadMaxBatchSize;
    private boolean usingForegroundTracking = false;
    private boolean trackingSessionEvents = false;
    private boolean inForeground = false;
    private boolean flushEventsOnClose = true;
    private String libraryName = "amplitude-android";
    private String libraryVersion = "2.35.0";
    private boolean useDynamicConfig = false;
    private AtomicBoolean updateScheduled = new AtomicBoolean(false);
    AtomicBoolean uploadingCurrently = new AtomicBoolean(false);
    Throwable lastError;
    String url = "https://api2.amplitude.com/";
    String bearerToken = null;
    WorkerThread logThread = new WorkerThread("logThread");
    WorkerThread httpThread = new WorkerThread("httpThread");
    MiddlewareRunner middlewareRunner = new MiddlewareRunner();

    public AmplitudeClient() {
        this(null);
    }

    public AmplitudeClient(String instance) {
        this.instanceName = Utils.normalizeInstanceName(instance);
        this.logThread.start();
        this.httpThread.start();
    }

    public AmplitudeClient initialize(Context context, String apiKey) {
        return this.initialize(context, apiKey, null);
    }

    public AmplitudeClient initialize(Context context, String apiKey, String userId) {
        return this.initialize(context, apiKey, userId, null, false);
    }

    public synchronized AmplitudeClient initialize(Context context, String apiKey, String userId, String platform, boolean enableDiagnosticLogging) {
        return this.initializeInternal(context, apiKey, userId, platform, enableDiagnosticLogging, null);
    }

    public synchronized AmplitudeClient initialize(Context context, String apiKey, String userId, String platform, boolean enableDiagnosticLogging, Call.Factory callFactory) {
        return this.initializeInternal(context, apiKey, userId, platform, enableDiagnosticLogging, callFactory);
    }

    public synchronized AmplitudeClient initializeInternal(Context context, String apiKey, String userId, String platform, boolean enableDiagnosticLogging, Call.Factory callFactory) {
        if (context == null) {
            logger.e(TAG, "Argument context cannot be null in initialize()");
            return this;
        }
        if (Utils.isEmptyString(apiKey)) {
            logger.e(TAG, "Argument apiKey cannot be null or blank in initialize()");
            return this;
        }
        this.context = context.getApplicationContext();
        this.apiKey = apiKey;
        this.dbHelper = DatabaseHelper.getDatabaseHelper(this.context, this.instanceName);
        this.platform = Utils.isEmptyString(platform) ? "Android" : platform;
        final AmplitudeClient client = this;
        this.runOnLogThread(() -> {
            if (!this.initialized) {
                try {
                    if (callFactory == null) {
                        Provider callProvider = DoubleCheck.provider(OkHttpClient::new);
                        this.callFactory = request -> ((Call.Factory)callProvider.get()).newCall(request);
                    } else {
                        this.callFactory = callFactory;
                    }
                    if (this.useDynamicConfig) {
                        ConfigManager.getInstance().refresh(new ConfigManager.RefreshListener(){

                            @Override
                            public void onFinished() {
                                AmplitudeClient.this.url = ConfigManager.getInstance().getIngestionEndpoint();
                            }
                        }, this.serverZone);
                    }
                    this.deviceInfo = this.initializeDeviceInfo();
                    this.deviceId = this.initializeDeviceId();
                    if (this.deviceIdCallback != null) {
                        this.deviceIdCallback.onDeviceIdReady(this.deviceId);
                    }
                    this.deviceInfo.prefetch();
                    if (userId != null) {
                        client.userId = userId;
                        this.dbHelper.insertOrReplaceKeyValue(USER_ID_KEY, userId);
                    } else {
                        client.userId = this.dbHelper.getValue(USER_ID_KEY);
                    }
                    Long optOutLong = this.dbHelper.getLongValue(OPT_OUT_KEY);
                    this.optOut = optOutLong != null && optOutLong == 1L;
                    this.previousSessionId = this.getLongvalue(PREVIOUS_SESSION_ID_KEY, -1L);
                    if (this.previousSessionId >= 0L) {
                        this.sessionId = this.previousSessionId;
                    }
                    this.sequenceNumber = this.getLongvalue(SEQUENCE_NUMBER_KEY, 0L);
                    this.lastEventId = this.getLongvalue(LAST_EVENT_ID_KEY, -1L);
                    this.lastIdentifyId = this.getLongvalue(LAST_IDENTIFY_ID_KEY, -1L);
                    this.lastEventTime = this.getLongvalue(LAST_EVENT_TIME_KEY, -1L);
                    this.dbHelper.setDatabaseResetListener(new DatabaseResetListener(){

                        @Override
                        public void onDatabaseReset(SQLiteDatabase db) {
                            AmplitudeClient.this.dbHelper.insertOrReplaceKeyValueToTable(db, "store", AmplitudeClient.DEVICE_ID_KEY, client.deviceId);
                            AmplitudeClient.this.dbHelper.insertOrReplaceKeyValueToTable(db, "store", AmplitudeClient.USER_ID_KEY, client.userId);
                            AmplitudeClient.this.dbHelper.insertOrReplaceKeyValueToTable(db, "long_store", AmplitudeClient.OPT_OUT_KEY, client.optOut ? 1L : 0L);
                            AmplitudeClient.this.dbHelper.insertOrReplaceKeyValueToTable(db, "long_store", AmplitudeClient.PREVIOUS_SESSION_ID_KEY, client.sessionId);
                            AmplitudeClient.this.dbHelper.insertOrReplaceKeyValueToTable(db, "long_store", AmplitudeClient.LAST_EVENT_TIME_KEY, client.lastEventTime);
                        }
                    });
                    this.initialized = true;
                }
                catch (CursorWindowAllocationException e) {
                    logger.e(TAG, String.format("Failed to initialize Amplitude SDK due to: %s", e.getMessage()));
                    client.apiKey = null;
                }
            }
        });
        return this;
    }

    public AmplitudeClient enableForegroundTracking(Application app) {
        if (this.usingForegroundTracking || !this.contextAndApiKeySet("enableForegroundTracking()")) {
            return this;
        }
        if (Build.VERSION.SDK_INT >= 14) {
            app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new AmplitudeCallbacks(this));
        }
        return this;
    }

    public AmplitudeClient enableDiagnosticLogging() {
        return this;
    }

    public AmplitudeClient disableDiagnosticLogging() {
        return this;
    }

    public AmplitudeClient setDiagnosticEventMaxCount(int eventMaxCount) {
        return this;
    }

    public AmplitudeClient enableNewDeviceIdPerInstall(boolean newDeviceIdPerInstall) {
        this.newDeviceIdPerInstall = newDeviceIdPerInstall;
        return this;
    }

    public AmplitudeClient useAdvertisingIdForDeviceId() {
        this.useAdvertisingIdForDeviceId = true;
        return this;
    }

    public AmplitudeClient useAppSetIdForDeviceId() {
        this.useAppSetIdForDeviceId = true;
        return this;
    }

    public AmplitudeClient enableLocationListening() {
        this.locationListening = true;
        if (this.deviceInfo != null) {
            this.deviceInfo.setLocationListening(true);
        }
        return this;
    }

    public AmplitudeClient disableLocationListening() {
        this.locationListening = false;
        if (this.deviceInfo != null) {
            this.deviceInfo.setLocationListening(false);
        }
        return this;
    }

    public AmplitudeClient setEventUploadThreshold(int eventUploadThreshold) {
        this.eventUploadThreshold = eventUploadThreshold;
        return this;
    }

    public AmplitudeClient setEventUploadMaxBatchSize(int eventUploadMaxBatchSize) {
        this.eventUploadMaxBatchSize = eventUploadMaxBatchSize;
        this.backoffUploadBatchSize = eventUploadMaxBatchSize;
        return this;
    }

    public AmplitudeClient setEventMaxCount(int eventMaxCount) {
        this.eventMaxCount = eventMaxCount;
        return this;
    }

    public AmplitudeClient setEventUploadPeriodMillis(int eventUploadPeriodMillis) {
        this.eventUploadPeriodMillis = eventUploadPeriodMillis;
        return this;
    }

    public AmplitudeClient setMinTimeBetweenSessionsMillis(long minTimeBetweenSessionsMillis) {
        this.minTimeBetweenSessionsMillis = minTimeBetweenSessionsMillis;
        return this;
    }

    public AmplitudeClient setServerUrl(String serverUrl) {
        if (!Utils.isEmptyString(serverUrl)) {
            this.url = serverUrl;
        }
        return this;
    }

    public AmplitudeClient setBearerToken(String token) {
        this.bearerToken = token;
        return this;
    }

    public AmplitudeClient setSessionTimeoutMillis(long sessionTimeoutMillis) {
        this.sessionTimeoutMillis = sessionTimeoutMillis;
        return this;
    }

    public AmplitudeClient setTrackingOptions(TrackingOptions trackingOptions) {
        this.inputTrackingOptions = trackingOptions;
        this.appliedTrackingOptions = TrackingOptions.copyOf(this.inputTrackingOptions);
        if (this.coppaControlEnabled) {
            this.appliedTrackingOptions.mergeIn(TrackingOptions.forCoppaControl());
        }
        this.apiPropertiesTrackingOptions = this.appliedTrackingOptions.getApiPropertiesTrackingOptions();
        return this;
    }

    public AmplitudeClient enableCoppaControl() {
        this.coppaControlEnabled = true;
        this.appliedTrackingOptions.mergeIn(TrackingOptions.forCoppaControl());
        this.apiPropertiesTrackingOptions = this.appliedTrackingOptions.getApiPropertiesTrackingOptions();
        return this;
    }

    public AmplitudeClient disableCoppaControl() {
        this.coppaControlEnabled = false;
        this.appliedTrackingOptions = TrackingOptions.copyOf(this.inputTrackingOptions);
        this.apiPropertiesTrackingOptions = this.appliedTrackingOptions.getApiPropertiesTrackingOptions();
        return this;
    }

    public AmplitudeClient setOptOut(final boolean optOut) {
        if (!this.contextAndApiKeySet("setOptOut()")) {
            return this;
        }
        final AmplitudeClient client = this;
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                if (Utils.isEmptyString(AmplitudeClient.this.apiKey)) {
                    return;
                }
                client.optOut = optOut;
                AmplitudeClient.this.dbHelper.insertOrReplaceKeyLongValue(AmplitudeClient.OPT_OUT_KEY, optOut ? 1L : 0L);
            }
        });
        return this;
    }

    public AmplitudeClient setLibraryName(String libraryName) {
        this.libraryName = libraryName;
        return this;
    }

    public AmplitudeClient setLibraryVersion(String libraryVersion) {
        this.libraryVersion = libraryVersion;
        return this;
    }

    public boolean isOptedOut() {
        return this.optOut;
    }

    public AmplitudeClient enableLogging(boolean enableLogging) {
        logger.setEnableLogging(enableLogging);
        return this;
    }

    public AmplitudeClient setLogLevel(int logLevel) {
        logger.setLogLevel(logLevel);
        return this;
    }

    public AmplitudeClient setLogCallback(AmplitudeLogCallback callback) {
        logger.setAmplitudeLogCallback(callback);
        return this;
    }

    public AmplitudeClient setOffline(boolean offline) {
        this.offline = offline;
        if (!offline) {
            this.uploadEvents();
        }
        return this;
    }

    public AmplitudeClient setFlushEventsOnClose(boolean flushEventsOnClose) {
        this.flushEventsOnClose = flushEventsOnClose;
        return this;
    }

    public AmplitudeClient trackSessionEvents(boolean trackingSessionEvents) {
        this.trackingSessionEvents = trackingSessionEvents;
        return this;
    }

    public AmplitudeClient setUseDynamicConfig(boolean useDynamicConfig) {
        this.useDynamicConfig = useDynamicConfig;
        return this;
    }

    public void showEventExplorer(Activity activity) {
        if (this.eventExplorer == null) {
            this.eventExplorer = new EventExplorer(this.instanceName);
        }
        this.eventExplorer.show(activity);
    }

    void useForegroundTracking() {
        this.usingForegroundTracking = true;
    }

    boolean isUsingForegroundTracking() {
        return this.usingForegroundTracking;
    }

    void addEventMiddleware(Middleware middleware) {
        this.middlewareRunner.add(middleware);
    }

    boolean isInForeground() {
        return this.inForeground;
    }

    public void logEvent(String eventType) {
        this.logEvent(eventType, null);
    }

    public void logEvent(String eventType, JSONObject eventProperties) {
        this.logEvent(eventType, eventProperties, false);
    }

    public void logEvent(String eventType, JSONObject eventProperties, boolean outOfSession) {
        this.logEvent(eventType, eventProperties, null, outOfSession);
    }

    public void logEvent(String eventType, JSONObject eventProperties, JSONObject groups) {
        this.logEvent(eventType, eventProperties, groups, false);
    }

    public void logEvent(String eventType, JSONObject eventProperties, JSONObject groups, boolean outOfSession) {
        this.logEvent(eventType, eventProperties, groups, this.getCurrentTimeMillis(), outOfSession);
    }

    public void logEvent(String eventType, JSONObject eventProperties, JSONObject groups, long timestamp, boolean outOfSession) {
        this.logEvent(eventType, eventProperties, groups, timestamp, outOfSession, null);
    }

    public void logEvent(String eventType, JSONObject eventProperties, JSONObject groups, long timestamp, boolean outOfSession, MiddlewareExtra extra) {
        if (this.validateLogEvent(eventType)) {
            this.logEventAsync(eventType, eventProperties, null, null, groups, null, timestamp, outOfSession, extra);
        }
    }

    public void logEventSync(String eventType) {
        this.logEventSync(eventType, null);
    }

    public void logEventSync(String eventType, JSONObject eventProperties) {
        this.logEventSync(eventType, eventProperties, false);
    }

    public void logEventSync(String eventType, JSONObject eventProperties, boolean outOfSession) {
        this.logEventSync(eventType, eventProperties, null, outOfSession);
    }

    public void logEventSync(String eventType, JSONObject eventProperties, JSONObject groups) {
        this.logEventSync(eventType, eventProperties, groups, false);
    }

    public void logEventSync(String eventType, JSONObject eventProperties, JSONObject groups, boolean outOfSession) {
        this.logEventSync(eventType, eventProperties, groups, this.getCurrentTimeMillis(), outOfSession);
    }

    public void logEventSync(String eventType, JSONObject eventProperties, JSONObject groups, long timestamp, boolean outOfSession) {
        if (this.validateLogEvent(eventType)) {
            this.logEvent(eventType, eventProperties, null, null, groups, null, timestamp, outOfSession);
        }
    }

    protected boolean validateLogEvent(String eventType) {
        if (Utils.isEmptyString(eventType)) {
            logger.e(TAG, "Argument eventType cannot be null or blank in logEvent()");
            return false;
        }
        return this.contextAndApiKeySet("logEvent()");
    }

    protected void logEventAsync(String eventType, JSONObject eventProperties, JSONObject apiProperties, JSONObject userProperties, JSONObject groups, JSONObject groupProperties, long timestamp, boolean outOfSession) {
        this.logEventAsync(eventType, eventProperties, apiProperties, userProperties, groups, groupProperties, timestamp, outOfSession, null);
    }

    protected void logEventAsync(final String eventType, JSONObject eventProperties, JSONObject apiProperties, JSONObject userProperties, JSONObject groups, JSONObject groupProperties, final long timestamp, final boolean outOfSession, final MiddlewareExtra extra) {
        if (eventProperties != null) {
            eventProperties = Utils.cloneJSONObject(eventProperties);
        }
        if (apiProperties != null) {
            apiProperties = Utils.cloneJSONObject(apiProperties);
        }
        if (userProperties != null) {
            userProperties = Utils.cloneJSONObject(userProperties);
        }
        if (groups != null) {
            groups = Utils.cloneJSONObject(groups);
        }
        if (groupProperties != null) {
            groupProperties = Utils.cloneJSONObject(groupProperties);
        }
        final JSONObject copyEventProperties = eventProperties;
        final JSONObject copyApiProperties = apiProperties;
        final JSONObject copyUserProperties = userProperties;
        final JSONObject copyGroups = groups;
        final JSONObject copyGroupProperties = groupProperties;
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                if (Utils.isEmptyString(AmplitudeClient.this.apiKey)) {
                    return;
                }
                AmplitudeClient.this.logEvent(eventType, copyEventProperties, copyApiProperties, copyUserProperties, copyGroups, copyGroupProperties, timestamp, outOfSession, extra);
            }
        });
    }

    protected long logEvent(String eventType, JSONObject eventProperties, JSONObject apiProperties, JSONObject userProperties, JSONObject groups, JSONObject groupProperties, long timestamp, boolean outOfSession) {
        return this.logEvent(eventType, eventProperties, apiProperties, userProperties, groups, groupProperties, timestamp, outOfSession, null);
    }

    protected long logEvent(String eventType, JSONObject eventProperties, JSONObject apiProperties, JSONObject userProperties, JSONObject groups, JSONObject groupProperties, long timestamp, boolean outOfSession, MiddlewareExtra extra) {
        boolean loggingSessionEvent;
        logger.d(TAG, "Logged event to Amplitude: " + eventType);
        if (this.optOut) {
            return -1L;
        }
        boolean bl = loggingSessionEvent = this.trackingSessionEvents && (eventType.equals(START_SESSION_EVENT) || eventType.equals(END_SESSION_EVENT));
        if (!loggingSessionEvent && !outOfSession) {
            if (!this.inForeground) {
                this.startNewSessionIfNeeded(timestamp);
            } else {
                this.refreshSessionTime(timestamp);
            }
        }
        long result = -1L;
        JSONObject event = new JSONObject();
        try {
            Location location;
            event.put("event_type", this.replaceWithJSONNull(eventType));
            event.put("timestamp", timestamp);
            event.put(USER_ID_KEY, this.replaceWithJSONNull(this.userId));
            event.put(DEVICE_ID_KEY, this.replaceWithJSONNull(this.deviceId));
            event.put("session_id", outOfSession ? -1L : this.sessionId);
            event.put("uuid", (Object)UUID.randomUUID().toString());
            event.put(SEQUENCE_NUMBER_KEY, this.getNextSequenceNumber());
            if (this.appliedTrackingOptions.shouldTrackVersionName()) {
                event.put("version_name", this.replaceWithJSONNull(this.deviceInfo.getVersionName()));
            }
            if (this.appliedTrackingOptions.shouldTrackOsName()) {
                event.put("os_name", this.replaceWithJSONNull(this.deviceInfo.getOsName()));
            }
            if (this.appliedTrackingOptions.shouldTrackOsVersion()) {
                event.put("os_version", this.replaceWithJSONNull(this.deviceInfo.getOsVersion()));
            }
            if (this.appliedTrackingOptions.shouldTrackApiLevel()) {
                event.put("api_level", this.replaceWithJSONNull(Build.VERSION.SDK_INT));
            }
            if (this.appliedTrackingOptions.shouldTrackDeviceBrand()) {
                event.put("device_brand", this.replaceWithJSONNull(this.deviceInfo.getBrand()));
            }
            if (this.appliedTrackingOptions.shouldTrackDeviceManufacturer()) {
                event.put("device_manufacturer", this.replaceWithJSONNull(this.deviceInfo.getManufacturer()));
            }
            if (this.appliedTrackingOptions.shouldTrackDeviceModel()) {
                event.put("device_model", this.replaceWithJSONNull(this.deviceInfo.getModel()));
            }
            if (this.appliedTrackingOptions.shouldTrackCarrier()) {
                event.put("carrier", this.replaceWithJSONNull(this.deviceInfo.getCarrier()));
            }
            if (this.appliedTrackingOptions.shouldTrackCountry()) {
                event.put("country", this.replaceWithJSONNull(this.deviceInfo.getCountry()));
            }
            if (this.appliedTrackingOptions.shouldTrackLanguage()) {
                event.put("language", this.replaceWithJSONNull(this.deviceInfo.getLanguage()));
            }
            if (this.appliedTrackingOptions.shouldTrackPlatform()) {
                event.put("platform", (Object)this.platform);
            }
            JSONObject library = new JSONObject();
            library.put("name", (Object)(this.libraryName == null ? "unknown-library" : this.libraryName));
            library.put("version", (Object)(this.libraryVersion == null ? "unknown-version" : this.libraryVersion));
            event.put("library", (Object)library);
            if (this.plan != null) {
                event.put("plan", (Object)this.plan.toJSONObject());
            }
            JSONObject jSONObject = apiProperties = apiProperties == null ? new JSONObject() : apiProperties;
            if (this.apiPropertiesTrackingOptions != null && this.apiPropertiesTrackingOptions.length() > 0) {
                apiProperties.put("tracking_options", (Object)this.apiPropertiesTrackingOptions);
            }
            if (this.appliedTrackingOptions.shouldTrackLatLng() && (location = this.deviceInfo.getMostRecentLocation()) != null) {
                JSONObject locationJSON = new JSONObject();
                locationJSON.put("lat", location.getLatitude());
                locationJSON.put("lng", location.getLongitude());
                apiProperties.put("location", (Object)locationJSON);
            }
            if (this.appliedTrackingOptions.shouldTrackAdid() && this.deviceInfo.getAdvertisingId() != null) {
                apiProperties.put("androidADID", (Object)this.deviceInfo.getAdvertisingId());
            }
            if (this.appliedTrackingOptions.shouldTrackAppSetId() && this.deviceInfo.getAppSetId() != null) {
                apiProperties.put("android_app_set_id", (Object)this.deviceInfo.getAppSetId());
            }
            apiProperties.put("limit_ad_tracking", this.deviceInfo.isLimitAdTrackingEnabled());
            apiProperties.put("gps_enabled", this.deviceInfo.isGooglePlayServicesEnabled());
            event.put("api_properties", (Object)apiProperties);
            event.put("event_properties", (Object)(eventProperties == null ? new JSONObject() : this.truncate(eventProperties)));
            event.put("user_properties", (Object)(userProperties == null ? new JSONObject() : this.truncate(userProperties)));
            event.put("groups", (Object)(groups == null ? new JSONObject() : this.truncate(groups)));
            event.put("group_properties", (Object)(groupProperties == null ? new JSONObject() : this.truncate(groupProperties)));
            result = this.saveEvent(eventType, event, extra);
        }
        catch (JSONException e) {
            logger.e(TAG, String.format("JSON Serialization of event type %s failed, skipping: %s", eventType, e.toString()));
        }
        return result;
    }

    protected long saveEvent(String eventType, JSONObject event, MiddlewareExtra extra) {
        long totalEventCount;
        if (!this.middlewareRunner.run(new MiddlewarePayload(event, extra))) {
            return -1L;
        }
        String eventString = event.toString();
        if (Utils.isEmptyString(eventString)) {
            logger.e(TAG, String.format("Detected empty event string for event type %s, skipping", eventType));
            return -1L;
        }
        if (eventType.equals("$identify") || eventType.equals("$groupidentify")) {
            this.lastIdentifyId = this.dbHelper.addIdentify(eventString);
            this.setLastIdentifyId(this.lastIdentifyId);
        } else {
            this.lastEventId = this.dbHelper.addEvent(eventString);
            this.setLastEventId(this.lastEventId);
        }
        int numEventsToRemove = Math.min(Math.max(1, this.eventMaxCount / 10), 20);
        if (this.dbHelper.getEventCount() > (long)this.eventMaxCount) {
            this.dbHelper.removeEvents(this.dbHelper.getNthEventId(numEventsToRemove));
        }
        if (this.dbHelper.getIdentifyCount() > (long)this.eventMaxCount) {
            this.dbHelper.removeIdentifys(this.dbHelper.getNthIdentifyId(numEventsToRemove));
        }
        if ((totalEventCount = this.dbHelper.getTotalEventCount()) % (long)this.eventUploadThreshold == 0L && totalEventCount >= (long)this.eventUploadThreshold) {
            this.updateServer();
        } else {
            this.updateServerLater(this.eventUploadPeriodMillis);
        }
        return eventType.equals("$identify") || eventType.equals("$groupidentify") ? this.lastIdentifyId : this.lastEventId;
    }

    private long getLongvalue(String key, long defaultValue) {
        Long value = this.dbHelper.getLongValue(key);
        return value == null ? defaultValue : value;
    }

    long getNextSequenceNumber() {
        ++this.sequenceNumber;
        this.dbHelper.insertOrReplaceKeyLongValue(SEQUENCE_NUMBER_KEY, this.sequenceNumber);
        return this.sequenceNumber;
    }

    void setLastEventTime(long timestamp) {
        this.lastEventTime = timestamp;
        this.dbHelper.insertOrReplaceKeyLongValue(LAST_EVENT_TIME_KEY, timestamp);
    }

    void setLastEventId(long eventId) {
        this.lastEventId = eventId;
        this.dbHelper.insertOrReplaceKeyLongValue(LAST_EVENT_ID_KEY, eventId);
    }

    void setLastIdentifyId(long identifyId) {
        this.lastIdentifyId = identifyId;
        this.dbHelper.insertOrReplaceKeyLongValue(LAST_IDENTIFY_ID_KEY, identifyId);
    }

    public long getSessionId() {
        return this.sessionId;
    }

    void setPreviousSessionId(long timestamp) {
        this.previousSessionId = timestamp;
        this.dbHelper.insertOrReplaceKeyLongValue(PREVIOUS_SESSION_ID_KEY, timestamp);
    }

    public boolean startNewSessionIfNeeded(long timestamp) {
        if (this.inSession()) {
            if (this.isWithinMinTimeBetweenSessions(timestamp)) {
                this.refreshSessionTime(timestamp);
                return false;
            }
            this.startNewSession(timestamp);
            return true;
        }
        if (this.isWithinMinTimeBetweenSessions(timestamp)) {
            if (this.previousSessionId == -1L) {
                this.startNewSession(timestamp);
                return true;
            }
            this.setSessionId(this.previousSessionId);
            this.refreshSessionTime(timestamp);
            return false;
        }
        this.startNewSession(timestamp);
        return true;
    }

    private void startNewSession(long timestamp) {
        if (this.trackingSessionEvents) {
            this.sendSessionEvent(END_SESSION_EVENT);
        }
        this.setSessionId(timestamp);
        this.refreshSessionTime(timestamp);
        if (this.trackingSessionEvents) {
            this.sendSessionEvent(START_SESSION_EVENT);
        }
    }

    private boolean inSession() {
        return this.sessionId >= 0L;
    }

    private boolean isWithinMinTimeBetweenSessions(long timestamp) {
        long sessionLimit = this.usingForegroundTracking ? this.minTimeBetweenSessionsMillis : this.sessionTimeoutMillis;
        return timestamp - this.lastEventTime < sessionLimit;
    }

    private void setSessionId(long timestamp) {
        this.sessionId = timestamp;
        this.setPreviousSessionId(timestamp);
    }

    void refreshSessionTime(long timestamp) {
        if (!this.inSession()) {
            return;
        }
        this.setLastEventTime(timestamp);
    }

    private void sendSessionEvent(String sessionEvent) {
        if (!this.contextAndApiKeySet(String.format("sendSessionEvent('%s')", sessionEvent))) {
            return;
        }
        if (!this.inSession()) {
            return;
        }
        JSONObject apiProperties = new JSONObject();
        try {
            apiProperties.put("special", (Object)sessionEvent);
        }
        catch (JSONException e) {
            return;
        }
        this.logEvent(sessionEvent, null, apiProperties, null, null, null, this.lastEventTime, false);
    }

    void onExitForeground(final long timestamp) {
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                if (Utils.isEmptyString(AmplitudeClient.this.apiKey)) {
                    return;
                }
                AmplitudeClient.this.refreshSessionTime(timestamp);
                AmplitudeClient.this.inForeground = false;
                if (AmplitudeClient.this.flushEventsOnClose) {
                    AmplitudeClient.this.updateServer();
                }
                AmplitudeClient.this.dbHelper.insertOrReplaceKeyValue(AmplitudeClient.DEVICE_ID_KEY, AmplitudeClient.this.deviceId);
                AmplitudeClient.this.dbHelper.insertOrReplaceKeyValue(AmplitudeClient.USER_ID_KEY, AmplitudeClient.this.userId);
                AmplitudeClient.this.dbHelper.insertOrReplaceKeyLongValue(AmplitudeClient.OPT_OUT_KEY, AmplitudeClient.this.optOut ? 1L : 0L);
                AmplitudeClient.this.dbHelper.insertOrReplaceKeyLongValue(AmplitudeClient.PREVIOUS_SESSION_ID_KEY, AmplitudeClient.this.sessionId);
                AmplitudeClient.this.dbHelper.insertOrReplaceKeyLongValue(AmplitudeClient.LAST_EVENT_TIME_KEY, AmplitudeClient.this.lastEventTime);
            }
        });
    }

    void onEnterForeground(final long timestamp) {
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                if (Utils.isEmptyString(AmplitudeClient.this.apiKey)) {
                    return;
                }
                if (AmplitudeClient.this.useDynamicConfig) {
                    ConfigManager.getInstance().refresh(new ConfigManager.RefreshListener(){

                        @Override
                        public void onFinished() {
                            AmplitudeClient.this.url = ConfigManager.getInstance().getIngestionEndpoint();
                        }
                    }, AmplitudeClient.this.serverZone);
                }
                AmplitudeClient.this.startNewSessionIfNeeded(timestamp);
                AmplitudeClient.this.inForeground = true;
            }
        });
    }

    public void logRevenue(double amount) {
        this.logRevenue(null, 1, amount);
    }

    public void logRevenue(String productId, int quantity, double price) {
        this.logRevenue(productId, quantity, price, null, null);
    }

    public void logRevenue(String productId, int quantity, double price, String receipt, String receiptSignature) {
        this.logRevenue(productId, quantity, price, receipt, receiptSignature, null);
    }

    public void logRevenue(String productId, int quantity, double price, String receipt, String receiptSignature, MiddlewareExtra extra) {
        if (!this.contextAndApiKeySet("logRevenue()")) {
            return;
        }
        JSONObject apiProperties = new JSONObject();
        try {
            apiProperties.put("special", (Object)"revenue_amount");
            apiProperties.put("productId", (Object)productId);
            apiProperties.put("quantity", quantity);
            apiProperties.put("price", price);
            apiProperties.put("receipt", (Object)receipt);
            apiProperties.put("receiptSig", (Object)receiptSignature);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.logEventAsync("revenue_amount", null, apiProperties, null, null, null, this.getCurrentTimeMillis(), false, extra);
    }

    public void logRevenueV2(Revenue revenue) {
        this.logRevenueV2(revenue, null);
    }

    public void logRevenueV2(Revenue revenue, MiddlewareExtra extra) {
        if (!this.contextAndApiKeySet("logRevenueV2()") || revenue == null || !revenue.isValidRevenue()) {
            return;
        }
        this.logEvent("revenue_amount", revenue.toJSONObject(), null, null, null, null, this.getCurrentTimeMillis(), false, extra);
    }

    public void setUserProperties(JSONObject userProperties, boolean replace) {
        this.setUserProperties(userProperties);
    }

    public void setUserProperties(JSONObject userProperties) {
        this.setUserProperties(userProperties, null);
    }

    public void setUserProperties(JSONObject userProperties, MiddlewareExtra extra) {
        if (userProperties == null || userProperties.length() == 0 || !this.contextAndApiKeySet("setUserProperties")) {
            return;
        }
        JSONObject sanitized = this.truncate(userProperties);
        if (sanitized.length() == 0) {
            return;
        }
        Identify identify = new Identify();
        Iterator keys = sanitized.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                identify.setUserProperty(key, sanitized.get(key));
            }
            catch (JSONException e) {
                logger.e(TAG, e.toString());
            }
        }
        this.identify(identify, false, extra);
    }

    public void clearUserProperties() {
        Identify identify = new Identify().clearAll();
        this.identify(identify);
    }

    public void identify(Identify identify) {
        this.identify(identify, false);
    }

    public void identify(Identify identify, boolean outOfSession) {
        this.identify(identify, outOfSession, null);
    }

    public void identify(Identify identify, boolean outOfSession, MiddlewareExtra extra) {
        if (identify == null || identify.userPropertiesOperations.length() == 0 || !this.contextAndApiKeySet("identify()")) {
            return;
        }
        this.logEventAsync("$identify", null, null, identify.userPropertiesOperations, null, null, this.getCurrentTimeMillis(), outOfSession, extra);
    }

    public void setGroup(String groupType, Object groupName) {
        this.setGroup(groupType, groupName, null);
    }

    public void setGroup(String groupType, Object groupName, MiddlewareExtra extra) {
        if (!this.contextAndApiKeySet("setGroup()") || Utils.isEmptyString(groupType)) {
            return;
        }
        JSONObject group = null;
        try {
            group = new JSONObject().put(groupType, groupName);
        }
        catch (JSONException e) {
            logger.e(TAG, e.toString());
        }
        Identify identify = new Identify().setUserProperty(groupType, groupName);
        this.logEventAsync("$identify", null, null, identify.userPropertiesOperations, group, null, this.getCurrentTimeMillis(), false, extra);
    }

    public void groupIdentify(String groupType, Object groupName, Identify groupIdentify) {
        this.groupIdentify(groupType, groupName, groupIdentify, false);
    }

    public void groupIdentify(String groupType, Object groupName, Identify groupIdentify, boolean outOfSession) {
        this.groupIdentify(groupType, groupName, groupIdentify, false, null);
    }

    public void groupIdentify(String groupType, Object groupName, Identify groupIdentify, boolean outOfSession, MiddlewareExtra extra) {
        if (groupIdentify == null || groupIdentify.userPropertiesOperations.length() == 0 || !this.contextAndApiKeySet("groupIdentify()") || Utils.isEmptyString(groupType)) {
            return;
        }
        JSONObject group = null;
        try {
            group = new JSONObject().put(groupType, groupName);
        }
        catch (JSONException e) {
            logger.e(TAG, e.toString());
        }
        this.logEventAsync("$groupidentify", null, null, null, group, groupIdentify.userPropertiesOperations, this.getCurrentTimeMillis(), outOfSession);
    }

    public JSONObject truncate(JSONObject object) {
        if (object == null) {
            return new JSONObject();
        }
        if (object.length() > 1000) {
            logger.w(TAG, "Warning: too many properties (more than 1000), ignoring");
            return new JSONObject();
        }
        Iterator keys = object.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                Object value = object.get(key);
                if (key.equals("$receipt") || key.equals("$receiptSig")) {
                    object.put(key, value);
                    continue;
                }
                if (value.getClass().equals(String.class)) {
                    object.put(key, (Object)AmplitudeClient.truncate((String)value));
                    continue;
                }
                if (value.getClass().equals(JSONObject.class)) {
                    object.put(key, (Object)this.truncate((JSONObject)value));
                    continue;
                }
                if (!value.getClass().equals(JSONArray.class)) continue;
                object.put(key, (Object)this.truncate((JSONArray)value));
            }
            catch (JSONException e) {
                logger.e(TAG, e.toString());
            }
        }
        return object;
    }

    public JSONArray truncate(JSONArray array) throws JSONException {
        if (array == null) {
            return new JSONArray();
        }
        for (int i = 0; i < array.length(); ++i) {
            Object value = array.get(i);
            if (value.getClass().equals(String.class)) {
                array.put(i, (Object)AmplitudeClient.truncate((String)value));
                continue;
            }
            if (value.getClass().equals(JSONObject.class)) {
                array.put(i, (Object)this.truncate((JSONObject)value));
                continue;
            }
            if (!value.getClass().equals(JSONArray.class)) continue;
            array.put(i, (Object)this.truncate((JSONArray)value));
        }
        return array;
    }

    public static String truncate(String value) {
        return value.length() <= 1024 ? value : value.substring(0, 1024);
    }

    public String getUserId() {
        return this.userId;
    }

    public AmplitudeClient setUserId(String userId) {
        return this.setUserId(userId, false);
    }

    public AmplitudeClient setUserId(final String userId, final boolean startNewSession) {
        if (!this.contextAndApiKeySet("setUserId()")) {
            return this;
        }
        final AmplitudeClient client = this;
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                if (Utils.isEmptyString(client.apiKey)) {
                    return;
                }
                if (startNewSession && AmplitudeClient.this.trackingSessionEvents) {
                    AmplitudeClient.this.sendSessionEvent(AmplitudeClient.END_SESSION_EVENT);
                }
                client.userId = userId;
                AmplitudeClient.this.dbHelper.insertOrReplaceKeyValue(AmplitudeClient.USER_ID_KEY, userId);
                if (startNewSession) {
                    long timestamp = AmplitudeClient.this.getCurrentTimeMillis();
                    AmplitudeClient.this.setSessionId(timestamp);
                    AmplitudeClient.this.refreshSessionTime(timestamp);
                    if (AmplitudeClient.this.trackingSessionEvents) {
                        AmplitudeClient.this.sendSessionEvent(AmplitudeClient.START_SESSION_EVENT);
                    }
                }
            }
        });
        return this;
    }

    public AmplitudeClient setDeviceId(final String deviceId) {
        Set<String> invalidDeviceIds = this.getInvalidDeviceIds();
        if (!this.contextAndApiKeySet("setDeviceId()") || Utils.isEmptyString(deviceId) || invalidDeviceIds.contains(deviceId)) {
            return this;
        }
        final AmplitudeClient client = this;
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                if (Utils.isEmptyString(client.apiKey)) {
                    return;
                }
                client.deviceId = deviceId;
                AmplitudeClient.this.saveDeviceId(deviceId);
            }
        });
        return this;
    }

    public AmplitudeClient regenerateDeviceId() {
        if (!this.contextAndApiKeySet("regenerateDeviceId()")) {
            return this;
        }
        final AmplitudeClient client = this;
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                if (Utils.isEmptyString(client.apiKey)) {
                    return;
                }
                String randomId = DeviceInfo.generateUUID() + "R";
                AmplitudeClient.this.setDeviceId(randomId);
            }
        });
        return this;
    }

    public void uploadEvents() {
        if (!this.contextAndApiKeySet("uploadEvents()")) {
            return;
        }
        this.logThread.post(new Runnable(){

            @Override
            public void run() {
                if (Utils.isEmptyString(AmplitudeClient.this.apiKey)) {
                    return;
                }
                AmplitudeClient.this.updateServer();
            }
        });
    }

    private void updateServerLater(long delayMillis) {
        if (this.updateScheduled.getAndSet(true)) {
            return;
        }
        this.logThread.postDelayed(new Runnable(){

            @Override
            public void run() {
                AmplitudeClient.this.updateScheduled.set(false);
                AmplitudeClient.this.updateServer();
            }
        }, delayMillis);
    }

    protected void updateServer() {
        this.updateServer(false);
    }

    protected void updateServer(boolean limit) {
        if (this.optOut || this.offline) {
            return;
        }
        if (!this.uploadingCurrently.getAndSet(true)) {
            long totalEventCount;
            long batchSize = Math.min(limit ? (long)this.backoffUploadBatchSize : (long)this.eventUploadMaxBatchSize, totalEventCount = this.dbHelper.getTotalEventCount());
            if (batchSize <= 0L) {
                this.uploadingCurrently.set(false);
                return;
            }
            try {
                List<JSONObject> events = this.dbHelper.getEvents(this.lastEventId, batchSize);
                List<JSONObject> identifys = this.dbHelper.getIdentifys(this.lastIdentifyId, batchSize);
                Pair<Pair<Long, Long>, JSONArray> merged = this.mergeEventsAndIdentifys(events, identifys, batchSize);
                JSONArray mergedEvents = (JSONArray)merged.second;
                if (mergedEvents.length() == 0) {
                    this.uploadingCurrently.set(false);
                    return;
                }
                final long maxEventId = (Long)((Pair)merged.first).first;
                final long maxIdentifyId = (Long)((Pair)merged.first).second;
                final String mergedEventsString = ((JSONArray)merged.second).toString();
                this.httpThread.post(new Runnable(){

                    @Override
                    public void run() {
                        AmplitudeClient.this.makeEventUploadPostRequest(AmplitudeClient.this.callFactory, mergedEventsString, maxEventId, maxIdentifyId);
                    }
                });
            }
            catch (JSONException e) {
                this.uploadingCurrently.set(false);
                logger.e(TAG, e.toString());
            }
            catch (CursorWindowAllocationException e) {
                this.uploadingCurrently.set(false);
                logger.e(TAG, String.format("Caught Cursor window exception during event upload, deferring upload: %s", e.getMessage()));
            }
        }
    }

    protected Pair<Pair<Long, Long>, JSONArray> mergeEventsAndIdentifys(List<JSONObject> events, List<JSONObject> identifys, long numEvents) throws JSONException {
        JSONArray merged = new JSONArray();
        long maxEventId = -1L;
        long maxIdentifyId = -1L;
        while ((long)merged.length() < numEvents) {
            JSONObject identify;
            JSONObject event;
            boolean noEvents = events.isEmpty();
            boolean noIdentifys = identifys.isEmpty();
            if (noEvents && noIdentifys) {
                logger.w(TAG, String.format("mergeEventsAndIdentifys: number of events and identifys less than expected by %d", numEvents - (long)merged.length()));
                break;
            }
            if (noIdentifys) {
                event = events.remove(0);
                maxEventId = event.getLong("event_id");
                merged.put((Object)event);
                continue;
            }
            if (noEvents) {
                identify = identifys.remove(0);
                maxIdentifyId = identify.getLong("event_id");
                merged.put((Object)identify);
                continue;
            }
            if (!events.get(0).has(SEQUENCE_NUMBER_KEY) || events.get(0).getLong(SEQUENCE_NUMBER_KEY) < identifys.get(0).getLong(SEQUENCE_NUMBER_KEY)) {
                event = events.remove(0);
                maxEventId = event.getLong("event_id");
                merged.put((Object)event);
                continue;
            }
            identify = identifys.remove(0);
            maxIdentifyId = identify.getLong("event_id");
            merged.put((Object)identify);
        }
        return new Pair((Object)new Pair((Object)maxEventId, (Object)maxIdentifyId), (Object)merged);
    }

    protected void makeEventUploadPostRequest(Call.Factory client, String events, final long maxEventId, final long maxIdentifyId) {
        Request request;
        String apiVersionString = "2";
        String timestampString = "" + this.getCurrentTimeMillis();
        String checksumString = "";
        try {
            String preimage = apiVersionString + this.apiKey + events + timestampString;
            MD5 messageDigest = new MD5();
            checksumString = this.bytesToHexString(messageDigest.digest(preimage.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            logger.e(TAG, e.toString());
        }
        FormBody body = new FormBody.Builder().add("v", apiVersionString).add("client", this.apiKey).add("e", events).add("upload_time", timestampString).add("checksum", checksumString).build();
        try {
            Request.Builder builder = new Request.Builder().url(this.url).post((RequestBody)body);
            if (!Utils.isEmptyString(this.bearerToken)) {
                builder.addHeader("Authorization", "Bearer " + this.bearerToken);
            }
            request = builder.build();
        }
        catch (IllegalArgumentException e) {
            logger.e(TAG, e.toString());
            this.uploadingCurrently.set(false);
            return;
        }
        boolean uploadSuccess = false;
        try {
            Response response = client.newCall(request).execute();
            String stringResponse = response.body().string();
            if (stringResponse.equals("success")) {
                uploadSuccess = true;
                this.logThread.post(new Runnable(){

                    @Override
                    public void run() {
                        if (maxEventId >= 0L) {
                            AmplitudeClient.this.dbHelper.removeEvents(maxEventId);
                        }
                        if (maxIdentifyId >= 0L) {
                            AmplitudeClient.this.dbHelper.removeIdentifys(maxIdentifyId);
                        }
                        AmplitudeClient.this.uploadingCurrently.set(false);
                        if (AmplitudeClient.this.dbHelper.getTotalEventCount() > (long)AmplitudeClient.this.eventUploadThreshold) {
                            AmplitudeClient.this.logThread.post(new Runnable(){

                                @Override
                                public void run() {
                                    AmplitudeClient.this.updateServer(AmplitudeClient.this.backoffUpload);
                                }
                            });
                        } else {
                            AmplitudeClient.this.backoffUpload = false;
                            AmplitudeClient.this.backoffUploadBatchSize = AmplitudeClient.this.eventUploadMaxBatchSize;
                        }
                    }
                });
            } else if (stringResponse.equals("invalid_api_key")) {
                logger.e(TAG, "Invalid API key, make sure your API key is correct in initialize()");
            } else if (stringResponse.equals("bad_checksum")) {
                logger.w(TAG, "Bad checksum, post request was mangled in transit, will attempt to reupload later");
            } else if (stringResponse.equals("request_db_write_failed")) {
                logger.w(TAG, "Couldn't write to request database on server, will attempt to reupload later");
            } else if (response.code() == 413) {
                if (this.backoffUpload && this.backoffUploadBatchSize == 1) {
                    if (maxEventId >= 0L) {
                        this.dbHelper.removeEvent(maxEventId);
                    }
                    if (maxIdentifyId >= 0L) {
                        this.dbHelper.removeIdentify(maxIdentifyId);
                    }
                }
                this.backoffUpload = true;
                int numEvents = Math.min((int)this.dbHelper.getEventCount(), this.backoffUploadBatchSize);
                this.backoffUploadBatchSize = (int)Math.ceil((double)numEvents / 2.0);
                logger.w(TAG, "Request too large, will decrease size and attempt to reupload");
                this.logThread.post(new Runnable(){

                    @Override
                    public void run() {
                        AmplitudeClient.this.uploadingCurrently.set(false);
                        AmplitudeClient.this.updateServer(true);
                    }
                });
            } else {
                logger.w(TAG, "Upload failed, " + stringResponse + ", will attempt to reupload later");
            }
        }
        catch (ConnectException e) {
            this.lastError = e;
        }
        catch (UnknownHostException e) {
            this.lastError = e;
        }
        catch (IOException e) {
            logger.e(TAG, e.toString());
            this.lastError = e;
        }
        catch (AssertionError e) {
            logger.e(TAG, "Exception:", (Throwable)((Object)e));
            this.lastError = e;
        }
        catch (Exception e) {
            logger.e(TAG, "Exception:", e);
            this.lastError = e;
        }
        if (!uploadSuccess) {
            this.uploadingCurrently.set(false);
        }
    }

    protected DeviceInfo initializeDeviceInfo() {
        return new DeviceInfo(this.context, this.locationListening);
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    private Set<String> getInvalidDeviceIds() {
        HashSet<String> invalidDeviceIds = new HashSet<String>();
        invalidDeviceIds.add("");
        invalidDeviceIds.add("9774d56d682e549c");
        invalidDeviceIds.add("unknown");
        invalidDeviceIds.add("000000000000000");
        invalidDeviceIds.add("Android");
        invalidDeviceIds.add("DEFACE");
        invalidDeviceIds.add("00000000-0000-0000-0000-000000000000");
        return invalidDeviceIds;
    }

    private String initializeDeviceId() {
        String appSetId;
        String advertisingId;
        Set<String> invalidIds = this.getInvalidDeviceIds();
        String deviceId = this.dbHelper.getValue(DEVICE_ID_KEY);
        if (!(Utils.isEmptyString(deviceId) || invalidIds.contains(deviceId) || deviceId.endsWith("S"))) {
            return deviceId;
        }
        if (!(this.newDeviceIdPerInstall || !this.useAdvertisingIdForDeviceId || this.deviceInfo.isLimitAdTrackingEnabled() || Utils.isEmptyString(advertisingId = this.deviceInfo.getAdvertisingId()) || invalidIds.contains(advertisingId))) {
            this.saveDeviceId(advertisingId);
            return advertisingId;
        }
        if (this.useAppSetIdForDeviceId && !Utils.isEmptyString(appSetId = this.deviceInfo.getAppSetId()) && !invalidIds.contains(appSetId)) {
            String appSetDeviceId = appSetId + "S";
            this.saveDeviceId(appSetDeviceId);
            return appSetDeviceId;
        }
        AmplitudeClient amplitudeClient = this;
        String randomId = amplitudeClient.deviceInfo.generateUUID() + "R";
        this.saveDeviceId(randomId);
        return randomId;
    }

    private void saveDeviceId(String deviceId) {
        this.dbHelper.insertOrReplaceKeyValue(DEVICE_ID_KEY, deviceId);
    }

    public AmplitudeClient setDeviceIdCallback(AmplitudeDeviceIdCallback callback) {
        this.deviceIdCallback = callback;
        return this;
    }

    protected void runOnLogThread(Runnable r) {
        if (Thread.currentThread() != this.logThread) {
            this.logThread.post(r);
        } else {
            r.run();
        }
    }

    protected Object replaceWithJSONNull(Object obj) {
        return obj == null ? JSONObject.NULL : obj;
    }

    protected synchronized boolean contextAndApiKeySet(String methodName) {
        if (this.context == null) {
            logger.e(TAG, "context cannot be null, set context with initialize() before calling " + methodName);
            return false;
        }
        if (Utils.isEmptyString(this.apiKey)) {
            logger.e(TAG, "apiKey cannot be null or empty, set apiKey with initialize() before calling " + methodName);
            return false;
        }
        return true;
    }

    protected String bytesToHexString(byte[] bytes) {
        char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    protected long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public AmplitudeClient setPlan(Plan plan) {
        this.plan = plan;
        return this;
    }

    public AmplitudeClient setServerZone(AmplitudeServerZone serverZone) {
        return this.setServerZone(serverZone, true);
    }

    public AmplitudeClient setServerZone(AmplitudeServerZone serverZone, boolean updateServerUrl) {
        if (serverZone == null) {
            return null;
        }
        this.serverZone = serverZone;
        if (updateServerUrl) {
            this.setServerUrl(AmplitudeServerZone.getEventLogApiForZone(serverZone));
        }
        return this;
    }
}

