/*
 * Decompiled with CFR 0.152.
 */
package com.amplitude.api;

import com.amplitude.api.Middleware;
import com.amplitude.api.MiddlewareNext;
import com.amplitude.api.MiddlewarePayload;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class MiddlewareRunner {
    private final ConcurrentLinkedQueue<Middleware> middlewares = new ConcurrentLinkedQueue();

    public void add(Middleware middleware) {
        this.middlewares.add(middleware);
    }

    private void runMiddlewares(final List<Middleware> middlewares, MiddlewarePayload payload, final MiddlewareNext next) {
        if (middlewares.size() == 0) {
            next.run(payload);
            return;
        }
        middlewares.get(0).run(payload, new MiddlewareNext(){

            @Override
            public void run(MiddlewarePayload curPayload) {
                MiddlewareRunner.this.runMiddlewares(middlewares.subList(1, middlewares.size()), curPayload, next);
            }
        });
    }

    public boolean run(MiddlewarePayload payload) {
        final AtomicBoolean middlewareCompleted = new AtomicBoolean(false);
        this.run(payload, new MiddlewareNext(){

            @Override
            public void run(MiddlewarePayload curPayload) {
                middlewareCompleted.set(true);
            }
        });
        return middlewareCompleted.get();
    }

    public void run(MiddlewarePayload payload, MiddlewareNext next) {
        ArrayList<Middleware> middlewareList = new ArrayList<Middleware>(this.middlewares);
        this.runMiddlewares(middlewareList, payload, next);
    }
}

