/*
 * Decompiled with CFR 0.152.
 */
package com.amplitude.api;

import java.util.HashMap;
import java.util.Map;

public enum AmplitudeServerZone {
    US,
    EU;

    private static Map<AmplitudeServerZone, String> amplitudeServerZoneEventLogApiMap;
    private static Map<AmplitudeServerZone, String> amplitudeServerZoneDynamicConfigMap;

    protected static String getEventLogApiForZone(AmplitudeServerZone serverZone) {
        if (amplitudeServerZoneEventLogApiMap.containsKey((Object)serverZone)) {
            return amplitudeServerZoneEventLogApiMap.get((Object)serverZone);
        }
        return "https://api2.amplitude.com/";
    }

    protected static String getDynamicConfigApi(AmplitudeServerZone serverZone) {
        if (amplitudeServerZoneDynamicConfigMap.containsKey((Object)serverZone)) {
            return amplitudeServerZoneDynamicConfigMap.get((Object)serverZone);
        }
        return "https://regionconfig.amplitude.com/";
    }

    public static AmplitudeServerZone getServerZone(String serverZone) {
        AmplitudeServerZone amplitudeServerZone = US;
        switch (serverZone) {
            case "EU": {
                amplitudeServerZone = EU;
                break;
            }
            case "US": {
                amplitudeServerZone = US;
                break;
            }
        }
        return amplitudeServerZone;
    }

    static {
        amplitudeServerZoneEventLogApiMap = new HashMap<AmplitudeServerZone, String>(){
            {
                this.put(US, "https://api2.amplitude.com/");
                this.put(EU, "https://api.eu.amplitude.com/");
            }
        };
        amplitudeServerZoneDynamicConfigMap = new HashMap<AmplitudeServerZone, String>(){
            {
                this.put(US, "https://regionconfig.amplitude.com/");
                this.put(EU, "https://regionconfig.eu.amplitude.com/");
            }
        };
    }
}

