/*
 * Decompiled with CFR 0.152.
 */
package com.amplitude.api;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import com.amplitude.api.AmplitudeLog;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Utils {
    private static final String TAG = Utils.class.getName();
    private static AmplitudeLog logger = AmplitudeLog.getLogger();

    static JSONObject cloneJSONObject(JSONObject obj) {
        if (obj == null) {
            return null;
        }
        if (obj.length() == 0) {
            return new JSONObject();
        }
        JSONArray nameArray = null;
        try {
            nameArray = obj.names();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            logger.e(TAG, e.toString());
        }
        int len = nameArray != null ? nameArray.length() : 0;
        String[] names = new String[len];
        for (int i = 0; i < len; ++i) {
            names[i] = nameArray.optString(i);
        }
        try {
            return new JSONObject(obj, names);
        }
        catch (JSONException e) {
            logger.e(TAG, e.toString());
            return null;
        }
    }

    static boolean compareJSONObjects(JSONObject o1, JSONObject o2) {
        try {
            if (o1 == o2) {
                return true;
            }
            if (o1 != null && o2 == null || o1 == null && o2 != null) {
                return false;
            }
            if (o1.length() != o2.length()) {
                return false;
            }
            Iterator keys = o1.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (!o2.has(key)) {
                    return false;
                }
                Object value1 = o1.get(key);
                Object value2 = o2.get(key);
                if (!value1.getClass().equals(value2.getClass())) {
                    return false;
                }
                if (!(value1.getClass() == JSONObject.class ? !Utils.compareJSONObjects((JSONObject)value1, (JSONObject)value2) : !value1.equals(value2))) continue;
                return false;
            }
            return true;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    public static boolean isEmptyString(String s) {
        return s == null || s.length() == 0;
    }

    static String normalizeInstanceName(String instance) {
        if (Utils.isEmptyString(instance)) {
            instance = "$default_instance";
        }
        return instance.toLowerCase();
    }

    static boolean checkLocationPermissionAllowed(Context context) {
        return Utils.checkPermissionAllowed(context, "android.permission.ACCESS_COARSE_LOCATION") || Utils.checkPermissionAllowed(context, "android.permission.ACCESS_FINE_LOCATION");
    }

    static boolean checkPermissionAllowed(Context context, String permission2) {
        if (Build.VERSION.SDK_INT >= 23) {
            boolean hasPermission = false;
            try {
                Method methodCheckPermission = Activity.class.getMethod("checkSelfPermission", String.class);
                Object resultObj = methodCheckPermission.invoke((Object)context, permission2);
                int result = Integer.parseInt(resultObj.toString());
                hasPermission = result == 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return hasPermission;
        }
        return true;
    }
}

