/*
 * Decompiled with CFR 0.152.
 */
package com.amplitude.eventexplorer;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.amplitude.R;
import com.amplitude.eventexplorer.EventExplorerTouchHandler;

public class EventExplorer {
    private String instanceName;
    private View bubbleView;

    public EventExplorer(String instanceName) {
        this.instanceName = instanceName;
    }

    public void show(Activity rootActivity) {
        if (this.bubbleView == null) {
            new Handler(Looper.getMainLooper()).post(() -> {
                WindowManager windowManager = rootActivity.getWindowManager();
                DisplayMetrics displayMetrics = new DisplayMetrics();
                if (windowManager.getDefaultDisplay() != null) {
                    windowManager.getDefaultDisplay().getMetrics(displayMetrics);
                }
                WindowManager.LayoutParams layoutParams = this.prepareWindowManagerLayoutParams((Context)rootActivity, displayMetrics);
                this.bubbleView = rootActivity.getLayoutInflater().inflate(R.layout.amp_bubble_view, null);
                windowManager.addView(this.bubbleView, (ViewGroup.LayoutParams)layoutParams);
                this.bubbleView.setOnTouchListener((View.OnTouchListener)new EventExplorerTouchHandler(windowManager, layoutParams, this.instanceName));
            });
        }
    }

    private WindowManager.LayoutParams prepareWindowManagerLayoutParams(Context context, DisplayMetrics displayMetrics) {
        int navbarHeight = 0;
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId > 0) {
            navbarHeight = resources.getDimensionPixelSize(resourceId);
        }
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
        layoutParams.type = 2;
        layoutParams.format = -3;
        layoutParams.flags = 40;
        layoutParams.y = (displayMetrics.heightPixels - navbarHeight) / 2;
        layoutParams.x = displayMetrics.widthPixels / 2;
        layoutParams.height = -2;
        layoutParams.width = -2;
        return layoutParams;
    }
}

