/*
 * Decompiled with CFR 0.152.
 */
package com.amplitude.eventexplorer;

import android.content.Intent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.amplitude.eventexplorer.EventExplorerInfoActivity;

public class EventExplorerTouchHandler
implements View.OnTouchListener {
    private int initialX;
    private float initialTouchX;
    private int initialY;
    private float initialTouchY;
    private WindowManager.LayoutParams layoutParams;
    private WindowManager windowManager;
    private String instanceName;

    EventExplorerTouchHandler(WindowManager windowManager, WindowManager.LayoutParams layoutParams, String instanceName) {
        this.layoutParams = layoutParams;
        this.windowManager = windowManager;
        this.instanceName = instanceName;
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.initialY = this.layoutParams.y;
                this.initialX = this.layoutParams.x;
                this.initialTouchX = event.getRawX();
                this.initialTouchY = event.getRawY();
                return true;
            }
            case 2: {
                this.layoutParams.y = this.initialY + (int)(event.getRawY() - this.initialTouchY);
                this.layoutParams.x = this.initialX + (int)(event.getRawX() - this.initialTouchX);
                this.windowManager.updateViewLayout(v, (ViewGroup.LayoutParams)this.layoutParams);
                return true;
            }
            case 1: {
                float endX = event.getRawX();
                float endY = event.getRawY();
                if (this.isAClick(this.initialTouchX, endX, this.initialTouchY, endY)) {
                    v.performClick();
                    Intent intent = new Intent(v.getContext(), EventExplorerInfoActivity.class);
                    intent.putExtra("instanceName", this.instanceName);
                    v.getContext().startActivity(intent);
                }
                return true;
            }
        }
        return false;
    }

    private boolean isAClick(float startX, float endX, float startY, float endY) {
        float differenceX = Math.abs(startX - endX);
        float differenceY = Math.abs(startY - endY);
        return !(differenceX > 5.0f) && !(differenceY > 5.0f);
    }
}

