/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.activity;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.wear.R;
import android.support.wear.widget.ConfirmationOverlay;
import android.util.SparseIntArray;

public class ConfirmationActivity
extends Activity {
    public static final String EXTRA_MESSAGE = "android.support.wear.activity.extra.MESSAGE";
    public static final String EXTRA_ANIMATION_TYPE = "android.support.wear.activity.extra.ANIMATION_TYPE";
    public static final int SUCCESS_ANIMATION = 1;
    public static final int OPEN_ON_PHONE_ANIMATION = 2;
    public static final int FAILURE_ANIMATION = 3;
    private static final SparseIntArray CONFIRMATION_OVERLAY_TYPES = new SparseIntArray();

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setTheme(R.style.ConfirmationActivity);
        Intent intent = this.getIntent();
        int requestedType = intent.getIntExtra(EXTRA_ANIMATION_TYPE, 1);
        if (CONFIRMATION_OVERLAY_TYPES.indexOfKey(requestedType) < 0) {
            throw new IllegalArgumentException("Unknown type of animation: " + requestedType);
        }
        int type = CONFIRMATION_OVERLAY_TYPES.get(requestedType);
        String message = intent.getStringExtra(EXTRA_MESSAGE);
        new ConfirmationOverlay().setType(type).setMessage(message).setFinishedAnimationListener(new ConfirmationOverlay.OnAnimationFinishedListener(){

            @Override
            public void onAnimationFinished() {
                ConfirmationActivity.this.onAnimationFinished();
            }
        }).showOn(this);
    }

    protected void onAnimationFinished() {
        this.finish();
    }

    static {
        CONFIRMATION_OVERLAY_TYPES.append(1, 0);
        CONFIRMATION_OVERLAY_TYPES.append(2, 2);
        CONFIRMATION_OVERLAY_TYPES.append(3, 1);
    }
}

