/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.ambient;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.wear.ambient.WearableControllerProvider;
import com.google.android.wearable.compat.WearableActivityController;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;

final class AmbientDelegate {
    private static final String TAG = "AmbientDelegate";
    private WearableActivityController mWearableController;
    private static boolean sInitAutoResumeEnabledMethod;
    private static boolean sHasAutoResumeEnabledMethod;
    private final WearableControllerProvider mWearableControllerProvider;
    private final AmbientCallback mCallback;
    private final WeakReference<Activity> mActivity;

    AmbientDelegate(@Nullable Activity activity, @NonNull WearableControllerProvider wearableControllerProvider, @NonNull AmbientCallback callback) {
        this.mActivity = new WeakReference<Activity>(activity);
        this.mCallback = callback;
        this.mWearableControllerProvider = wearableControllerProvider;
    }

    void onCreate() {
        Activity activity = (Activity)this.mActivity.get();
        if (activity != null) {
            this.mWearableController = this.mWearableControllerProvider.getWearableController(activity, this.mCallback);
        }
        if (this.mWearableController != null) {
            this.mWearableController.onCreate();
        }
    }

    void onResume() {
        if (this.mWearableController != null) {
            this.mWearableController.onResume();
        }
    }

    void onPause() {
        if (this.mWearableController != null) {
            this.mWearableController.onPause();
        }
    }

    void onStop() {
        if (this.mWearableController != null) {
            this.mWearableController.onStop();
        }
    }

    void onDestroy() {
        if (this.mWearableController != null) {
            this.mWearableController.onDestroy();
        }
    }

    void setAmbientEnabled() {
        if (this.mWearableController != null) {
            this.mWearableController.setAmbientEnabled();
        }
    }

    public void setAmbientOffloadEnabled(boolean enabled) {
        if (this.mWearableController != null) {
            this.mWearableController.setAmbientOffloadEnabled(enabled);
        }
    }

    boolean isAmbient() {
        if (this.mWearableController != null) {
            return this.mWearableController.isAmbient();
        }
        return false;
    }

    void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        if (this.mWearableController != null) {
            this.mWearableController.dump(prefix, fd, writer, args);
        }
    }

    static interface AmbientCallback {
        public void onEnterAmbient(Bundle var1);

        public void onUpdateAmbient();

        public void onExitAmbient();

        public void onAmbientOffloadInvalidated();
    }
}

