/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.ambient;

import android.os.Build;
import android.support.annotation.VisibleForTesting;
import com.google.android.wearable.WearableSharedLib;

final class SharedLibraryVersion {
    private SharedLibraryVersion() {
    }

    public static int version() {
        SharedLibraryVersion.verifySharedLibraryPresent();
        return VersionHolder.VERSION;
    }

    public static void verifySharedLibraryPresent() {
        if (!PresenceHolder.PRESENT) {
            throw new IllegalStateException("Could not find wearable shared library classes. Please add <uses-library android:name=\"com.google.android.wearable\" android:required=\"false\" /> to the application manifest");
        }
    }

    @VisibleForTesting
    static final class PresenceHolder {
        static final boolean PRESENT = PresenceHolder.isSharedLibPresent(Build.VERSION.SDK_INT);

        @VisibleForTesting
        static boolean isSharedLibPresent(int sdkInt) {
            try {
                Class.forName("com.google.android.wearable.compat.WearableActivityController");
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            return true;
        }

        private PresenceHolder() {
        }
    }

    @VisibleForTesting
    static final class VersionHolder {
        static final int VERSION = VersionHolder.getSharedLibVersion(Build.VERSION.SDK_INT);

        @VisibleForTesting
        static int getSharedLibVersion(int sdkInt) {
            if (sdkInt < 25) {
                return 0;
            }
            return WearableSharedLib.version();
        }

        private VersionHolder() {
        }
    }
}

