/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.ambient;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.RestrictTo;
import android.support.wear.ambient.AmbientDelegate;
import android.support.wear.ambient.SharedLibraryVersion;
import com.google.android.wearable.compat.WearableActivityController;
import java.lang.reflect.Method;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class WearableControllerProvider {
    private static final String TAG = "WearableControllerProvider";
    private static volatile boolean sAmbientCallbacksVerifiedPresent;

    public WearableActivityController getWearableController(Activity activity, final AmbientDelegate.AmbientCallback callback) {
        SharedLibraryVersion.verifySharedLibraryPresent();
        WearableActivityController.AmbientCallback callbackBridge = new WearableActivityController.AmbientCallback(){

            public void onEnterAmbient(Bundle ambientDetails) {
                callback.onEnterAmbient(ambientDetails);
            }

            public void onUpdateAmbient() {
                callback.onUpdateAmbient();
            }

            public void onExitAmbient() {
                callback.onExitAmbient();
            }

            public void onInvalidateAmbientOffload() {
                callback.onAmbientOffloadInvalidated();
            }
        };
        WearableControllerProvider.verifyAmbientCallbacksPresent();
        return new WearableActivityController(TAG, activity, callbackBridge);
    }

    private static void verifyAmbientCallbacksPresent() {
        if (sAmbientCallbacksVerifiedPresent) {
            return;
        }
        try {
            Method method = WearableActivityController.AmbientCallback.class.getDeclaredMethod("onEnterAmbient", Bundle.class);
            if (!".onEnterAmbient".equals("." + method.getName())) {
                throw new NoSuchMethodException();
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Could not find a required method for ambient support, likely due to proguard optimization. Please add com.google.android.wearable:wearable jar to the list of library jars for your project");
        }
        sAmbientCallbacksVerifiedPresent = true;
    }
}

