/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.internal.widget.drawer;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.wear.R;
import android.support.wear.internal.widget.drawer.MultiPagePresenter;
import android.support.wear.internal.widget.drawer.WearableNavigationDrawerPresenter;
import android.support.wear.widget.drawer.PageIndicatorView;
import android.support.wear.widget.drawer.WearableNavigationDrawerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class MultiPageUi
implements MultiPagePresenter.Ui {
    private static final String TAG = "MultiPageUi";
    WearableNavigationDrawerPresenter mPresenter;
    @Nullable
    private ViewPager mNavigationPager;
    @Nullable
    private PageIndicatorView mPageIndicatorView;

    @Override
    public void initialize(WearableNavigationDrawerView drawer, WearableNavigationDrawerPresenter presenter) {
        if (drawer == null) {
            throw new IllegalArgumentException("Received null drawer.");
        }
        if (presenter == null) {
            throw new IllegalArgumentException("Received null presenter.");
        }
        this.mPresenter = presenter;
        LayoutInflater inflater = LayoutInflater.from((Context)drawer.getContext());
        View content = inflater.inflate(R.layout.ws_navigation_drawer_view, (ViewGroup)drawer, false);
        this.mNavigationPager = (ViewPager)content.findViewById(R.id.ws_navigation_drawer_view_pager);
        this.mPageIndicatorView = (PageIndicatorView)content.findViewById(R.id.ws_navigation_drawer_page_indicator);
        drawer.setDrawerContent(content);
    }

    @Override
    public void setNavigationPagerAdapter(WearableNavigationDrawerView.WearableNavigationDrawerAdapter adapter) {
        if (this.mNavigationPager == null || this.mPageIndicatorView == null) {
            Log.w((String)TAG, (String)"setNavigationPagerAdapter was called before initialize.");
            return;
        }
        NavigationPagerAdapter navigationPagerAdapter = new NavigationPagerAdapter(adapter);
        this.mNavigationPager.setAdapter((PagerAdapter)navigationPagerAdapter);
        this.mNavigationPager.clearOnPageChangeListeners();
        this.mNavigationPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

            public void onPageSelected(int position) {
                MultiPageUi.this.mPresenter.onSelected(position);
            }
        });
        this.mPageIndicatorView.setPager(this.mNavigationPager);
    }

    @Override
    public void notifyPageIndicatorDataChanged() {
        if (this.mPageIndicatorView != null) {
            this.mPageIndicatorView.notifyDataSetChanged();
        }
    }

    @Override
    public void notifyNavigationPagerAdapterDataChanged() {
        PagerAdapter adapter;
        if (this.mNavigationPager != null && (adapter = this.mNavigationPager.getAdapter()) != null) {
            adapter.notifyDataSetChanged();
        }
    }

    @Override
    public void setNavigationPagerSelectedItem(int index, boolean smoothScrollTo) {
        if (this.mNavigationPager != null) {
            this.mNavigationPager.setCurrentItem(index, smoothScrollTo);
        }
    }

    private static final class NavigationPagerAdapter
    extends PagerAdapter {
        private final WearableNavigationDrawerView.WearableNavigationDrawerAdapter mAdapter;

        NavigationPagerAdapter(WearableNavigationDrawerView.WearableNavigationDrawerAdapter adapter) {
            this.mAdapter = adapter;
        }

        @NonNull
        public Object instantiateItem(@NonNull ViewGroup container, int position) {
            View view = LayoutInflater.from((Context)container.getContext()).inflate(R.layout.ws_navigation_drawer_item_view, container, false);
            container.addView(view);
            ImageView iconView = (ImageView)view.findViewById(R.id.ws_navigation_drawer_item_icon);
            TextView textView = (TextView)view.findViewById(R.id.ws_navigation_drawer_item_text);
            iconView.setImageDrawable(this.mAdapter.getItemDrawable(position));
            textView.setText(this.mAdapter.getItemText(position));
            return view;
        }

        public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
            container.removeView((View)object);
        }

        public int getCount() {
            return this.mAdapter.getCount();
        }

        public int getItemPosition(@NonNull Object object) {
            return -2;
        }

        public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
            return view == object;
        }
    }
}

