/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.widget;

import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.support.annotation.Px;
import android.support.annotation.RestrictTo;
import android.support.wear.R;
import android.support.wear.widget.ProgressDrawable;
import android.util.AttributeSet;
import android.view.View;
import java.util.Objects;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class CircledImageView
extends View {
    private static final ArgbEvaluator ARGB_EVALUATOR = new ArgbEvaluator();
    private static final int SQUARE_DIMEN_NONE = 0;
    private static final int SQUARE_DIMEN_HEIGHT = 1;
    private static final int SQUARE_DIMEN_WIDTH = 2;
    private final RectF mOval;
    private final Paint mPaint;
    private final OvalShadowPainter mShadowPainter;
    private final float mInitialCircleRadius;
    private final ProgressDrawable mIndeterminateDrawable;
    private final Rect mIndeterminateBounds = new Rect();
    private final Drawable.Callback mDrawableCallback = new Drawable.Callback(){

        public void invalidateDrawable(Drawable drawable2) {
            CircledImageView.this.invalidate();
        }

        public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        }

        public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        }
    };
    private ColorStateList mCircleColor;
    private Drawable mDrawable;
    private float mCircleRadius;
    private float mCircleRadiusPercent;
    private float mCircleRadiusPressed;
    private float mCircleRadiusPressedPercent;
    private float mRadiusInset;
    private int mCircleBorderColor;
    private Paint.Cap mCircleBorderCap;
    private float mCircleBorderWidth;
    private boolean mCircleHidden = false;
    private float mProgress = 1.0f;
    private boolean mPressed = false;
    private boolean mProgressIndeterminate;
    private boolean mVisible;
    private boolean mWindowVisible;
    private long mColorChangeAnimationDurationMs = 0L;
    private float mImageCirclePercentage = 1.0f;
    private float mImageHorizontalOffcenterPercentage = 0.0f;
    private Integer mImageTint;
    private Integer mSquareDimen;
    int mCurrentColor;
    private final ValueAnimator.AnimatorUpdateListener mAnimationListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            int color2 = (Integer)animation.getAnimatedValue();
            if (color2 != CircledImageView.this.mCurrentColor) {
                CircledImageView.this.mCurrentColor = color2;
                CircledImageView.this.invalidate();
            }
        }
    };
    private ValueAnimator mColorAnimator;

    public CircledImageView(Context context) {
        this(context, null);
    }

    public CircledImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircledImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        float circlePadding;
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.CircledImageView);
        this.mDrawable = a.getDrawable(R.styleable.CircledImageView_android_src);
        if (this.mDrawable != null && this.mDrawable.getConstantState() != null) {
            this.mDrawable = this.mDrawable.getConstantState().newDrawable(context.getResources(), context.getTheme());
            this.mDrawable = this.mDrawable.mutate();
        }
        this.mCircleColor = a.getColorStateList(R.styleable.CircledImageView_background_color);
        if (this.mCircleColor == null) {
            this.mCircleColor = ColorStateList.valueOf((int)context.getColor(0x1060000));
        }
        this.mInitialCircleRadius = this.mCircleRadius = a.getDimension(R.styleable.CircledImageView_background_radius, 0.0f);
        this.mCircleRadiusPressed = a.getDimension(R.styleable.CircledImageView_background_radius_pressed, this.mCircleRadius);
        this.mCircleBorderColor = a.getColor(R.styleable.CircledImageView_background_border_color, -16777216);
        this.mCircleBorderCap = Paint.Cap.values()[a.getInt(R.styleable.CircledImageView_background_border_cap, 0)];
        this.mCircleBorderWidth = a.getDimension(R.styleable.CircledImageView_background_border_width, 0.0f);
        if (this.mCircleBorderWidth > 0.0f) {
            this.mRadiusInset += this.mCircleBorderWidth / 2.0f;
        }
        if ((circlePadding = a.getDimension(R.styleable.CircledImageView_img_padding, 0.0f)) > 0.0f) {
            this.mRadiusInset += circlePadding;
        }
        this.mImageCirclePercentage = a.getFloat(R.styleable.CircledImageView_img_circle_percentage, 0.0f);
        this.mImageHorizontalOffcenterPercentage = a.getFloat(R.styleable.CircledImageView_img_horizontal_offset_percentage, 0.0f);
        if (a.hasValue(R.styleable.CircledImageView_img_tint)) {
            this.mImageTint = a.getColor(R.styleable.CircledImageView_img_tint, 0);
        }
        if (a.hasValue(R.styleable.CircledImageView_clip_dimen)) {
            this.mSquareDimen = a.getInt(R.styleable.CircledImageView_clip_dimen, 0);
        }
        this.mCircleRadiusPercent = a.getFraction(R.styleable.CircledImageView_background_radius_percent, 1, 1, 0.0f);
        this.mCircleRadiusPressedPercent = a.getFraction(R.styleable.CircledImageView_background_radius_pressed_percent, 1, 1, this.mCircleRadiusPercent);
        float shadowWidth = a.getDimension(R.styleable.CircledImageView_background_shadow_width, 0.0f);
        a.recycle();
        this.mOval = new RectF();
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mShadowPainter = new OvalShadowPainter(shadowWidth, 0.0f, this.getCircleRadius(), this.mCircleBorderWidth);
        this.mIndeterminateDrawable = new ProgressDrawable();
        this.mIndeterminateDrawable.setCallback(this.mDrawableCallback);
        this.setWillNotDraw(false);
        this.setColorForCurrentState();
    }

    public void setCircleHidden(boolean circleHidden) {
        if (circleHidden != this.mCircleHidden) {
            this.mCircleHidden = circleHidden;
            this.invalidate();
        }
    }

    protected boolean onSetAlpha(int alpha) {
        return true;
    }

    protected void onDraw(Canvas canvas) {
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        float circleRadius = this.mPressed ? this.getCircleRadiusPressed() : this.getCircleRadius();
        this.mShadowPainter.draw(canvas, this.getAlpha());
        if (this.mCircleBorderWidth > 0.0f) {
            this.mOval.set((float)paddingLeft, (float)paddingTop, (float)(this.getWidth() - this.getPaddingRight()), (float)(this.getHeight() - this.getPaddingBottom()));
            this.mOval.set(this.mOval.centerX() - circleRadius, this.mOval.centerY() - circleRadius, this.mOval.centerX() + circleRadius, this.mOval.centerY() + circleRadius);
            this.mPaint.setColor(this.mCircleBorderColor);
            this.mPaint.setAlpha(Math.round((float)this.mPaint.getAlpha() * this.getAlpha()));
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth(this.mCircleBorderWidth);
            this.mPaint.setStrokeCap(this.mCircleBorderCap);
            if (this.mProgressIndeterminate) {
                this.mOval.roundOut(this.mIndeterminateBounds);
                this.mIndeterminateDrawable.setBounds(this.mIndeterminateBounds);
                this.mIndeterminateDrawable.setRingColor(this.mCircleBorderColor);
                this.mIndeterminateDrawable.setRingWidth(this.mCircleBorderWidth);
                this.mIndeterminateDrawable.draw(canvas);
            } else {
                canvas.drawArc(this.mOval, -90.0f, 360.0f * this.mProgress, false, this.mPaint);
            }
        }
        if (!this.mCircleHidden) {
            this.mOval.set((float)paddingLeft, (float)paddingTop, (float)(this.getWidth() - this.getPaddingRight()), (float)(this.getHeight() - this.getPaddingBottom()));
            this.mPaint.setColor(this.mCurrentColor);
            this.mPaint.setAlpha(Math.round((float)this.mPaint.getAlpha() * this.getAlpha()));
            this.mPaint.setStyle(Paint.Style.FILL);
            float centerX = this.mOval.centerX();
            float centerY = this.mOval.centerY();
            canvas.drawCircle(centerX, centerY, circleRadius, this.mPaint);
        }
        if (this.mDrawable != null) {
            this.mDrawable.setAlpha(Math.round(this.getAlpha() * 255.0f));
            if (this.mImageTint != null) {
                this.mDrawable.setTint(this.mImageTint.intValue());
            }
            this.mDrawable.draw(canvas);
        }
        super.onDraw(canvas);
    }

    private void setColorForCurrentState() {
        int newColor = this.mCircleColor.getColorForState(this.getDrawableState(), this.mCircleColor.getDefaultColor());
        if (this.mColorChangeAnimationDurationMs > 0L) {
            if (this.mColorAnimator != null) {
                this.mColorAnimator.cancel();
            } else {
                this.mColorAnimator = new ValueAnimator();
            }
            this.mColorAnimator.setIntValues(new int[]{this.mCurrentColor, newColor});
            this.mColorAnimator.setEvaluator((TypeEvaluator)ARGB_EVALUATOR);
            this.mColorAnimator.setDuration(this.mColorChangeAnimationDurationMs);
            this.mColorAnimator.addUpdateListener(this.mAnimationListener);
            this.mColorAnimator.start();
        } else if (newColor != this.mCurrentColor) {
            this.mCurrentColor = newColor;
            this.invalidate();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        float radius = this.getCircleRadius() + this.mCircleBorderWidth + this.mShadowPainter.mShadowWidth * this.mShadowPainter.mShadowVisibility;
        float desiredWidth = radius * 2.0f;
        float desiredHeight = radius * 2.0f;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = widthMode == 0x40000000 ? widthSize : (widthMode == Integer.MIN_VALUE ? (int)Math.min(desiredWidth, (float)widthSize) : (int)desiredWidth);
        int height = heightMode == 0x40000000 ? heightSize : (heightMode == Integer.MIN_VALUE ? (int)Math.min(desiredHeight, (float)heightSize) : (int)desiredHeight);
        if (this.mSquareDimen != null) {
            switch (this.mSquareDimen) {
                case 1: {
                    width = height;
                    break;
                }
                case 2: {
                    height = width;
                }
            }
        }
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.mDrawable != null) {
            int nativeDrawableWidth = this.mDrawable.getIntrinsicWidth();
            int nativeDrawableHeight = this.mDrawable.getIntrinsicHeight();
            int viewWidth = this.getMeasuredWidth();
            int viewHeight = this.getMeasuredHeight();
            float imageCirclePercentage = this.mImageCirclePercentage > 0.0f ? this.mImageCirclePercentage : 1.0f;
            float scaleFactor = Math.min(1.0f, Math.min((float)nativeDrawableWidth != 0.0f ? imageCirclePercentage * (float)viewWidth / (float)nativeDrawableWidth : 1.0f, (float)nativeDrawableHeight != 0.0f ? imageCirclePercentage * (float)viewHeight / (float)nativeDrawableHeight : 1.0f));
            int drawableWidth = Math.round(scaleFactor * (float)nativeDrawableWidth);
            int drawableHeight = Math.round(scaleFactor * (float)nativeDrawableHeight);
            int drawableLeft = (viewWidth - drawableWidth) / 2 + Math.round(this.mImageHorizontalOffcenterPercentage * (float)drawableWidth);
            int drawableTop = (viewHeight - drawableHeight) / 2;
            this.mDrawable.setBounds(drawableLeft, drawableTop, drawableLeft + drawableWidth, drawableTop + drawableHeight);
        }
        super.onLayout(changed, left, top, right, bottom);
    }

    public void setImageResource(int resId) {
        this.setImageDrawable(resId == 0 ? null : this.getContext().getDrawable(resId));
    }

    public void setImageCirclePercentage(float percentage) {
        float clamped = Math.max(0.0f, Math.min(1.0f, percentage));
        if (clamped != this.mImageCirclePercentage) {
            this.mImageCirclePercentage = clamped;
            this.invalidate();
        }
    }

    public void setImageHorizontalOffcenterPercentage(float percentage) {
        if (percentage != this.mImageHorizontalOffcenterPercentage) {
            this.mImageHorizontalOffcenterPercentage = percentage;
            this.invalidate();
        }
    }

    public void setImageTint(int tint) {
        if (this.mImageTint == null || tint != this.mImageTint) {
            this.mImageTint = tint;
            this.invalidate();
        }
    }

    public float getCircleRadius() {
        float radius = this.mCircleRadius;
        if (this.mCircleRadius <= 0.0f && this.mCircleRadiusPercent > 0.0f) {
            radius = (float)Math.max(this.getMeasuredHeight(), this.getMeasuredWidth()) * this.mCircleRadiusPercent;
        }
        return radius - this.mRadiusInset;
    }

    public void setCircleRadius(float circleRadius) {
        if (circleRadius != this.mCircleRadius) {
            this.mCircleRadius = circleRadius;
            this.mShadowPainter.setInnerCircleRadius(this.mPressed ? this.getCircleRadiusPressed() : this.getCircleRadius());
            this.invalidate();
        }
    }

    public float getCircleRadiusPercent() {
        return this.mCircleRadiusPercent;
    }

    public void setCircleRadiusPercent(float circleRadiusPercent) {
        if (circleRadiusPercent != this.mCircleRadiusPercent) {
            this.mCircleRadiusPercent = circleRadiusPercent;
            this.mShadowPainter.setInnerCircleRadius(this.mPressed ? this.getCircleRadiusPressed() : this.getCircleRadius());
            this.invalidate();
        }
    }

    public float getCircleRadiusPressed() {
        float radius = this.mCircleRadiusPressed;
        if (this.mCircleRadiusPressed <= 0.0f && this.mCircleRadiusPressedPercent > 0.0f) {
            radius = (float)Math.max(this.getMeasuredHeight(), this.getMeasuredWidth()) * this.mCircleRadiusPressedPercent;
        }
        return radius - this.mRadiusInset;
    }

    public void setCircleRadiusPressed(float circleRadiusPressed) {
        if (circleRadiusPressed != this.mCircleRadiusPressed) {
            this.mCircleRadiusPressed = circleRadiusPressed;
            this.invalidate();
        }
    }

    public float getCircleRadiusPressedPercent() {
        return this.mCircleRadiusPressedPercent;
    }

    public void setCircleRadiusPressedPercent(float circleRadiusPressedPercent) {
        if (circleRadiusPressedPercent != this.mCircleRadiusPressedPercent) {
            this.mCircleRadiusPressedPercent = circleRadiusPressedPercent;
            this.mShadowPainter.setInnerCircleRadius(this.mPressed ? this.getCircleRadiusPressed() : this.getCircleRadius());
            this.invalidate();
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.setColorForCurrentState();
    }

    public void setCircleColor(int circleColor) {
        this.setCircleColorStateList(ColorStateList.valueOf((int)circleColor));
    }

    public ColorStateList getCircleColorStateList() {
        return this.mCircleColor;
    }

    public void setCircleColorStateList(ColorStateList circleColor) {
        if (!Objects.equals(circleColor, this.mCircleColor)) {
            this.mCircleColor = circleColor;
            this.setColorForCurrentState();
            this.invalidate();
        }
    }

    public int getDefaultCircleColor() {
        return this.mCircleColor.getDefaultColor();
    }

    public void showIndeterminateProgress(boolean show) {
        this.mProgressIndeterminate = show;
        if (this.mIndeterminateDrawable != null) {
            if (show && this.mVisible && this.mWindowVisible) {
                this.mIndeterminateDrawable.startAnimation();
            } else {
                this.mIndeterminateDrawable.stopAnimation();
            }
        }
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.mVisible = visibility == 0;
        this.showIndeterminateProgress(this.mProgressIndeterminate);
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mWindowVisible = visibility == 0;
        this.showIndeterminateProgress(this.mProgressIndeterminate);
    }

    public void setProgress(float progress) {
        if (progress != this.mProgress) {
            this.mProgress = progress;
            this.invalidate();
        }
    }

    public void setShadowVisibility(float shadowVisibility) {
        if (shadowVisibility != this.mShadowPainter.mShadowVisibility) {
            this.mShadowPainter.setShadowVisibility(shadowVisibility);
            this.invalidate();
        }
    }

    public float getInitialCircleRadius() {
        return this.mInitialCircleRadius;
    }

    public void setCircleBorderColor(int circleBorderColor) {
        this.mCircleBorderColor = circleBorderColor;
    }

    public void setCircleBorderWidth(float circleBorderWidth) {
        if (circleBorderWidth != this.mCircleBorderWidth) {
            this.mCircleBorderWidth = circleBorderWidth;
            this.mShadowPainter.setInnerCircleBorderWidth(circleBorderWidth);
            this.invalidate();
        }
    }

    public void setCircleBorderCap(Paint.Cap circleBorderCap) {
        if (circleBorderCap != this.mCircleBorderCap) {
            this.mCircleBorderCap = circleBorderCap;
            this.invalidate();
        }
    }

    public void setPressed(boolean pressed) {
        super.setPressed(pressed);
        if (pressed != this.mPressed) {
            this.mPressed = pressed;
            this.mShadowPainter.setInnerCircleRadius(this.mPressed ? this.getCircleRadiusPressed() : this.getCircleRadius());
            this.invalidate();
        }
    }

    public void setPadding(@Px int left, @Px int top, @Px int right, @Px int bottom) {
        if (left != this.getPaddingLeft() || top != this.getPaddingTop() || right != this.getPaddingRight() || bottom != this.getPaddingBottom()) {
            this.mShadowPainter.setBounds(left, top, this.getWidth() - right, this.getHeight() - bottom);
        }
        super.setPadding(left, top, right, bottom);
    }

    public void onSizeChanged(int newWidth, int newHeight, int oldWidth, int oldHeight) {
        if (newWidth != oldWidth || newHeight != oldHeight) {
            this.mShadowPainter.setBounds(this.getPaddingLeft(), this.getPaddingTop(), newWidth - this.getPaddingRight(), newHeight - this.getPaddingBottom());
        }
    }

    public Drawable getImageDrawable() {
        return this.mDrawable;
    }

    public void setImageDrawable(Drawable drawable2) {
        if (drawable2 != this.mDrawable) {
            boolean skipLayout;
            Drawable existingDrawable = this.mDrawable;
            this.mDrawable = drawable2;
            if (this.mDrawable != null && this.mDrawable.getConstantState() != null) {
                this.mDrawable = this.mDrawable.getConstantState().newDrawable(this.getResources(), this.getContext().getTheme()).mutate();
            }
            boolean bl = skipLayout = drawable2 != null && existingDrawable != null && existingDrawable.getIntrinsicHeight() == drawable2.getIntrinsicHeight() && existingDrawable.getIntrinsicWidth() == drawable2.getIntrinsicWidth();
            if (skipLayout) {
                this.mDrawable.setBounds(existingDrawable.getBounds());
            } else {
                this.requestLayout();
            }
            this.invalidate();
        }
    }

    public long getColorChangeAnimationDuration() {
        return this.mColorChangeAnimationDurationMs;
    }

    public void setColorChangeAnimationDuration(long mColorChangeAnimationDurationMs) {
        this.mColorChangeAnimationDurationMs = mColorChangeAnimationDurationMs;
    }

    private static class OvalShadowPainter {
        private final int[] mShaderColors = new int[]{-16777216, 0};
        private final float[] mShaderStops = new float[]{0.6f, 1.0f};
        private final RectF mBounds = new RectF();
        final float mShadowWidth;
        private final Paint mShadowPaint = new Paint();
        private float mShadowRadius;
        float mShadowVisibility;
        private float mInnerCircleRadius;
        private float mInnerCircleBorderWidth;

        OvalShadowPainter(float shadowWidth, float shadowVisibility, float innerCircleRadius, float innerCircleBorderWidth) {
            this.mShadowWidth = shadowWidth;
            this.mShadowVisibility = shadowVisibility;
            this.mInnerCircleRadius = innerCircleRadius;
            this.mInnerCircleBorderWidth = innerCircleBorderWidth;
            this.mShadowRadius = this.mInnerCircleRadius + this.mInnerCircleBorderWidth + this.mShadowWidth * this.mShadowVisibility;
            this.mShadowPaint.setColor(-16777216);
            this.mShadowPaint.setStyle(Paint.Style.FILL);
            this.mShadowPaint.setAntiAlias(true);
            this.updateRadialGradient();
        }

        void draw(Canvas canvas, float alpha) {
            if (this.mShadowWidth > 0.0f && this.mShadowVisibility > 0.0f) {
                this.mShadowPaint.setAlpha(Math.round((float)this.mShadowPaint.getAlpha() * alpha));
                canvas.drawCircle(this.mBounds.centerX(), this.mBounds.centerY(), this.mShadowRadius, this.mShadowPaint);
            }
        }

        void setBounds(@Px int left, @Px int top, @Px int right, @Px int bottom) {
            this.mBounds.set((float)left, (float)top, (float)right, (float)bottom);
            this.updateRadialGradient();
        }

        void setInnerCircleRadius(float newInnerCircleRadius) {
            this.mInnerCircleRadius = newInnerCircleRadius;
            this.updateRadialGradient();
        }

        void setInnerCircleBorderWidth(float newInnerCircleBorderWidth) {
            this.mInnerCircleBorderWidth = newInnerCircleBorderWidth;
            this.updateRadialGradient();
        }

        void setShadowVisibility(float newShadowVisibility) {
            this.mShadowVisibility = newShadowVisibility;
            this.updateRadialGradient();
        }

        private void updateRadialGradient() {
            this.mShadowRadius = this.mInnerCircleRadius + this.mInnerCircleBorderWidth + this.mShadowWidth * this.mShadowVisibility;
            if (this.mShadowRadius > 0.0f) {
                this.mShadowPaint.setShader((Shader)new RadialGradient(this.mBounds.centerX(), this.mBounds.centerY(), this.mShadowRadius, this.mShaderColors, this.mShaderStops, Shader.TileMode.MIRROR));
            }
        }
    }
}

