/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.widget;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.MainThread;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.ContextCompat;
import android.support.wear.R;
import android.support.wear.widget.ResourcesUtil;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.TextView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;

public class ConfirmationOverlay {
    public static final int DEFAULT_ANIMATION_DURATION_MS = 1000;
    public static final int SUCCESS_ANIMATION = 0;
    public static final int FAILURE_ANIMATION = 1;
    public static final int OPEN_ON_PHONE_ANIMATION = 2;
    private int mType = 0;
    private int mDurationMillis = 1000;
    OnAnimationFinishedListener mListener;
    private String mMessage;
    View mOverlayView;
    private Drawable mOverlayDrawable;
    boolean mIsShowing = false;
    private final Handler mMainThreadHandler = new Handler(Looper.getMainLooper());
    private final Runnable mHideRunnable = new Runnable(){

        @Override
        public void run() {
            ConfirmationOverlay.this.hide();
        }
    };

    public ConfirmationOverlay setMessage(String message) {
        this.mMessage = message;
        return this;
    }

    public ConfirmationOverlay setType(int type) {
        this.mType = type;
        return this;
    }

    public ConfirmationOverlay setDuration(int millis) {
        this.mDurationMillis = millis;
        return this;
    }

    public ConfirmationOverlay setFinishedAnimationListener(@Nullable OnAnimationFinishedListener listener) {
        this.mListener = listener;
        return this;
    }

    @MainThread
    public void showAbove(View view) {
        if (this.mIsShowing) {
            return;
        }
        this.mIsShowing = true;
        this.updateOverlayView(view.getContext());
        ((ViewGroup)view.getRootView()).addView(this.mOverlayView);
        this.animateAndHideAfterDelay();
    }

    @MainThread
    public void showOn(Activity activity) {
        if (this.mIsShowing) {
            return;
        }
        this.mIsShowing = true;
        this.updateOverlayView((Context)activity);
        activity.getWindow().addContentView(this.mOverlayView, this.mOverlayView.getLayoutParams());
        this.animateAndHideAfterDelay();
    }

    @MainThread
    private void animateAndHideAfterDelay() {
        if (this.mOverlayDrawable instanceof Animatable) {
            Animatable animatable = (Animatable)this.mOverlayDrawable;
            animatable.start();
        }
        this.mMainThreadHandler.postDelayed(this.mHideRunnable, (long)this.mDurationMillis);
    }

    @MainThread
    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void hide() {
        Animation fadeOut = AnimationUtils.loadAnimation((Context)this.mOverlayView.getContext(), (int)0x10A0001);
        fadeOut.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                ConfirmationOverlay.this.mOverlayView.clearAnimation();
            }

            public void onAnimationEnd(Animation animation) {
                ((ViewGroup)ConfirmationOverlay.this.mOverlayView.getParent()).removeView(ConfirmationOverlay.this.mOverlayView);
                ConfirmationOverlay.this.mIsShowing = false;
                if (ConfirmationOverlay.this.mListener != null) {
                    ConfirmationOverlay.this.mListener.onAnimationFinished();
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.mOverlayView.startAnimation(fadeOut);
    }

    @MainThread
    private void updateOverlayView(Context context) {
        if (this.mOverlayView == null) {
            this.mOverlayView = LayoutInflater.from((Context)context).inflate(R.layout.ws_overlay_confirmation, null);
        }
        this.mOverlayView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
        this.mOverlayView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.updateImageView(context, this.mOverlayView);
        this.updateMessageView(context, this.mOverlayView);
    }

    @MainThread
    private void updateMessageView(Context context, View overlayView) {
        TextView messageView = (TextView)overlayView.findViewById(R.id.wearable_support_confirmation_overlay_message);
        if (this.mMessage != null) {
            int screenWidthPx = ResourcesUtil.getScreenWidthPx(context);
            int topMarginPx = ResourcesUtil.getFractionOfScreenPx(context, screenWidthPx, R.fraction.confirmation_overlay_margin_above_text);
            int sideMarginPx = ResourcesUtil.getFractionOfScreenPx(context, screenWidthPx, R.fraction.confirmation_overlay_margin_side);
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)messageView.getLayoutParams();
            layoutParams.topMargin = topMarginPx;
            layoutParams.leftMargin = sideMarginPx;
            layoutParams.rightMargin = sideMarginPx;
            messageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            messageView.setText((CharSequence)this.mMessage);
            messageView.setVisibility(0);
        } else {
            messageView.setVisibility(8);
        }
    }

    @MainThread
    private void updateImageView(Context context, View overlayView) {
        switch (this.mType) {
            case 0: {
                this.mOverlayDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.generic_confirmation_animation);
                break;
            }
            case 1: {
                this.mOverlayDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.ws_full_sad);
                break;
            }
            case 2: {
                this.mOverlayDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.ws_open_on_phone_animation);
                break;
            }
            default: {
                String errorMessage = String.format(Locale.US, "Invalid ConfirmationOverlay type [%d]", this.mType);
                throw new IllegalStateException(errorMessage);
            }
        }
        ImageView imageView = (ImageView)overlayView.findViewById(R.id.wearable_support_confirmation_overlay_image);
        imageView.setImageDrawable(this.mOverlayDrawable);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OverlayType {
    }

    public static interface OnAnimationFinishedListener {
        public void onAnimationFinished();
    }
}

