/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.widget;

import android.support.annotation.RestrictTo;
import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.VelocityTracker;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
class ScrollManager {
    private static final int ONE_SEC_IN_MS = 1000;
    private static final float VELOCITY_MULTIPLIER = 1.5f;
    private static final float FLING_EDGE_RATIO = 1.5f;
    private float mMinRadiusFraction = 0.0f;
    private float mMinRadiusFractionSquared = this.mMinRadiusFraction * this.mMinRadiusFraction;
    private float mScrollDegreesPerScreen = 180.0f;
    private float mScrollRadiansPerScreen = (float)Math.toRadians(this.mScrollDegreesPerScreen);
    private float mScreenRadiusPx;
    private float mScreenRadiusPxSquared;
    private float mScrollPixelsPerRadian;
    private boolean mDown;
    private boolean mScrolling;
    private float mLastAngleRadians;
    private RecyclerView mRecyclerView;
    VelocityTracker mVelocityTracker;

    ScrollManager() {
    }

    void setRecyclerView(RecyclerView recyclerView, int width, int height) {
        this.mRecyclerView = recyclerView;
        this.mScreenRadiusPx = (float)Math.max(width, height) / 2.0f;
        this.mScreenRadiusPxSquared = this.mScreenRadiusPx * this.mScreenRadiusPx;
        this.mScrollPixelsPerRadian = (float)height / this.mScrollRadiansPerScreen;
        this.mVelocityTracker = VelocityTracker.obtain();
    }

    void clearRecyclerView() {
        this.mRecyclerView = null;
    }

    boolean onTouchEvent(MotionEvent event) {
        float deltaX = event.getRawX() - this.mScreenRadiusPx;
        float deltaY = event.getRawY() - this.mScreenRadiusPx;
        float radiusSquared = deltaX * deltaX + deltaY * deltaY;
        MotionEvent vtev = MotionEvent.obtain((MotionEvent)event);
        this.mVelocityTracker.addMovement(vtev);
        vtev.recycle();
        switch (event.getActionMasked()) {
            case 0: {
                if (!(radiusSquared / this.mScreenRadiusPxSquared > this.mMinRadiusFractionSquared)) break;
                this.mDown = true;
                return true;
            }
            case 2: {
                if (this.mScrolling) {
                    float angleRadians = (float)Math.atan2(deltaY, deltaX);
                    float deltaRadians = angleRadians - this.mLastAngleRadians;
                    int scrollPixels = Math.round((deltaRadians = ScrollManager.normalizeAngleRadians(deltaRadians)) * this.mScrollPixelsPerRadian);
                    if (scrollPixels != 0) {
                        this.mRecyclerView.scrollBy(0, scrollPixels);
                        deltaRadians = (float)scrollPixels / this.mScrollPixelsPerRadian;
                        this.mLastAngleRadians += deltaRadians;
                        this.mLastAngleRadians = ScrollManager.normalizeAngleRadians(this.mLastAngleRadians);
                    }
                    return true;
                }
                if (this.mDown) {
                    float deltaYFromCenter;
                    float deltaXFromCenter = event.getRawX() - this.mScreenRadiusPx;
                    float distFromCenter = (float)Math.hypot(deltaXFromCenter, deltaYFromCenter = event.getRawY() - this.mScreenRadiusPx);
                    if (distFromCenter == 0.0f) break;
                    this.mScrolling = true;
                    this.mRecyclerView.invalidate();
                    this.mLastAngleRadians = (float)Math.atan2(deltaYFromCenter /= distFromCenter, deltaXFromCenter /= distFromCenter);
                    return true;
                }
                if (!(radiusSquared / this.mScreenRadiusPxSquared > this.mMinRadiusFractionSquared)) break;
                this.mDown = true;
                return true;
            }
            case 1: {
                this.mDown = false;
                this.mScrolling = false;
                this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mRecyclerView.getMaxFlingVelocity());
                int velocityY = (int)this.mVelocityTracker.getYVelocity();
                if (event.getX() < 1.5f * this.mScreenRadiusPx) {
                    velocityY = -velocityY;
                }
                this.mVelocityTracker.clear();
                if (Math.abs(velocityY) <= this.mRecyclerView.getMinFlingVelocity()) break;
                return this.mRecyclerView.fling(0, (int)(1.5f * (float)velocityY));
            }
            case 3: {
                if (!this.mDown) break;
                this.mDown = false;
                this.mScrolling = false;
                this.mRecyclerView.invalidate();
                return true;
            }
        }
        return false;
    }

    private static float normalizeAngleRadians(float angleRadians) {
        if ((double)angleRadians < -Math.PI) {
            angleRadians = (float)((double)angleRadians + Math.PI * 2);
        }
        if ((double)angleRadians > Math.PI) {
            angleRadians = (float)((double)angleRadians - Math.PI * 2);
        }
        return angleRadians;
    }

    public void setScrollDegreesPerScreen(float degreesPerScreen) {
        this.mScrollDegreesPerScreen = degreesPerScreen;
        this.mScrollRadiansPerScreen = (float)Math.toRadians(this.mScrollDegreesPerScreen);
    }

    public void setBezelWidth(float fraction2) {
        this.mMinRadiusFraction = 1.0f - fraction2;
        this.mMinRadiusFractionSquared = this.mMinRadiusFraction * this.mMinRadiusFraction;
    }

    public float getScrollDegreesPerScreen() {
        return this.mScrollDegreesPerScreen;
    }

    public float getBezelWidth() {
        return 1.0f - this.mMinRadiusFraction;
    }
}

