/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.widget;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.support.annotation.UiThread;
import android.support.wear.widget.SwipeDismissLayout;
import android.util.AttributeSet;
import android.util.Log;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import java.util.ArrayList;

@UiThread
public class SwipeDismissFrameLayout
extends SwipeDismissLayout {
    private static final String TAG = "SwipeDismissFrameLayout";
    private static final float TRANSLATION_MIN_ALPHA = 0.5f;
    private static final float DEFAULT_INTERPOLATION_FACTOR = 1.5f;
    private final SwipeDismissLayout.OnPreSwipeListener mOnPreSwipeListener = new MyOnPreSwipeListener();
    private final SwipeDismissLayout.OnDismissedListener mOnDismissedListener = new MyOnDismissedListener();
    private final SwipeDismissLayout.OnSwipeProgressChangedListener mOnSwipeProgressListener = new MyOnSwipeProgressChangedListener();
    final ArrayList<Callback> mCallbacks = new ArrayList();
    final int mAnimationTime;
    final DecelerateInterpolator mCancelInterpolator;
    final AccelerateInterpolator mDismissInterpolator;
    final DecelerateInterpolator mCompleteDismissGestureInterpolator;
    boolean mStarted;

    public SwipeDismissFrameLayout(Context context) {
        this(context, null, 0);
    }

    public SwipeDismissFrameLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwipeDismissFrameLayout(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, 0);
    }

    public SwipeDismissFrameLayout(Context context, AttributeSet attrs, int defStyle, int defStyleRes) {
        super(context, attrs, defStyle, defStyleRes);
        this.setOnPreSwipeListener(this.mOnPreSwipeListener);
        this.setOnDismissedListener(this.mOnDismissedListener);
        this.setOnSwipeProgressChangedListener(this.mOnSwipeProgressListener);
        this.mAnimationTime = this.getContext().getResources().getInteger(0x10E0000);
        this.mCancelInterpolator = new DecelerateInterpolator(1.5f);
        this.mDismissInterpolator = new AccelerateInterpolator(1.5f);
        this.mCompleteDismissGestureInterpolator = new DecelerateInterpolator(1.5f);
    }

    public void addCallback(Callback callback) {
        if (callback == null) {
            throw new NullPointerException("addCallback called with null callback");
        }
        this.mCallbacks.add(callback);
    }

    public void removeCallback(Callback callback) {
        if (callback == null) {
            throw new NullPointerException("removeCallback called with null callback");
        }
        if (!this.mCallbacks.remove(callback)) {
            throw new IllegalStateException("removeCallback called with nonexistent callback");
        }
    }

    void resetTranslationAndAlpha() {
        this.animate().cancel();
        this.setTranslationX(0.0f);
        this.setAlpha(1.0f);
        this.mStarted = false;
    }

    private final class MyOnSwipeProgressChangedListener
    implements SwipeDismissLayout.OnSwipeProgressChangedListener {
        MyOnSwipeProgressChangedListener() {
        }

        @Override
        public void onSwipeProgressChanged(SwipeDismissLayout layout2, float progress, float translate) {
            if (Log.isLoggable((String)SwipeDismissFrameLayout.TAG, (int)3)) {
                Log.d((String)SwipeDismissFrameLayout.TAG, (String)("onSwipeProgressChanged() - " + translate));
            }
            SwipeDismissFrameLayout.this.setTranslationX(translate);
            SwipeDismissFrameLayout.this.setAlpha(1.0f - progress * 0.5f);
            if (!SwipeDismissFrameLayout.this.mStarted) {
                for (int i = SwipeDismissFrameLayout.this.mCallbacks.size() - 1; i >= 0; --i) {
                    Callback callbacks = SwipeDismissFrameLayout.this.mCallbacks.get(i);
                    callbacks.onSwipeStarted(SwipeDismissFrameLayout.this);
                }
                SwipeDismissFrameLayout.this.mStarted = true;
            }
        }

        @Override
        public void onSwipeCanceled(SwipeDismissLayout layout2) {
            if (Log.isLoggable((String)SwipeDismissFrameLayout.TAG, (int)3)) {
                Log.d((String)SwipeDismissFrameLayout.TAG, (String)"onSwipeCanceled() run swipe cancel animation");
            }
            SwipeDismissFrameLayout.this.mStarted = false;
            SwipeDismissFrameLayout.this.animate().translationX(0.0f).alpha(1.0f).setDuration((long)SwipeDismissFrameLayout.this.mAnimationTime).setInterpolator((TimeInterpolator)SwipeDismissFrameLayout.this.mCancelInterpolator).withEndAction(new Runnable(){

                @Override
                public void run() {
                    for (int i = SwipeDismissFrameLayout.this.mCallbacks.size() - 1; i >= 0; --i) {
                        Callback callbacks = SwipeDismissFrameLayout.this.mCallbacks.get(i);
                        callbacks.onSwipeCanceled(SwipeDismissFrameLayout.this);
                    }
                    SwipeDismissFrameLayout.this.resetTranslationAndAlpha();
                }
            });
        }
    }

    private final class MyOnDismissedListener
    implements SwipeDismissLayout.OnDismissedListener {
        MyOnDismissedListener() {
        }

        @Override
        public void onDismissed(SwipeDismissLayout layout2) {
            if (Log.isLoggable((String)SwipeDismissFrameLayout.TAG, (int)3)) {
                Log.d((String)SwipeDismissFrameLayout.TAG, (String)"onDismissed()");
            }
            SwipeDismissFrameLayout.this.animate().translationX((float)SwipeDismissFrameLayout.this.getWidth()).alpha(0.0f).setDuration((long)SwipeDismissFrameLayout.this.mAnimationTime).setInterpolator((TimeInterpolator)(SwipeDismissFrameLayout.this.mStarted ? SwipeDismissFrameLayout.this.mCompleteDismissGestureInterpolator : SwipeDismissFrameLayout.this.mDismissInterpolator)).withEndAction(new Runnable(){

                @Override
                public void run() {
                    for (int i = SwipeDismissFrameLayout.this.mCallbacks.size() - 1; i >= 0; --i) {
                        Callback callbacks = SwipeDismissFrameLayout.this.mCallbacks.get(i);
                        callbacks.onDismissed(SwipeDismissFrameLayout.this);
                    }
                    SwipeDismissFrameLayout.this.resetTranslationAndAlpha();
                }
            });
        }
    }

    private final class MyOnPreSwipeListener
    implements SwipeDismissLayout.OnPreSwipeListener {
        MyOnPreSwipeListener() {
        }

        @Override
        public boolean onPreSwipe(SwipeDismissLayout layout2, float xDown, float yDown) {
            for (Callback callback : SwipeDismissFrameLayout.this.mCallbacks) {
                if (callback.onPreSwipeStart(SwipeDismissFrameLayout.this, xDown, yDown)) continue;
                return false;
            }
            return true;
        }
    }

    @UiThread
    public static abstract class Callback {
        boolean onPreSwipeStart(SwipeDismissFrameLayout layout2, float xDown, float yDown) {
            return true;
        }

        public void onSwipeStarted(SwipeDismissFrameLayout layout2) {
        }

        public void onSwipeCanceled(SwipeDismissFrameLayout layout2) {
        }

        public void onDismissed(SwipeDismissFrameLayout layout2) {
        }
    }
}

