/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.support.wear.R;
import android.support.wear.widget.ScrollManager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;

public class WearableRecyclerView
extends RecyclerView {
    private static final String TAG = "WearableRecyclerView";
    private static final int NO_VALUE = Integer.MIN_VALUE;
    private final ScrollManager mScrollManager = new ScrollManager();
    private boolean mCircularScrollingEnabled;
    private boolean mEdgeItemsCenteringEnabled;
    boolean mCenterEdgeItemsWhenThereAreChildren;
    private int mOriginalPaddingTop = Integer.MIN_VALUE;
    private int mOriginalPaddingBottom = Integer.MIN_VALUE;
    private final ViewTreeObserver.OnPreDrawListener mPaddingPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

        public boolean onPreDraw() {
            if (WearableRecyclerView.this.mCenterEdgeItemsWhenThereAreChildren && WearableRecyclerView.this.getChildCount() > 0) {
                WearableRecyclerView.this.setupCenteredPadding();
                WearableRecyclerView.this.mCenterEdgeItemsWhenThereAreChildren = false;
            }
            return true;
        }
    };

    public WearableRecyclerView(Context context) {
        this(context, null);
    }

    public WearableRecyclerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WearableRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, 0);
    }

    public WearableRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle, int defStyleRes) {
        super(context, attrs, defStyle);
        this.setHasFixedSize(true);
        this.setClipToPadding(false);
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.WearableRecyclerView, defStyle, defStyleRes);
            this.setCircularScrollingGestureEnabled(a.getBoolean(R.styleable.WearableRecyclerView_circularScrollingGestureEnabled, this.mCircularScrollingEnabled));
            this.setBezelFraction(a.getFloat(R.styleable.WearableRecyclerView_bezelWidth, this.mScrollManager.getBezelWidth()));
            this.setScrollDegreesPerScreen(a.getFloat(R.styleable.WearableRecyclerView_scrollDegreesPerScreen, this.mScrollManager.getScrollDegreesPerScreen()));
            a.recycle();
        }
    }

    void setupCenteredPadding() {
        if (this.getChildCount() < 1 || !this.mEdgeItemsCenteringEnabled) {
            return;
        }
        View child = this.getChildAt(0);
        int height = child.getHeight();
        int desiredPadding = (int)((float)this.getHeight() * 0.5f - (float)height * 0.5f);
        if (this.getPaddingTop() != desiredPadding) {
            this.mOriginalPaddingTop = this.getPaddingTop();
            this.mOriginalPaddingBottom = this.getPaddingBottom();
            this.setPadding(this.getPaddingLeft(), desiredPadding, this.getPaddingRight(), desiredPadding);
            View focusedChild = this.getFocusedChild();
            int focusedPosition = focusedChild != null ? this.getLayoutManager().getPosition(focusedChild) : 0;
            this.getLayoutManager().scrollToPosition(focusedPosition);
        }
    }

    private void setupOriginalPadding() {
        if (this.mOriginalPaddingTop == Integer.MIN_VALUE) {
            return;
        }
        this.setPadding(this.getPaddingLeft(), this.mOriginalPaddingTop, this.getPaddingRight(), this.mOriginalPaddingBottom);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mCircularScrollingEnabled && this.mScrollManager.onTouchEvent(event)) {
            return true;
        }
        return super.onTouchEvent(event);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Point screenSize = new Point();
        this.getDisplay().getSize(screenSize);
        this.mScrollManager.setRecyclerView(this, screenSize.x, screenSize.y);
        this.getViewTreeObserver().addOnPreDrawListener(this.mPaddingPreDrawListener);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mScrollManager.clearRecyclerView();
        this.getViewTreeObserver().removeOnPreDrawListener(this.mPaddingPreDrawListener);
    }

    public void setCircularScrollingGestureEnabled(boolean circularScrollingGestureEnabled) {
        this.mCircularScrollingEnabled = circularScrollingGestureEnabled;
    }

    public boolean isCircularScrollingGestureEnabled() {
        return this.mCircularScrollingEnabled;
    }

    public void setScrollDegreesPerScreen(float degreesPerScreen) {
        this.mScrollManager.setScrollDegreesPerScreen(degreesPerScreen);
    }

    public float getScrollDegreesPerScreen() {
        return this.mScrollManager.getScrollDegreesPerScreen();
    }

    public void setBezelFraction(float fraction2) {
        this.mScrollManager.setBezelWidth(fraction2);
    }

    public float getBezelFraction() {
        return this.mScrollManager.getBezelWidth();
    }

    public void setEdgeItemsCenteringEnabled(boolean isEnabled) {
        this.mEdgeItemsCenteringEnabled = isEnabled;
        if (this.mEdgeItemsCenteringEnabled) {
            if (this.getChildCount() > 0) {
                this.setupCenteredPadding();
            } else {
                this.mCenterEdgeItemsWhenThereAreChildren = true;
            }
        } else {
            this.setupOriginalPadding();
            this.mCenterEdgeItemsWhenThereAreChildren = false;
        }
    }

    public boolean isEdgeItemsCenteringEnabled() {
        return this.mEdgeItemsCenteringEnabled;
    }
}

