/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.widget.drawer;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.RestrictTo;
import android.support.v4.widget.NestedScrollView;
import android.support.wear.widget.drawer.FlingWatcherFactory;
import android.view.View;
import java.lang.ref.WeakReference;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
class NestedScrollViewFlingWatcher
implements FlingWatcherFactory.FlingWatcher,
NestedScrollView.OnScrollChangeListener {
    static final int MAX_WAIT_TIME_MS = 100;
    private final Handler mMainThreadHandler = new Handler(Looper.getMainLooper());
    private final FlingWatcherFactory.FlingListener mListener;
    private final WeakReference<NestedScrollView> mNestedScrollView;
    private final Runnable mNotifyListenerRunnable = new Runnable(){

        @Override
        public void run() {
            NestedScrollViewFlingWatcher.this.onEndOfFlingFound();
        }
    };

    NestedScrollViewFlingWatcher(FlingWatcherFactory.FlingListener listener, NestedScrollView nestedScrollView) {
        this.mListener = listener;
        this.mNestedScrollView = new WeakReference<NestedScrollView>(nestedScrollView);
    }

    private static boolean isViewAtTopOrBottom(View view) {
        return !view.canScrollVertically(-1) || !view.canScrollVertically(1);
    }

    @Override
    public void watch() {
        NestedScrollView nestedScrollView = (NestedScrollView)this.mNestedScrollView.get();
        if (nestedScrollView != null) {
            nestedScrollView.setOnScrollChangeListener((NestedScrollView.OnScrollChangeListener)this);
            this.scheduleNext();
        }
    }

    public void onScrollChange(NestedScrollView v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
        if (NestedScrollViewFlingWatcher.isViewAtTopOrBottom((View)v)) {
            this.onEndOfFlingFound();
        } else {
            this.scheduleNext();
        }
    }

    void onEndOfFlingFound() {
        this.mMainThreadHandler.removeCallbacks(this.mNotifyListenerRunnable);
        NestedScrollView nestedScrollView = (NestedScrollView)this.mNestedScrollView.get();
        if (nestedScrollView != null) {
            nestedScrollView.setOnScrollChangeListener((NestedScrollView.OnScrollChangeListener)null);
            this.mListener.onFlingComplete((View)nestedScrollView);
        }
    }

    private void scheduleNext() {
        this.mMainThreadHandler.removeCallbacks(this.mNotifyListenerRunnable);
        this.mMainThreadHandler.postDelayed(this.mNotifyListenerRunnable, 100L);
    }
}

