/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.widget.drawer;

import android.animation.Animator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import android.support.annotation.RestrictTo;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.wear.R;
import android.support.wear.widget.SimpleAnimatorListener;
import android.util.AttributeSet;
import android.view.View;
import java.util.concurrent.TimeUnit;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class PageIndicatorView
extends View
implements ViewPager.OnPageChangeListener {
    private static final String TAG = "Dots";
    private final Paint mDotPaint;
    private final Paint mDotPaintShadow;
    private final Paint mDotPaintSelected;
    private final Paint mDotPaintShadowSelected;
    private int mDotSpacing;
    private float mDotRadius;
    private float mDotRadiusSelected;
    private int mDotColor;
    private int mDotColorSelected;
    private boolean mDotFadeWhenIdle;
    int mDotFadeOutDelay;
    int mDotFadeOutDuration;
    private int mDotFadeInDuration;
    private float mDotShadowDx;
    private float mDotShadowDy;
    private float mDotShadowRadius;
    private int mDotShadowColor;
    private PagerAdapter mAdapter;
    private int mNumberOfPositions;
    private int mSelectedPosition;
    private int mCurrentViewPagerState;
    boolean mVisible;

    public PageIndicatorView(Context context) {
        this(context, null);
    }

    public PageIndicatorView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PageIndicatorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.PageIndicatorView, defStyleAttr, R.style.WsPageIndicatorViewStyle);
        this.mDotSpacing = a.getDimensionPixelOffset(R.styleable.PageIndicatorView_wsPageIndicatorDotSpacing, 0);
        this.mDotRadius = a.getDimension(R.styleable.PageIndicatorView_wsPageIndicatorDotRadius, 0.0f);
        this.mDotRadiusSelected = a.getDimension(R.styleable.PageIndicatorView_wsPageIndicatorDotRadiusSelected, 0.0f);
        this.mDotColor = a.getColor(R.styleable.PageIndicatorView_wsPageIndicatorDotColor, 0);
        this.mDotColorSelected = a.getColor(R.styleable.PageIndicatorView_wsPageIndicatorDotColorSelected, 0);
        this.mDotFadeOutDelay = a.getInt(R.styleable.PageIndicatorView_wsPageIndicatorDotFadeOutDelay, 0);
        this.mDotFadeOutDuration = a.getInt(R.styleable.PageIndicatorView_wsPageIndicatorDotFadeOutDuration, 0);
        this.mDotFadeInDuration = a.getInt(R.styleable.PageIndicatorView_wsPageIndicatorDotFadeInDuration, 0);
        this.mDotFadeWhenIdle = a.getBoolean(R.styleable.PageIndicatorView_wsPageIndicatorDotFadeWhenIdle, false);
        this.mDotShadowDx = a.getDimension(R.styleable.PageIndicatorView_wsPageIndicatorDotShadowDx, 0.0f);
        this.mDotShadowDy = a.getDimension(R.styleable.PageIndicatorView_wsPageIndicatorDotShadowDy, 0.0f);
        this.mDotShadowRadius = a.getDimension(R.styleable.PageIndicatorView_wsPageIndicatorDotShadowRadius, 0.0f);
        this.mDotShadowColor = a.getColor(R.styleable.PageIndicatorView_wsPageIndicatorDotShadowColor, 0);
        a.recycle();
        this.mDotPaint = new Paint(1);
        this.mDotPaint.setColor(this.mDotColor);
        this.mDotPaint.setStyle(Paint.Style.FILL);
        this.mDotPaintSelected = new Paint(1);
        this.mDotPaintSelected.setColor(this.mDotColorSelected);
        this.mDotPaintSelected.setStyle(Paint.Style.FILL);
        this.mDotPaintShadow = new Paint(1);
        this.mDotPaintShadowSelected = new Paint(1);
        this.mCurrentViewPagerState = 0;
        if (this.isInEditMode()) {
            this.mNumberOfPositions = 5;
            this.mSelectedPosition = 2;
            this.mDotFadeWhenIdle = false;
        }
        if (this.mDotFadeWhenIdle) {
            this.mVisible = false;
            this.animate().alpha(0.0f).setStartDelay(2000L).setDuration((long)this.mDotFadeOutDuration).start();
        } else {
            this.animate().cancel();
            this.setAlpha(1.0f);
        }
        this.updateShadows();
    }

    private void updateShadows() {
        this.updateDotPaint(this.mDotPaint, this.mDotPaintShadow, this.mDotRadius, this.mDotShadowRadius, this.mDotColor, this.mDotShadowColor);
        this.updateDotPaint(this.mDotPaintSelected, this.mDotPaintShadowSelected, this.mDotRadiusSelected, this.mDotShadowRadius, this.mDotColorSelected, this.mDotShadowColor);
    }

    private void updateDotPaint(Paint dotPaint, Paint shadowPaint, float baseRadius, float shadowRadius, int color2, int shadowColor) {
        float radius = baseRadius + shadowRadius;
        float shadowStart = baseRadius / radius;
        RadialGradient gradient = new RadialGradient(0.0f, 0.0f, radius, new int[]{shadowColor, shadowColor, 0}, new float[]{0.0f, shadowStart, 1.0f}, Shader.TileMode.CLAMP);
        shadowPaint.setShader((Shader)gradient);
        dotPaint.setColor(color2);
        dotPaint.setStyle(Paint.Style.FILL);
    }

    public void setPager(ViewPager pager) {
        pager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.setPagerAdapter(pager.getAdapter());
        this.mAdapter = pager.getAdapter();
        if (this.mAdapter != null && this.mAdapter.getCount() > 0) {
            this.positionChanged(0);
        }
    }

    public float getDotSpacing() {
        return this.mDotSpacing;
    }

    public void setDotSpacing(int spacing) {
        if (this.mDotSpacing != spacing) {
            this.mDotSpacing = spacing;
            this.requestLayout();
        }
    }

    public float getDotRadius() {
        return this.mDotRadius;
    }

    public void setDotRadius(int radius) {
        if (this.mDotRadius != (float)radius) {
            this.mDotRadius = radius;
            this.updateShadows();
            this.invalidate();
        }
    }

    public float getDotRadiusSelected() {
        return this.mDotRadiusSelected;
    }

    public void setDotRadiusSelected(int radius) {
        if (this.mDotRadiusSelected != (float)radius) {
            this.mDotRadiusSelected = radius;
            this.updateShadows();
            this.invalidate();
        }
    }

    public int getDotColor() {
        return this.mDotColor;
    }

    public void setDotColor(int color2) {
        if (this.mDotColor != color2) {
            this.mDotColor = color2;
            this.invalidate();
        }
    }

    public int getDotColorSelected() {
        return this.mDotColorSelected;
    }

    public void setDotColorSelected(int color2) {
        if (this.mDotColorSelected != color2) {
            this.mDotColorSelected = color2;
            this.invalidate();
        }
    }

    public boolean getDotFadeWhenIdle() {
        return this.mDotFadeWhenIdle;
    }

    public void setDotFadeWhenIdle(boolean fade) {
        this.mDotFadeWhenIdle = fade;
        if (!fade) {
            this.fadeIn();
        }
    }

    public int getDotFadeOutDuration() {
        return this.mDotFadeOutDuration;
    }

    public void setDotFadeOutDuration(int duration, TimeUnit unit) {
        this.mDotFadeOutDuration = (int)TimeUnit.MILLISECONDS.convert(duration, unit);
    }

    public int getDotFadeInDuration() {
        return this.mDotFadeInDuration;
    }

    public void setDotFadeInDuration(int duration, TimeUnit unit) {
        this.mDotFadeInDuration = (int)TimeUnit.MILLISECONDS.convert(duration, unit);
    }

    public int getDotFadeOutDelay() {
        return this.mDotFadeOutDelay;
    }

    public void setDotFadeOutDelay(int delay) {
        this.mDotFadeOutDelay = delay;
    }

    public float getDotShadowRadius() {
        return this.mDotShadowRadius;
    }

    public void setDotShadowRadius(float radius) {
        if (this.mDotShadowRadius != radius) {
            this.mDotShadowRadius = radius;
            this.updateShadows();
            this.invalidate();
        }
    }

    public float getDotShadowDx() {
        return this.mDotShadowDx;
    }

    public void setDotShadowDx(float dx) {
        this.mDotShadowDx = dx;
        this.invalidate();
    }

    public float getDotShadowDy() {
        return this.mDotShadowDy;
    }

    public void setDotShadowDy(float dy) {
        this.mDotShadowDy = dy;
        this.invalidate();
    }

    public int getDotShadowColor() {
        return this.mDotShadowColor;
    }

    public void setDotShadowColor(int color2) {
        this.mDotShadowColor = color2;
        this.updateShadows();
        this.invalidate();
    }

    private void positionChanged(int position) {
        this.mSelectedPosition = position;
        this.invalidate();
    }

    private void updateNumberOfPositions() {
        int count = this.mAdapter.getCount();
        if (count != this.mNumberOfPositions) {
            this.mNumberOfPositions = count;
            this.requestLayout();
        }
    }

    private void fadeIn() {
        this.mVisible = true;
        this.animate().cancel();
        this.animate().alpha(1.0f).setStartDelay(0L).setDuration((long)this.mDotFadeInDuration).start();
    }

    private void fadeOut(long delayMillis) {
        this.mVisible = false;
        this.animate().cancel();
        this.animate().alpha(0.0f).setStartDelay(delayMillis).setDuration((long)this.mDotFadeOutDuration).start();
    }

    private void fadeInOut() {
        this.mVisible = true;
        this.animate().cancel();
        this.animate().alpha(1.0f).setStartDelay(0L).setDuration((long)this.mDotFadeInDuration).setListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationComplete(Animator animator) {
                PageIndicatorView.this.mVisible = false;
                PageIndicatorView.this.animate().alpha(0.0f).setListener(null).setStartDelay((long)PageIndicatorView.this.mDotFadeOutDelay).setDuration((long)PageIndicatorView.this.mDotFadeOutDuration).start();
            }
        }).start();
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mDotFadeWhenIdle && this.mCurrentViewPagerState == 1) {
            if (positionOffset != 0.0f) {
                if (!this.mVisible) {
                    this.fadeIn();
                }
            } else if (this.mVisible) {
                this.fadeOut(0L);
            }
        }
    }

    public void onPageSelected(int position) {
        if (position != this.mSelectedPosition) {
            this.positionChanged(position);
        }
    }

    public void onPageScrollStateChanged(int state) {
        if (this.mCurrentViewPagerState != state) {
            this.mCurrentViewPagerState = state;
            if (this.mDotFadeWhenIdle && state == 0) {
                if (this.mVisible) {
                    this.fadeOut(this.mDotFadeOutDelay);
                } else {
                    this.fadeInOut();
                }
            }
        }
    }

    public void setPagerAdapter(PagerAdapter adapter) {
        this.mAdapter = adapter;
        if (this.mAdapter != null) {
            this.updateNumberOfPositions();
            if (this.mDotFadeWhenIdle) {
                this.fadeInOut();
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int totalHeight;
        int totalWidth;
        if (View.MeasureSpec.getMode((int)widthMeasureSpec) == 0x40000000) {
            totalWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        } else {
            int contentWidth = this.mNumberOfPositions * this.mDotSpacing;
            totalWidth = contentWidth + this.getPaddingLeft() + this.getPaddingRight();
        }
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) == 0x40000000) {
            totalHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        } else {
            float maxRadius = Math.max(this.mDotRadius + this.mDotShadowRadius, this.mDotRadiusSelected + this.mDotShadowRadius);
            int contentHeight = (int)Math.ceil(maxRadius * 2.0f);
            contentHeight = (int)((float)contentHeight + this.mDotShadowDy);
            totalHeight = contentHeight + this.getPaddingTop() + this.getPaddingBottom();
        }
        this.setMeasuredDimension(PageIndicatorView.resolveSizeAndState((int)totalWidth, (int)widthMeasureSpec, (int)0), PageIndicatorView.resolveSizeAndState((int)totalHeight, (int)heightMeasureSpec, (int)0));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mNumberOfPositions > 1) {
            float dotCenterLeft = (float)this.getPaddingLeft() + (float)this.mDotSpacing / 2.0f;
            float dotCenterTop = (float)this.getHeight() / 2.0f;
            canvas.save();
            canvas.translate(dotCenterLeft, dotCenterTop);
            for (int i = 0; i < this.mNumberOfPositions; ++i) {
                float radius;
                if (i == this.mSelectedPosition) {
                    radius = this.mDotRadiusSelected + this.mDotShadowRadius;
                    canvas.drawCircle(this.mDotShadowDx, this.mDotShadowDy, radius, this.mDotPaintShadowSelected);
                    canvas.drawCircle(0.0f, 0.0f, this.mDotRadiusSelected, this.mDotPaintSelected);
                } else {
                    radius = this.mDotRadius + this.mDotShadowRadius;
                    canvas.drawCircle(this.mDotShadowDx, this.mDotShadowDy, radius, this.mDotPaintShadow);
                    canvas.drawCircle(0.0f, 0.0f, this.mDotRadius, this.mDotPaint);
                }
                canvas.translate((float)this.mDotSpacing, 0.0f);
            }
            canvas.restore();
        }
    }

    public void notifyDataSetChanged() {
        if (this.mAdapter != null && this.mAdapter.getCount() > 0) {
            this.updateNumberOfPositions();
        }
    }
}

