/*
 * Decompiled with CFR 0.152.
 */
package android.support.wear.widget.drawer;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.RestrictTo;
import android.support.wear.widget.drawer.FlingWatcherFactory;
import android.view.View;
import android.widget.ScrollView;
import java.lang.ref.WeakReference;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
class ScrollViewFlingWatcher
implements FlingWatcherFactory.FlingWatcher,
View.OnScrollChangeListener {
    static final int MAX_WAIT_TIME_MS = 100;
    private final Handler mMainThreadHandler = new Handler(Looper.getMainLooper());
    private final FlingWatcherFactory.FlingListener mListener;
    private final WeakReference<ScrollView> mScrollView;
    private final Runnable mNotifyListenerRunnable = new Runnable(){

        @Override
        public void run() {
            ScrollViewFlingWatcher.this.onEndOfFlingFound();
        }
    };

    ScrollViewFlingWatcher(FlingWatcherFactory.FlingListener listener, ScrollView scrollView) {
        this.mListener = listener;
        this.mScrollView = new WeakReference<ScrollView>(scrollView);
    }

    private static boolean isViewAtTopOrBottom(View view) {
        return !view.canScrollVertically(-1) || !view.canScrollVertically(1);
    }

    @Override
    public void watch() {
        ScrollView scrollView = (ScrollView)this.mScrollView.get();
        if (scrollView != null) {
            scrollView.setOnScrollChangeListener((View.OnScrollChangeListener)this);
            this.scheduleNext();
        }
    }

    public void onScrollChange(View v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
        if (ScrollViewFlingWatcher.isViewAtTopOrBottom(v)) {
            this.onEndOfFlingFound();
        } else {
            this.scheduleNext();
        }
    }

    void onEndOfFlingFound() {
        this.mMainThreadHandler.removeCallbacks(this.mNotifyListenerRunnable);
        ScrollView scrollView = (ScrollView)this.mScrollView.get();
        if (scrollView != null) {
            scrollView.setOnScrollChangeListener(null);
            this.mListener.onFlingComplete((View)scrollView);
        }
    }

    private void scheduleNext() {
        this.mMainThreadHandler.removeCallbacks(this.mNotifyListenerRunnable);
        this.mMainThreadHandler.postDelayed(this.mNotifyListenerRunnable, 100L);
    }
}

