/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler;

import com.android.aaptcompiler.FlattenedXml;
import com.android.aaptcompiler.Span;
import com.android.aaptcompiler.StyleString;
import com.android.aaptcompiler.UntranslatableSection;
import com.android.aaptcompiler.android.ResourceTypesKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.PrimitiveIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0006J\"\u0010\"\u001a\u00020\u00032\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0$2\n\u0010%\u001a\u00060\u0017j\u0002`\u0018H\u0002J\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020\u0000J\u0006\u0010)\u001a\u00020\u0000J\b\u0010*\u001a\u00020\u000bH\u0002J\u0006\u0010+\u001a\u00020,J\u0010\u0010-\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u0006H\u0002J*\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u000b2\n\u0010\u001d\u001a\u00060\u0017j\u0002`\u00182\u0006\u00100\u001a\u0002012\u0006\u0010!\u001a\u00020\u0006J\b\u00102\u001a\u00020'H\u0002J\u000e\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u0006J\u0006\u00105\u001a\u00020\u0000R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u000e\u0010\u0015\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u00060\u0017j\u0002`\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/android/aaptcompiler/XmlStringBuilder;", "", "preserveSpaces", "", "(Z)V", "<set-?>", "", "error", "getError", "()Ljava/lang/String;", "firstChar", "", "firstQuote", "inQuote", "getInQuote", "()Z", "inUntranslatable", "lastChar", "lastCodepointWasBackslash", "lastCodepointWasSpace", "getLastCodepointWasSpace", "lastQuote", "rawStringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "spanStack", "", "Lcom/android/aaptcompiler/Span;", "spans", "textBuilder", "untranslatableSections", "Lcom/android/aaptcompiler/UntranslatableSection;", "append", "str", "appendUnicodeEscapeSequence", "iter", "", "text", "clear", "", "endSpan", "endUntranslatable", "getFirstChar", "getFlattenedXml", "Lcom/android/aaptcompiler/FlattenedXml;", "getLastChar", "handleEscape", "codePoint", "codePoints", "Ljava/util/PrimitiveIterator$OfInt;", "resetTextState", "startSpan", "name", "startUntranslatable", "aaptcompiler"})
public final class XmlStringBuilder {
    private final boolean preserveSpaces;
    private boolean inQuote;
    private boolean lastCodepointWasSpace;
    private boolean lastCodepointWasBackslash;
    private int firstQuote;
    private int lastQuote;
    private int firstChar;
    private int lastChar;
    @NotNull
    private StringBuilder rawStringBuilder;
    @NotNull
    private StringBuilder textBuilder;
    @NotNull
    private final List<Span> spans;
    @NotNull
    private final List<Span> spanStack;
    @NotNull
    private final List<UntranslatableSection> untranslatableSections;
    private boolean inUntranslatable;
    @NotNull
    private String error;

    public XmlStringBuilder(boolean preserveSpaces) {
        this.inQuote = this.preserveSpaces = preserveSpaces;
        this.firstQuote = -1;
        this.lastQuote = -1;
        this.firstChar = -1;
        this.lastChar = -1;
        this.rawStringBuilder = new StringBuilder();
        this.textBuilder = new StringBuilder();
        boolean bl = false;
        this.spans = new ArrayList();
        bl = false;
        this.spanStack = new ArrayList();
        bl = false;
        this.untranslatableSections = new ArrayList();
        this.error = "";
    }

    public /* synthetic */ XmlStringBuilder(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public final boolean getInQuote() {
        return this.inQuote;
    }

    public final boolean getLastCodepointWasSpace() {
        return this.lastCodepointWasSpace;
    }

    @NotNull
    public final String getError() {
        return this.error;
    }

    public final void clear() {
        this.inQuote = this.preserveSpaces;
        this.lastCodepointWasSpace = false;
        this.lastCodepointWasBackslash = false;
        this.firstQuote = -1;
        this.lastQuote = -1;
        this.firstChar = -1;
        this.lastChar = -1;
        this.rawStringBuilder = new StringBuilder();
        this.textBuilder = new StringBuilder();
        this.spans.clear();
        this.spanStack.clear();
        this.untranslatableSections.clear();
        this.inUntranslatable = false;
        this.error = "";
    }

    public final boolean handleEscape(int codePoint, @NotNull StringBuilder textBuilder, @NotNull PrimitiveIterator.OfInt codePoints, @NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)textBuilder, (String)"textBuilder");
        Intrinsics.checkNotNullParameter((Object)codePoints, (String)"codePoints");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        int n = codePoint;
        switch (n) {
            case 116: {
                textBuilder.append('\t');
                break;
            }
            case 110: {
                textBuilder.append('\n');
                break;
            }
            case 34: 
            case 35: 
            case 39: 
            case 63: 
            case 64: 
            case 92: {
                textBuilder.appendCodePoint(codePoint);
                break;
            }
            case 117: {
                if (this.appendUnicodeEscapeSequence(codePoints, textBuilder)) break;
                this.error = "Invalid unicode escape sequence in string\n\"" + str + '\"';
                return false;
            }
            default: {
                textBuilder.appendCodePoint(codePoint);
            }
        }
        return true;
    }

    @NotNull
    public final XmlStringBuilder append(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.rawStringBuilder.append(str);
        PrimitiveIterator.OfInt codePoints = str.codePoints().iterator();
        while (codePoints.hasNext()) {
            int codePoint = codePoints.nextInt();
            if (!Character.isValidCodePoint(codePoint)) {
                this.error = "Invalid unicode code point in string\n\"" + str + '\"';
                return this;
            }
            if (Character.isWhitespace(codePoint) && !this.preserveSpaces && !this.inQuote) {
                if (this.lastCodepointWasSpace) continue;
                this.textBuilder.append(' ');
                this.lastCodepointWasSpace = true;
                this.lastCodepointWasBackslash = false;
                continue;
            }
            if (this.firstChar == -1) {
                this.firstChar = this.textBuilder.length();
            }
            this.lastCodepointWasSpace = false;
            if (this.lastCodepointWasBackslash) {
                Intrinsics.checkNotNullExpressionValue((Object)codePoints, (String)"codePoints");
                if (!this.handleEscape(codePoint, this.textBuilder, codePoints, str)) {
                    return this;
                }
                this.lastChar = this.textBuilder.length();
                this.lastCodepointWasBackslash = false;
                continue;
            }
            if (codePoint == 92) {
                if (codePoints.hasNext()) {
                    codePoint = codePoints.nextInt();
                    Intrinsics.checkNotNullExpressionValue((Object)codePoints, (String)"codePoints");
                    if (!this.handleEscape(codePoint, this.textBuilder, codePoints, str)) {
                        return this;
                    }
                    this.lastChar = this.textBuilder.length();
                    continue;
                }
                this.lastCodepointWasBackslash = true;
                continue;
            }
            if (codePoint == 34 && !this.preserveSpaces) {
                boolean bl = this.inQuote = !this.inQuote;
                if (this.firstQuote == -1) {
                    this.firstQuote = this.textBuilder.length();
                }
                this.lastQuote = this.textBuilder.length();
                this.lastChar = this.textBuilder.length();
                continue;
            }
            if (codePoint == 39 && !this.preserveSpaces && !this.inQuote) {
                this.error = "Invalid unicode escape sequence in string\n\"{str}\"";
                return this;
            }
            this.textBuilder.appendCodePoint(codePoint);
            this.lastChar = this.textBuilder.length();
        }
        return this;
    }

    @NotNull
    public final XmlStringBuilder startSpan(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CharSequence charSequence = this.error;
        boolean bl = false;
        if (charSequence.length() > 0) {
            return this;
        }
        this.resetTextState();
        Span span = new Span(name, this.textBuilder.length(), 0, 4, null);
        this.spans.add(span);
        this.spanStack.add(span);
        return this;
    }

    @NotNull
    public final XmlStringBuilder endSpan() {
        CharSequence charSequence = this.error;
        boolean bl = false;
        if (charSequence.length() > 0) {
            return this;
        }
        if (this.spanStack.isEmpty()) {
            this.error = "Unmatched span end.";
            return this;
        }
        this.resetTextState();
        Span lastSpan = this.spanStack.remove(CollectionsKt.getLastIndex(this.spanStack));
        lastSpan.setLastChar(this.textBuilder.length() - 1);
        return this;
    }

    @NotNull
    public final XmlStringBuilder startUntranslatable() {
        CharSequence charSequence = this.error;
        boolean bl = false;
        if (charSequence.length() > 0) {
            return this;
        }
        if (this.inUntranslatable) {
            this.error = "Attempt to nest untranslatable sections in flattened xml, which is not allowed.";
            return this;
        }
        UntranslatableSection section = new UntranslatableSection(this.textBuilder.length(), 0, 2, null);
        this.untranslatableSections.add(section);
        this.inUntranslatable = true;
        return this;
    }

    @NotNull
    public final XmlStringBuilder endUntranslatable() {
        CharSequence charSequence = this.error;
        boolean bl = false;
        if (charSequence.length() > 0) {
            return this;
        }
        if (!this.inUntranslatable) {
            this.error = "Attempting to end untranslatable section while not in an untranslatable sections.";
            return this;
        }
        ((UntranslatableSection)CollectionsKt.last(this.untranslatableSections)).setEndIndex(this.textBuilder.length());
        this.inUntranslatable = false;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FlattenedXml getFlattenedXml() {
        if (this.inUntranslatable) {
            this.error = "Attempting to flatten xml with unfinished untranslatable section.";
        }
        Collection collection = this.spanStack;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.error = "Attempting to flatten xml with unfinished spans.";
        }
        List untranslatables = this.untranslatableSections;
        String string = this.textBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textBuilder.toString()");
        String text = string;
        if (this.spans.isEmpty()) {
            String string2;
            void $this$mapTo$iv$iv;
            boolean bl2;
            int firstChar = 0;
            firstChar = this.getFirstChar();
            Collection collection2 = this.untranslatableSections;
            int n = 0;
            if (!collection2.isEmpty()) {
                int n2 = firstChar;
                n = ((UntranslatableSection)CollectionsKt.first(this.untranslatableSections)).getStartIndex();
                bl2 = false;
                firstChar = Math.min(n2, n);
            }
            int lastChar = this.getLastChar(text);
            Collection collection3 = this.untranslatableSections;
            bl2 = false;
            if (!collection3.isEmpty()) {
                int n3 = ((UntranslatableSection)CollectionsKt.last(this.untranslatableSections)).getEndIndex();
                bl2 = false;
                lastChar = Math.max(lastChar, n3);
            }
            Iterable $this$map$iv = this.untranslatableSections;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                UntranslatableSection untranslatableSection = (UntranslatableSection)item$iv$iv;
                Collection collection4 = destination$iv$iv;
                boolean bl3 = false;
                UntranslatableSection untranslatableSection2 = it.shift(-firstChar);
                collection4.add(untranslatableSection2);
            }
            untranslatables = (List)destination$iv$iv;
            if (firstChar >= lastChar) {
                string2 = "";
            } else {
                String string3 = this.textBuilder.substring(firstChar, lastChar);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"textBuilder.substring(firstChar, lastChar)");
                string2 = string3;
            }
            text = string2;
        }
        CharSequence charSequence = this.rawStringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"rawStringBuilder.toString()");
        String raw2 = charSequence;
        charSequence = this.error;
        boolean bl4 = false;
        return new FlattenedXml(raw2, new StyleString(text, CollectionsKt.toList((Iterable)this.spans)), CollectionsKt.toList((Iterable)untranslatables), charSequence.length() == 0);
    }

    private final int getFirstChar() {
        if (this.firstQuote == -1) {
            if (this.firstChar != -1) {
                return this.firstChar;
            }
            return this.textBuilder.length();
        }
        if (this.firstChar != -1 && this.firstChar < this.firstQuote) {
            return 0;
        }
        return this.firstQuote;
    }

    private final int getLastChar(String text) {
        if (this.lastQuote == -1) {
            if (this.lastChar != -1) {
                return this.lastChar;
            }
            return 0;
        }
        if (this.lastChar != -1 && this.lastChar > this.lastQuote) {
            return text.length();
        }
        return this.lastQuote;
    }

    private final boolean appendUnicodeEscapeSequence(Iterator<Integer> iter, StringBuilder text) {
        int code = 0;
        int n = 1;
        do {
            int i = n++;
            if (!iter.hasNext()) break;
            int codePoint = ((Number)iter.next()).intValue();
            int value = ResourceTypesKt.parseHex(codePoint);
            if (value == -1) {
                return false;
            }
            code = code << 4 | value;
        } while (n <= 4);
        if (!Character.isValidCodePoint(code)) {
            return false;
        }
        text.appendCodePoint(code);
        return true;
    }

    private final void resetTextState() {
        this.inQuote = this.preserveSpaces;
        this.lastCodepointWasSpace = false;
        this.lastCodepointWasBackslash = false;
    }

    public XmlStringBuilder() {
        this(false, 1, null);
    }
}

