/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.apkzlib.zip.StoredEntry;
import com.android.apkzlib.zip.ZFile;
import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.ClassFileInput;
import com.android.builder.dexing.NoCacheJarClassFileEntry;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Predicate;
import java.util.stream.Stream;

final class JarClassFileInput
implements ClassFileInput {
    private final Path rootPath;
    private ZFile jarFile;

    public JarClassFileInput(Path rootPath) {
        this.rootPath = rootPath;
    }

    @Override
    public void close() throws IOException {
        if (this.jarFile != null) {
            this.jarFile.close();
        }
    }

    @Override
    public Stream<ClassFileEntry> entries(Predicate<String> filter) {
        if (this.jarFile == null) {
            try {
                this.jarFile = new ZFile(this.rootPath.toFile());
            }
            catch (IOException e) {
                throw new JarClassFileInputsException("Unable to read jar file " + this.rootPath.toString(), e);
            }
        }
        Predicate<String> newFilter = CLASS_MATCHER.and(filter);
        return this.jarFile.entries().stream().filter(entry -> newFilter.test(entry.getCentralDirectoryHeader().getName())).map(JarClassFileInput::createEntryFromEntry);
    }

    private static ClassFileEntry createEntryFromEntry(StoredEntry storedEntry) {
        return new NoCacheJarClassFileEntry(storedEntry);
    }

    public static final class JarClassFileInputsException
    extends RuntimeException {
        public JarClassFileInputsException(String s, IOException e) {
            super(s, e);
        }
    }
}

