/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.testing;

import com.android.builder.internal.testing.SimpleTestCallable;
import com.android.builder.testing.BaseTestRunner;
import com.android.builder.testing.TestData;
import com.android.builder.testing.api.DeviceConnector;
import com.android.ddmlib.IShellEnabledDevice;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.ProcessExecutor;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class SimpleTestRunner
extends BaseTestRunner {
    public SimpleTestRunner(File splitSelectExec, ProcessExecutor processExecutor) {
        super(splitSelectExec, processExecutor);
    }

    @Override
    protected WaitableExecutor scheduleTests(String projectName, String variantName, TestData testData, Map<DeviceConnector, ImmutableList<File>> apksForDevice, Set<File> helperApks, int timeoutInMs, Collection<String> installOptions, File resultsDir, File coverageDir, ILogger logger) {
        WaitableExecutor executor = WaitableExecutor.useGlobalSharedThreadPool();
        for (Map.Entry<DeviceConnector, ImmutableList<File>> apks : apksForDevice.entrySet()) {
            DeviceConnector device = apks.getKey();
            SimpleTestCallable testCallable = new SimpleTestCallable(device, projectName, this.createRemoteAndroidTestRunner(testData, device), variantName, (List)apks.getValue(), testData, helperApks, resultsDir, coverageDir, timeoutInMs, installOptions, logger);
            executor.execute((Callable)testCallable);
        }
        return executor;
    }

    protected RemoteAndroidTestRunner createRemoteAndroidTestRunner(TestData testData, DeviceConnector device) {
        return new RemoteAndroidTestRunner(testData.getApplicationId(), testData.getInstrumentationRunner(), (IShellEnabledDevice)device);
    }
}

