/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.api.artifact;

import com.android.build.api.artifact.ArtifactKind;
import java.io.Serializable;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.FileSystemLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u000b\b&\u0018\u0000 \u0013*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\b\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0006\u0010\u0010\u001a\u00020\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/android/build/api/artifact/Artifact;", "T", "Lorg/gradle/api/file/FileSystemLocation;", "Ljava/io/Serializable;", "kind", "Lcom/android/build/api/artifact/ArtifactKind;", "category", "Lcom/android/build/api/artifact/Artifact$Category;", "(Lcom/android/build/api/artifact/ArtifactKind;Lcom/android/build/api/artifact/Artifact$Category;)V", "getCategory", "()Lcom/android/build/api/artifact/Artifact$Category;", "getKind", "()Lcom/android/build/api/artifact/ArtifactKind;", "getFileSystemLocationName", "", "getFolderName", "name", "Appendable", "Category", "Companion", "ContainsMany", "Multiple", "Replaceable", "Single", "Transformable", "gradle-api"})
public abstract class Artifact<T extends FileSystemLocation>
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArtifactKind<T> kind;
    @NotNull
    private final Category category;
    @JvmField
    @NotNull
    public static final ArtifactKind.FILE FILE = ArtifactKind.FILE.INSTANCE;
    @JvmField
    @NotNull
    public static final ArtifactKind.DIRECTORY DIRECTORY = ArtifactKind.DIRECTORY.INSTANCE;

    public Artifact(@NotNull ArtifactKind<T> kind, @NotNull Category category) {
        Intrinsics.checkNotNullParameter(kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
        this.kind = kind;
        this.category = category;
    }

    @NotNull
    public final ArtifactKind<T> getKind() {
        return this.kind;
    }

    @NotNull
    public final Category getCategory() {
        return this.category;
    }

    @NotNull
    public final String name() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return string;
    }

    @NotNull
    public String getFolderName() {
        String string = this.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }

    @NotNull
    public String getFileSystemLocationName() {
        return "";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001\u00a8\u0006\u0002\u00c0\u0006\u0003"}, d2={"Lcom/android/build/api/artifact/Artifact$Appendable;", "", "gradle-api"})
    public static interface Appendable {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/android/build/api/artifact/Artifact$Category;", "", "(Ljava/lang/String;I)V", "SOURCES", "GENERATED", "INTERMEDIATES", "OUTPUTS", "REPORTS", "gradle-api"})
    public static final class Category
    extends Enum<Category> {
        public static final /* enum */ Category SOURCES = new Category();
        public static final /* enum */ Category GENERATED = new Category();
        public static final /* enum */ Category INTERMEDIATES = new Category();
        public static final /* enum */ Category OUTPUTS = new Category();
        public static final /* enum */ Category REPORTS = new Category();
        private static final /* synthetic */ Category[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Category[] values() {
            return (Category[])$VALUES.clone();
        }

        public static Category valueOf(String value) {
            return Enum.valueOf(Category.class, value);
        }

        @NotNull
        public static EnumEntries<Category> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = categoryArray = new Category[]{Category.SOURCES, Category.GENERATED, Category.INTERMEDIATES, Category.OUTPUTS, Category.REPORTS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/build/api/artifact/Artifact$Companion;", "", "()V", "DIRECTORY", "Lcom/android/build/api/artifact/ArtifactKind$DIRECTORY;", "FILE", "Lcom/android/build/api/artifact/ArtifactKind$FILE;", "gradle-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001\u00a8\u0006\u0002\u00c0\u0006\u0003"}, d2={"Lcom/android/build/api/artifact/Artifact$ContainsMany;", "", "gradle-api"})
    public static interface ContainsMany {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/build/api/artifact/Artifact$Multiple;", "FileTypeT", "Lorg/gradle/api/file/FileSystemLocation;", "Lcom/android/build/api/artifact/Artifact;", "kind", "Lcom/android/build/api/artifact/ArtifactKind;", "category", "Lcom/android/build/api/artifact/Artifact$Category;", "(Lcom/android/build/api/artifact/ArtifactKind;Lcom/android/build/api/artifact/Artifact$Category;)V", "gradle-api"})
    public static abstract class Multiple<FileTypeT extends FileSystemLocation>
    extends Artifact<FileTypeT> {
        public Multiple(@NotNull ArtifactKind<FileTypeT> kind, @NotNull Category category) {
            Intrinsics.checkNotNullParameter(kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
            super(kind, category);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001\u00a8\u0006\u0002\u00c0\u0006\u0003"}, d2={"Lcom/android/build/api/artifact/Artifact$Replaceable;", "", "gradle-api"})
    public static interface Replaceable {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/build/api/artifact/Artifact$Single;", "FileTypeT", "Lorg/gradle/api/file/FileSystemLocation;", "Lcom/android/build/api/artifact/Artifact;", "kind", "Lcom/android/build/api/artifact/ArtifactKind;", "category", "Lcom/android/build/api/artifact/Artifact$Category;", "(Lcom/android/build/api/artifact/ArtifactKind;Lcom/android/build/api/artifact/Artifact$Category;)V", "gradle-api"})
    public static abstract class Single<FileTypeT extends FileSystemLocation>
    extends Artifact<FileTypeT> {
        public Single(@NotNull ArtifactKind<FileTypeT> kind, @NotNull Category category) {
            Intrinsics.checkNotNullParameter(kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
            super(kind, category);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001\u00a8\u0006\u0002\u00c0\u0006\u0003"}, d2={"Lcom/android/build/api/artifact/Artifact$Transformable;", "", "gradle-api"})
    public static interface Transformable {
    }
}

