/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.attributes.BuildTypeAttr;
import com.android.build.api.attributes.ProductFlavorAttr;
import com.android.build.api.variant.VariantConfiguration;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.TestedAndroidConfig;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.api.VariantFilter;
import com.android.build.gradle.internal.api.artifact.BuildArtifactSpec;
import com.android.build.gradle.internal.core.VariantBuilder;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.core.VariantDslInfoImpl;
import com.android.build.gradle.internal.core.VariantSources;
import com.android.build.gradle.internal.crash.ExternalApiUsageException;
import com.android.build.gradle.internal.dependency.AarResourcesCompilerTransform;
import com.android.build.gradle.internal.dependency.AarToClassTransform;
import com.android.build.gradle.internal.dependency.AarTransform;
import com.android.build.gradle.internal.dependency.AlternateCompatibilityRule;
import com.android.build.gradle.internal.dependency.AlternateDisambiguationRule;
import com.android.build.gradle.internal.dependency.AndroidXDependencySubstitution;
import com.android.build.gradle.internal.dependency.DesugarLibConfiguration;
import com.android.build.gradle.internal.dependency.DexingArtifactConfiguration;
import com.android.build.gradle.internal.dependency.DexingOutputSplitTransformKt;
import com.android.build.gradle.internal.dependency.DexingTransformKt;
import com.android.build.gradle.internal.dependency.ExtractAarTransform;
import com.android.build.gradle.internal.dependency.ExtractProGuardRulesTransform;
import com.android.build.gradle.internal.dependency.FilterShrinkerRulesTransform;
import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.android.build.gradle.internal.dependency.IdentityTransform;
import com.android.build.gradle.internal.dependency.JetifyTransform;
import com.android.build.gradle.internal.dependency.L8DexDesugarLibTransformKt;
import com.android.build.gradle.internal.dependency.LibraryDefinedSymbolTableTransform;
import com.android.build.gradle.internal.dependency.LibrarySymbolTableTransform;
import com.android.build.gradle.internal.dependency.MockableJarTransform;
import com.android.build.gradle.internal.dependency.ModelArtifactCompatibilityRule;
import com.android.build.gradle.internal.dependency.PlatformAttrTransform;
import com.android.build.gradle.internal.dependency.SourceSetManager;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dependency.VersionedCodeShrinker;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.dsl.BaseFlavor;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.errors.SyncIssueHandler;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.publishing.PublishingSpecs;
import com.android.build.gradle.internal.res.Aapt2MavenUtils;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.SingleArtifactType;
import com.android.build.gradle.internal.scope.TransformVariantScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.utils.DesugarLibUtils;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.build.gradle.internal.variant.VariantCombinator;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.internal.variant.VariantModel;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SigningOptions;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.core.AbstractProductFlavor;
import com.android.builder.core.DefaultManifestParser;
import com.android.builder.core.ManifestAttributeSupplier;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.model.CodeShrinker;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.builder.profile.Recorder;
import com.android.utils.StringHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.wireless.android.sdk.stats.ApiVersion;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.Pair;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;

public class VariantManager
implements VariantModel {
    private static final String MULTIDEX_VERSION = "1.0.2";
    protected static final String COM_ANDROID_SUPPORT_MULTIDEX = "com.android.support:multidex:1.0.2";
    protected static final String COM_ANDROID_SUPPORT_MULTIDEX_INSTRUMENTATION = "com.android.support:multidex-instrumentation:1.0.2";
    protected static final String ANDROIDX_MULTIDEX_MULTIDEX = AndroidXDependencySubstitution.getAndroidXMappings().get("com.android.support:multidex");
    protected static final String ANDROIDX_MULTIDEX_MULTIDEX_INSTRUMENTATION = AndroidXDependencySubstitution.getAndroidXMappings().get("com.android.support:multidex-instrumentation");
    private final Project project;
    private final ProjectOptions projectOptions;
    private final BaseExtension extension;
    private final VariantFactory variantFactory;
    private final TaskManager taskManager;
    private final SourceSetManager sourceSetManager;
    private final Recorder recorder;
    private final ProductFlavorData<DefaultConfig> defaultConfigData;
    private final Map<String, BuildTypeData> buildTypes;
    private final VariantFilter variantFilter;
    private final List<VariantScope> variantScopes;
    private final Map<String, ProductFlavorData<ProductFlavor>> productFlavors;
    private final Map<String, SigningConfig> signingConfigs;
    private final Map<File, ManifestAttributeSupplier> manifestParserMap;
    protected final GlobalScope globalScope;
    private final SigningConfig signingOverride;
    private boolean hasCreatedTasks = false;
    public static final Attribute<String> SHRINKER_ATTR = Attribute.of((String)"codeShrinker", String.class);

    public VariantManager(GlobalScope globalScope, Project project2, ProjectOptions projectOptions, BaseExtension extension, VariantFactory variantFactory, TaskManager taskManager, SourceSetManager sourceSetManager, Recorder recorder) {
        this.globalScope = globalScope;
        this.extension = extension;
        this.project = project2;
        this.projectOptions = projectOptions;
        this.variantFactory = variantFactory;
        this.taskManager = taskManager;
        this.sourceSetManager = sourceSetManager;
        this.recorder = recorder;
        this.signingOverride = this.createSigningOverride();
        this.variantFilter = new VariantFilter(new ReadOnlyObjectProvider());
        this.buildTypes = Maps.newHashMap();
        this.variantScopes = Lists.newArrayList();
        this.productFlavors = Maps.newHashMap();
        this.signingConfigs = Maps.newHashMap();
        this.manifestParserMap = Maps.newHashMap();
        DefaultAndroidSourceSet mainSourceSet = (DefaultAndroidSourceSet)extension.getSourceSets().getByName("main");
        DefaultAndroidSourceSet androidTestSourceSet = null;
        DefaultAndroidSourceSet unitTestSourceSet = null;
        if (variantFactory.hasTestScope()) {
            androidTestSourceSet = (DefaultAndroidSourceSet)extension.getSourceSets().getByName("androidTest");
            unitTestSourceSet = (DefaultAndroidSourceSet)extension.getSourceSets().getByName("test");
        }
        this.defaultConfigData = new ProductFlavorData<DefaultConfig>(extension.getDefaultConfig(), mainSourceSet, androidTestSourceSet, unitTestSourceSet);
    }

    public void addVariant(BaseVariantData variantData) {
        this.variantScopes.add(variantData.getScope());
    }

    @Override
    public ProductFlavorData<DefaultConfig> getDefaultConfig() {
        return this.defaultConfigData;
    }

    @Override
    public Map<String, BuildTypeData> getBuildTypes() {
        return this.buildTypes;
    }

    @Override
    public Map<String, ProductFlavorData<ProductFlavor>> getProductFlavors() {
        return this.productFlavors;
    }

    @Override
    public Map<String, SigningConfig> getSigningConfigs() {
        return this.signingConfigs;
    }

    public void addSigningConfig(SigningConfig signingConfig) {
        this.signingConfigs.put(signingConfig.getName(), signingConfig);
    }

    public void addBuildType(BuildType buildType) {
        String name2 = buildType.getName();
        VariantManager.checkName(name2, "BuildType");
        if (this.productFlavors.containsKey(name2)) {
            throw new RuntimeException("BuildType names cannot collide with ProductFlavor names");
        }
        DefaultAndroidSourceSet mainSourceSet = (DefaultAndroidSourceSet)this.sourceSetManager.setUpSourceSet(name2);
        DefaultAndroidSourceSet androidTestSourceSet = null;
        DefaultAndroidSourceSet unitTestSourceSet = null;
        if (this.variantFactory.hasTestScope()) {
            if (buildType.getName().equals(this.extension.getTestBuildType())) {
                androidTestSourceSet = (DefaultAndroidSourceSet)this.sourceSetManager.setUpTestSourceSet(VariantManager.computeSourceSetName(buildType.getName(), (VariantType)VariantTypeImpl.ANDROID_TEST));
            }
            unitTestSourceSet = (DefaultAndroidSourceSet)this.sourceSetManager.setUpTestSourceSet(VariantManager.computeSourceSetName(buildType.getName(), (VariantType)VariantTypeImpl.UNIT_TEST));
        }
        BuildTypeData buildTypeData = new BuildTypeData(buildType, mainSourceSet, androidTestSourceSet, unitTestSourceSet);
        this.buildTypes.put(name2, buildTypeData);
    }

    public void addProductFlavor(ProductFlavor productFlavor) {
        String name2 = productFlavor.getName();
        VariantManager.checkName(name2, "ProductFlavor");
        if (this.buildTypes.containsKey(name2)) {
            throw new RuntimeException("ProductFlavor names cannot collide with BuildType names");
        }
        DefaultAndroidSourceSet mainSourceSet = (DefaultAndroidSourceSet)this.sourceSetManager.setUpSourceSet(productFlavor.getName());
        DefaultAndroidSourceSet androidTestSourceSet = null;
        DefaultAndroidSourceSet unitTestSourceSet = null;
        if (this.variantFactory.hasTestScope()) {
            androidTestSourceSet = (DefaultAndroidSourceSet)this.sourceSetManager.setUpTestSourceSet(VariantManager.computeSourceSetName(productFlavor.getName(), (VariantType)VariantTypeImpl.ANDROID_TEST));
            unitTestSourceSet = (DefaultAndroidSourceSet)this.sourceSetManager.setUpTestSourceSet(VariantManager.computeSourceSetName(productFlavor.getName(), (VariantType)VariantTypeImpl.UNIT_TEST));
        }
        ProductFlavorData<ProductFlavor> productFlavorData = new ProductFlavorData<ProductFlavor>(productFlavor, mainSourceSet, androidTestSourceSet, unitTestSourceSet);
        this.productFlavors.put(productFlavor.getName(), productFlavorData);
    }

    public List<VariantScope> getVariantScopes() {
        return this.variantScopes;
    }

    public List<VariantScope> createVariantsAndTasks() {
        this.variantFactory.validateModel(this);
        this.variantFactory.preVariantWork(this.project);
        if (this.variantScopes.isEmpty()) {
            this.computeVariants();
        }
        this.taskManager.createTopLevelTestTasks(!this.productFlavors.isEmpty());
        for (VariantScope variantScope : this.variantScopes) {
            this.createTasksForVariant(variantScope);
        }
        this.taskManager.createReportTasks(this.variantScopes);
        return this.variantScopes;
    }

    public void createTasksForVariant(VariantScope variantScope) {
        BaseVariantData variantData = variantScope.getVariantData();
        VariantType variantType = variantData.getType();
        VariantDslInfo variantDslInfo = variantScope.getVariantDslInfo();
        VariantSources variantSources = variantScope.getVariantSources();
        this.taskManager.createAssembleTask(variantData);
        if (variantType.isBaseModule()) {
            this.taskManager.createBundleTask(variantData);
        }
        if (variantType.isTestComponent()) {
            BuildTypeData buildTypeData;
            DefaultAndroidSourceSet buildTypeConfigurationProvider;
            BaseVariantData testedVariantData = (BaseVariantData)((Object)((TestVariantData)variantData).getTestedVariantData());
            List<ProductFlavor> testProductFlavors = variantDslInfo.getProductFlavors();
            ArrayList testVariantSourceSets = Lists.newArrayListWithExpectedSize((int)(4 + testProductFlavors.size()));
            if (!testProductFlavors.isEmpty()) {
                testVariantSourceSets.add((DefaultAndroidSourceSet)variantSources.getVariantSourceProvider());
            }
            if ((buildTypeConfigurationProvider = (buildTypeData = this.buildTypes.get(variantDslInfo.getBuildType().getName())).getTestSourceSet(variantType)) != null) {
                testVariantSourceSets.add(buildTypeConfigurationProvider);
            }
            if (testProductFlavors.size() > 1) {
                testVariantSourceSets.add((DefaultAndroidSourceSet)variantSources.getMultiFlavorSourceProvider());
            }
            for (ProductFlavor productFlavor : testProductFlavors) {
                testVariantSourceSets.add(this.productFlavors.get(productFlavor.getName()).getTestSourceSet(variantType));
            }
            testVariantSourceSets.add(this.defaultConfigData.getTestSourceSet(variantType));
            VariantDependencies.Builder builder = VariantDependencies.builder(this.project, variantScope.getGlobalScope().getErrorHandler(), variantDslInfo).addSourceSets(testVariantSourceSets).setFlavorSelection(this.getFlavorSelection(variantDslInfo)).setTestedVariantScope(testedVariantData.getScope());
            VariantDependencies variantDep = builder.build(variantScope);
            variantData.setVariantDependency(variantDep);
            if (testedVariantData.getVariantDslInfo().getRenderscriptSupportModeEnabled()) {
                this.project.getDependencies().add(variantDep.getCompileClasspath().getName(), (Object)this.project.files(new Object[]{this.globalScope.getSdkComponents().getRenderScriptSupportJarProvider()}));
            }
            if (variantType.isApk()) {
                if (variantDslInfo.isLegacyMultiDexMode()) {
                    String multiDexInstrumentationDep = this.globalScope.getProjectOptions().get(BooleanOption.USE_ANDROID_X) ? ANDROIDX_MULTIDEX_MULTIDEX_INSTRUMENTATION : COM_ANDROID_SUPPORT_MULTIDEX_INSTRUMENTATION;
                    this.project.getDependencies().add(variantDep.getCompileClasspath().getName(), (Object)multiDexInstrumentationDep);
                    this.project.getDependencies().add(variantDep.getRuntimeClasspath().getName(), (Object)multiDexInstrumentationDep);
                }
                this.taskManager.createAndroidTestVariantTasks((TestVariantData)variantData, this.variantScopes.stream().filter(TaskManager::isLintVariant).collect(Collectors.toList()));
            } else {
                this.taskManager.createUnitTestVariantTasks((TestVariantData)variantData);
            }
        } else {
            this.taskManager.createTasksForVariantScope(variantScope, this.variantScopes.stream().filter(TaskManager::isLintVariant).collect(Collectors.toList()));
        }
    }

    public void publishBuildArtifacts(VariantScope variantScope) {
        BuildArtifactsHolder buildArtifactsHolder = variantScope.getArtifacts();
        for (PublishingSpecs.OutputSpec outputSpec : variantScope.getPublishingSpec().getOutputs()) {
            SingleArtifactType<? extends FileSystemLocation> buildArtifactType = outputSpec.getOutputType();
            if (BuildArtifactSpec.Companion.has(buildArtifactType) && BuildArtifactSpec.Companion.get(buildArtifactType).getAppendable()) {
                throw new RuntimeException(String.format("Appendable ArtifactType '%1s' cannot be published.", buildArtifactType.name()));
            }
            if (buildArtifactsHolder.hasFinalProduct(buildArtifactType)) {
                Provider artifact = buildArtifactsHolder.getFinalProduct(buildArtifactType);
                variantScope.publishIntermediateArtifact(artifact, outputSpec.getArtifactType(), (Collection<AndroidArtifacts.PublishedConfigType>)outputSpec.getPublishedConfigTypes());
                continue;
            }
            if (buildArtifactType != InternalArtifactType.ALL_CLASSES.INSTANCE) continue;
            Provider<FileCollection> allClasses = buildArtifactsHolder.getFinalProductAsFileCollection(InternalArtifactType.ALL_CLASSES.INSTANCE);
            Provider file = allClasses.map(FileCollection::getSingleFile);
            variantScope.publishIntermediateArtifact((Provider<?>)file, outputSpec.getArtifactType(), (Collection<AndroidArtifacts.PublishedConfigType>)outputSpec.getPublishedConfigTypes());
        }
    }

    private Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> getFlavorSelection(VariantDslInfo variantDslInfo) {
        ObjectFactory factory2 = this.project.getObjects();
        return variantDslInfo.getMissingDimensionStrategies().entrySet().stream().collect(Collectors.toMap(entry -> Attribute.of((String)((String)entry.getKey()), ProductFlavorAttr.class), entry -> (ProductFlavorAttr)factory2.named(ProductFlavorAttr.class, ((AbstractProductFlavor.DimensionRequest)entry.getValue()).getRequested())));
    }

    public void configureDependencies() {
        DependencyHandler dependencies = this.project.getDependencies();
        if (!this.globalScope.getProjectOptions().get(BooleanOption.USE_ANDROID_X) && this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_JETIFIER)) {
            throw new IllegalStateException("AndroidX must be enabled when Jetifier is enabled. To resolve, set " + BooleanOption.USE_ANDROID_X.getPropertyName() + "=true in your gradle.properties file.");
        }
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_JETIFIER)) {
            AndroidXDependencySubstitution.replaceOldSupportLibraries(this.project);
        }
        boolean jetifierSkipIfPossible = this.globalScope.getProjectOptions().get(BooleanOption.JETIFIER_SKIP_IF_POSSIBLE);
        String jetifierBlackList = Strings.nullToEmpty((String)this.globalScope.getProjectOptions().get(StringOption.JETIFIER_BLACKLIST));
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_JETIFIER)) {
            dependencies.registerTransform(JetifyTransform.class, spec2 -> {
                ((JetifyTransform.Parameters)spec2.getParameters()).getProjectName().set((Object)this.project.getName());
                ((JetifyTransform.Parameters)spec2.getParameters()).getSkipIfPossible().set((Object)jetifierSkipIfPossible);
                ((JetifyTransform.Parameters)spec2.getParameters()).getBlackListOption().set((Object)jetifierBlackList);
                spec2.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.AAR.getType());
                spec2.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.PROCESSED_AAR.getType());
            });
            dependencies.registerTransform(JetifyTransform.class, spec2 -> {
                ((JetifyTransform.Parameters)spec2.getParameters()).getProjectName().set((Object)this.project.getName());
                ((JetifyTransform.Parameters)spec2.getParameters()).getSkipIfPossible().set((Object)jetifierSkipIfPossible);
                ((JetifyTransform.Parameters)spec2.getParameters()).getBlackListOption().set((Object)jetifierBlackList);
                spec2.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.JAR.getType());
                spec2.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.PROCESSED_JAR.getType());
            });
        } else {
            dependencies.registerTransform(IdentityTransform.class, spec2 -> {
                ((GenericTransformParameters)spec2.getParameters()).getProjectName().set((Object)this.project.getName());
                spec2.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.AAR.getType());
                spec2.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.PROCESSED_AAR.getType());
            });
            dependencies.registerTransform(IdentityTransform.class, spec2 -> {
                ((GenericTransformParameters)spec2.getParameters()).getProjectName().set((Object)this.project.getName());
                spec2.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.JAR.getType());
                spec2.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.PROCESSED_JAR.getType());
            });
        }
        dependencies.registerTransform(ExtractAarTransform.class, spec2 -> {
            ((GenericTransformParameters)spec2.getParameters()).getProjectName().set((Object)this.project.getName());
            spec2.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.PROCESSED_AAR.getType());
            spec2.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.EXPLODED_AAR.getType());
        });
        dependencies.registerTransform(MockableJarTransform.class, spec2 -> {
            ((MockableJarTransform.Parameters)spec2.getParameters()).getProjectName().set((Object)this.project.getName());
            ((MockableJarTransform.Parameters)spec2.getParameters()).getReturnDefaultValues().set((Object)true);
            spec2.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.JAR.getType());
            spec2.getFrom().attribute(AndroidArtifacts.MOCKABLE_JAR_RETURN_DEFAULT_VALUES, (Object)true);
            spec2.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"android-mockable-jar");
            spec2.getTo().attribute(AndroidArtifacts.MOCKABLE_JAR_RETURN_DEFAULT_VALUES, (Object)true);
        });
        dependencies.registerTransform(MockableJarTransform.class, spec2 -> {
            ((MockableJarTransform.Parameters)spec2.getParameters()).getProjectName().set((Object)this.project.getName());
            ((MockableJarTransform.Parameters)spec2.getParameters()).getReturnDefaultValues().set((Object)false);
            spec2.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.JAR.getType());
            spec2.getFrom().attribute(AndroidArtifacts.MOCKABLE_JAR_RETURN_DEFAULT_VALUES, (Object)false);
            spec2.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"android-mockable-jar");
            spec2.getTo().attribute(AndroidArtifacts.MOCKABLE_JAR_RETURN_DEFAULT_VALUES, (Object)false);
        });
        dependencies.registerTransform(PlatformAttrTransform.class, spec2 -> {
            ((GenericTransformParameters)spec2.getParameters()).getProjectName().set((Object)this.project.getName());
            spec2.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.JAR.getType());
            spec2.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"android-platform-attr");
        });
        boolean sharedLibSupport = this.globalScope.getProjectOptions().get(BooleanOption.CONSUME_DEPENDENCIES_AS_SHARED_LIBRARIES);
        boolean autoNamespaceDependencies = this.globalScope.getExtension().getAaptOptions().getNamespaced() && this.globalScope.getProjectOptions().get(BooleanOption.CONVERT_NON_NAMESPACED_DEPENDENCIES);
        for (AndroidArtifacts.ArtifactType transformTarget : AarTransform.getTransformTargets()) {
            dependencies.registerTransform(AarTransform.class, spec2 -> {
                ((AarTransform.Parameters)spec2.getParameters()).getProjectName().set((Object)this.project.getName());
                ((AarTransform.Parameters)spec2.getParameters()).getTargetType().set((Object)transformTarget);
                ((AarTransform.Parameters)spec2.getParameters()).getSharedLibSupport().set((Object)sharedLibSupport);
                ((AarTransform.Parameters)spec2.getParameters()).getAutoNamespaceDependencies().set((Object)autoNamespaceDependencies);
                spec2.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.EXPLODED_AAR.getType());
                spec2.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)transformTarget.getType());
            });
        }
        if (this.globalScope.getProjectOptions().get(BooleanOption.PRECOMPILE_DEPENDENCIES_RESOURCES)) {
            dependencies.registerTransform(AarResourcesCompilerTransform.class, reg -> {
                reg.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.EXPLODED_AAR.getType());
                reg.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.COMPILED_DEPENDENCIES_RESOURCES.getType());
                reg.parameters(params -> {
                    Pair<FileCollection, String> aapt2FromMavenAndVersion = Aapt2MavenUtils.getAapt2FromMavenAndVersion(this.globalScope);
                    params.getAapt2FromMaven().from(new Object[]{aapt2FromMavenAndVersion.getFirst()});
                    params.getAapt2Version().set(aapt2FromMavenAndVersion.getSecond());
                    params.getErrorFormatMode().set((Object)SyncOptions.getErrorFormatMode(this.globalScope.getProjectOptions()));
                });
            });
        }
        Usage apiUsage = (Usage)this.project.getObjects().named(Usage.class, "java-api");
        dependencies.registerTransform(AarToClassTransform.class, reg -> {
            reg.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.PROCESSED_AAR.getType());
            reg.getFrom().attribute(Usage.USAGE_ATTRIBUTE, (Object)apiUsage);
            reg.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.CLASSES_JAR.getType());
            reg.getTo().attribute(Usage.USAGE_ATTRIBUTE, (Object)apiUsage);
            reg.parameters(params -> {
                params.getForCompileUse().set((Object)true);
                params.getAutoNamespaceDependencies().set((Object)autoNamespaceDependencies);
                params.getGenerateRClassJar().set((Object)this.projectOptions.get(BooleanOption.COMPILE_CLASSPATH_LIBRARY_R_CLASSES));
            });
        });
        Usage runtimeUsage = (Usage)this.project.getObjects().named(Usage.class, "java-runtime");
        dependencies.registerTransform(AarToClassTransform.class, reg -> {
            reg.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.PROCESSED_AAR.getType());
            reg.getFrom().attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
            reg.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.CLASSES_JAR.getType());
            reg.getTo().attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
            reg.parameters(params -> {
                params.getForCompileUse().set((Object)false);
                params.getAutoNamespaceDependencies().set((Object)autoNamespaceDependencies);
                params.getGenerateRClassJar().set((Object)false);
            });
        });
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_PROGUARD_RULES_EXTRACTION)) {
            dependencies.registerTransform(ExtractProGuardRulesTransform.class, spec2 -> {
                ((GenericTransformParameters)spec2.getParameters()).getProjectName().set((Object)this.project.getName());
                spec2.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.PROCESSED_JAR.getType());
                spec2.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.UNFILTERED_PROGUARD_RULES.getType());
            });
        }
        dependencies.registerTransform(LibrarySymbolTableTransform.class, spec2 -> {
            ((GenericTransformParameters)spec2.getParameters()).getProjectName().set((Object)this.project.getName());
            spec2.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.EXPLODED_AAR.getType());
            spec2.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.SYMBOL_LIST_WITH_PACKAGE_NAME.getType());
        });
        if (autoNamespaceDependencies) {
            dependencies.registerTransform(LibraryDefinedSymbolTableTransform.class, spec2 -> {
                ((GenericTransformParameters)spec2.getParameters()).getProjectName().set((Object)this.project.getName());
                spec2.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.EXPLODED_AAR.getType());
                spec2.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.DEFINED_ONLY_SYMBOL_LIST.getType());
            });
        }
        for (String classesOrResources : new String[]{AndroidArtifacts.ArtifactType.CLASSES_JAR.getType(), AndroidArtifacts.ArtifactType.JAVA_RES.getType()}) {
            dependencies.registerTransform(IdentityTransform.class, spec2 -> {
                spec2.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.PROCESSED_JAR.getType());
                spec2.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)classesOrResources);
            });
        }
        this.project.getConfigurations().all(configuration2 -> {
            if (configuration2.getName().startsWith("kapt")) {
                configuration2.getAttributes().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.PROCESSED_JAR.getType());
            }
        });
        AttributesSchema schema = dependencies.getAttributesSchema();
        this.setBuildTypeStrategy(schema);
        this.setupFlavorStrategy(schema);
        VariantManager.setupModelStrategy(schema);
    }

    private void configureVariantArtifactTransforms(Collection<VariantScope> variantScopes) {
        DependencyHandler dependencies = this.project.getDependencies();
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_DEXING_ARTIFACT_TRANSFORM)) {
            for (DexingArtifactConfiguration dexingArtifactConfiguration : DexingTransformKt.getDexingArtifactConfigurations(variantScopes)) {
                dexingArtifactConfiguration.registerTransform(this.globalScope.getProject().getName(), dependencies, this.globalScope.getBootClasspath(), DesugarLibUtils.getDesugarLibConfig(this.globalScope.getProject()), SyncOptions.getErrorFormatMode(this.globalScope.getProjectOptions()));
            }
        }
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_PROGUARD_RULES_EXTRACTION)) {
            Set shrinkers = variantScopes.stream().map(VariantScope::getCodeShrinker).filter(Objects::nonNull).collect(Collectors.toSet());
            for (CodeShrinker shrinker : shrinkers) {
                dependencies.registerTransform(FilterShrinkerRulesTransform.class, reg -> {
                    reg.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.UNFILTERED_PROGUARD_RULES.getType());
                    reg.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)AndroidArtifacts.ArtifactType.FILTERED_PROGUARD_RULES.getType());
                    reg.getFrom().attribute(SHRINKER_ATTR, (Object)shrinker.toString());
                    reg.getTo().attribute(SHRINKER_ATTR, (Object)shrinker.toString());
                    reg.parameters(params -> {
                        params.getShrinker().set((Object)VersionedCodeShrinker.of(shrinker));
                        params.getProjectName().set((Object)this.project.getName());
                    });
                });
            }
        }
        for (DesugarLibConfiguration desugarLibConfiguration : L8DexDesugarLibTransformKt.getDesugarLibConfigurations(variantScopes)) {
            desugarLibConfiguration.registerTransform(dependencies);
        }
        DexingOutputSplitTransformKt.registerDexingOutputSplitTransform(dependencies);
    }

    private static <F, T> List<T> convert(Collection<F> values, Function<F, ?> function, Class<T> convertedType) {
        return values.stream().map(function).filter(convertedType::isInstance).map(convertedType::cast).collect(Collectors.toList());
    }

    private void setBuildTypeStrategy(AttributesSchema schema) {
        List<BuildType> dslBuildTypes = VariantManager.convert(this.buildTypes.values(), BuildTypeData::getBuildType, BuildType.class);
        if (dslBuildTypes.isEmpty()) {
            return;
        }
        HashMap alternateMap = Maps.newHashMap();
        for (BuildType buildType : dslBuildTypes) {
            if (buildType.getMatchingFallbacks().isEmpty()) continue;
            alternateMap.put(buildType.getName(), buildType.getMatchingFallbacks());
        }
        if (!alternateMap.isEmpty()) {
            AttributeMatchingStrategy buildTypeStrategy = schema.attribute(BuildTypeAttr.getATTRIBUTE());
            buildTypeStrategy.getCompatibilityRules().add(AlternateCompatibilityRule.BuildTypeRule.class, config2 -> config2.setParams(new Object[]{alternateMap}));
            buildTypeStrategy.getDisambiguationRules().add(AlternateDisambiguationRule.BuildTypeRule.class, config2 -> config2.setParams(new Object[]{alternateMap}));
        }
    }

    private void setupFlavorStrategy(AttributesSchema schema) {
        List<ProductFlavor> flavors = VariantManager.convert(this.productFlavors.values(), ProductFlavorData::getProductFlavor, ProductFlavor.class);
        HashMap alternateMap = Maps.newHashMap();
        for (ProductFlavor productFlavor : flavors) {
            if (!productFlavor.getMatchingFallbacks().isEmpty()) {
                String name2 = productFlavor.getName();
                String dimension = productFlavor.getDimension();
                Map dimensionMap = alternateMap.computeIfAbsent(dimension, s -> Maps.newHashMap());
                dimensionMap.put(name2, productFlavor.getMatchingFallbacks());
            }
            VariantManager.handleMissingDimensions(alternateMap, productFlavor);
        }
        if (this.defaultConfigData.getProductFlavor() instanceof BaseFlavor) {
            VariantManager.handleMissingDimensions(alternateMap, this.defaultConfigData.getProductFlavor());
        }
        for (Map.Entry entry : alternateMap.entrySet()) {
            VariantManager.addFlavorStrategy(schema, (String)entry.getKey(), (Map)entry.getValue());
        }
    }

    public static void addFlavorStrategy(AttributesSchema schema, String dimension, Map<String, List<String>> alternateMap) {
        Attribute attr = Attribute.of((String)dimension, ProductFlavorAttr.class);
        AttributeMatchingStrategy flavorStrategy = schema.attribute(attr);
        flavorStrategy.getCompatibilityRules().add(AlternateCompatibilityRule.ProductFlavorRule.class, config2 -> config2.setParams(new Object[]{alternateMap}));
        flavorStrategy.getDisambiguationRules().add(AlternateDisambiguationRule.ProductFlavorRule.class, config2 -> config2.setParams(new Object[]{alternateMap}));
    }

    private static void setupModelStrategy(AttributesSchema attributesSchema) {
        ModelArtifactCompatibilityRule.Companion.setUp(attributesSchema);
    }

    private static void handleMissingDimensions(Map<String, Map<String, List<String>>> alternateMap, BaseFlavor flavor) {
        Map missingStrategies = flavor.getMissingDimensionStrategies();
        if (!missingStrategies.isEmpty()) {
            for (Map.Entry entry : missingStrategies.entrySet()) {
                String dimension = (String)entry.getKey();
                Map dimensionMap = alternateMap.computeIfAbsent(dimension, s -> Maps.newHashMap());
                dimensionMap.put(((AbstractProductFlavor.DimensionRequest)entry.getValue()).getRequested(), ((AbstractProductFlavor.DimensionRequest)entry.getValue()).getFallbacks());
            }
        }
    }

    public static String getModifiedName(String name2) {
        return "____" + name2;
    }

    @VisibleForTesting
    public void computeVariants() {
        List<String> flavorDimensionList = this.extension.getFlavorDimensionList();
        VariantCombinator computer = new VariantCombinator(this, this.globalScope.getErrorHandler(), this.variantFactory.getVariantType(), flavorDimensionList);
        List<VariantConfiguration> variants = computer.computeVariants();
        this.configureDependencies();
        BuildTypeData testBuildTypeData = this.getTestBuildTypeData();
        for (VariantConfiguration variant2 : variants) {
            this.createVariantDataForProductFlavors(variant2, testBuildTypeData);
        }
        this.configureVariantArtifactTransforms(this.variantScopes);
    }

    private BuildTypeData getTestBuildTypeData() {
        TestedAndroidConfig testedExtension;
        BuildTypeData testBuildTypeData = null;
        if (this.extension instanceof TestedAndroidConfig && (testBuildTypeData = this.buildTypes.get((testedExtension = (TestedAndroidConfig)((Object)this.extension)).getTestBuildType())) == null) {
            throw new RuntimeException(String.format("Test Build Type '%1$s' does not exist.", testedExtension.getTestBuildType()));
        }
        return testBuildTypeData;
    }

    private BaseVariantData createVariantDataForVariantType(com.android.builder.model.BuildType buildType, List<? extends ProductFlavor> productFlavorList, VariantType variantType) {
        BuildTypeData buildTypeData = this.buildTypes.get(buildType.getName());
        DefaultAndroidSourceSet defaultConfigSourceProvider = this.defaultConfigData.getSourceSet();
        VariantBuilder variantBuilder = VariantBuilder.getBuilder(variantType, this.defaultConfigData.getProductFlavor(), defaultConfigSourceProvider, buildTypeData.getBuildType(), buildTypeData.getSourceSet(), this.signingOverride, this.getParser(defaultConfigSourceProvider.getManifestFile(), variantType.getRequiresManifest()), this.globalScope.getProjectOptions(), this.globalScope.getErrorHandler(), this::canParseManifest);
        for (ProductFlavor productFlavor : productFlavorList) {
            ProductFlavorData<ProductFlavor> data = this.productFlavors.get(productFlavor.getName());
            variantBuilder.addProductFlavor(data.getProductFlavor(), data.getSourceSet());
        }
        VariantManager.createCompoundSourceSets(productFlavorList, variantBuilder, this.sourceSetManager);
        VariantDslInfoImpl variantDslInfo = variantBuilder.createVariantDslInfo();
        VariantSources variantSources = variantBuilder.createVariantSources();
        if (!buildTypeData.getBuildType().isDebuggable() && variantType.isApk() && !variantDslInfo.getVariantType().isForTesting()) {
            ProcessProfileWriter.get().recordApplicationId(variantDslInfo::getApplicationId);
        }
        ArrayList variantSourceSets = Lists.newArrayListWithExpectedSize((int)(productFlavorList.size() + 4));
        if (!productFlavorList.isEmpty()) {
            variantSourceSets.add((DefaultAndroidSourceSet)variantSources.getVariantSourceProvider());
        }
        variantSourceSets.add(buildTypeData.getSourceSet());
        if (productFlavorList.size() > 1) {
            variantSourceSets.add((DefaultAndroidSourceSet)variantSources.getMultiFlavorSourceProvider());
        }
        for (ProductFlavor productFlavor : productFlavorList) {
            variantSourceSets.add(this.productFlavors.get(productFlavor.getName()).getSourceSet());
        }
        variantSourceSets.add(this.defaultConfigData.getSourceSet());
        BaseVariantData variantData = this.variantFactory.createVariantData(variantDslInfo, variantSources, this.taskManager, this.recorder);
        VariantScope variantScope = variantData.getScope();
        VariantDependencies.Builder builder = VariantDependencies.builder(this.project, variantScope.getGlobalScope().getErrorHandler(), variantDslInfo).setFlavorSelection(this.getFlavorSelection(variantDslInfo)).addSourceSets(variantSourceSets);
        if (this.extension instanceof BaseAppModuleExtension) {
            builder.setFeatureList(((BaseAppModuleExtension)this.extension).getDynamicFeatures());
        }
        VariantDependencies variantDep = builder.build(variantScope);
        variantData.setVariantDependency(variantDep);
        if (variantDslInfo.isLegacyMultiDexMode()) {
            String multiDexDependency = this.globalScope.getProjectOptions().get(BooleanOption.USE_ANDROID_X) ? ANDROIDX_MULTIDEX_MULTIDEX : COM_ANDROID_SUPPORT_MULTIDEX;
            this.project.getDependencies().add(variantDep.getCompileClasspath().getName(), (Object)multiDexDependency);
            this.project.getDependencies().add(variantDep.getRuntimeClasspath().getName(), (Object)multiDexDependency);
        }
        if (variantDslInfo.getRenderscriptSupportModeEnabled()) {
            ConfigurableFileCollection fileCollection2 = this.project.files(new Object[]{this.globalScope.getSdkComponents().getRenderScriptSupportJarProvider()});
            this.project.getDependencies().add(variantDep.getCompileClasspath().getName(), (Object)fileCollection2);
            if (variantType.isApk() && !variantType.isForTesting()) {
                this.project.getDependencies().add(variantDep.getRuntimeClasspath().getName(), (Object)fileCollection2);
            }
        }
        return variantData;
    }

    private static void createCompoundSourceSets(List<? extends ProductFlavor> productFlavorList, VariantBuilder variantBuilder, SourceSetManager sourceSetManager) {
        VariantType variantType = variantBuilder.getVariantType();
        if (!productFlavorList.isEmpty()) {
            DefaultAndroidSourceSet variantSourceSet = (DefaultAndroidSourceSet)sourceSetManager.setUpSourceSet(VariantManager.computeSourceSetName(variantBuilder.getName(), variantType), variantType.isTestComponent());
            variantBuilder.setVariantSourceProvider(variantSourceSet);
        }
        if (productFlavorList.size() > 1) {
            DefaultAndroidSourceSet multiFlavorSourceSet = (DefaultAndroidSourceSet)sourceSetManager.setUpSourceSet(VariantManager.computeSourceSetName(variantBuilder.getFlavorName(), variantType), variantType.isTestComponent());
            variantBuilder.setMultiFlavorSourceProvider(multiFlavorSourceSet);
        }
    }

    private static String computeSourceSetName(String name2, VariantType variantType) {
        if (name2.endsWith(variantType.getSuffix())) {
            name2 = name2.substring(0, name2.length() - variantType.getSuffix().length());
        }
        if (!variantType.getPrefix().isEmpty()) {
            name2 = StringHelper.appendCapitalized((String)variantType.getPrefix(), (String)name2);
        }
        return name2;
    }

    public TestVariantData createTestVariantData(BaseVariantData testedVariantData, VariantType type) {
        BuildType buildType = testedVariantData.getVariantDslInfo().getBuildType();
        BuildTypeData buildTypeData = this.buildTypes.get(buildType.getName());
        DefaultAndroidSourceSet testSourceSet = this.defaultConfigData.getTestSourceSet(type);
        VariantBuilder variantBuilder = VariantBuilder.getBuilder(type, this.defaultConfigData.getProductFlavor(), testSourceSet, buildTypeData.getBuildType(), buildTypeData.getTestSourceSet(type), this.signingOverride, testSourceSet != null ? this.getParser(testSourceSet.getManifestFile(), type.getRequiresManifest()) : null, this.globalScope.getProjectOptions(), this.globalScope.getErrorHandler(), this::canParseManifest);
        VariantDslInfoImpl testedVariantDslInfo = (VariantDslInfoImpl)testedVariantData.getVariantDslInfo();
        variantBuilder.setTestedVariant(testedVariantDslInfo);
        List<ProductFlavor> productFlavorList = testedVariantDslInfo.getProductFlavors();
        for (ProductFlavor productFlavor : productFlavorList) {
            ProductFlavorData<ProductFlavor> data = this.productFlavors.get(productFlavor.getName());
            variantBuilder.addProductFlavor(data.getProductFlavor(), data.getTestSourceSet(type));
        }
        VariantManager.createCompoundSourceSets(productFlavorList, variantBuilder, this.sourceSetManager);
        TestVariantData testVariantData = new TestVariantData(this.globalScope, this.taskManager, variantBuilder.createVariantDslInfo(), variantBuilder.createVariantSources(), (TestedVariantData)((Object)testedVariantData), this.recorder);
        ((TestedVariantData)((Object)testedVariantData)).setTestVariantData(testVariantData, type);
        return testVariantData;
    }

    private void createVariantDataForProductFlavors(VariantConfiguration variantConfiguration, BuildTypeData testBuildTypeData) {
        VariantType variantType = this.variantFactory.getVariantType();
        Action<com.android.build.api.variant.VariantFilter> variantFilterAction = this.extension.getVariantFilter();
        DefaultConfig defaultConfig = this.defaultConfigData.getProductFlavor();
        BuildTypeData buildTypeData = this.buildTypes.get(variantConfiguration.getBuildType());
        BuildType buildType = buildTypeData.getBuildType();
        List productFlavorList = variantConfiguration.getFlavors().stream().map(it -> this.productFlavors.get(it).getProductFlavor()).collect(Collectors.toList());
        boolean ignore = false;
        if (variantFilterAction != null) {
            this.variantFilter.reset(defaultConfig, buildType, variantType, productFlavorList);
            try {
                variantFilterAction.execute((Object)this.variantFilter);
            }
            catch (Throwable t) {
                throw new ExternalApiUsageException(t);
            }
            ignore = this.variantFilter.isIgnore();
        }
        BaseVariantData variantForAndroidTest = null;
        if (!ignore) {
            VariantScope.Java8LangSupport supportType;
            BaseVariantData variantData = this.createVariantDataForVariantType(buildType, productFlavorList, variantType);
            this.addVariant(variantData);
            VariantDslInfo variantDslInfo = variantData.getVariantDslInfo();
            VariantScope variantScope = variantData.getScope();
            int minSdkVersion = variantDslInfo.getMinSdkVersion().getApiLevel();
            int targetSdkVersion = variantDslInfo.getTargetSdkVersion().getApiLevel();
            if (minSdkVersion > 0 && targetSdkVersion > 0 && minSdkVersion > targetSdkVersion) {
                this.globalScope.getDslScope().getIssueReporter().reportWarning(EvalIssueReporter.Type.GENERIC, String.format(Locale.US, "minSdkVersion (%d) is greater than targetSdkVersion (%d) for variant \"%s\". Please change the values such that minSdkVersion is less than or equal to targetSdkVersion.", minSdkVersion, targetSdkVersion, variantData.getName()));
            }
            GradleBuildVariant.Builder profileBuilder = ProcessProfileWriter.getOrCreateVariant((String)this.project.getPath(), (String)variantData.getName()).setIsDebug(variantData.getPublicVariantApi().isDebuggable()).setMinSdkVersion(AnalyticsUtil.toProto(variantDslInfo.getMinSdkVersion())).setMinifyEnabled(variantScope.getCodeShrinker() != null).setUseMultidex(variantDslInfo.isMultiDexEnabled()).setUseLegacyMultidex(variantDslInfo.isLegacyMultiDexMode()).setVariantType(variantData.getType().getAnalyticsVariantType()).setDexBuilder(AnalyticsUtil.toProto(variantScope.getDexer())).setDexMerger(AnalyticsUtil.toProto(variantScope.getDexMerger())).setTestExecution(AnalyticsUtil.toProto(this.globalScope.getExtension().getTestOptions().getExecutionEnum()));
            if (variantScope.getCodeShrinker() != null) {
                profileBuilder.setCodeShrinker(AnalyticsUtil.toProto(variantScope.getCodeShrinker()));
            }
            if (variantDslInfo.getTargetSdkVersion().getApiLevel() > 0) {
                profileBuilder.setTargetSdkVersion(AnalyticsUtil.toProto(variantDslInfo.getTargetSdkVersion()));
            }
            if (variantDslInfo.getMaxSdkVersion() != null) {
                profileBuilder.setMaxSdkVersion(ApiVersion.newBuilder().setApiLevel((long)variantDslInfo.getMaxSdkVersion().intValue()));
            }
            if ((supportType = variantData.getScope().getJava8LangSupportType()) != VariantScope.Java8LangSupport.INVALID && supportType != VariantScope.Java8LangSupport.UNUSED) {
                profileBuilder.setJava8LangSupport(AnalyticsUtil.toProto(supportType));
            }
            if (this.variantFactory.hasTestScope()) {
                if (buildTypeData == testBuildTypeData) {
                    variantForAndroidTest = variantData;
                }
                TestVariantData unitTestVariantData = this.createTestVariantData(variantData, (VariantType)VariantTypeImpl.UNIT_TEST);
                this.addVariant(unitTestVariantData);
            }
        }
        if (variantForAndroidTest != null) {
            TestVariantData androidTestVariantData = this.createTestVariantData(variantForAndroidTest, (VariantType)VariantTypeImpl.ANDROID_TEST);
            this.addVariant(androidTestVariantData);
        }
    }

    private static void checkName(String name2, String displayName) {
        VariantManager.checkPrefix(name2, displayName, "androidTest");
        VariantManager.checkPrefix(name2, displayName, "test");
        if ("lint".equals(name2)) {
            throw new RuntimeException(String.format("%1$s names cannot be %2$s", displayName, "lint"));
        }
    }

    private static void checkPrefix(String name2, String displayName, String prefix) {
        if (name2.startsWith(prefix)) {
            throw new RuntimeException(String.format("%1$s names cannot start with '%2$s'", displayName, prefix));
        }
    }

    private SigningConfig createSigningOverride() {
        SigningOptions signingOptions = SigningOptions.readSigningOptions(this.projectOptions);
        if (signingOptions != null) {
            SigningConfig signingConfigDsl = new SigningConfig("externalOverride");
            signingConfigDsl.setStoreFile(new File(signingOptions.getStoreFile()));
            signingConfigDsl.setStorePassword(signingOptions.getStorePassword());
            signingConfigDsl.setKeyAlias(signingOptions.getKeyAlias());
            signingConfigDsl.setKeyPassword(signingOptions.getKeyPassword());
            if (signingOptions.getStoreType() != null) {
                signingConfigDsl.setStoreType(signingOptions.getStoreType());
            }
            if (signingOptions.getV1Enabled() != null) {
                signingConfigDsl.setV1SigningEnabled(signingOptions.getV1Enabled());
            }
            if (signingOptions.getV2Enabled() != null) {
                signingConfigDsl.setV2SigningEnabled(signingOptions.getV2Enabled());
            }
            return signingConfigDsl;
        }
        return null;
    }

    private ManifestAttributeSupplier getParser(File file, boolean isManifestFileRequired) {
        return this.manifestParserMap.computeIfAbsent(file, f -> new DefaultManifestParser(f, this::canParseManifest, isManifestFileRequired, (EvalIssueReporter)this.globalScope.getErrorHandler()));
    }

    private boolean canParseManifest() {
        return this.hasCreatedTasks || !this.projectOptions.get(BooleanOption.DISABLE_EARLY_MANIFEST_PARSING);
    }

    public void setHasCreatedTasks(boolean hasCreatedTasks) {
        this.hasCreatedTasks = hasCreatedTasks;
    }

    public String getDefaultVariant(SyncIssueHandler syncIssueHandler) {
        this.finalizeDefaultVariantDsl();
        if (this.variantScopes.isEmpty()) {
            return null;
        }
        String chosenBuildType = this.getBuildAuthorSpecifiedDefaultBuildType(syncIssueHandler);
        Map<String, String> chosenFlavors = this.getBuildAuthorSpecifiedDefaultFlavors(syncIssueHandler);
        String fallbackDefaultBuildType = this.getFallbackDefaultBuildType();
        Comparator<VariantScope> preferredDefaultVariantScopeComparator = new BuildAuthorSpecifiedDefaultBuildTypeComparator(chosenBuildType).thenComparing(new BuildAuthorSpecifiedDefaultsFlavorComparator(chosenFlavors)).thenComparing(new DefaultBuildTypeComparator(fallbackDefaultBuildType)).thenComparing(new DefaultFlavorComparator());
        Optional<VariantScope> defaultVariantScope = this.variantScopes.stream().filter(it -> !it.getType().isTestComponent()).min(preferredDefaultVariantScopeComparator);
        return defaultVariantScope.map(TransformVariantScope::getFullVariantName).orElse(null);
    }

    private String getFallbackDefaultBuildType() {
        String testBuildType = this.extension.getTestBuildType();
        if (testBuildType != null) {
            return testBuildType;
        }
        return "debug";
    }

    private void finalizeDefaultVariantDsl() {
        for (BuildTypeData buildTypeData : this.buildTypes.values()) {
            buildTypeData.getBuildType().getIsDefault().finalizeValue();
        }
        for (ProductFlavorData productFlavorData : this.productFlavors.values()) {
            ((ProductFlavor)productFlavorData.getProductFlavor()).getIsDefault().finalizeValue();
        }
    }

    private String getBuildAuthorSpecifiedDefaultBuildType(SyncIssueHandler syncIssueHandler) {
        ArrayList<String> buildTypesMarkedAsDefault = new ArrayList<String>(1);
        for (BuildTypeData buildType : this.buildTypes.values()) {
            if (!((Boolean)buildType.getBuildType().getIsDefault().get()).booleanValue()) continue;
            buildTypesMarkedAsDefault.add(buildType.getBuildType().getName());
        }
        Collections.sort(buildTypesMarkedAsDefault);
        if (buildTypesMarkedAsDefault.size() > 1) {
            syncIssueHandler.reportWarning(EvalIssueReporter.Type.AMBIGUOUS_BUILD_TYPE_DEFAULT, "Ambiguous default build type: '" + Joiner.on((String)"', '").join(buildTypesMarkedAsDefault) + "'.\nPlease only set `isDefault = true` for one build type.", Joiner.on((char)',').join(buildTypesMarkedAsDefault));
        }
        if (buildTypesMarkedAsDefault.isEmpty()) {
            return null;
        }
        return (String)buildTypesMarkedAsDefault.get(0);
    }

    private Map<String, String> getBuildAuthorSpecifiedDefaultFlavors(SyncIssueHandler syncIssueHandler) {
        ArrayListMultimap userDefaults = ArrayListMultimap.create();
        for (ProductFlavorData<ProductFlavor> flavor : this.productFlavors.values()) {
            ProductFlavor productFlavor = flavor.getProductFlavor();
            String dimension = productFlavor.getDimension();
            if (!((Boolean)productFlavor.getIsDefault().get()).booleanValue()) continue;
            userDefaults.put((Object)dimension, (Object)productFlavor.getName());
        }
        ImmutableMap.Builder defaults = ImmutableMap.builder();
        for (String dimension : userDefaults.keySet()) {
            List userDefault = userDefaults.get((Object)dimension);
            Collections.sort(userDefault);
            if (!userDefault.isEmpty()) {
                defaults.put((Object)dimension, userDefault.get(0));
            }
            if (userDefault.size() <= 1) continue;
            syncIssueHandler.reportWarning(EvalIssueReporter.Type.AMBIGUOUS_PRODUCT_FLAVOR_DEFAULT, "Ambiguous default product flavors for flavor dimension '" + dimension + "': '" + Joiner.on((String)"', '").join((Iterable)userDefault) + "'.\nPlease only set `isDefault = true` for one product flavor in each flavor dimension.", dimension);
        }
        return defaults.build();
    }

    private static class DefaultFlavorComparator
    implements Comparator<VariantScope> {
        private DefaultFlavorComparator() {
        }

        @Override
        public int compare(VariantScope v1, VariantScope v2) {
            for (int i2 = 0; i2 < v1.getVariantDslInfo().getProductFlavors().size(); ++i2) {
                String f2;
                String f1 = v1.getVariantDslInfo().getProductFlavors().get(i2).getName();
                int diff = f1.compareTo(f2 = v2.getVariantDslInfo().getProductFlavors().get(i2).getName());
                if (diff == 0) continue;
                return diff;
            }
            return 0;
        }
    }

    private static class DefaultBuildTypeComparator
    implements Comparator<VariantScope> {
        private final String preferredBuildType;

        private DefaultBuildTypeComparator(String preferredBuildType) {
            this.preferredBuildType = preferredBuildType;
        }

        @Override
        public int compare(VariantScope v1, VariantScope v2) {
            String b2;
            String b1 = v1.getVariantDslInfo().getBuildType().getName();
            if (b1.equals(b2 = v2.getVariantDslInfo().getBuildType().getName())) {
                return 0;
            }
            if (b1.equals(this.preferredBuildType)) {
                return -1;
            }
            if (b2.equals(this.preferredBuildType)) {
                return 1;
            }
            return b1.compareTo(b2);
        }
    }

    private static class BuildAuthorSpecifiedDefaultsFlavorComparator
    implements Comparator<VariantScope> {
        private final Map<String, String> defaultFlavors;

        BuildAuthorSpecifiedDefaultsFlavorComparator(Map<String, String> defaultFlavors) {
            this.defaultFlavors = defaultFlavors;
        }

        @Override
        public int compare(VariantScope v1, VariantScope v2) {
            int f1Score = 0;
            int f2Score = 0;
            for (ProductFlavor flavor : v1.getVariantDslInfo().getProductFlavors()) {
                if (!flavor.getName().equals(this.defaultFlavors.get(flavor.getDimension()))) continue;
                ++f1Score;
            }
            for (ProductFlavor flavor : v2.getVariantDslInfo().getProductFlavors()) {
                if (!flavor.getName().equals(this.defaultFlavors.get(flavor.getDimension()))) continue;
                ++f2Score;
            }
            return f2Score - f1Score;
        }
    }

    private static class BuildAuthorSpecifiedDefaultBuildTypeComparator
    implements Comparator<VariantScope> {
        private final String chosen;

        private BuildAuthorSpecifiedDefaultBuildTypeComparator(String chosen) {
            this.chosen = chosen;
        }

        @Override
        public int compare(VariantScope v1, VariantScope v2) {
            if (this.chosen == null) {
                return 0;
            }
            int b1Score = v1.getVariantDslInfo().getBuildType().getName().equals(this.chosen) ? 1 : 0;
            int b2Score = v2.getVariantDslInfo().getBuildType().getName().equals(this.chosen) ? 1 : 0;
            return b2Score - b1Score;
        }
    }
}

