/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.api.attributes.BuildTypeAttr;
import com.android.build.api.attributes.ProductFlavorAttr;
import com.android.build.api.attributes.VariantAttr;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.dependency.AndroidXDependencyCheck;
import com.android.build.gradle.internal.dependency.ConstraintHandler;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.errors.SyncIssueHandler;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.TestVariantFactory;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.core.VariantType;
import com.android.builder.errors.EvalIssueReporter;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.model.ObjectFactory;

public class VariantDependencies {
    public static final String CONFIG_NAME_COMPILE = "compile";
    public static final String CONFIG_NAME_PUBLISH = "publish";
    public static final String CONFIG_NAME_APK = "apk";
    public static final String CONFIG_NAME_PROVIDED = "provided";
    public static final String CONFIG_NAME_WEAR_APP = "wearApp";
    public static final String CONFIG_NAME_ANDROID_APIS = "androidApis";
    public static final String CONFIG_NAME_ANNOTATION_PROCESSOR = "annotationProcessor";
    public static final String CONFIG_NAME_API = "api";
    public static final String CONFIG_NAME_COMPILE_ONLY = "compileOnly";
    public static final String CONFIG_NAME_IMPLEMENTATION = "implementation";
    public static final String CONFIG_NAME_RUNTIME_ONLY = "runtimeOnly";
    @Deprecated
    public static final String CONFIG_NAME_FEATURE = "feature";
    public static final String CONFIG_NAME_APPLICATION = "application";
    public static final String CONFIG_NAME_LINTCHECKS = "lintChecks";
    public static final String CONFIG_NAME_LINTPUBLISH = "lintPublish";
    public static final String CONFIG_NAME_TESTED_APKS = "testedApks";
    public static final String CONFIG_NAME_CORE_LIBRARY_DESUGARING = "coreLibraryDesugaring";
    private final String variantName;
    private final Configuration compileClasspath;
    private final Configuration runtimeClasspath;
    private final Collection<Configuration> sourceSetRuntimeConfigurations;
    private final Collection<Configuration> sourceSetImplementationConfigurations;
    private final ImmutableMap<AndroidArtifacts.PublishedConfigType, Configuration> elements;
    private final Configuration annotationProcessorConfiguration;
    private final Configuration wearAppConfiguration;
    private final Configuration reverseMetadataValuesConfiguration;

    public static Builder builder(Project project2, SyncIssueHandler errorReporter, VariantDslInfo variantDslInfo) {
        return new Builder(project2, errorReporter, variantDslInfo);
    }

    private VariantDependencies(String variantName, Configuration compileClasspath, Configuration runtimeClasspath, Collection<Configuration> sourceSetRuntimeConfigurations, Collection<Configuration> sourceSetImplementationConfigurations, Map<AndroidArtifacts.PublishedConfigType, Configuration> elements, Configuration annotationProcessorConfiguration, Configuration reverseMetadataValuesConfiguration, Configuration wearAppConfiguration) {
        this.variantName = variantName;
        this.compileClasspath = compileClasspath;
        this.runtimeClasspath = runtimeClasspath;
        this.sourceSetRuntimeConfigurations = sourceSetRuntimeConfigurations;
        this.sourceSetImplementationConfigurations = sourceSetImplementationConfigurations;
        this.elements = Maps.immutableEnumMap(elements);
        this.annotationProcessorConfiguration = annotationProcessorConfiguration;
        this.reverseMetadataValuesConfiguration = reverseMetadataValuesConfiguration;
        this.wearAppConfiguration = wearAppConfiguration;
    }

    public String getName() {
        return this.variantName;
    }

    public Configuration getCompileClasspath() {
        return this.compileClasspath;
    }

    public Configuration getRuntimeClasspath() {
        return this.runtimeClasspath;
    }

    public Collection<Dependency> getIncomingRuntimeDependencies() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Configuration classpath : this.sourceSetRuntimeConfigurations) {
            builder.addAll((Iterable)classpath.getIncoming().getDependencies());
        }
        return builder.build();
    }

    public Configuration getElements(AndroidArtifacts.PublishedConfigType configType) {
        return (Configuration)this.elements.get((Object)configType);
    }

    public Configuration getAnnotationProcessorConfiguration() {
        return this.annotationProcessorConfiguration;
    }

    public Configuration getWearAppConfiguration() {
        return this.wearAppConfiguration;
    }

    public Configuration getReverseMetadataValuesConfiguration() {
        return this.reverseMetadataValuesConfiguration;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.variantName).toString();
    }

    public static final class Builder {
        private final Project project;
        private final SyncIssueHandler errorReporter;
        private final VariantDslInfo variantDslInfo;
        private Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> flavorSelection;
        private final Set<Configuration> compileClasspaths = Sets.newLinkedHashSet();
        private final Set<Configuration> apiClasspaths = Sets.newLinkedHashSet();
        private final Set<Configuration> implementationConfigurations = Sets.newLinkedHashSet();
        private final Set<Configuration> runtimeClasspaths = Sets.newLinkedHashSet();
        private final Set<Configuration> annotationConfigs = Sets.newLinkedHashSet();
        private final Set<Configuration> wearAppConfigs = Sets.newLinkedHashSet();
        private VariantScope testedVariantScope;
        private Set<String> featureList;

        protected Builder(Project project2, SyncIssueHandler errorReporter, VariantDslInfo variantDslInfo) {
            this.project = project2;
            this.errorReporter = errorReporter;
            this.variantDslInfo = variantDslInfo;
        }

        public Builder addSourceSets(DefaultAndroidSourceSet ... sourceSets) {
            for (DefaultAndroidSourceSet sourceSet : sourceSets) {
                this.addSourceSet(sourceSet);
            }
            return this;
        }

        public Builder addSourceSets(Collection<DefaultAndroidSourceSet> sourceSets) {
            for (DefaultAndroidSourceSet sourceSet : sourceSets) {
                this.addSourceSet(sourceSet);
            }
            return this;
        }

        public Builder setTestedVariantScope(VariantScope testedVariantScope) {
            this.testedVariantScope = testedVariantScope;
            return this;
        }

        public Builder setFeatureList(Set<String> featureList) {
            this.featureList = featureList;
            return this;
        }

        public Builder addSourceSet(DefaultAndroidSourceSet sourceSet) {
            if (sourceSet != null) {
                ConfigurationContainer configs = this.project.getConfigurations();
                this.compileClasspaths.add(configs.getByName(sourceSet.getCompileOnlyConfigurationName()));
                this.runtimeClasspaths.add(configs.getByName(sourceSet.getRuntimeOnlyConfigurationName()));
                Configuration implementationConfig = configs.getByName(sourceSet.getImplementationConfigurationName());
                this.compileClasspaths.add(implementationConfig);
                this.runtimeClasspaths.add(implementationConfig);
                this.implementationConfigurations.add(implementationConfig);
                String apiConfigName = sourceSet.getApiConfigurationName();
                if (apiConfigName != null) {
                    this.apiClasspaths.add(configs.getByName(apiConfigName));
                }
                this.annotationConfigs.add(configs.getByName(sourceSet.getAnnotationProcessorConfigurationName()));
                this.wearAppConfigs.add(configs.getByName(sourceSet.getWearAppConfigurationName()));
            }
            return this;
        }

        public Builder setFlavorSelection(Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> flavorSelection) {
            this.flavorSelection = flavorSelection;
            return this;
        }

        public VariantDependencies build(VariantScope variantScope) {
            ObjectFactory factory2 = this.project.getObjects();
            Usage apiUsage = (Usage)factory2.named(Usage.class, "java-api");
            Usage runtimeUsage = (Usage)factory2.named(Usage.class, "java-runtime");
            Usage reverseMetadataUsage = (Usage)factory2.named(Usage.class, "android-reverse-meta-data");
            String variantName = this.variantDslInfo.getFullName();
            VariantType variantType = this.variantDslInfo.getVariantType();
            String buildType = this.variantDslInfo.getBuildType().getName();
            Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> consumptionFlavorMap = this.getFlavorAttributes(this.flavorSelection);
            ConfigurationContainer configurations = this.project.getConfigurations();
            String compileClasspathName = variantName + "CompileClasspath";
            Configuration compileClasspath = (Configuration)configurations.maybeCreate(compileClasspathName);
            compileClasspath.setVisible(false);
            compileClasspath.setDescription("Resolved configuration for compilation for variant: " + variantName);
            compileClasspath.setExtendsFrom(this.compileClasspaths);
            if (this.testedVariantScope != null) {
                for (Configuration configuration2 : this.testedVariantScope.getVariantDependencies().sourceSetImplementationConfigurations) {
                    compileClasspath.extendsFrom(new Configuration[]{configuration2});
                }
            }
            compileClasspath.setCanBeConsumed(false);
            compileClasspath.getResolutionStrategy().sortArtifacts(ResolutionStrategy.SortOrder.CONSUMER_FIRST);
            AttributeContainer compileAttributes = compileClasspath.getAttributes();
            this.applyVariantAttributes(compileAttributes, buildType, consumptionFlavorMap);
            compileAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)apiUsage);
            Configuration annotationProcessor = (Configuration)configurations.maybeCreate(variantName + "AnnotationProcessorClasspath");
            annotationProcessor.setVisible(false);
            annotationProcessor.setDescription("Resolved configuration for annotation-processor for variant: " + variantName);
            annotationProcessor.setExtendsFrom(this.annotationConfigs);
            annotationProcessor.setCanBeConsumed(false);
            AttributeContainer annotationAttributes = annotationProcessor.getAttributes();
            annotationAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
            this.applyVariantAttributes(annotationAttributes, buildType, consumptionFlavorMap);
            String runtimeClasspathName = variantName + "RuntimeClasspath";
            Configuration runtimeClasspath = (Configuration)configurations.maybeCreate(runtimeClasspathName);
            runtimeClasspath.setVisible(false);
            runtimeClasspath.setDescription("Resolved configuration for runtime for variant: " + variantName);
            runtimeClasspath.setExtendsFrom(this.runtimeClasspaths);
            if (this.testedVariantScope != null) {
                for (Configuration configuration3 : this.testedVariantScope.getVariantDependencies().sourceSetRuntimeConfigurations) {
                    runtimeClasspath.extendsFrom(new Configuration[]{configuration3});
                }
            }
            runtimeClasspath.setCanBeConsumed(false);
            runtimeClasspath.getResolutionStrategy().sortArtifacts(ResolutionStrategy.SortOrder.CONSUMER_FIRST);
            AttributeContainer runtimeAttributes = runtimeClasspath.getAttributes();
            this.applyVariantAttributes(runtimeAttributes, buildType, consumptionFlavorMap);
            runtimeAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
            if (variantScope.getGlobalScope().getProjectOptions().get(BooleanOption.USE_DEPENDENCY_CONSTRAINTS)) {
                compileClasspath.getIncoming().beforeResolve((Action)new ConstraintHandler(runtimeClasspath, this.project.getDependencies().getConstraints(), false));
                if (variantType.isApk() && this.testedVariantScope != null) {
                    Configuration testedRuntimeClasspath = this.testedVariantScope.getVariantDependencies().getRuntimeClasspath();
                    runtimeClasspath.getIncoming().beforeResolve((Action)new ConstraintHandler(testedRuntimeClasspath, this.project.getDependencies().getConstraints(), true));
                }
            }
            if (!variantScope.getGlobalScope().getProjectOptions().get(BooleanOption.USE_ANDROID_X)) {
                AndroidXDependencyCheck androidXDependencyCheck = new AndroidXDependencyCheck(variantScope.getGlobalScope().getErrorHandler());
                compileClasspath.getIncoming().afterResolve((Action)androidXDependencyCheck);
                runtimeClasspath.getIncoming().afterResolve((Action)androidXDependencyCheck);
            }
            Configuration globalTestedApks = (Configuration)configurations.findByName(VariantDependencies.CONFIG_NAME_TESTED_APKS);
            if (variantType.isApk() && globalTestedApks != null) {
                Configuration testedApks = (Configuration)configurations.maybeCreate(TestVariantFactory.getTestedApksConfigurationName(variantName));
                testedApks.setVisible(false);
                testedApks.setDescription("Resolved configuration for tested apks for variant: " + variantName);
                testedApks.extendsFrom(new Configuration[]{globalTestedApks});
                AttributeContainer testedApksAttributes = testedApks.getAttributes();
                this.applyVariantAttributes(testedApksAttributes, buildType, consumptionFlavorMap);
                testedApksAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
            }
            Configuration reverseMetadataValues = null;
            Configuration wearApp = null;
            EnumMap elements = Maps.newEnumMap(AndroidArtifacts.PublishedConfigType.class);
            if (variantType.isBaseModule()) {
                wearApp = (Configuration)configurations.maybeCreate(variantName + "WearBundling");
                wearApp.setDescription("Resolved Configuration for wear app bundling for variant: " + variantName);
                wearApp.setExtendsFrom(this.wearAppConfigs);
                wearApp.setCanBeConsumed(false);
                AttributeContainer wearAttributes = wearApp.getAttributes();
                this.applyVariantAttributes(wearAttributes, buildType, consumptionFlavorMap);
                wearAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
            }
            VariantAttr variantNameAttr = (VariantAttr)factory2.named(VariantAttr.class, variantName);
            Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> publicationFlavorMap = this.getFlavorAttributes(null);
            if (variantType.getPublishToOtherModules()) {
                Configuration runtimeElements = this.createPublishingConfig(configurations, variantName + "RuntimeElements", "Runtime elements for " + variantName, buildType, publicationFlavorMap, variantNameAttr, runtimeUsage);
                runtimeElements.extendsFrom(new Configuration[]{runtimeClasspath});
                elements.put(AndroidArtifacts.PublishedConfigType.RUNTIME_ELEMENTS, runtimeElements);
                Configuration apiElements = this.createPublishingConfig(configurations, variantName + "ApiElements", "API elements for " + variantName, buildType, publicationFlavorMap, variantNameAttr, apiUsage);
                apiElements.setExtendsFrom(this.apiClasspaths);
                elements.put(AndroidArtifacts.PublishedConfigType.API_ELEMENTS, apiElements);
            }
            if (variantType.getPublishToRepository()) {
                if (variantType.isAar()) {
                    LibraryElements libraryElements = (LibraryElements)factory2.named(LibraryElements.class, AndroidArtifacts.ArtifactType.AAR.getType());
                    Bundling bundling = (Bundling)factory2.named(Bundling.class, "external");
                    Category category = (Category)factory2.named(Category.class, "library");
                    Configuration runtimePublication = this.createAarPublishingConfiguration(configurations, variantName + "RuntimePublication", "Runtime publication for " + variantName, runtimeUsage, libraryElements, bundling, category, null, null, null);
                    runtimePublication.extendsFrom(new Configuration[]{runtimeClasspath});
                    elements.put(AndroidArtifacts.PublishedConfigType.RUNTIME_PUBLICATION, runtimePublication);
                    Configuration apiPublication = this.createAarPublishingConfiguration(configurations, variantName + "ApiPublication", "API publication for " + variantName, apiUsage, libraryElements, bundling, category, null, null, null);
                    apiPublication.setExtendsFrom(this.apiClasspaths);
                    elements.put(AndroidArtifacts.PublishedConfigType.API_PUBLICATION, apiPublication);
                    Configuration allApiPublication = this.createAarPublishingConfiguration(configurations, variantName + "AllApiPublication", "All API publication for " + variantName, apiUsage, libraryElements, bundling, category, buildType, publicationFlavorMap, variantNameAttr);
                    allApiPublication.setExtendsFrom(this.apiClasspaths);
                    elements.put(AndroidArtifacts.PublishedConfigType.ALL_API_PUBLICATION, allApiPublication);
                    Configuration allRuntimePublication = this.createAarPublishingConfiguration(configurations, variantName + "AllRuntimePublication", "All runtime publication for " + variantName, runtimeUsage, libraryElements, bundling, category, buildType, publicationFlavorMap, variantNameAttr);
                    allRuntimePublication.setExtendsFrom(this.runtimeClasspaths);
                    elements.put(AndroidArtifacts.PublishedConfigType.ALL_RUNTIME_PUBLICATION, allRuntimePublication);
                } else {
                    Configuration apkPublication = this.createPublishingConfig(configurations, variantName + "ApkPublication", "APK publication for " + variantName, buildType, publicationFlavorMap, variantNameAttr, null);
                    elements.put(AndroidArtifacts.PublishedConfigType.APK_PUBLICATION, apkPublication);
                    apkPublication.setVisible(false);
                    apkPublication.setCanBeConsumed(false);
                    Configuration aabPublication = this.createPublishingConfig(configurations, variantName + "AabPublication", "Bundle Publication for " + variantName, buildType, publicationFlavorMap, variantNameAttr, null);
                    elements.put(AndroidArtifacts.PublishedConfigType.AAB_PUBLICATION, aabPublication);
                    aabPublication.setVisible(false);
                    aabPublication.setCanBeConsumed(false);
                }
            }
            if (variantType.getPublishToMetadata()) {
                Configuration reverseMetadataElements = this.createPublishingConfig(configurations, variantName + "ReverseMetadataElements", "Reverse Meta-data elements for " + variantName, buildType, publicationFlavorMap, variantNameAttr, reverseMetadataUsage);
                elements.put(AndroidArtifacts.PublishedConfigType.REVERSE_METADATA_ELEMENTS, reverseMetadataElements);
            }
            if (variantType.isBaseModule()) {
                String reverseMetadataValuesName = variantName + "ReverseMetadataValues";
                reverseMetadataValues = (Configuration)configurations.maybeCreate(reverseMetadataValuesName);
                if (this.featureList != null) {
                    DependencyHandler depHandler = this.project.getDependencies();
                    ArrayList<String> notFound = new ArrayList<String>();
                    for (String feature : this.featureList) {
                        Project p = this.project.findProject(feature);
                        if (p != null) {
                            depHandler.add(reverseMetadataValuesName, (Object)p);
                            continue;
                        }
                        notFound.add(feature);
                    }
                    if (!notFound.isEmpty()) {
                        this.errorReporter.reportError(EvalIssueReporter.Type.GENERIC, "Unable to find matching projects for Dynamic Features: " + notFound);
                    }
                } else {
                    reverseMetadataValues.extendsFrom(new Configuration[]{configurations.getByName(VariantDependencies.CONFIG_NAME_FEATURE)});
                }
                reverseMetadataValues.setDescription("Metadata Values dependencies for the base Split");
                reverseMetadataValues.setCanBeConsumed(false);
                AttributeContainer reverseMetadataValuesAttributes = reverseMetadataValues.getAttributes();
                reverseMetadataValuesAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)reverseMetadataUsage);
                this.applyVariantAttributes(reverseMetadataValuesAttributes, buildType, consumptionFlavorMap);
            }
            Builder.checkOldConfigurations(configurations, "_" + variantName + "Compile", compileClasspathName);
            Builder.checkOldConfigurations(configurations, "_" + variantName + "Apk", runtimeClasspathName);
            Builder.checkOldConfigurations(configurations, "_" + variantName + "Publish", runtimeClasspathName);
            return new VariantDependencies(variantName, compileClasspath, runtimeClasspath, this.runtimeClasspaths, this.implementationConfigurations, elements, annotationProcessor, reverseMetadataValues, wearApp);
        }

        private Configuration createPublishingConfig(ConfigurationContainer configurations, String configName, String configDesc, String buildType, Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> publicationFlavorMap, VariantAttr variantNameAttr, Usage usage) {
            Configuration config2 = (Configuration)configurations.maybeCreate(configName);
            config2.setDescription(configDesc);
            config2.setCanBeResolved(false);
            AttributeContainer attrContainer = config2.getAttributes();
            this.applyVariantAttributes(attrContainer, buildType, publicationFlavorMap);
            attrContainer.attribute(VariantAttr.getATTRIBUTE(), (Object)variantNameAttr);
            if (usage != null) {
                attrContainer.attribute(Usage.USAGE_ATTRIBUTE, (Object)usage);
            }
            return config2;
        }

        private Configuration createAarPublishingConfiguration(ConfigurationContainer configurations, String configName, String configDesc, Usage usage, LibraryElements libraryElements, Bundling bundling, Category category, String buildType, Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> publicationFlavorMap, VariantAttr variantNameAttr) {
            Configuration config2 = (Configuration)configurations.maybeCreate(configName);
            config2.setDescription(configDesc);
            config2.setCanBeResolved(false);
            config2.setVisible(false);
            config2.setCanBeConsumed(false);
            AttributeContainer attrContainer = config2.getAttributes();
            attrContainer.attribute(Usage.USAGE_ATTRIBUTE, (Object)usage);
            attrContainer.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)libraryElements);
            attrContainer.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)bundling);
            attrContainer.attribute(Category.CATEGORY_ATTRIBUTE, (Object)category);
            if (buildType != null) {
                Preconditions.checkNotNull(publicationFlavorMap);
                this.applyVariantAttributes(attrContainer, buildType, publicationFlavorMap);
            }
            if (variantNameAttr != null) {
                attrContainer.attribute(VariantAttr.getATTRIBUTE(), (Object)variantNameAttr);
            }
            return config2;
        }

        private static void checkOldConfigurations(ConfigurationContainer configurations, String oldConfigName, String newConfigName) {
            if (configurations.findByName(oldConfigName) != null) {
                throw new RuntimeException(String.format("Configuration with old name %s found. Use new name %s instead.", oldConfigName, newConfigName));
            }
        }

        private Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> getFlavorAttributes(Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> flavorSelection) {
            List<ProductFlavor> productFlavors = this.variantDslInfo.getProductFlavors();
            HashMap map = Maps.newHashMapWithExpectedSize((int)productFlavors.size());
            if (this.errorReporter.hasSyncIssue(EvalIssueReporter.Type.UNNAMED_FLAVOR_DIMENSION)) {
                return map;
            }
            ObjectFactory objectFactory = this.project.getObjects();
            for (ProductFlavor f : productFlavors) {
                assert (f.getDimension() != null);
                map.put(Attribute.of((String)f.getDimension(), ProductFlavorAttr.class), objectFactory.named(ProductFlavorAttr.class, f.getName()));
            }
            if (flavorSelection != null) {
                map.putAll(flavorSelection);
            }
            return map;
        }

        private void applyVariantAttributes(AttributeContainer attributeContainer, String buildType, Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> flavorMap2) {
            attributeContainer.attribute(BuildTypeAttr.Companion.getATTRIBUTE(), (Object)this.project.getObjects().named(BuildTypeAttr.class, buildType));
            for (Map.Entry<Attribute<ProductFlavorAttr>, ProductFlavorAttr> entry : flavorMap2.entrySet()) {
                attributeContainer.attribute(entry.getKey(), (Object)entry.getValue());
            }
        }
    }
}

