/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.api.variant.VariantConfiguration;
import com.android.build.api.variant.impl.TestVariantImpl;
import com.android.build.api.variant.impl.TestVariantPropertiesImpl;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.api.variant.impl.VariantPropertiesImpl;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.core.VariantDslInfoImpl;
import com.android.build.gradle.internal.core.VariantSources;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.builder.core.VariantType;
import com.android.builder.profile.Recorder;
import com.android.utils.StringHelper;

public class TestVariantData
extends ApkVariantData {
    private final TestedVariantData testedVariantData;

    public TestVariantData(GlobalScope globalScope, TaskManager taskManager, VariantDslInfoImpl variantDslInfo, VariantSources variantSources, TestedVariantData testedVariantData, Recorder recorder) {
        super(globalScope, taskManager, variantDslInfo, variantSources, recorder);
        this.testedVariantData = testedVariantData;
        this.getPublicVariantPropertiesApi().addVariantOutput(this.getOutputFactory().addMainApk());
    }

    public TestedVariantData getTestedVariantData() {
        return this.testedVariantData;
    }

    @Override
    public String getDescription() {
        VariantType variantType = this.getType();
        String prefix = variantType.isApk() ? "android (on device) tests" : "unit tests";
        VariantDslInfo variantDslInfo = this.getVariantDslInfo();
        if (variantDslInfo.hasFlavors()) {
            StringBuilder sb = new StringBuilder(50);
            sb.append(prefix);
            sb.append(" for the ");
            StringHelper.appendCapitalized((StringBuilder)sb, (String)variantDslInfo.getFlavorName());
            StringHelper.appendCapitalized((StringBuilder)sb, (String)variantDslInfo.getBuildType().getName());
            sb.append(" build");
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder(50);
        sb.append(prefix);
        sb.append(" for the ");
        StringHelper.appendCapitalized((StringBuilder)sb, (String)variantDslInfo.getBuildType().getName());
        sb.append(" build");
        return sb.toString();
    }

    @Override
    VariantImpl<?> instantiatePublicVariantObject(VariantConfiguration publicVariantConfiguration) {
        return new TestVariantImpl(publicVariantConfiguration);
    }

    @Override
    VariantPropertiesImpl instantiatePublicVariantPropertiesObject(VariantConfiguration publicVariantConfiguration) {
        return (VariantPropertiesImpl)this.scope.getGlobalScope().getProject().getObjects().newInstance(TestVariantPropertiesImpl.class, new Object[]{this.scope.getGlobalScope().getDslScope(), this.scope, this.scope.getArtifacts().getOperations(), publicVariantConfiguration});
    }
}

