/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.external.gnumake;

import com.android.build.gradle.external.gnumake.AbstractOsFileConventions;
import com.android.build.gradle.external.gnumake.BuildStepInfo;
import com.android.build.gradle.external.gnumake.CommandClassifier;
import com.android.build.gradle.external.gnumake.CommandLine;
import com.android.build.gradle.external.gnumake.FlowAnalyzer;
import com.android.build.gradle.external.gnumake.OsFileConventions;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValue;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValue;
import com.android.build.gradle.internal.cxx.json.NativeSourceFileValue;
import com.android.build.gradle.internal.cxx.json.NativeToolchainValue;
import com.android.utils.NativeSourceFileExtensions;
import com.android.utils.NdkUtils;
import com.android.utils.cxx.CompileCommandsCodecKt;
import com.android.utils.cxx.CompileCommandsEncoder;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 72\u00020\u0001:\u000278B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020#H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000bH\u0002J\b\u0010(\u001a\u00020&H\u0002J\b\u0010)\u001a\u00020&H\u0002J\u0010\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u000bH\u0002J\b\u0010,\u001a\u00020&H\u0002J\u0014\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\nH\u0002J\u0016\u0010.\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u0002000/H\u0002J\u0016\u00101\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u0002020/H\u0002J2\u00103\u001a\u00020\u00002\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u00106\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u000bJ\u0006\u0010\u0019\u001a\u00020&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/android/build/gradle/external/gnumake/NativeBuildConfigValueBuilder;", "", "androidMk", "Ljava/io/File;", "executionRootPath", "(Ljava/io/File;Ljava/io/File;)V", "fileConventions", "Lcom/android/build/gradle/external/gnumake/OsFileConventions;", "(Ljava/io/File;Ljava/io/File;Lcom/android/build/gradle/external/gnumake/OsFileConventions;)V", "buildTargetsCommand", "", "", "cFileExtensions", "", "compileCommandsEncoder", "Lcom/android/utils/cxx/CompileCommandsEncoder;", "compileCommandsJsonBinFile", "getCompileCommandsJsonBinFile", "()Ljava/io/File;", "setCompileCommandsJsonBinFile", "(Ljava/io/File;)V", "cppFileExtensions", "outputs", "", "Lcom/android/build/gradle/external/gnumake/NativeBuildConfigValueBuilder$Output;", "skipProcessingCompilerFlags", "", "getSkipProcessingCompilerFlags", "()Z", "setSkipProcessingCompilerFlags", "(Z)V", "toolChainToCCompiler", "", "toolChainToCppCompiler", "build", "Lcom/android/build/gradle/internal/cxx/json/NativeBuildConfigValue;", "buildImpl", "extractWorkingDirectoryFromDryRunOutputIfAvailable", "", "dryRunOutput", "findLibraryNames", "findToolChainCompilers", "findToolChainName", "outputFileName", "findToolchainNames", "generateCleanCommands", "generateLibraries", "", "Lcom/android/build/gradle/internal/cxx/json/NativeLibraryValue;", "generateToolchains", "Lcom/android/build/gradle/internal/cxx/json/NativeToolchainValue;", "setCommands", "buildCommand", "cleanCommand", "variantName", "Companion", "Output", "gradle-core"})
public final class NativeBuildConfigValueBuilder {
    private final Map<String, String> toolChainToCCompiler;
    private final Map<String, String> toolChainToCppCompiler;
    private final Set<String> cFileExtensions;
    private final Set<String> cppFileExtensions;
    private final List<Output> outputs;
    private final OsFileConventions fileConventions;
    private List<String> buildTargetsCommand;
    private boolean skipProcessingCompilerFlags;
    @Nullable
    private File compileCommandsJsonBinFile;
    private CompileCommandsEncoder compileCommandsEncoder;
    private final File androidMk;
    private File executionRootPath;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final boolean getSkipProcessingCompilerFlags() {
        return this.skipProcessingCompilerFlags;
    }

    public final void setSkipProcessingCompilerFlags(boolean bl) {
        this.skipProcessingCompilerFlags = bl;
    }

    @Nullable
    public final File getCompileCommandsJsonBinFile() {
        return this.compileCommandsJsonBinFile;
    }

    public final void setCompileCommandsJsonBinFile(@Nullable File file) {
        this.compileCommandsJsonBinFile = file;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NativeBuildConfigValueBuilder setCommands(@NotNull List<String> buildCommand, @NotNull List<String> cleanCommand, @NotNull String variantName, @NotNull String dryRunOutput) {
        Intrinsics.checkParameterIsNotNull(buildCommand, (String)"buildCommand");
        Intrinsics.checkParameterIsNotNull(cleanCommand, (String)"cleanCommand");
        Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
        Intrinsics.checkParameterIsNotNull((Object)dryRunOutput, (String)"dryRunOutput");
        Collection collection = this.outputs;
        boolean bl = false;
        if (!collection.isEmpty()) {
            throw (Throwable)new RuntimeException("setCommands should be called once");
        }
        this.extractWorkingDirectoryFromDryRunOutputIfAvailable(dryRunOutput);
        List<BuildStepInfo> list = CommandClassifier.classify(dryRunOutput, this.fileConventions);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"CommandClassifier.classi\u2026nOutput, fileConventions)");
        List<BuildStepInfo> buildSteps = list;
        ListMultimap<String, List<BuildStepInfo>> listMultimap = FlowAnalyzer.analyze(buildSteps);
        Intrinsics.checkExpressionValueIsNotNull(listMultimap, (String)"FlowAnalyzer.analyze(buildSteps)");
        ListMultimap<String, List<BuildStepInfo>> outputs = listMultimap;
        Iterator iterator = outputs.entries().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)iterator.next();
            boolean bl2 = false;
            String string = (String)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            List value = (List)entry2.getValue();
            void v2 = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"key");
            List list2 = value;
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"value");
            this.outputs.add(new Output((String)v2, list2, buildCommand, cleanCommand, variantName));
        }
        this.buildTargetsCommand = CollectionsKt.plus((Collection)buildCommand, (Iterable)CollectionsKt.listOf((Object)"{LIST_OF_TARGETS_TO_BUILD}"));
        return this;
    }

    private final void extractWorkingDirectoryFromDryRunOutputIfAvailable(String dryRunOutput) {
        if (StringsKt.contains$default((CharSequence)dryRunOutput, (CharSequence)"make: Entering directory", (boolean)false, (int)2, null)) {
            Regex workingDirPattern = new Regex("^make: Entering directory [`'](.*?)'$", RegexOption.MULTILINE);
            MatchResult matchResult = Regex.find$default((Regex)workingDirPattern, (CharSequence)dryRunOutput, (int)0, (int)2, null);
            if (matchResult == null) {
                return;
            }
            MatchResult match = matchResult;
            MatchGroup matchGroup = match.getGroups().get(1);
            if (matchGroup == null) {
                Intrinsics.throwNpe();
            }
            this.executionRootPath = new File(matchGroup.getValue());
        }
    }

    public final void skipProcessingCompilerFlags() {
        this.skipProcessingCompilerFlags = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final NativeBuildConfigValue build() {
        NativeBuildConfigValue nativeBuildConfigValue;
        File compileCommandsJsonBinFile = this.compileCommandsJsonBinFile;
        if (compileCommandsJsonBinFile == null) {
            nativeBuildConfigValue = this.buildImpl();
        } else {
            AutoCloseable autoCloseable = (AutoCloseable)new CompileCommandsEncoder(compileCommandsJsonBinFile, 0, 2, null);
            boolean bl = false;
            Throwable throwable = null;
            try {
                CompileCommandsEncoder encoder = (CompileCommandsEncoder)autoCloseable;
                boolean bl2 = false;
                this.compileCommandsEncoder = encoder;
                NativeBuildConfigValue nativeBuildConfigValue2 = this.buildImpl();
                nativeBuildConfigValue = nativeBuildConfigValue2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        return nativeBuildConfigValue;
    }

    private final NativeBuildConfigValue buildImpl() {
        this.findLibraryNames();
        this.findToolchainNames();
        this.findToolChainCompilers();
        NativeBuildConfigValue config2 = new NativeBuildConfigValue();
        List<Output> $this$sortBy$iv = this.outputs;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            List<Output> list = $this$sortBy$iv;
            boolean bl = false;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Output it = (Output)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it.getLibraryName());
                    it = (Output)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = it.getLibraryName();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            };
            CollectionsKt.sortWith(list, (Comparator)comparator);
        }
        config2.cleanCommandsComponents = this.generateCleanCommands();
        config2.buildTargetsCommandComponents = this.buildTargetsCommand;
        config2.buildFiles = Lists.newArrayList((Object[])new File[]{this.androidMk});
        config2.libraries = this.generateLibraries();
        config2.toolchains = this.generateToolchains();
        config2.cFileExtensions = NativeBuildConfigValueBuilder.Companion.generateExtensions(this.cFileExtensions);
        config2.cppFileExtensions = NativeBuildConfigValueBuilder.Companion.generateExtensions(this.cppFileExtensions);
        return config2;
    }

    private final void findLibraryNames() {
        for (Output output2 : this.outputs) {
            String abi;
            String parentFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)this.fileConventions.getFileParent(output2.getOutputFileName()), (String)"fileConventions.getFileP\u2026nt(output.outputFileName)");
            Intrinsics.checkExpressionValueIsNotNull((Object)this.fileConventions.getFileName(parentFile), (String)"fileConventions.getFileName(parentFile)");
            output2.setArtifactName(NdkUtils.getTargetNameFromBuildOutputFileName((String)this.fileConventions.getFileName(output2.getOutputFileName())));
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%s-%s-%s";
            Object[] objectArray = new Object[]{output2.getArtifactName(), output2.getVariantName(), abi};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            output2.setLibraryName(string2);
        }
    }

    private final void findToolChainCompilers() {
        for (Output output2 : this.outputs) {
            String string;
            String cCompiler;
            String string2;
            String toolchain = output2.getToolchain();
            Set cCompilers = new HashSet();
            Set cppCompilers = new HashSet();
            Map compilerToWeirdExtensions = new HashMap();
            for (BuildStepInfo command : output2.getCommandInputs()) {
                String compilerCommand = command.getCommand().getExecutable();
                String extension = Files.getFileExtension((String)command.getOnlyInput());
                if (NativeSourceFileExtensions.C_FILE_EXTENSIONS.contains(extension)) {
                    String string3 = extension;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"extension");
                    this.cFileExtensions.add(string3);
                    cCompilers.add(compilerCommand);
                    continue;
                }
                if (NativeSourceFileExtensions.CPP_FILE_EXTENSIONS.contains(extension)) {
                    String string4 = extension;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"extension");
                    this.cppFileExtensions.add(string4);
                    cppCompilers.add(compilerCommand);
                    continue;
                }
                Set extensions = (Set)compilerToWeirdExtensions.get(compilerCommand);
                if (extensions == null) {
                    extensions = new HashSet();
                    compilerToWeirdExtensions.put(compilerCommand, extensions);
                }
                String string5 = extension;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"extension");
                extensions.add(string5);
            }
            if (cCompilers.size() > 1) {
                throw (Throwable)new RuntimeException("Too many c compilers in toolchain.");
            }
            if (cppCompilers.size() > 1) {
                throw (Throwable)new RuntimeException("Too many cpp compilers in toolchain.");
            }
            String string6 = (String)CollectionsKt.firstOrNull((Iterable)cCompilers);
            if (string6 != null) {
                String string7 = string6;
                boolean compilerCommand = false;
                boolean bl = false;
                Object it = string7;
                boolean bl2 = false;
                if (toolchain != null) {
                    this.toolChainToCCompiler.put(toolchain, (String)it);
                }
                string2 = string7;
            } else {
                string2 = cCompiler = null;
            }
            if ((String)CollectionsKt.firstOrNull((Iterable)cppCompilers) != null) {
                String compilerCommand;
                boolean bl = false;
                boolean bl3 = false;
                String it = compilerCommand;
                boolean bl4 = false;
                if (toolchain != null) {
                    this.toolChainToCppCompiler.put(toolchain, it);
                }
                string = compilerCommand;
            } else {
                string = null;
            }
            String cppCompiler = string;
            for (String compiler : compilerToWeirdExtensions.keySet()) {
                if (Intrinsics.areEqual((Object)compiler, (Object)cCompiler)) {
                    Object v = compilerToWeirdExtensions.get(compiler);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    this.cFileExtensions.addAll((Collection)v);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)compiler, (Object)cppCompiler)) continue;
                Object v = compilerToWeirdExtensions.get(compiler);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                this.cppFileExtensions.addAll((Collection)v);
            }
        }
    }

    private final String findToolChainName(String outputFileName) {
        return "toolchain-" + this.fileConventions.getFileName(this.fileConventions.getFileParent(outputFileName));
    }

    private final void findToolchainNames() {
        for (Output output2 : this.outputs) {
            output2.setToolchain(this.findToolChainName(output2.getOutputFileName()));
        }
    }

    private final List<List<String>> generateCleanCommands() {
        HashSet hashSet = Sets.newHashSet();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashSet, (String)"Sets.newHashSet()");
        Set cleanCommands = hashSet;
        for (Output output2 : this.outputs) {
            cleanCommands.add(output2.getCleanCommand());
        }
        ArrayList arrayList = Lists.newArrayList((Iterable)cleanCommands);
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"Lists.newArrayList(cleanCommands)");
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, NativeLibraryValue> generateLibraries() {
        Map librariesMap = new HashMap();
        for (Output output2 : this.outputs) {
            NativeLibraryValue value = new NativeLibraryValue();
            librariesMap.put(output2.getLibraryName(), value);
            value.buildCommandComponents = CollectionsKt.plus((Collection)output2.getBuildCommand(), (Iterable)CollectionsKt.listOf((Object)output2.getOutputFileName()));
            value.abi = this.fileConventions.getFileName(this.fileConventions.getFileParent(output2.getOutputFileName()));
            value.artifactName = output2.getArtifactName();
            value.toolchain = output2.getToolchain();
            value.output = this.fileConventions.toFile(output2.getOutputFileName());
            if (this.compileCommandsEncoder != null) {
                CompileCommandsEncoder compileCommandsEncoder;
                boolean bl = false;
                boolean bl2 = false;
                CompileCommandsEncoder encoder = compileCommandsEncoder;
                boolean bl3 = false;
                String workingDirPath = this.executionRootPath.getAbsolutePath();
                for (BuildStepInfo commandInput : output2.getCommandInputs()) {
                    CommandLine command = commandInput.getCommand();
                    File file = this.fileConventions.toFile(commandInput.getOnlyInput());
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"fileConventions.toFile(commandInput.onlyInput)");
                    encoder.writeCompileCommand(file, new File(command.getExecutable()), CompileCommandsCodecKt.stripArgsForIde$default((String)commandInput.getOnlyInput(), command.getEscapedFlags(), null, (int)4, null), new File(workingDirPath));
                }
            }
            if (this.skipProcessingCompilerFlags) continue;
            ArrayList<NativeSourceFileValue> nativeSourceFiles = new ArrayList<NativeSourceFileValue>();
            value.files = nativeSourceFiles;
            for (BuildStepInfo input : output2.getCommandInputs()) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                BuildStepInfo commandInput;
                NativeSourceFileValue file = new NativeSourceFileValue();
                nativeSourceFiles.add(file);
                file.src = this.fileConventions.toFile(input.getOnlyInput());
                if (!this.fileConventions.isPathAbsolute(input.getOnlyInput())) {
                    file.src = this.fileConventions.toFile(this.executionRootPath, input.getOnlyInput());
                }
                int workingDirPath = 0;
                Map rawFlagsLookUpMap = new LinkedHashMap();
                workingDirPath = 0;
                int n = input.getCommand().getRawFlags().size();
                while (workingDirPath < n) {
                    void i2;
                    rawFlagsLookUpMap.put(input.getCommand().getEscapedFlags().get((int)i2), input.getCommand().getRawFlags().get((int)i2));
                    ++i2;
                }
                Iterable i2 = CompileCommandsCodecKt.stripArgsForIde$default((String)input.getOnlyInput(), input.getCommand().getEscapedFlags(), null, (int)4, null);
                NativeSourceFileValue nativeSourceFileValue = file;
                boolean $i$f$map = false;
                commandInput = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    String string2 = (String)rawFlagsLookUpMap.get(it);
                    collection.add(string2);
                }
                collection = (List)destination$iv$iv;
                nativeSourceFileValue.flags = CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            }
        }
        return librariesMap;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, NativeToolchainValue> generateToolchains() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.outputs;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Output output2 = (Output)element$iv$iv;
            boolean bl2 = false;
            if (output2.getToolchain() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set toolchainSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        List toolchains = new ArrayList(toolchainSet);
        CollectionsKt.sort((List)toolchains);
        Map toolchainsMap = new HashMap();
        for (String toolchain : toolchains) {
            NativeToolchainValue toolchainValue = new NativeToolchainValue();
            toolchainsMap.put(toolchain, toolchainValue);
            if (this.toolChainToCCompiler.containsKey(toolchain)) {
                String string = this.toolChainToCCompiler.get(toolchain);
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                toolchainValue.cCompilerExecutable = this.fileConventions.toFile(string);
            }
            if (!this.toolChainToCppCompiler.containsKey(toolchain)) continue;
            String string = this.toolChainToCppCompiler.get(toolchain);
            if (string == null) {
                Intrinsics.throwNpe();
            }
            toolchainValue.cppCompilerExecutable = this.fileConventions.toFile(string);
        }
        return toolchainsMap;
    }

    public NativeBuildConfigValueBuilder(@NotNull File androidMk, @NotNull File executionRootPath, @NotNull OsFileConventions fileConventions) {
        Intrinsics.checkParameterIsNotNull((Object)androidMk, (String)"androidMk");
        Intrinsics.checkParameterIsNotNull((Object)executionRootPath, (String)"executionRootPath");
        Intrinsics.checkParameterIsNotNull((Object)fileConventions, (String)"fileConventions");
        this.androidMk = androidMk;
        this.executionRootPath = executionRootPath;
        this.toolChainToCCompiler = new HashMap();
        this.toolChainToCppCompiler = new HashMap();
        this.cFileExtensions = new HashSet();
        this.cppFileExtensions = new HashSet();
        this.outputs = new ArrayList();
        this.fileConventions = fileConventions;
    }

    public NativeBuildConfigValueBuilder(@NotNull File androidMk, @NotNull File executionRootPath) {
        Intrinsics.checkParameterIsNotNull((Object)androidMk, (String)"androidMk");
        Intrinsics.checkParameterIsNotNull((Object)executionRootPath, (String)"executionRootPath");
        OsFileConventions osFileConventions = AbstractOsFileConventions.createForCurrentHost();
        Intrinsics.checkExpressionValueIsNotNull((Object)osFileConventions, (String)"AbstractOsFileConventions.createForCurrentHost()");
        this(androidMk, executionRootPath, osFileConventions);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0016\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\r\"\u0004\b\u0016\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\r\"\u0004\b\u001a\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/external/gnumake/NativeBuildConfigValueBuilder$Output;", "", "outputFileName", "", "commandInputs", "", "Lcom/android/build/gradle/external/gnumake/BuildStepInfo;", "buildCommand", "cleanCommand", "variantName", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/String;)V", "artifactName", "getArtifactName", "()Ljava/lang/String;", "setArtifactName", "(Ljava/lang/String;)V", "getBuildCommand", "()Ljava/util/List;", "getCleanCommand", "getCommandInputs", "libraryName", "getLibraryName", "setLibraryName", "getOutputFileName", "toolchain", "getToolchain", "setToolchain", "getVariantName", "gradle-core"})
    private static final class Output {
        @Nullable
        private String artifactName;
        @Nullable
        private String libraryName;
        @Nullable
        private String toolchain;
        @NotNull
        private final String outputFileName;
        @NotNull
        private final List<BuildStepInfo> commandInputs;
        @NotNull
        private final List<String> buildCommand;
        @NotNull
        private final List<String> cleanCommand;
        @NotNull
        private final String variantName;

        @Nullable
        public final String getArtifactName() {
            return this.artifactName;
        }

        public final void setArtifactName(@Nullable String string) {
            this.artifactName = string;
        }

        @Nullable
        public final String getLibraryName() {
            return this.libraryName;
        }

        public final void setLibraryName(@Nullable String string) {
            this.libraryName = string;
        }

        @Nullable
        public final String getToolchain() {
            return this.toolchain;
        }

        public final void setToolchain(@Nullable String string) {
            this.toolchain = string;
        }

        @NotNull
        public final String getOutputFileName() {
            return this.outputFileName;
        }

        @NotNull
        public final List<BuildStepInfo> getCommandInputs() {
            return this.commandInputs;
        }

        @NotNull
        public final List<String> getBuildCommand() {
            return this.buildCommand;
        }

        @NotNull
        public final List<String> getCleanCommand() {
            return this.cleanCommand;
        }

        @NotNull
        public final String getVariantName() {
            return this.variantName;
        }

        public Output(@NotNull String outputFileName, @NotNull List<BuildStepInfo> commandInputs, @NotNull List<String> buildCommand, @NotNull List<String> cleanCommand, @NotNull String variantName) {
            Intrinsics.checkParameterIsNotNull((Object)outputFileName, (String)"outputFileName");
            Intrinsics.checkParameterIsNotNull(commandInputs, (String)"commandInputs");
            Intrinsics.checkParameterIsNotNull(buildCommand, (String)"buildCommand");
            Intrinsics.checkParameterIsNotNull(cleanCommand, (String)"cleanCommand");
            Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
            this.outputFileName = outputFileName;
            this.commandInputs = commandInputs;
            this.buildCommand = buildCommand;
            this.cleanCommand = cleanCommand;
            this.variantName = variantName;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/external/gnumake/NativeBuildConfigValueBuilder$Companion;", "", "()V", "generateExtensions", "", "", "extensionSet", "", "gradle-core"})
    public static final class Companion {
        private final Collection<String> generateExtensions(Set<String> extensionSet) {
            ArrayList arrayList = Lists.newArrayList((Iterable)extensionSet);
            Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"Lists.newArrayList(extensionSet)");
            List extensionList = arrayList;
            CollectionsKt.sort((List)extensionList);
            return extensionList;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

