/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.tasks.DexMergingTask;
import com.android.build.gradle.internal.tasks.DexMergingTaskDelegate;
import com.android.build.gradle.internal.tasks.DexMergingWorkAction;
import com.android.builder.dexing.DexEntry;
import com.android.builder.dexing.DexEntryBucket;
import com.android.builder.dexing.DexUtilsKt;
import com.android.builder.files.SerializableChange;
import com.android.builder.files.SerializableFileChanges;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@VisibleForTesting
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/tasks/DexMergingTaskDelegate;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/DexMergingTaskDelegate$Params;", "()V", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "getWorkerExecutor", "()Lorg/gradle/workers/WorkerExecutor;", "run", "", "Companion", "Params", "gradle-core"})
public abstract class DexMergingTaskDelegate
extends ProfileAwareWorkAction<Params> {
    private static final Function1<String, Boolean> isDexFile;
    @NotNull
    public static final Companion Companion;

    @Inject
    @NotNull
    public abstract WorkerExecutor getWorkerExecutor();

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        WorkParameters workParameters = this.getParameters();
        boolean bl = false;
        boolean bl2 = false;
        Params $this$with = (Params)workParameters;
        boolean bl3 = false;
        Object object = $this$with.getDexDirsOrJars().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"dexDirsOrJars.get()");
        List list = (List)object;
        Object object2 = $this$with.getNumberOfBuckets().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"numberOfBuckets.get()");
        int n = ((Number)object2).intValue();
        Object object3 = $this$with.getIncremental().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"incremental.get()");
        Map buckets = DexMergingTaskDelegate.Companion.getBucketsToMerge(list, n, (Boolean)object3, (SerializableFileChanges)$this$with.getFileChanges().getOrNull());
        WorkQueue workQueue = this.getWorkerExecutor().noIsolation();
        Map map2 = buckets;
        boolean bl4 = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            File file;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl5 = false;
            int n2 = ((Number)entry2.getKey()).intValue();
            entry2 = entry;
            bl5 = false;
            DexEntryBucket bucket = (DexEntryBucket)entry2.getValue();
            Integer n3 = (Integer)$this$with.getNumberOfBuckets().get();
            if (n3 != null && n3 == 1) {
                Object object4 = $this$with.getOutputDir().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"outputDir.get()");
                file = ((Directory)object4).getAsFile();
            } else {
                void bucketNumber;
                Object object5 = $this$with.getOutputDir().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"outputDir.get()");
                File file2 = ((Directory)object5).getAsFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"outputDir.get().asFile");
                file = FilesKt.resolve((File)file2, (String)String.valueOf((int)bucketNumber));
            }
            File outputDirForBucket = file;
            FileUtils.cleanOutputDir((File)outputDirForBucket);
            workQueue.submit(DexMergingWorkAction.class, (Action)new Action<DexMergingWorkAction.Params>($this$with, bucket, outputDirForBucket){
                final /* synthetic */ Params $this_with;
                final /* synthetic */ DexEntryBucket $bucket;
                final /* synthetic */ File $outputDirForBucket;

                public final void execute(DexMergingWorkAction.Params it) {
                    Params params = this.$this_with;
                    Intrinsics.checkExpressionValueIsNotNull((Object)params, (String)"this");
                    it.initializeFromProfileAwareWorkAction(params);
                    Property<DexMergingTask.SharedParams> property = this.$this_with.getSharedParams();
                    Integer n = (Integer)this.$this_with.getNumberOfBuckets().get();
                    boolean bl = n != null && n == 1;
                    Object object = this.$this_with.getDexDirsOrJars().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"dexDirsOrJars.get()");
                    List list = (List)object;
                    File file = this.$outputDirForBucket;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputDirForBucket");
                    it.initialize(property, bl, this.$bucket, list, file);
                }
                {
                    this.$this_with = params;
                    this.$bucket = dexEntryBucket;
                    this.$outputDirForBucket = file;
                }
            });
        }
    }

    static {
        Companion = new Companion(null);
        isDexFile = Companion.isDexFile.1.INSTANCE;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JD\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\t2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\b\u001a\u0004\u0018\u00010\nR\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u0012\u0010\u0013\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\f\u00a8\u0006\u001d"}, d2={"Lcom/android/build/gradle/internal/tasks/DexMergingTaskDelegate$Params;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "dexDirsOrJars", "Lorg/gradle/api/provider/ListProperty;", "Ljava/io/File;", "getDexDirsOrJars", "()Lorg/gradle/api/provider/ListProperty;", "fileChanges", "Lorg/gradle/api/provider/Property;", "Lcom/android/builder/files/SerializableFileChanges;", "getFileChanges", "()Lorg/gradle/api/provider/Property;", "incremental", "", "getIncremental", "numberOfBuckets", "", "getNumberOfBuckets", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "sharedParams", "Lcom/android/build/gradle/internal/tasks/DexMergingTask$SharedParams;", "getSharedParams", "initialize", "", "", "gradle-core"})
    public static abstract class Params
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract Property<DexMergingTask.SharedParams> getSharedParams();

        @NotNull
        public abstract Property<Integer> getNumberOfBuckets();

        @NotNull
        public abstract ListProperty<File> getDexDirsOrJars();

        @NotNull
        public abstract DirectoryProperty getOutputDir();

        @NotNull
        public abstract Property<Boolean> getIncremental();

        @NotNull
        public abstract Property<SerializableFileChanges> getFileChanges();

        public final void initialize(@NotNull DexMergingTask.SharedParams sharedParams, @NotNull Property<Integer> numberOfBuckets, @NotNull List<? extends File> dexDirsOrJars, @NotNull DirectoryProperty outputDir, boolean incremental, @Nullable SerializableFileChanges fileChanges) {
            Intrinsics.checkParameterIsNotNull((Object)sharedParams, (String)"sharedParams");
            Intrinsics.checkParameterIsNotNull(numberOfBuckets, (String)"numberOfBuckets");
            Intrinsics.checkParameterIsNotNull(dexDirsOrJars, (String)"dexDirsOrJars");
            Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
            this.getSharedParams().set((Object)sharedParams);
            this.getNumberOfBuckets().set((Provider)numberOfBuckets);
            this.getDexDirsOrJars().set((Iterable)dexDirsOrJars);
            this.getOutputDir().set((Provider)outputDir);
            this.getIncremental().set((Object)incremental);
            this.getFileChanges().set((Object)fileChanges);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000bH\u0007J<\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u000bH\u0002R)\u0010\u0003\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/tasks/DexMergingTaskDelegate$Companion;", "", "()V", "isDexFile", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "relativePath", "", "getBucketNumber", "", "numberOfBuckets", "getBucketsToMerge", "", "Lcom/android/builder/dexing/DexEntryBucket;", "dexDirsOrJars", "", "Ljava/io/File;", "incremental", "fileChanges", "Lcom/android/builder/files/SerializableFileChanges;", "getImpactedBuckets", "", "gradle-core"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final Map<Integer, DexEntryBucket> getBucketsToMerge(List<? extends File> dexDirsOrJars, int numberOfBuckets, boolean incremental, SerializableFileChanges fileChanges) {
            void $this$mapTo$iv$iv;
            Object object;
            Collection collection;
            Iterable iterable;
            Set<Integer> set;
            if (incremental) {
                SerializableFileChanges serializableFileChanges = fileChanges;
                if (serializableFileChanges == null) {
                    Intrinsics.throwNpe();
                }
                set = this.getImpactedBuckets(serializableFileChanges, numberOfBuckets);
            } else {
                set = CollectionsKt.toSet((Iterable)((Iterable)RangesKt.until((int)0, (int)numberOfBuckets)));
            }
            Set<Integer> bucketsToMerge = set;
            boolean bl = false;
            Map bucketMap = new LinkedHashMap();
            Iterator<Comparable<Integer>> iterator = bucketsToMerge.iterator();
            while (iterator.hasNext()) {
                int n = ((Number)iterator.next()).intValue();
                boolean bl2 = false;
                bucketMap.put(n, (List)new ArrayList());
            }
            for (File file : dexDirsOrJars) {
                List list;
                if (file.isDirectory()) {
                    void $this$mapTo$iv$iv2;
                    Path path = file.toPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"dexDirOrJar.toPath()");
                    Iterable $this$map$iv = DexUtilsKt.getSortedFilesInDir((Path)path, (Function1)isDexFile);
                    boolean $i$f$map = false;
                    iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Map.Entry item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void it;
                        Path path2 = (Path)((Object)item$iv$iv2);
                        collection = destination$iv$iv;
                        boolean bl3 = false;
                        object = ((Object)file.toPath().relativize((Path)it)).toString();
                        collection.add(object);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = DexUtilsKt.getSortedRelativePathsInJar((File)file, (Function1)isDexFile);
                }
                List dexEntryRelativePaths = list;
                for (String relativePath : dexEntryRelativePaths) {
                    int bucketNumber = this.getBucketNumber(relativePath, numberOfBuckets);
                    if (!bucketsToMerge.contains(bucketNumber)) continue;
                    Object v = bucketMap.get(bucketNumber);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    ((List)v).add(new DexEntry(file, relativePath));
                }
            }
            Map map2 = bucketMap;
            boolean $i$f$map = false;
            Map dexEntryRelativePaths = map2;
            Collection destination$iv$iv = new ArrayList(map2.size());
            boolean $i$f$mapTo = false;
            iterable = $this$mapTo$iv$iv;
            boolean bl3 = false;
            Iterator iterator2 = iterable.entrySet().iterator();
            while (iterator2.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry item$iv$iv2;
                item$iv$iv2 = item$iv$iv = iterator2.next();
                collection = destination$iv$iv;
                boolean bl5 = false;
                object = TuplesKt.to(it.getKey(), (Object)new DexEntryBucket((List)it.getValue()));
                collection.add(object);
            }
            return MapsKt.toMap((Iterable)((List)destination$iv$iv));
        }

        /*
         * WARNING - void declaration
         */
        private final Set<Integer> getImpactedBuckets(SerializableFileChanges fileChanges, int numberOfBuckets) {
            Iterable $this$filterTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            void $this$flatMapTo$iv$iv;
            void $this$filterTo$iv$iv2;
            Object object;
            File it;
            Collection collection;
            Iterable $this$mapTo$iv$iv2;
            boolean hasModifiedRemovedJars;
            Object v0;
            block8: {
                Iterable iterable = CollectionsKt.plus((Collection)fileChanges.getModifiedFiles(), (Iterable)fileChanges.getRemovedFiles());
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    SerializableChange it2 = (SerializableChange)t;
                    boolean bl3 = false;
                    if (!((Boolean)DexUtilsKt.isJarFile().invoke((Object)it2.getFile())).booleanValue()) continue;
                    v0 = t;
                    break block8;
                }
                v0 = null;
            }
            boolean bl = hasModifiedRemovedJars = v0 != null;
            if (hasModifiedRemovedJars) {
                return CollectionsKt.toSet((Iterable)((Iterable)RangesKt.until((int)0, (int)numberOfBuckets)));
            }
            Iterable $this$map$iv = fileChanges.getAddedFiles();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                SerializableChange serializableChange = (SerializableChange)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                object = it.getFile();
                collection.add(object);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (File)element$iv$iv;
                boolean bl5 = false;
                if (!((Boolean)DexUtilsKt.isJarFile().invoke((Object)it)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List addedJars = (List)destination$iv$iv;
            Iterable $this$flatMap$iv = addedJars;
            boolean $i$f$flatMap = false;
            destination$iv$iv = $this$flatMap$iv;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                File it3 = (File)element$iv$iv;
                boolean bl6 = false;
                Iterable list$iv$iv = DexUtilsKt.getSortedRelativePathsInJar((File)it3, (Function1)isDexFile);
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List relativePathsOfDexFilesInAddedJars = (List)destination$iv$iv2;
            Iterable $this$map$iv2 = fileChanges.getFileChanges();
            boolean $i$f$map2 = false;
            destination$iv$iv2 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it4;
                SerializableChange bl6 = (SerializableChange)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl7 = false;
                object = it4.getNormalizedPath();
                collection.add(object);
            }
            Iterable $this$filter$iv2 = (List)destination$iv$iv3;
            boolean $i$f$filter2 = false;
            $this$mapTo$iv$iv = $this$filter$iv2;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it5 = (String)element$iv$iv;
                boolean bl8 = false;
                if (!((Boolean)isDexFile.invoke((Object)it5)).booleanValue()) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List relativePathsOfChangedDexFilesInDirs = (List)destination$iv$iv3;
            $this$map$iv2 = CollectionsKt.plus((Collection)relativePathsOfDexFilesInAddedJars, (Iterable)relativePathsOfChangedDexFilesInDirs);
            $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv2;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String it5 = (String)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl9 = false;
                object = Companion.getBucketNumber(it5, numberOfBuckets);
                collection.add(object);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
        }

        @VisibleForTesting
        public final int getBucketNumber(@NotNull String relativePath, int numberOfBuckets) {
            int n;
            Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
            boolean bl = !new File(relativePath).isAbsolute();
            boolean bl2 = false;
            int n2 = 0;
            if (!bl) {
                boolean bl3 = false;
                String string = "Expected relative path but found absolute path: " + relativePath;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            bl = StringsKt.endsWith((String)relativePath, (String)".dex", (boolean)true);
            bl2 = false;
            n2 = 0;
            if (!bl) {
                boolean bl4 = false;
                String string = "Expected .dex file but found: " + relativePath;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            String packagePath = new File(relativePath).getParent();
            CharSequence charSequence = packagePath;
            n2 = 0;
            boolean bl5 = false;
            if (charSequence == null || charSequence.length() == 0) {
                n = 0;
            } else {
                switch (numberOfBuckets) {
                    case 1: {
                        n = 0;
                        break;
                    }
                    default: {
                        String normalizedPackagePath = FilesKt.getInvariantSeparatorsPath((File)new File(packagePath));
                        n2 = normalizedPackagePath.hashCode();
                        bl5 = false;
                        return Math.abs(n2) % (numberOfBuckets - 1) + 1;
                    }
                }
            }
            return n;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

