/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.api.dsl.ManagedVirtualDevice;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.builder.core.ApiLevelUtilsKt;
import com.android.builder.core.DefaultApiVersion;
import com.android.builder.model.ApiVersion;
import com.android.utils.ILogger;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u001f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u00020\u00038WX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0005R+\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8W@VX\u0096\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015*\u0004\b\u0010\u0010\u0011R/\u0010\u0016\u001a\u0004\u0018\u00010\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u00038W@VX\u0096\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\u0018\u0010\u000b\"\u0004\b\u0019\u0010\u0005*\u0004\b\u0017\u0010\u0011R$\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e8W@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u0013\"\u0004\b\u001d\u0010\u0015R\u001c\u0010\u001e\u001a\u00020\u000e8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0013\"\u0004\b \u0010\u0015R(\u0010!\u001a\u0004\u0018\u00010\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u00038W@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010\u000b\"\u0004\b#\u0010\u0005R \u0010$\u001a\u0004\u0018\u00010\u000e8WX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010)\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001c\u0010*\u001a\u00020\u00038WX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u000b\"\u0004\b,\u0010\u0005R\u001c\u0010-\u001a\u00020.8WX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001c\u00103\u001a\u0002048WX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u0011\u00109\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u000bR\u0010\u0010;\u001a\u0004\u0018\u00010<X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/android/build/gradle/internal/dsl/ManagedVirtualDevice;", "Lcom/android/build/api/dsl/ManagedVirtualDevice;", "name", "", "<init>", "(Ljava/lang/String;)V", "logger", "Lcom/android/utils/ILogger;", "getName", "device", "getDevice", "()Ljava/lang/String;", "setDevice", "<set-?>", "", "apiLevel", "getApiLevel$delegate", "(Lcom/android/build/gradle/internal/dsl/ManagedVirtualDevice;)Ljava/lang/Object;", "getApiLevel", "()I", "setApiLevel", "(I)V", "apiPreview", "getApiPreview$delegate", "getApiPreview", "setApiPreview", "value", "sdkVersion", "getSdkVersion", "setSdkVersion", "sdkMinorVersion", "getSdkMinorVersion", "setSdkMinorVersion", "sdkPreview", "getSdkPreview", "setSdkPreview", "sdkExtensionVersion", "getSdkExtensionVersion", "()Ljava/lang/Integer;", "setSdkExtensionVersion", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "systemImageSource", "getSystemImageSource", "setSystemImageSource", "require64Bit", "", "getRequire64Bit", "()Z", "setRequire64Bit", "(Z)V", "pageAlignment", "Lcom/android/build/api/dsl/ManagedVirtualDevice$PageAlignment;", "getPageAlignment", "()Lcom/android/build/api/dsl/ManagedVirtualDevice$PageAlignment;", "setPageAlignment", "(Lcom/android/build/api/dsl/ManagedVirtualDevice$PageAlignment;)V", "pageAlignmentSuffix", "getPageAlignmentSuffix", "apiVersion", "Lcom/android/builder/model/ApiVersion;", "gradle-core"})
public class ManagedVirtualDevice
implements com.android.build.api.dsl.ManagedVirtualDevice {
    @NotNull
    private final String name;
    @NotNull
    private final ILogger logger;
    @NotNull
    private String device;
    private int sdkMinorVersion;
    @Nullable
    private Integer sdkExtensionVersion;
    @NotNull
    private String systemImageSource;
    private boolean require64Bit;
    @NotNull
    private ManagedVirtualDevice.PageAlignment pageAlignment;
    @Nullable
    private ApiVersion apiVersion;

    @Inject
    public ManagedVirtualDevice(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(com.android.build.api.dsl.ManagedVirtualDevice.class);
        Intrinsics.checkNotNullExpressionValue((Object)loggerWrapper, (String)"getLogger(...)");
        this.logger = loggerWrapper;
        this.device = "";
        this.systemImageSource = "google";
        this.pageAlignment = ManagedVirtualDevice.PageAlignment.DEFAULT_FOR_SDK_VERSION;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Input
    @NotNull
    public String getDevice() {
        return this.device;
    }

    public void setDevice(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.device = string;
    }

    @Internal
    public int getApiLevel() {
        return this.getSdkVersion();
    }

    public void setApiLevel(int n) {
        this.setSdkVersion(n);
    }

    private static Object getApiLevel$delegate(ManagedVirtualDevice managedVirtualDevice) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)managedVirtualDevice, ManagedVirtualDevice.class, "sdkVersion", "getSdkVersion()I", 0)));
    }

    @Internal
    @Nullable
    public String getApiPreview() {
        return this.getSdkPreview();
    }

    public void setApiPreview(@Nullable String string) {
        this.setSdkPreview(string);
    }

    private static Object getApiPreview$delegate(ManagedVirtualDevice managedVirtualDevice) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)managedVirtualDevice, ManagedVirtualDevice.class, "sdkPreview", "getSdkPreview()Ljava/lang/String;", 0)));
    }

    @Input
    public int getSdkVersion() {
        ApiVersion apiVersion = this.apiVersion;
        return apiVersion != null ? apiVersion.getApiLevel() : 0;
    }

    public void setSdkVersion(int value) {
        this.apiVersion = (ApiVersion)new DefaultApiVersion(value);
    }

    @Input
    public final int getSdkMinorVersion() {
        return this.sdkMinorVersion;
    }

    public final void setSdkMinorVersion(int n) {
        this.sdkMinorVersion = n;
    }

    @Internal
    @Nullable
    public String getSdkPreview() {
        ApiVersion apiVersion = this.apiVersion;
        return apiVersion != null ? apiVersion.getCodename() : null;
    }

    public void setSdkPreview(@Nullable String value) {
        this.apiVersion = (ApiVersion)ApiLevelUtilsKt.apiVersionFromString((String)value);
    }

    @Optional
    @Input
    @Nullable
    public Integer getSdkExtensionVersion() {
        return this.sdkExtensionVersion;
    }

    public void setSdkExtensionVersion(@Nullable Integer n) {
        this.sdkExtensionVersion = n;
    }

    @Input
    @NotNull
    public String getSystemImageSource() {
        return this.systemImageSource;
    }

    public void setSystemImageSource(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.systemImageSource = string;
    }

    @Input
    public boolean getRequire64Bit() {
        return this.require64Bit;
    }

    public void setRequire64Bit(boolean bl) {
        this.require64Bit = bl;
    }

    @Internal
    @NotNull
    public ManagedVirtualDevice.PageAlignment getPageAlignment() {
        return this.pageAlignment;
    }

    public void setPageAlignment(@NotNull ManagedVirtualDevice.PageAlignment pageAlignment) {
        Intrinsics.checkNotNullParameter((Object)pageAlignment, (String)"<set-?>");
        this.pageAlignment = pageAlignment;
    }

    @Input
    @NotNull
    public final String getPageAlignmentSuffix() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getPageAlignment().ordinal()]) {
            case 1: {
                string = "_ps16k";
                break;
            }
            case 2: {
                string = "";
                break;
            }
            default: {
                if (this.getSdkVersion() > 36 && this.getPageAlignment() == ManagedVirtualDevice.PageAlignment.DEFAULT_FOR_SDK_VERSION) {
                    this.logger.warning(StringsKt.trimIndent((String)("\n                            " + this.name + " has a pageAlignment value of\n                            DEFAULT_FOR_SDK_VERSION. However for sdkVersion = " + this.getSdkVersion() + ",\n                            the page size of the validated system image cannot be determined. A 4 kb\n                            aligned image will be selected. If this is not intended set\n                            pageAlignment = " + ManagedVirtualDevice.PageAlignment.FORCE_16KB_PAGES + " for\n                            " + this.name + "\n                         ")), new Object[0]);
                }
                string = "";
            }
        }
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ManagedVirtualDevice.PageAlignment.values().length];
            try {
                nArray[ManagedVirtualDevice.PageAlignment.FORCE_16KB_PAGES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ManagedVirtualDevice.PageAlignment.FORCE_4KB_PAGES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

