/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.gradle.internal.lint.EnvironmentVariableInputs;
import com.android.build.gradle.internal.lint.LintMode;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Transformer;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0014\u0010\u000f\u001a\u00020\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\bR\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\bR\u0014\u0010\u0017\u001a\u00020\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/android/build/gradle/internal/lint/EnvironmentVariableInputs;", "", "<init>", "()V", "androidLintIncludeLdpi", "Lorg/gradle/api/provider/Property;", "", "getAndroidLintIncludeLdpi", "()Lorg/gradle/api/provider/Property;", "androidLintMaxDepth", "getAndroidLintMaxDepth", "androidLintMaxViewCount", "getAndroidLintMaxViewCount", "androidLintNullnessIgnoreDeprecated", "getAndroidLintNullnessIgnoreDeprecated", "lintApiDatabase", "Lorg/gradle/api/file/RegularFileProperty;", "getLintApiDatabase", "()Lorg/gradle/api/file/RegularFileProperty;", "lintHtmlPrefs", "getLintHtmlPrefs", "lintXmlRoot", "getLintXmlRoot", "lintOverrideConfiguration", "getLintOverrideConfiguration", "initialize", "", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "lintMode", "Lcom/android/build/gradle/internal/lint/LintMode;", "gradle-core"})
public abstract class EnvironmentVariableInputs {
    @Input
    @Optional
    @NotNull
    public abstract Property<String> getAndroidLintIncludeLdpi();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getAndroidLintMaxDepth();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getAndroidLintMaxViewCount();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getAndroidLintNullnessIgnoreDeprecated();

    @InputFile
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @Optional
    @NotNull
    public abstract RegularFileProperty getLintApiDatabase();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getLintHtmlPrefs();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getLintXmlRoot();

    @InputFile
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @Optional
    @NotNull
    public abstract RegularFileProperty getLintOverrideConfiguration();

    public final void initialize(@NotNull ProviderFactory providerFactory, @NotNull LintMode lintMode) {
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkNotNullParameter((Object)((Object)lintMode), (String)"lintMode");
        if (lintMode == LintMode.ANALYSIS) {
            this.getLintHtmlPrefs().disallowChanges();
            this.getLintXmlRoot().disallowChanges();
        } else {
            Property<String> property = this.getLintHtmlPrefs();
            Provider provider2 = providerFactory.environmentVariable("LINT_HTML_PREFS");
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"environmentVariable(...)");
            HasConfigurableValuesKt.setDisallowChanges(property, provider2);
            Property<String> property2 = this.getLintXmlRoot();
            Provider provider3 = providerFactory.environmentVariable("LINT_XML_ROOT");
            Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"environmentVariable(...)");
            HasConfigurableValuesKt.setDisallowChanges(property2, provider3);
        }
        Property<String> property = this.getAndroidLintIncludeLdpi();
        Provider provider4 = providerFactory.environmentVariable("ANDROID_LINT_INCLUDE_LDPI");
        Intrinsics.checkNotNullExpressionValue((Object)provider4, (String)"environmentVariable(...)");
        HasConfigurableValuesKt.setDisallowChanges(property, provider4);
        Property<String> property3 = this.getAndroidLintMaxDepth();
        Provider provider5 = providerFactory.environmentVariable("ANDROID_LINT_MAX_DEPTH");
        Intrinsics.checkNotNullExpressionValue((Object)provider5, (String)"environmentVariable(...)");
        HasConfigurableValuesKt.setDisallowChanges(property3, provider5);
        Property<String> property4 = this.getAndroidLintMaxViewCount();
        Provider provider6 = providerFactory.environmentVariable("ANDROID_LINT_MAX_VIEW_COUNT");
        Intrinsics.checkNotNullExpressionValue((Object)provider6, (String)"environmentVariable(...)");
        HasConfigurableValuesKt.setDisallowChanges(property4, provider6);
        Property<String> property5 = this.getAndroidLintNullnessIgnoreDeprecated();
        Provider provider7 = providerFactory.environmentVariable("ANDROID_LINT_NULLNESS_IGNORE_DEPRECATED");
        Intrinsics.checkNotNullExpressionValue((Object)provider7, (String)"environmentVariable(...)");
        HasConfigurableValuesKt.setDisallowChanges(property5, provider7);
        Function1 function1 = initialize.1.INSTANCE;
        Transformer transformer = new Transformer(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object transform(Object in) {
                return this.function.invoke(in);
            }
        };
        function1 = initialize.2.INSTANCE;
        this.getLintApiDatabase().fileProvider(providerFactory.environmentVariable("LINT_API_DATABASE").map(transformer).filter(new Spec(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ boolean isSatisfiedBy(Object p0) {
                return (Boolean)this.function.invoke(p0);
            }
        }));
        this.getLintApiDatabase().disallowChanges();
        function1 = initialize.3.INSTANCE;
        Transformer transformer2 = new /* invalid duplicate definition of identical inner class */;
        function1 = initialize.4.INSTANCE;
        this.getLintOverrideConfiguration().fileProvider(providerFactory.environmentVariable("LINT_OVERRIDE_CONFIGURATION").map(transformer2).filter(new /* invalid duplicate definition of identical inner class */));
        this.getLintOverrideConfiguration().disallowChanges();
    }
}

