/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.DeviceTargetingConfigParser;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.ParseDeviceTargetingConfigTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.bundle.DeviceGroupConfig;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

@CacheableTask
@BuildAnalyzer(primaryTaskCategory=TaskCategory.METADATA)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u0003\f\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/tasks/ParseDeviceTargetingConfigTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "<init>", "()V", "deviceTargetingConfigXml", "Lorg/gradle/api/file/RegularFileProperty;", "getDeviceTargetingConfigXml", "()Lorg/gradle/api/file/RegularFileProperty;", "deviceTargetingConfigProto", "getDeviceTargetingConfigProto", "doTaskAction", "", "Params", "ParseDeviceTargetingConfigRunnable", "CreationAction", "gradle-core"})
public abstract class ParseDeviceTargetingConfigTask
extends NonIncrementalTask {
    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getDeviceTargetingConfigXml();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getDeviceTargetingConfigProto();

    @Override
    public void doTaskAction() {
        Function1 function1 = (Function1)new Function1<Params, Unit>(this){
            final /* synthetic */ ParseDeviceTargetingConfigTask this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Params it) {
                it.initializeFromBaseTask(this.this$0);
                it.getDeviceTargetingConfigXml().set((Provider)this.this$0.getDeviceTargetingConfigXml());
                it.getDeviceTargetingConfigProto().set((Provider)this.this$0.getDeviceTargetingConfigProto());
            }
        };
        this.getWorkerExecutor().noIsolation().submit(ParseDeviceTargetingConfigRunnable.class, new Action(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object p0) {
                this.function.invoke(p0);
            }
        });
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/ParseDeviceTargetingConfigTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ParseDeviceTargetingConfigTask;", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "creationConfig", "<init>", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "configure", "task", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ParseDeviceTargetingConfigTask, VariantCreationConfig> {
        public CreationAction(@NotNull VariantCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig, false, 2, null);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("parse", "DeviceTargetingConfig");
        }

        @Override
        @NotNull
        public Class<ParseDeviceTargetingConfigTask> getType() {
            return ParseDeviceTargetingConfigTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ParseDeviceTargetingConfigTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("DeviceTargetingConfig.pb").on(InternalArtifactType.DEVICE_TARGETING_CONFIG.INSTANCE);
        }

        @Override
        public void configure(@NotNull ParseDeviceTargetingConfigTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            HasConfigurableValuesKt.setDisallowChanges((Property)task.getDeviceTargetingConfigXml(), (Provider)((VariantCreationConfig)this.creationConfig).getGlobal().getBundleOptions().getDeviceTargetingConfig());
        }
    }

    @VisibleForTesting
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/tasks/ParseDeviceTargetingConfigTask$Params;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "<init>", "()V", "deviceTargetingConfigXml", "Lorg/gradle/api/file/RegularFileProperty;", "getDeviceTargetingConfigXml", "()Lorg/gradle/api/file/RegularFileProperty;", "deviceTargetingConfigProto", "getDeviceTargetingConfigProto", "gradle-core"})
    public static abstract class Params
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract RegularFileProperty getDeviceTargetingConfigXml();

        @NotNull
        public abstract RegularFileProperty getDeviceTargetingConfigProto();
    }

    @VisibleForTesting
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/tasks/ParseDeviceTargetingConfigTask$ParseDeviceTargetingConfigRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/ParseDeviceTargetingConfigTask$Params;", "<init>", "()V", "run", "", "loadXML", "Lorg/w3c/dom/Document;", "xmlFile", "Ljava/io/File;", "storeProto", "configProto", "Lcom/android/bundle/DeviceGroupConfig;", "output", "gradle-core"})
    public static abstract class ParseDeviceTargetingConfigRunnable
    extends ProfileAwareWorkAction<Params> {
        @Override
        public void run() {
            File file = (File)((Params)this.getParameters()).getDeviceTargetingConfigXml().getAsFile().getOrNull();
            if (file != null) {
                File it = file;
                boolean bl = false;
                Document doc = this.loadXML(it);
                DeviceGroupConfig configProto = new DeviceTargetingConfigParser(doc).parseConfig();
                Object object = ((Params)this.getParameters()).getDeviceTargetingConfigProto().getAsFile().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                this.storeProto(configProto, (File)object);
            } else {
                ParseDeviceTargetingConfigRunnable $this$run_u24lambda_u241 = this;
                boolean bl = false;
                Files.deleteIfExists(((File)((Params)$this$run_u24lambda_u241.getParameters()).getDeviceTargetingConfigProto().getAsFile().get()).toPath());
            }
        }

        private final Document loadXML(File xmlFile) {
            DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
            documentFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(xmlFile);
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
            return document;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void storeProto(DeviceGroupConfig configProto, File output2) {
            Closeable closeable = Files.newOutputStream(output2.toPath(), new OpenOption[0]);
            Throwable throwable = null;
            try {
                OutputStream outputStream = (OutputStream)closeable;
                boolean bl = false;
                configProto.writeTo(outputStream);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }
}

