/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.api.variant.impl.AndroidVersionImpl;
import com.android.build.gradle.internal.utils.CompileData;
import com.android.builder.core.DefaultApiVersion;
import com.android.sdklib.AndroidVersion;
import com.google.common.base.Splitter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u001a\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u0003\u001a#\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0000\u00a2\u0006\u0002\u0010\f\"\u0018\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\"\u0018\u0010\u0011\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\"\u0018\u0010\u0012\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006\u0013"}, d2={"parseTargetHash", "Lcom/android/build/gradle/internal/utils/CompileData;", "targetHash", "", "validateNamespaceValue", "value", "validatePreviewTargetValue", "createTargetSdkVersion", "Lcom/android/build/api/variant/impl/AndroidVersionImpl;", "targetSdk", "", "targetSdkPreview", "(Ljava/lang/Integer;Ljava/lang/String;)Lcom/android/build/api/variant/impl/AndroidVersionImpl;", "API_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "FULL_PREVIEW_PATTERN", "ADDON_PATTERN", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nSdkUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkUtils.kt\ncom/android/build/gradle/internal/utils/SdkUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1#2:126\n*E\n"})
public final class SdkUtilsKt {
    private static final Pattern API_PATTERN = Pattern.compile("android-(\\d+)(?:\\.(\\d+))?(-ext(\\d+))?");
    private static final Pattern FULL_PREVIEW_PATTERN = Pattern.compile("android-([A-Z]\\w*)");
    private static final Pattern ADDON_PATTERN = Pattern.compile("([^:]+):([^:]+):(\\d+)");

    @NotNull
    public static final CompileData parseTargetHash(@NotNull String targetHash) {
        Intrinsics.checkNotNullParameter((Object)targetHash, (String)"targetHash");
        Matcher apiMatcher = API_PATTERN.matcher(targetHash);
        if (apiMatcher.matches()) {
            String string = apiMatcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            int n = Integer.parseInt(string);
            String string2 = apiMatcher.group(2);
            Integer n2 = string2 != null ? StringsKt.toIntOrNull((String)string2) : null;
            String string3 = apiMatcher.group(4);
            Integer n3 = string3 != null ? StringsKt.toIntOrNull((String)string3) : null;
            return new CompileData(n, null, n3, null, null, n2, 26, null);
        }
        Matcher previewMatcher = FULL_PREVIEW_PATTERN.matcher(targetHash);
        if (previewMatcher.matches()) {
            return new CompileData(null, previewMatcher.group(1), null, null, null, null, 61, null);
        }
        Matcher addonMatcher = ADDON_PATTERN.matcher(targetHash);
        if (addonMatcher.matches()) {
            String string = addonMatcher.group(1);
            String string4 = addonMatcher.group(2);
            String string5 = addonMatcher.group(3);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"group(...)");
            int n = Integer.parseInt(string5);
            return new CompileData(n, null, null, string, string4, null, 38, null);
        }
        throw new RuntimeException(StringsKt.trimIndent((String)("\n                    Unsupported value: " + targetHash + ". Format must be one of:\n                    - android-31\n                    - android-36.2\n                    - android-31-ext2\n                    - android-36.2-ext2\n                    - android-T\n                    - vendorName:addonName:31\n                    ")));
    }

    @Nullable
    public static final String validateNamespaceValue(@Nullable String value) {
        CharSequence charSequence = value;
        if (charSequence == null || charSequence.length() == 0 || SourceVersion.isName(value)) {
            return null;
        }
        String msg = "Namespace '" + value + "' is not a valid Java package name";
        for (String segment : Splitter.on((char)'.').split((CharSequence)value)) {
            if (!SourceVersion.isIdentifier(segment)) {
                return msg + " as '" + segment + "' is not a valid Java identifier.";
            }
            if (!SourceVersion.isKeyword(segment)) continue;
            return msg + " as '" + segment + "' is a Java keyword.";
        }
        return msg + ".";
    }

    @Nullable
    public static final String validatePreviewTargetValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return AndroidVersion.PREVIEW_PATTERN.matcher(value).matches() ? value : null;
    }

    @Nullable
    public static final AndroidVersionImpl createTargetSdkVersion(@Nullable Integer targetSdk2, @Nullable String targetSdkPreview) {
        AndroidVersionImpl androidVersionImpl;
        if (targetSdk2 != null || targetSdkPreview != null) {
            DefaultApiVersion apiVersion;
            DefaultApiVersion defaultApiVersion;
            Integer n = targetSdk2;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                defaultApiVersion = new DefaultApiVersion(it);
            } else {
                String string = targetSdkPreview;
                Intrinsics.checkNotNull((Object)string);
                defaultApiVersion = new DefaultApiVersion(string);
            }
            DefaultApiVersion $this$createTargetSdkVersion_u24lambda_u241 = apiVersion = defaultApiVersion;
            boolean bl = false;
            androidVersionImpl = new AndroidVersionImpl($this$createTargetSdkVersion_u24lambda_u241.getApiLevel(), $this$createTargetSdkVersion_u24lambda_u241.getCodename());
        } else {
            androidVersionImpl = null;
        }
        return androidVersionImpl;
    }
}

