/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.manifmerger.ManifestMerger2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\t"}, d2={"stripUsesSplitFromFeatureManifest", "", "document", "Lorg/w3c/dom/Document;", "stripMinSdkFromFeatureManifest", "replacePackageNameInFeatureManifest", "newPackageName", "", "removeSplitNames", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nXmlDocumentUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlDocumentUtils.kt\ncom/android/build/gradle/tasks/XmlDocumentUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1863#2,2:112\n*S KotlinDebug\n*F\n+ 1 XmlDocumentUtils.kt\ncom/android/build/gradle/tasks/XmlDocumentUtilsKt\n*L\n40#1:112,2\n*E\n"})
public final class XmlDocumentUtilsKt {
    public static final void stripUsesSplitFromFeatureManifest(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Element manifest = document.getDocumentElement();
        ImmutableList usesSplitList = ManifestMerger2.getChildElementsByName((Element)manifest, (String)"uses-split");
        Intrinsics.checkNotNull((Object)usesSplitList);
        Iterable $this$forEach$iv = (Iterable)usesSplitList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element node = (Element)element$iv;
            boolean bl = false;
            manifest.removeChild(node);
        }
    }

    public static final void stripMinSdkFromFeatureManifest(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Element manifest = document.getDocumentElement();
        ImmutableList usesSdkList = ManifestMerger2.getChildElementsByName((Element)manifest, (String)"uses-sdk");
        Element usesSdk = null;
        if (!usesSdkList.isEmpty()) {
            usesSdk = (Element)usesSdkList.get(0);
            usesSdk.removeAttributeNS("http://schemas.android.com/apk/res/android", "minSdkVersion");
        }
    }

    public static final void replacePackageNameInFeatureManifest(@NotNull Document document, @NotNull String newPackageName) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)newPackageName, (String)"newPackageName");
        Element manifest = document.getDocumentElement();
        manifest.setAttribute("package", newPackageName);
    }

    public static final void removeSplitNames(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Element element = document.getDocumentElement();
        if (element == null) {
            return;
        }
        Element manifest = element;
        ImmutableList applicationElements = ManifestMerger2.getChildElementsByName((Element)manifest, (String)"application");
        if (applicationElements.isEmpty()) {
            return;
        }
        Element application = (Element)applicationElements.get(0);
        String[] stringArray = new String[]{"activity", "service", "provider"};
        List elementNamesToUpdate = CollectionsKt.listOf((Object[])stringArray);
        for (String elementName : elementNamesToUpdate) {
            UnmodifiableIterator unmodifiableIterator;
            Intrinsics.checkNotNullExpressionValue((Object)ManifestMerger2.getChildElementsByName((Element)application, (String)elementName).iterator(), (String)"iterator(...)");
            while (unmodifiableIterator.hasNext()) {
                Element elementToUpdate = (Element)unmodifiableIterator.next();
                elementToUpdate.removeAttributeNS("http://schemas.android.com/apk/res/android", "splitName");
            }
        }
    }
}

