/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.ScopedArtifact;
import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.artifact.impl.InternalScopedArtifacts;
import com.android.build.api.dsl.TestCoverage;
import com.android.build.api.variant.ScopedArtifacts;
import com.android.build.gradle.internal.HostTestTaskManager;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.UnitTestTaskManager;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.HostTestCreationConfig;
import com.android.build.gradle.internal.component.KmpComponentCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.coverage.JacocoConfigurations;
import com.android.build.gradle.internal.coverage.JacocoOptions;
import com.android.build.gradle.internal.coverage.JacocoReportTask;
import com.android.build.gradle.internal.lint.AndroidLintAnalysisTask;
import com.android.build.gradle.internal.lint.LintModelWriterTask;
import com.android.build.gradle.internal.res.GenerateLibraryRFileTask;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.MutableTaskContainer;
import com.android.build.gradle.internal.tasks.PackageForUnitTest;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.tasks.GenerateTestConfig;
import com.android.build.gradle.tasks.factory.AndroidUnitTest;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.testing.jacoco.plugins.JacocoPlugin;
import org.gradle.testing.jacoco.plugins.JacocoPluginExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000fJ\u0006\u0010\u0012\u001a\u00020\rJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000fH\u0002R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/UnitTestTaskManager;", "Lcom/android/build/gradle/internal/HostTestTaskManager;", "project", "Lorg/gradle/api/Project;", "globalConfig", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;", "(Lorg/gradle/api/Project;Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;)V", "javaResMergingScopes", "", "Lcom/android/build/api/artifact/impl/InternalScopedArtifacts$InternalScope;", "getJavaResMergingScopes", "()Ljava/util/Set;", "createRunUnitTestTask", "", "creationConfig", "Lcom/android/build/gradle/internal/component/HostTestCreationConfig;", "createTasks", "unitTestCreationConfig", "createTopLevelTasks", "getJacocoVersion", "", "gradle-core"})
public final class UnitTestTaskManager
extends HostTestTaskManager {
    @NotNull
    private final Set<InternalScopedArtifacts.InternalScope> javaResMergingScopes;

    public UnitTestTaskManager(@NotNull Project project, @NotNull GlobalTaskCreationConfig globalConfig2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)globalConfig2, (String)"globalConfig");
        super(project, globalConfig2);
        InternalScopedArtifacts.InternalScope[] internalScopeArray = new InternalScopedArtifacts.InternalScope[]{InternalScopedArtifacts.InternalScope.SUB_PROJECTS, InternalScopedArtifacts.InternalScope.EXTERNAL_LIBS};
        this.javaResMergingScopes = SetsKt.setOf((Object[])internalScopeArray);
    }

    public final void createTopLevelTasks() {
        this.taskFactory.register(this.globalConfig.getTaskNames().getTest(), createTopLevelTasks.1.INSTANCE);
        this.taskFactory.configure("check", (Action<? super Task>)new Action(this){
            final /* synthetic */ UnitTestTaskManager this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(@NotNull Task check) {
                Intrinsics.checkNotNullParameter((Object)check, (String)"check");
                Object[] objectArray = new Object[]{this.this$0.globalConfig.getTaskNames().getTest()};
                check.dependsOn(objectArray);
            }
        });
    }

    public final void createTasks(@NotNull HostTestCreationConfig unitTestCreationConfig) {
        TaskProvider compileTask;
        Intrinsics.checkNotNullParameter((Object)unitTestCreationConfig, (String)"unitTestCreationConfig");
        MutableTaskContainer taskContainer = unitTestCreationConfig.getTaskContainer();
        VariantCreationConfig testedVariant = unitTestCreationConfig.getMainVariant();
        boolean includeAndroidResources = this.globalConfig.getUnitTestOptions().isIncludeAndroidResources();
        this.createAnchorTasks(unitTestCreationConfig);
        this.createDependencyStreams(unitTestCreationConfig);
        this.createProcessJavaResTask(unitTestCreationConfig);
        if (includeAndroidResources) {
            if (testedVariant.getComponentType().isAar()) {
                this.createProcessTestManifestTask(unitTestCreationConfig);
                this.createGenerateResValuesTask(unitTestCreationConfig);
                this.createMergeAssetsTask(unitTestCreationConfig);
                ComponentCreationConfig componentCreationConfig = unitTestCreationConfig;
                ImmutableSet immutableSet = ImmutableSet.of();
                Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"of()");
                this.createMergeResourcesTask(componentCreationConfig, true, (Set)immutableSet);
                this.createApkProcessResTask(unitTestCreationConfig, (Artifact.Single<Directory>)((Artifact.Single)InternalArtifactType.FEATURE_RESOURCE_PKG.INSTANCE));
                this.taskFactory.register(new PackageForUnitTest.CreationAction(unitTestCreationConfig));
                this.createDataBindingTasksIfNecessary(unitTestCreationConfig);
            } else if (testedVariant.getComponentType().isApk()) {
                unitTestCreationConfig.getArtifacts().copy(InternalArtifactType.PROCESSED_RES.INSTANCE, testedVariant.getArtifacts());
                unitTestCreationConfig.getArtifacts().copy((Artifact.Single)SingleArtifact.ASSETS.INSTANCE, testedVariant.getArtifacts());
                this.taskFactory.register(new PackageForUnitTest.CreationAction(unitTestCreationConfig));
            } else {
                throw new IllegalStateException("Tested variant " + testedVariant.getName() + " in " + this.project.getPath() + " must be a library or an application to have unit tests.");
            }
            TaskProvider generateTestConfig = this.taskFactory.register(new GenerateTestConfig.CreationAction(unitTestCreationConfig));
            compileTask = unitTestCreationConfig instanceof KmpComponentCreationConfig ? ((KmpComponentCreationConfig)((Object)unitTestCreationConfig)).getAndroidKotlinCompilation().getCompileTaskProvider() : taskContainer.getCompileTask();
            TaskProvider[] taskProviderArray = new TaskProvider[]{generateTestConfig};
            TaskFactoryUtils.dependsOn(compileTask, taskProviderArray);
            compileTask.configure(new Action(unitTestCreationConfig){
                final /* synthetic */ HostTestCreationConfig $unitTestCreationConfig;
                {
                    this.$unitTestCreationConfig = $unitTestCreationConfig;
                }

                public final void execute(@NotNull Task task) {
                    Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                    GenerateTestConfig.TestConfigInputs testConfigInputs = new GenerateTestConfig.TestConfigInputs(this.$unitTestCreationConfig);
                    TaskInputs taskInputs = task.getInputs();
                    Object[] objectArray = new Object[]{testConfigInputs.getResourceApk()};
                    taskInputs.files(objectArray).withPropertyName("resourceApk").optional().withPathSensitivity(PathSensitivity.RELATIVE);
                    objectArray = new Object[]{testConfigInputs.getMergedAssets()};
                    taskInputs.files(objectArray).withPropertyName("mergedAssets").withPathSensitivity(PathSensitivity.RELATIVE);
                    objectArray = new Object[]{testConfigInputs.getMergedManifest()};
                    taskInputs.files(objectArray).withPropertyName("mergedManifest").withPathSensitivity(PathSensitivity.RELATIVE);
                    taskInputs.property("packageNameOfFinalRClassProvider", testConfigInputs.getPackageNameOfFinalRClass());
                }
            });
            taskContainer.getAssembleTask().configure(new Action(unitTestCreationConfig){
                final /* synthetic */ HostTestCreationConfig $unitTestCreationConfig;
                {
                    this.$unitTestCreationConfig = $unitTestCreationConfig;
                }

                public final void execute(@NotNull Task task) {
                    Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                    Object[] objectArray = new Object[]{this.$unitTestCreationConfig.getArtifacts().get(InternalArtifactType.APK_FOR_LOCAL_TEST.INSTANCE)};
                    task.dependsOn(objectArray);
                }
            });
        } else if (testedVariant.getComponentType().isAar() && testedVariant.getBuildFeatures().getAndroidResources()) {
            this.taskFactory.register(new GenerateLibraryRFileTask.TestRuntimeStubRClassCreationAction(unitTestCreationConfig));
        }
        taskContainer.getAssembleTask().configure(new Action(unitTestCreationConfig){
            final /* synthetic */ HostTestCreationConfig $unitTestCreationConfig;
            {
                this.$unitTestCreationConfig = $unitTestCreationConfig;
            }

            public final void execute(@NotNull Task task) {
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                Object[] objectArray = new Object[]{this.$unitTestCreationConfig.getArtifacts().forScope(ScopedArtifacts.Scope.PROJECT).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE)};
                task.dependsOn(objectArray);
            }
        });
        this.taskFactory.configure("assembleUnitTest", (Action<? super Task>)new Action(unitTestCreationConfig){
            final /* synthetic */ HostTestCreationConfig $unitTestCreationConfig;
            {
                this.$unitTestCreationConfig = $unitTestCreationConfig;
            }

            public final void execute(@NotNull Task assembleTest) {
                Intrinsics.checkNotNullParameter((Object)assembleTest, (String)"assembleTest");
                Object[] objectArray = new Object[]{this.$unitTestCreationConfig.getTaskContainer().getAssembleTask().getName()};
                assembleTest.dependsOn(objectArray);
            }
        });
        if (!(unitTestCreationConfig instanceof KmpComponentCreationConfig)) {
            TaskProvider<? extends Task> compileTask2 = taskContainer.getCompileTask();
            compileTask = new TaskProvider[]{taskContainer.getProcessJavaResourcesTask(), testedVariant.getTaskContainer().getProcessJavaResourcesTask()};
            TaskFactoryUtils.dependsOn(compileTask2, compileTask);
            TaskProvider<? extends JavaCompile> javacTask = this.createJavacTask(unitTestCreationConfig);
            TaskManager.Companion.setJavaCompilerTask(javacTask, unitTestCreationConfig);
        }
        this.maybeCreateTransformClassesWithAsmTask(unitTestCreationConfig);
        if (!this.globalConfig.getAvoidTaskRegistration() && unitTestCreationConfig.getServices().getProjectOptions().get(BooleanOption.LINT_ANALYSIS_PER_COMPONENT) && !this.globalConfig.getLintOptions().getIgnoreTestSources()) {
            this.taskFactory.register(new AndroidLintAnalysisTask.PerComponentCreationAction(unitTestCreationConfig, false));
            this.taskFactory.register(new LintModelWriterTask.PerComponentCreationAction(unitTestCreationConfig, false, false, false));
        }
        this.createRunUnitTestTask(unitTestCreationConfig);
    }

    private final void createRunUnitTestTask(HostTestCreationConfig creationConfig) {
        if (creationConfig.isCoverageEnabled()) {
            this.project.getPluginManager().apply(JacocoPlugin.class);
        }
        TaskProvider runTestsTask = this.taskFactory.register(new AndroidUnitTest.CreationAction(creationConfig, this.getJacocoVersion(creationConfig)));
        creationConfig.runTestTaskConfigurationActions(runTestsTask);
        this.taskFactory.configure(this.globalConfig.getTaskNames().getTest(), (Action<? super Task>)new Action(runTestsTask){
            final /* synthetic */ TaskProvider<AndroidUnitTest> $runTestsTask;
            {
                this.$runTestsTask = $runTestsTask;
            }

            public final void execute(@NotNull Task test) {
                Intrinsics.checkNotNullParameter((Object)test, (String)"test");
                Object[] objectArray = new Object[]{this.$runTestsTask};
                test.dependsOn(objectArray);
            }
        });
        if (creationConfig.isCoverageEnabled()) {
            Configuration configuration = JacocoConfigurations.getJacocoAntTaskConfiguration(this.project, this.getJacocoVersion(creationConfig));
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getJacocoAntTaskConfigur\u2026tionConfig)\n            )");
            Configuration ant = configuration;
            this.project.getPlugins().withType(JacocoPlugin.class, new Action(this, creationConfig, ant){
                final /* synthetic */ UnitTestTaskManager this$0;
                final /* synthetic */ HostTestCreationConfig $creationConfig;
                final /* synthetic */ Configuration $ant;
                {
                    this.this$0 = $receiver;
                    this.$creationConfig = $creationConfig;
                    this.$ant = $ant;
                }

                public final void execute(JacocoPlugin it) {
                    this.this$0.taskFactory.register(new JacocoReportTask.CreateActionUnitTest(this.$creationConfig, this.$ant));
                }
            });
        }
    }

    private final String getJacocoVersion(HostTestCreationConfig unitTestCreationConfig) {
        String jacocoVersionProjectOption = unitTestCreationConfig.getServices().getProjectOptions().get(StringOption.JACOCO_TOOL_VERSION);
        CharSequence charSequence = jacocoVersionProjectOption;
        if (!(charSequence == null || charSequence.length() == 0)) {
            return jacocoVersionProjectOption;
        }
        TestCoverage testCoverage = unitTestCreationConfig.getGlobal().getTestCoverage();
        Intrinsics.checkNotNull((Object)testCoverage, (String)"null cannot be cast to non-null type com.android.build.gradle.internal.coverage.JacocoOptions");
        if (((JacocoOptions)testCoverage).getVersionSetByUser()) {
            return unitTestCreationConfig.getGlobal().getTestCoverage().getJacocoVersion();
        }
        JacocoPluginExtension pluginExtension = (JacocoPluginExtension)this.project.getExtensions().findByType(JacocoPluginExtension.class);
        if (pluginExtension != null) {
            String string = pluginExtension.getToolVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginExtension.toolVersion");
            return string;
        }
        return "0.8.11";
    }

    @Override
    @NotNull
    protected Set<InternalScopedArtifacts.InternalScope> getJavaResMergingScopes() {
        return this.javaResMergingScopes;
    }
}

