/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.mlkit;

import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.mlkit.GenerateMlModelClass;
import com.android.build.gradle.internal.tasks.mlkit.codegen.TfliteModelGenerator;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.buildanalyzer.common.TaskCategory;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@BuildAnalyzer(primaryTaskCategory=TaskCategory.COMPILED_CLASSES, secondaryTaskCategories={TaskCategory.SOURCE_GENERATION})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0014R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/tasks/mlkit/GenerateMlModelClass;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "modelFileDir", "Lorg/gradle/api/file/DirectoryProperty;", "getModelFileDir", "()Lorg/gradle/api/file/DirectoryProperty;", "namespace", "Lorg/gradle/api/provider/Property;", "", "getNamespace", "()Lorg/gradle/api/provider/Property;", "sourceOutDir", "getSourceOutDir", "doTaskAction", "", "CreationAction", "gradle-core"})
public abstract class GenerateMlModelClass
extends NonIncrementalTask {
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputFiles
    @NotNull
    public abstract DirectoryProperty getModelFileDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getSourceOutDir();

    @Input
    @NotNull
    public abstract Property<String> getNamespace();

    @Override
    protected void doTaskAction() {
        this.getModelFileDir().getAsFileTree().visit(new FileVisitor(this){
            final /* synthetic */ GenerateMlModelClass this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitDir(@NotNull FileVisitDetails fileVisitDetails) {
                Intrinsics.checkNotNullParameter((Object)fileVisitDetails, (String)"fileVisitDetails");
            }

            public void visitFile(@NotNull FileVisitDetails fileVisitDetails) {
                Intrinsics.checkNotNullParameter((Object)fileVisitDetails, (String)"fileVisitDetails");
                File modelFile = fileVisitDetails.getFile();
                String string = modelFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"modelFile.name");
                if (StringsKt.endsWith$default((String)string, (String)".tflite", (boolean)false, (int)2, null) && modelFile.length() <= 0xC800000L) {
                    try {
                        Intrinsics.checkNotNullExpressionValue((Object)modelFile, (String)"modelFile");
                        String string2 = this.this$0.getNamespace().get() + ".ml";
                        String string3 = fileVisitDetails.getRelativePath().getPathString();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"fileVisitDetails.relativePath.pathString");
                        TfliteModelGenerator modelGenerator = new TfliteModelGenerator(modelFile, string2, string3);
                        modelGenerator.generateBuildClass(this.this$0.getSourceOutDir());
                    }
                    catch (Exception e) {
                        Logging.getLogger(this.getClass()).warn(e.getMessage());
                    }
                }
            }
        });
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/mlkit/GenerateMlModelClass$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/mlkit/GenerateMlModelClass;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<GenerateMlModelClass, ComponentCreationConfig> {
        @NotNull
        private final String name;
        @NotNull
        private final Class<GenerateMlModelClass> type;

        public CreationAction(@NotNull ComponentCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig);
            this.name = this.computeTaskName("generate", "MlModelClass");
            this.type = GenerateMlModelClass.class;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<GenerateMlModelClass> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<GenerateMlModelClass> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.creationConfig.getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).on(InternalArtifactType.ML_SOURCE_OUT.INSTANCE);
        }

        @Override
        public void configure(@NotNull GenerateMlModelClass task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            this.creationConfig.getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.MERGED_ML_MODELS.INSTANCE, (Property)task.getModelFileDir());
            HasConfigurableValuesKt.setDisallowChanges(task.getNamespace(), this.creationConfig.getNamespace());
        }
    }
}

