/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.model;

import com.android.build.gradle.internal.cxx.configure.BuildSystemCommandLineKt;
import com.android.build.gradle.internal.cxx.configure.CmakeLocatorKt;
import com.android.build.gradle.internal.cxx.configure.CmakeProperty;
import com.android.build.gradle.internal.cxx.configure.CommandLineArgument;
import com.android.build.gradle.internal.cxx.configure.NdkBuildProperty;
import com.android.build.gradle.internal.cxx.configure.NdkMetaPlatforms;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxCmakeModuleModelKt;
import com.android.build.gradle.internal.cxx.model.CxxModuleModel;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.utils.FileUtils;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\u001a\u0018\u0010\u0017\u001a\u00020\u0018*\u00020\u00022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u001a\u0018\u0010\u001c\u001a\u00020\u0018*\u00020\u00022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u001a\u0018\u0010\u001d\u001a\u00020\u0018*\u00020\u00022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u001a\u0018\u0010\u001e\u001a\u00020\u0018*\u00020\u00022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001a\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\"\u0015\u0010\t\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0015\u0010\r\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\"\u0015\u0010\u000f\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\"\u0015\u0010\u0011\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\f\"\u0015\u0010\u0013\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\f\"\u0015\u0010\u0015\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\f\"\u0015\u0010\u001f\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b \u0010\f\"\u0015\u0010!\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\f\"\u0015\u0010#\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\f\"\u0015\u0010%\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0004\"\u0015\u0010'\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0004\u00a8\u0006)"}, d2={"cmakeSettingsFile", "Ljava/io/File;", "Lcom/android/build/gradle/internal/cxx/model/CxxModuleModel;", "getCmakeSettingsFile", "(Lcom/android/build/gradle/internal/cxx/model/CxxModuleModel;)Ljava/io/File;", "buildSettingsFile", "getBuildSettingsFile", "makeFileFolder", "getMakeFileFolder", "moduleName", "", "getModuleName", "(Lcom/android/build/gradle/internal/cxx/model/CxxModuleModel;)Ljava/lang/String;", "ndkMinPlatform", "getNdkMinPlatform", "ndkMaxPlatform", "getNdkMaxPlatform", "ndkMajorVersion", "getNdkMajorVersion", "ndkMinorVersion", "getNdkMinorVersion", "cmakeGenerator", "getCmakeGenerator", "determineUsedStlForCmake", "Lcom/android/build/gradle/internal/ndk/Stl;", "arguments", "", "Lcom/android/build/gradle/internal/cxx/configure/CommandLineArgument;", "determineUsedStlForNdkBuild", "determineUsedStlFromArguments", "determineUsedStl", "buildSystemTag", "getBuildSystemTag", "buildSystemNameForTasks", "getBuildSystemNameForTasks", "intermediatesParentDirSuffix", "getIntermediatesParentDirSuffix", "predictableRepublishFolder", "getPredictableRepublishFolder", "refsFolder", "getRefsFolder", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nCxxModuleModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CxxModuleModel.kt\ncom/android/build/gradle/internal/cxx/model/CxxModuleModelKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,342:1\n1#2:343\n*E\n"})
public final class CxxModuleModelKt {
    @NotNull
    public static final File getCmakeSettingsFile(@NotNull CxxModuleModel $this$cmakeSettingsFile) {
        Intrinsics.checkNotNullParameter((Object)$this$cmakeSettingsFile, (String)"<this>");
        String[] stringArray = new String[]{"CMakeSettings.json"};
        File file = FileUtils.join((File)$this$cmakeSettingsFile.getMakeFile().getParentFile(), (String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"join(...)");
        return file;
    }

    @NotNull
    public static final File getBuildSettingsFile(@NotNull CxxModuleModel $this$buildSettingsFile) {
        Intrinsics.checkNotNullParameter((Object)$this$buildSettingsFile, (String)"<this>");
        String[] stringArray = new String[]{"BuildSettings.json"};
        File file = FileUtils.join((File)$this$buildSettingsFile.getMakeFile().getParentFile(), (String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"join(...)");
        return file;
    }

    @NotNull
    public static final File getMakeFileFolder(@NotNull CxxModuleModel $this$makeFileFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$makeFileFolder, (String)"<this>");
        File file = $this$makeFileFolder.getMakeFile().getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        return file;
    }

    @NotNull
    public static final String getModuleName(@NotNull CxxModuleModel $this$moduleName) {
        Intrinsics.checkNotNullParameter((Object)$this$moduleName, (String)"<this>");
        return StringsKt.substringAfterLast$default((String)$this$moduleName.getGradleModulePathName(), (String)":", null, (int)2, null);
    }

    @NotNull
    public static final String getNdkMinPlatform(@NotNull CxxModuleModel $this$ndkMinPlatform) {
        Intrinsics.checkNotNullParameter((Object)$this$ndkMinPlatform, (String)"<this>");
        Object object = $this$ndkMinPlatform.getNdkMetaPlatforms();
        if (object == null || (object = Integer.valueOf(((NdkMetaPlatforms)object).getMin()).toString()) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public static final String getNdkMaxPlatform(@NotNull CxxModuleModel $this$ndkMaxPlatform) {
        Intrinsics.checkNotNullParameter((Object)$this$ndkMaxPlatform, (String)"<this>");
        Object object = $this$ndkMaxPlatform.getNdkMetaPlatforms();
        if (object == null || (object = Integer.valueOf(((NdkMetaPlatforms)object).getMax()).toString()) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public static final String getNdkMajorVersion(@NotNull CxxModuleModel $this$ndkMajorVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$ndkMajorVersion, (String)"<this>");
        return String.valueOf($this$ndkMajorVersion.getNdkVersion().getMajor());
    }

    @NotNull
    public static final String getNdkMinorVersion(@NotNull CxxModuleModel $this$ndkMinorVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$ndkMinorVersion, (String)"<this>");
        return String.valueOf($this$ndkMinorVersion.getNdkVersion().getMinor());
    }

    @NotNull
    public static final String getCmakeGenerator(@NotNull CxxModuleModel $this$cmakeGenerator) {
        Intrinsics.checkNotNullParameter((Object)$this$cmakeGenerator, (String)"<this>");
        return $this$cmakeGenerator.getCmake() == null ? "" : (CmakeLocatorKt.isCmakeForkVersion(CxxCmakeModuleModelKt.getMinimumCmakeVersion($this$cmakeGenerator.getCmake())) ? "Android Gradle - Ninja" : "Ninja");
    }

    @NotNull
    public static final Stl determineUsedStlForCmake(@NotNull CxxModuleModel $this$determineUsedStlForCmake, @NotNull List<? extends CommandLineArgument> arguments) {
        Intrinsics.checkNotNullParameter((Object)$this$determineUsedStlForCmake, (String)"<this>");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        String stlFromArgument = BuildSystemCommandLineKt.getCmakeProperty(arguments, CmakeProperty.ANDROID_STL);
        if (stlFromArgument != null) {
            Stl result2 = Stl.Companion.fromArgumentName(stlFromArgument);
            if (result2 != null) {
                return result2;
            }
            LoggingEnvironmentKt.warnln("Unable to parse STL from build.gradle arguments: " + stlFromArgument, new Object[0]);
        }
        return $this$determineUsedStlForCmake.getNdkDefaultStl();
    }

    @NotNull
    public static final Stl determineUsedStlForNdkBuild(@NotNull CxxModuleModel $this$determineUsedStlForNdkBuild, @NotNull List<? extends CommandLineArgument> arguments) {
        Intrinsics.checkNotNullParameter((Object)$this$determineUsedStlForNdkBuild, (String)"<this>");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        String stlFromArgument = BuildSystemCommandLineKt.getNdkBuildProperty(arguments, NdkBuildProperty.APP_STL);
        if (stlFromArgument != null) {
            Stl result2;
            Stl stl = result2 = Stl.Companion.fromArgumentName(stlFromArgument);
            if (stl != null) {
                return stl;
            }
            LoggingEnvironmentKt.warnln("Unable to parse STL from build.gradle arguments: " + stlFromArgument, new Object[0]);
        }
        String appStl = null;
        File applicationMk = FilesKt.resolveSibling((File)$this$determineUsedStlForNdkBuild.getMakeFile(), (String)"Application.mk");
        if (applicationMk.exists()) {
            for (String line : StringsKt.lines((CharSequence)FilesKt.readText$default((File)applicationMk, null, (int)1, null))) {
                String string;
                MatchResult match2;
                if (Regex.find$default((Regex)new Regex("^APP_STL\\s*:?=\\s*(.*)$"), (CharSequence)((Object)StringsKt.trim((CharSequence)line)).toString(), (int)0, (int)2, null) == null) continue;
                MatchGroup appStlMatch = match2.getGroups().get(1);
                if (!(appStlMatch != null)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                String it = string = appStlMatch.getValue();
                boolean bl = false;
                appStl = ((CharSequence)it).length() > 0 ? string : null;
            }
            if (appStl != null) {
                Stl result3;
                Stl stl = result3 = Stl.Companion.fromArgumentName(appStl);
                if (stl != null) {
                    return stl;
                }
                LoggingEnvironmentKt.warnln("Unable to parse APP_STL from " + applicationMk + ": " + appStl, new Object[0]);
            }
        }
        return $this$determineUsedStlForNdkBuild.getNdkDefaultStl();
    }

    @NotNull
    public static final Stl determineUsedStlFromArguments(@NotNull CxxModuleModel $this$determineUsedStlFromArguments, @NotNull List<? extends CommandLineArgument> arguments) {
        Stl stl;
        Intrinsics.checkNotNullParameter((Object)$this$determineUsedStlFromArguments, (String)"<this>");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$determineUsedStlFromArguments.getBuildSystem().ordinal()]) {
            case 1: {
                stl = CxxModuleModelKt.determineUsedStlForCmake($this$determineUsedStlFromArguments, arguments);
                break;
            }
            case 2: {
                stl = CxxModuleModelKt.determineUsedStlForNdkBuild($this$determineUsedStlFromArguments, arguments);
                break;
            }
            case 3: {
                stl = Stl.UNKNOWN;
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf((Object)$this$determineUsedStlFromArguments.getBuildSystem()).toString());
            }
        }
        return stl;
    }

    @NotNull
    public static final Stl determineUsedStl(@NotNull CxxModuleModel $this$determineUsedStl, @NotNull List<String> arguments) {
        Stl stl;
        Intrinsics.checkNotNullParameter((Object)$this$determineUsedStl, (String)"<this>");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$determineUsedStl.getBuildSystem().ordinal()]) {
            case 1: {
                stl = CxxModuleModelKt.determineUsedStlForCmake($this$determineUsedStl, BuildSystemCommandLineKt.toCmakeArguments(arguments));
                break;
            }
            case 2: {
                stl = CxxModuleModelKt.determineUsedStlForNdkBuild($this$determineUsedStl, BuildSystemCommandLineKt.toNdkBuildArguments(arguments));
                break;
            }
            case 3: {
                stl = Stl.UNKNOWN;
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf((Object)$this$determineUsedStl.getBuildSystem()).toString());
            }
        }
        return stl;
    }

    @NotNull
    public static final String getBuildSystemTag(@NotNull CxxModuleModel $this$buildSystemTag) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$buildSystemTag, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$buildSystemTag.getBuildSystem().ordinal()]) {
            case 1: {
                string = "cmake";
                break;
            }
            case 3: {
                string = "ninja";
                break;
            }
            case 2: {
                string = "ndkBuild";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public static final String getBuildSystemNameForTasks(@NotNull CxxModuleModel $this$buildSystemNameForTasks) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$buildSystemNameForTasks, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$buildSystemNameForTasks.getBuildSystem().ordinal()]) {
            case 1: {
                string = "CMake";
                break;
            }
            case 3: {
                string = "Ninja";
                break;
            }
            case 2: {
                string = "NdkBuild";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public static final String getIntermediatesParentDirSuffix(@NotNull CxxModuleModel $this$intermediatesParentDirSuffix) {
        Intrinsics.checkNotNullParameter((Object)$this$intermediatesParentDirSuffix, (String)"<this>");
        return WhenMappings.$EnumSwitchMapping$0[$this$intermediatesParentDirSuffix.getBuildSystem().ordinal()] == 2 ? "obj/local" : "obj";
    }

    @NotNull
    public static final File getPredictableRepublishFolder(@NotNull CxxModuleModel $this$predictableRepublishFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$predictableRepublishFolder, (String)"<this>");
        return FilesKt.resolve((File)$this$predictableRepublishFolder.getCxxFolder(), (String)"tools");
    }

    @NotNull
    public static final File getRefsFolder(@NotNull CxxModuleModel $this$refsFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$refsFolder, (String)"<this>");
        String[] stringArray = new String[]{"refs"};
        File file = FileUtils.join((File)$this$refsFolder.getIntermediatesFolder(), (String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"join(...)");
        return file;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NativeBuildSystem.values().length];
            try {
                nArray[NativeBuildSystem.CMAKE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NativeBuildSystem.NDK_BUILD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NativeBuildSystem.NINJA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

