/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.kmp.resolvers;

import com.android.build.api.attributes.AgpVersionAttr;
import com.android.build.gradle.internal.component.KmpComponentCreationConfig;
import com.android.build.gradle.internal.ide.dependencies.BuildIdentifierMethods;
import com.android.build.gradle.internal.ide.kmp.LibraryResolver;
import com.android.build.gradle.internal.ide.kmp.resolvers.BaseIdeDependencyResolver;
import com.android.build.gradle.internal.ide.kmp.resolvers.ProjectDependencyResolver;
import com.android.build.gradle.internal.ide.proto.ConvertersKt;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.builder.model.v2.ide.Library;
import com.android.kotlin.multiplatform.ide.models.serialization.KeysKt;
import com.android.kotlin.multiplatform.models.DependencyInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinClasspath;
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinDependency;
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinProjectArtifactDependency;
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinProjectCoordinates;
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinSourceDependency;
import org.jetbrains.kotlin.gradle.idea.tcs.extras.ProjectArtifactClasspathExtrasKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.ide.IdeDependencyResolver;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\bH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/ide/kmp/resolvers/ProjectDependencyResolver;", "Lcom/android/build/gradle/internal/ide/kmp/resolvers/BaseIdeDependencyResolver;", "Lorg/jetbrains/kotlin/gradle/plugin/ide/IdeDependencyResolver;", "libraryResolver", "Lcom/android/build/gradle/internal/ide/kmp/LibraryResolver;", "sourceSetToCreationConfigMap", "Lkotlin/Lazy;", "", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "Lcom/android/build/gradle/internal/component/KmpComponentCreationConfig;", "<init>", "(Lcom/android/build/gradle/internal/ide/kmp/LibraryResolver;Lkotlin/Lazy;)V", "resolve", "", "Lorg/jetbrains/kotlin/gradle/idea/tcs/IdeaKotlinDependency;", "sourceSet", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nProjectDependencyResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectDependencyResolver.kt\ncom/android/build/gradle/internal/ide/kmp/resolvers/ProjectDependencyResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1611#2,9:108\n1863#2:117\n1864#2:119\n1620#2:120\n1#3:118\n*S KotlinDebug\n*F\n+ 1 ProjectDependencyResolver.kt\ncom/android/build/gradle/internal/ide/kmp/resolvers/ProjectDependencyResolver\n*L\n64#1:108,9\n64#1:117\n64#1:119\n64#1:120\n64#1:118\n*E\n"})
public final class ProjectDependencyResolver
extends BaseIdeDependencyResolver
implements IdeDependencyResolver {
    public ProjectDependencyResolver(@NotNull LibraryResolver libraryResolver, @NotNull Lazy<? extends Map<KotlinSourceSet, ? extends KmpComponentCreationConfig>> sourceSetToCreationConfigMap) {
        Intrinsics.checkNotNullParameter((Object)libraryResolver, (String)"libraryResolver");
        Intrinsics.checkNotNullParameter(sourceSetToCreationConfigMap, (String)"sourceSetToCreationConfigMap");
        super(libraryResolver, sourceSetToCreationConfigMap);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<IdeaKotlinDependency> resolve(@NotNull KotlinSourceSet sourceSet2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)sourceSet2, (String)"sourceSet");
        KmpComponentCreationConfig kmpComponentCreationConfig = (KmpComponentCreationConfig)((Map)this.getSourceSetToCreationConfigMap().getValue()).get(sourceSet2);
        if (kmpComponentCreationConfig == null) {
            return SetsKt.emptySet();
        }
        KmpComponentCreationConfig component2 = kmpComponentCreationConfig;
        this.getLibraryResolver().registerSourceSetArtifacts(sourceSet2);
        ArtifactCollection artifacts2 = this.getArtifactsForComponent(component2, AndroidArtifacts.ArtifactType.JAR, (Function1<? super ComponentIdentifier, Boolean>)((Function1)resolve.artifacts.1.INSTANCE));
        String projectBuildTreePath = (String)BuildIdentifierMethods.getProjectBuildTreePath(component2.getVariantDependencies()).get();
        Iterable $this$mapNotNull$iv = (Iterable)artifacts2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String[] stringArray;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ResolvedArtifactResult artifact = (ResolvedArtifactResult)element$iv$iv;
            boolean bl2 = false;
            ComponentIdentifier componentIdentifier = artifact.getId().getComponentIdentifier();
            Intrinsics.checkNotNull((Object)componentIdentifier, (String)"null cannot be cast to non-null type org.gradle.api.artifacts.component.ProjectComponentIdentifier");
            ProjectComponentIdentifier componentId = (ProjectComponentIdentifier)componentIdentifier;
            if (Intrinsics.areEqual((Object)projectBuildTreePath, (Object)componentId.getBuildTreePath())) {
                stringArray = null;
            } else {
                String[] stringArray2;
                String string;
                String buildPath = componentId.getBuild().getBuildPath();
                if (Intrinsics.areEqual((Object)buildPath, (Object)":")) {
                    string = ":";
                } else {
                    Intrinsics.checkNotNull((Object)buildPath);
                    stringArray2 = new String[]{":"};
                    string = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)buildPath, (String[])stringArray2, (boolean)false, (int)0, (int)6, null));
                }
                Intrinsics.checkNotNull((Object)buildPath);
                String string2 = componentId.getProjectPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProjectPath(...)");
                String string3 = componentId.getProjectName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProjectName(...)");
                String[] dependency = stringArray2 = new IdeaKotlinProjectArtifactDependency(IdeaKotlinSourceDependency.Type.Regular, new IdeaKotlinProjectCoordinates(string, buildPath, string2, string3), null, 4, null);
                boolean bl3 = false;
                LibraryResolver libraryResolver = this.getLibraryResolver();
                ResolvedVariantResult resolvedVariantResult = artifact.getVariant();
                Intrinsics.checkNotNullExpressionValue((Object)resolvedVariantResult, (String)"getVariant(...)");
                Library library = libraryResolver.getLibrary(resolvedVariantResult, sourceSet2);
                if (library != null && artifact.getVariant().getAttributes().contains(AgpVersionAttr.ATTRIBUTE)) {
                    dependency.getExtras().set(KeysKt.getAndroidDependencyKey(), (Object)DependencyInfo.newBuilder().setLibrary(ConvertersKt.convert(library).clearKey()).build());
                } else {
                    IdeaKotlinClasspath ideaKotlinClasspath = ProjectArtifactClasspathExtrasKt.getArtifactsClasspath((IdeaKotlinProjectArtifactDependency)dependency);
                    File file = artifact.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
                    ideaKotlinClasspath.add(file);
                }
                stringArray = stringArray2;
            }
            if (stringArray == null) continue;
            String[] it$iv$iv = stringArray;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }
}

