/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.GenerateRuntimeEnabledSdkTableTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.GuavaKtxKt;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.bundle.RuntimeEnabledSdkConfigProto;
import com.android.tools.build.bundletool.splitters.RuntimeEnabledSdkTableInjector;
import com.google.common.collect.ImmutableCollection;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@BuildAnalyzer(primaryTaskCategory=TaskCategory.APK_PACKAGING)
@CacheableTask
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/tasks/GenerateRuntimeEnabledSdkTableTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "<init>", "()V", "runtimeConfigFile", "Lorg/gradle/api/file/RegularFileProperty;", "getRuntimeConfigFile", "()Lorg/gradle/api/file/RegularFileProperty;", "runtimeEnabledSdkTableFile", "getRuntimeEnabledSdkTableFile", "doTaskAction", "", "writeRuntimeEnabledSdkTableFromRuntimeConfig", "runtimeConfig", "Ljava/io/File;", "runtimeEnabledSdkTableOutput", "generateRuntimeEnabledSdkTableBytes", "", "runtimeEnabledSdkTables", "", "Lcom/android/bundle/RuntimeEnabledSdkConfigProto$RuntimeEnabledSdk;", "CreationAction", "Companion", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nGenerateRuntimeEnabledSdkTableTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateRuntimeEnabledSdkTableTask.kt\ncom/android/build/gradle/internal/tasks/GenerateRuntimeEnabledSdkTableTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n1#2:100\n*E\n"})
public abstract class GenerateRuntimeEnabledSdkTableTask
extends NonIncrementalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String RUNTIME_ENABLED_SDK_TABLE_FILE_NAME = "RuntimeEnabledSdkTable.xml";

    @InputFile
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract RegularFileProperty getRuntimeConfigFile();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getRuntimeEnabledSdkTableFile();

    @Override
    protected void doTaskAction() {
        File file = ((RegularFile)this.getRuntimeConfigFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        this.writeRuntimeEnabledSdkTableFromRuntimeConfig(file, this.getRuntimeEnabledSdkTableFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeRuntimeEnabledSdkTableFromRuntimeConfig(File runtimeConfig, RegularFileProperty runtimeEnabledSdkTableOutput) {
        RuntimeEnabledSdkConfigProto.RuntimeEnabledSdkConfig runtimeEnabledSdkConfig;
        Closeable closeable = new FileInputStream(runtimeConfig);
        int n = 8192;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedInputStream input = (BufferedInputStream)closeable;
            boolean bl = false;
            runtimeEnabledSdkConfig = RuntimeEnabledSdkConfigProto.RuntimeEnabledSdkConfig.parseFrom((InputStream)input);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        RuntimeEnabledSdkConfigProto.RuntimeEnabledSdkConfig privacySandboxRuntimeConfig = runtimeEnabledSdkConfig;
        File file = ((RegularFile)runtimeEnabledSdkTableOutput.get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        List list = privacySandboxRuntimeConfig.getRuntimeEnabledSdkList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRuntimeEnabledSdkList(...)");
        FilesKt.writeBytes((File)file, (byte[])this.generateRuntimeEnabledSdkTableBytes(list));
    }

    private final byte[] generateRuntimeEnabledSdkTableBytes(List<RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk> runtimeEnabledSdkTables) {
        byte[] byArray = RuntimeEnabledSdkTableInjector.generateRuntimeEnabledSdkTableBytes((ImmutableCollection)((ImmutableCollection)GuavaKtxKt.toImmutableList((Iterable)runtimeEnabledSdkTables)));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"generateRuntimeEnabledSdkTableBytes(...)");
        return byArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/tasks/GenerateRuntimeEnabledSdkTableTask$Companion;", "", "<init>", "()V", "RUNTIME_ENABLED_SDK_TABLE_FILE_NAME", "", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/GenerateRuntimeEnabledSdkTableTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/GenerateRuntimeEnabledSdkTableTask;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "creationConfig", "<init>", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "configure", "task", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<GenerateRuntimeEnabledSdkTableTask, ComponentCreationConfig> {
        public CreationAction(@NotNull ComponentCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig, false, 2, null);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("generate", "PrivacySandboxRuntimeEnabledSdkTable");
        }

        @Override
        @NotNull
        public Class<GenerateRuntimeEnabledSdkTableTask> getType() {
            return GenerateRuntimeEnabledSdkTableTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<GenerateRuntimeEnabledSdkTableTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.creationConfig.getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName(GenerateRuntimeEnabledSdkTableTask.RUNTIME_ENABLED_SDK_TABLE_FILE_NAME).on(InternalArtifactType.RUNTIME_ENABLED_SDK_TABLE.INSTANCE);
        }

        @Override
        public void configure(@NotNull GenerateRuntimeEnabledSdkTableTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            HasConfigurableValuesKt.setDisallowChanges((Property)task.getRuntimeConfigFile(), this.creationConfig.getArtifacts().get(InternalArtifactType.PRIVACY_SANDBOX_SDK_RUNTIME_CONFIG_FILE.INSTANCE));
        }
    }
}

