/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.profile.TaskProfilingRecord;
import com.android.ide.common.workers.ExecutorServiceAdapter;
import com.android.ide.common.workers.WorkerExecutorException;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.workers.WorkerExecutionException;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u0012\u0013\u0014\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/Workers;", "", "<init>", "()V", "defaultExecutorService", "Ljava/util/concurrent/ExecutorService;", "withGradleWorkers", "Lcom/android/ide/common/workers/WorkerExecutorFacade;", "projectPath", "", "owner", "worker", "Lorg/gradle/workers/WorkerExecutor;", "analyticsService", "Lorg/gradle/api/provider/Provider;", "Lcom/android/build/gradle/internal/profile/AnalyticsService;", "withThreads", "Lcom/android/build/gradle/internal/tasks/Workers$ProfileAwareExecutorServiceAdapter;", "WorkerExecutorAdapter", "ProfileAwareExecutorServiceAdapter", "RunnableWrapperParams", "RunnableWrapperWorkAction", "gradle-core"})
public final class Workers {
    @NotNull
    public static final Workers INSTANCE = new Workers();
    @NotNull
    private static final ExecutorService defaultExecutorService;

    private Workers() {
    }

    @NotNull
    public final WorkerExecutorFacade withGradleWorkers(@NotNull String projectPath, @NotNull String owner, @NotNull WorkerExecutor worker, @NotNull Provider<AnalyticsService> analyticsService) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)worker, (String)"worker");
        Intrinsics.checkNotNullParameter(analyticsService, (String)"analyticsService");
        return new WorkerExecutorAdapter(projectPath, owner, worker, analyticsService);
    }

    @NotNull
    public final ProfileAwareExecutorServiceAdapter withThreads(@NotNull String owner, @NotNull AnalyticsService analyticsService) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)analyticsService, (String)"analyticsService");
        return new ProfileAwareExecutorServiceAdapter(owner, defaultExecutorService, null, analyticsService);
    }

    static {
        ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
        Intrinsics.checkNotNullExpressionValue((Object)forkJoinPool, (String)"commonPool(...)");
        defaultExecutorService = forkJoinPool;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0014J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/tasks/Workers$ProfileAwareExecutorServiceAdapter;", "Lcom/android/ide/common/workers/ExecutorServiceAdapter;", "Lcom/android/ide/common/workers/WorkerExecutorFacade;", "owner", "", "executor", "Ljava/util/concurrent/ExecutorService;", "delegate", "analyticsService", "Lcom/android/build/gradle/internal/profile/AnalyticsService;", "<init>", "(Ljava/lang/String;Ljava/util/concurrent/ExecutorService;Lcom/android/ide/common/workers/WorkerExecutorFacade;Lcom/android/build/gradle/internal/profile/AnalyticsService;)V", "getDelegate", "()Lcom/android/ide/common/workers/WorkerExecutorFacade;", "taskRecord", "Lcom/android/build/gradle/internal/profile/TaskProfilingRecord;", "getTaskRecord", "()Lcom/android/build/gradle/internal/profile/TaskProfilingRecord;", "taskRecord$delegate", "Lkotlin/Lazy;", "workerSubmission", "", "workerKey", "submit", "action", "Lcom/android/ide/common/workers/WorkerExecutorFacade$WorkAction;", "gradle-core"})
    public static final class ProfileAwareExecutorServiceAdapter
    extends ExecutorServiceAdapter
    implements WorkerExecutorFacade {
        @NotNull
        private final String owner;
        @Nullable
        private final WorkerExecutorFacade delegate;
        @NotNull
        private final AnalyticsService analyticsService;
        @NotNull
        private final Lazy taskRecord$delegate;

        public ProfileAwareExecutorServiceAdapter(@NotNull String owner, @NotNull ExecutorService executor2, @Nullable WorkerExecutorFacade delegate, @NotNull AnalyticsService analyticsService) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
            Intrinsics.checkNotNullParameter((Object)analyticsService, (String)"analyticsService");
            super(executor2);
            this.owner = owner;
            this.delegate = delegate;
            this.analyticsService = analyticsService;
            this.taskRecord$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TaskProfilingRecord>(this){
                final /* synthetic */ ProfileAwareExecutorServiceAdapter this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final TaskProfilingRecord invoke() {
                    return ProfileAwareExecutorServiceAdapter.access$getAnalyticsService$p(this.this$0).getTaskRecord(ProfileAwareExecutorServiceAdapter.access$getOwner$p(this.this$0));
                }
            }));
        }

        public /* synthetic */ ProfileAwareExecutorServiceAdapter(String string, ExecutorService executorService, WorkerExecutorFacade workerExecutorFacade, AnalyticsService analyticsService, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                workerExecutorFacade = null;
            }
            this(string, executorService, workerExecutorFacade, analyticsService);
        }

        @Nullable
        public final WorkerExecutorFacade getDelegate() {
            return this.delegate;
        }

        private final TaskProfilingRecord getTaskRecord() {
            Lazy lazy = this.taskRecord$delegate;
            return (TaskProfilingRecord)lazy.getValue();
        }

        protected void workerSubmission(@NotNull String workerKey) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)workerKey, (String)"workerKey");
                super.workerSubmission(workerKey);
                TaskProfilingRecord taskProfilingRecord = this.getTaskRecord();
                if (taskProfilingRecord == null) break block0;
                taskProfilingRecord.addWorker(workerKey, GradleBuildProfileSpan.ExecutionType.THREAD_EXECUTION);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void submit(@NotNull WorkerExecutorFacade.WorkAction action) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            String key = this.owner + action.getClass().getName() + action.hashCode();
            this.workerSubmission(key);
            Future<?> submission2 = this.getExecutor().submit(new Runnable(this, key, action){
                final /* synthetic */ ProfileAwareExecutorServiceAdapter this$0;
                final /* synthetic */ String $key;
                final /* synthetic */ WorkerExecutorFacade.WorkAction $action;
                {
                    this.this$0 = $receiver;
                    this.$key = $key;
                    this.$action = $action;
                }

                public final void run() {
                    ProfileAwareExecutorServiceAdapter.access$getAnalyticsService$p(this.this$0).workerStarted(ProfileAwareExecutorServiceAdapter.access$getOwner$p(this.this$0), this.$key);
                    this.$action.run();
                    ProfileAwareExecutorServiceAdapter.access$getAnalyticsService$p(this.this$0).workerFinished(ProfileAwareExecutorServiceAdapter.access$getOwner$p(this.this$0), this.$key);
                }
            });
            ProfileAwareExecutorServiceAdapter profileAwareExecutorServiceAdapter = this;
            synchronized (profileAwareExecutorServiceAdapter) {
                boolean bl = false;
                List list = this.getFutures();
                Intrinsics.checkNotNull(submission2);
                boolean bl2 = list.add(submission2);
            }
        }

        public static final /* synthetic */ AnalyticsService access$getAnalyticsService$p(ProfileAwareExecutorServiceAdapter $this) {
            return $this.analyticsService;
        }

        public static final /* synthetic */ String access$getOwner$p(ProfileAwareExecutorServiceAdapter $this) {
            return $this.owner;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/tasks/Workers$RunnableWrapperParams;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "<init>", "()V", "runnableAction", "Lorg/gradle/api/provider/Property;", "Ljava/lang/Runnable;", "getRunnableAction", "()Lorg/gradle/api/provider/Property;", "gradle-core"})
    public static abstract class RunnableWrapperParams
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract Property<Runnable> getRunnableAction();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/tasks/Workers$RunnableWrapperWorkAction;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/Workers$RunnableWrapperParams;", "<init>", "()V", "run", "", "gradle-core"})
    public static abstract class RunnableWrapperWorkAction
    extends ProfileAwareWorkAction<RunnableWrapperParams> {
        @Override
        public void run() {
            ((Runnable)((RunnableWrapperParams)this.getParameters()).getRunnableAction().get()).run();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u0004\u0018\u00010\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/tasks/Workers$WorkerExecutorAdapter;", "Lcom/android/ide/common/workers/WorkerExecutorFacade;", "projectPath", "", "owner", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "analyticsService", "Lorg/gradle/api/provider/Provider;", "Lcom/android/build/gradle/internal/profile/AnalyticsService;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/gradle/workers/WorkerExecutor;Lorg/gradle/api/provider/Provider;)V", "taskRecord", "Lcom/android/build/gradle/internal/profile/TaskProfilingRecord;", "getTaskRecord", "()Lcom/android/build/gradle/internal/profile/TaskProfilingRecord;", "taskRecord$delegate", "Lkotlin/Lazy;", "submit", "", "action", "Lcom/android/ide/common/workers/WorkerExecutorFacade$WorkAction;", "await", "close", "gradle-core"})
    private static final class WorkerExecutorAdapter
    implements WorkerExecutorFacade {
        @NotNull
        private final String projectPath;
        @NotNull
        private final String owner;
        @NotNull
        private final WorkerExecutor workerExecutor;
        @NotNull
        private final Provider<AnalyticsService> analyticsService;
        @NotNull
        private final Lazy taskRecord$delegate;

        public WorkerExecutorAdapter(@NotNull String projectPath, @NotNull String owner, @NotNull WorkerExecutor workerExecutor, @NotNull Provider<AnalyticsService> analyticsService) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
            Intrinsics.checkNotNullParameter(analyticsService, (String)"analyticsService");
            this.projectPath = projectPath;
            this.owner = owner;
            this.workerExecutor = workerExecutor;
            this.analyticsService = analyticsService;
            this.taskRecord$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TaskProfilingRecord>(this){
                final /* synthetic */ WorkerExecutorAdapter this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final TaskProfilingRecord invoke() {
                    return ((AnalyticsService)WorkerExecutorAdapter.access$getAnalyticsService$p(this.this$0).get()).getTaskRecord(WorkerExecutorAdapter.access$getOwner$p(this.this$0));
                }
            }));
        }

        @Nullable
        public final TaskProfilingRecord getTaskRecord() {
            Lazy lazy = this.taskRecord$delegate;
            return (TaskProfilingRecord)lazy.getValue();
        }

        public void submit(@NotNull WorkerExecutorFacade.WorkAction action) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            String workerKey = this.owner + action.getClass().getName() + action.hashCode();
            TaskProfilingRecord taskProfilingRecord = this.getTaskRecord();
            if (taskProfilingRecord != null) {
                taskProfilingRecord.addWorker(workerKey, GradleBuildProfileSpan.ExecutionType.WORKER_EXECUTION);
            }
            Function1 function1 = (Function1)new Function1<RunnableWrapperParams, Unit>(this, workerKey, action){
                final /* synthetic */ WorkerExecutorAdapter this$0;
                final /* synthetic */ String $workerKey;
                final /* synthetic */ WorkerExecutorFacade.WorkAction $action;
                {
                    this.this$0 = $receiver;
                    this.$workerKey = $workerKey;
                    this.$action = $action;
                    super(1);
                }

                public final void invoke(RunnableWrapperParams params) {
                    Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                    params.getProjectPath().set((Object)WorkerExecutorAdapter.access$getProjectPath$p(this.this$0));
                    params.getTaskOwner().set((Object)WorkerExecutorAdapter.access$getOwner$p(this.this$0));
                    params.getWorkerKey().set((Object)this.$workerKey);
                    params.getRunnableAction().set((Object)this.$action);
                    params.getAnalyticsService().set(WorkerExecutorAdapter.access$getAnalyticsService$p(this.this$0));
                }
            };
            this.workerExecutor.noIsolation().submit(RunnableWrapperWorkAction.class, new Action(function1){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ void execute(Object p0) {
                    this.function.invoke(p0);
                }
            });
        }

        public void await() {
            try {
                TaskProfilingRecord taskProfilingRecord = this.getTaskRecord();
                if (taskProfilingRecord != null) {
                    taskProfilingRecord.setTaskWaiting();
                }
                this.workerExecutor.await();
            }
            catch (WorkerExecutionException e) {
                List list = e.getCauses();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCauses(...)");
                throw new WorkerExecutorException((Iterable)list);
            }
        }

        public void close() {
        }

        public static final /* synthetic */ String access$getProjectPath$p(WorkerExecutorAdapter $this) {
            return $this.projectPath;
        }

        public static final /* synthetic */ String access$getOwner$p(WorkerExecutorAdapter $this) {
            return $this.owner;
        }

        public static final /* synthetic */ Provider access$getAnalyticsService$p(WorkerExecutorAdapter $this) {
            return $this.analyticsService;
        }
    }
}

