/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.jar.CoreJarVirtualFile;
import com.intellij.openapi.vfs.local.CoreLocalVirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;

public class MessageUtil {
    private MessageUtil() {
    }

    @Nullable
    public static CompilerMessageLocation psiElementToMessageLocation(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile file2 = element.getContainingFile();
        return MessageUtil.psiFileToMessageLocation(file2, "<no path>", DiagnosticUtils.getLineAndColumnInPsiFile(file2, element.getTextRange()));
    }

    @Nullable
    public static CompilerMessageLocation psiFileToMessageLocation(@NotNull PsiFile file2, @Nullable String defaultValue2, @NotNull PsiDiagnosticUtils.LineAndColumn lineAndColumn) {
        VirtualFile virtualFile2;
        if (file2 == null) {
            MessageUtil.$$$reportNull$$$2(0);
        }
        if (lineAndColumn == null) {
            MessageUtil.$$$reportNull$$$2(1);
        }
        if (file2 == null) {
            MessageUtil.$$$reportNull$$$1(0);
        }
        if (lineAndColumn == null) {
            MessageUtil.$$$reportNull$$$1(1);
        }
        if (file2 == null) {
            MessageUtil.$$$reportNull$$$0(0);
        }
        if (lineAndColumn == null) {
            MessageUtil.$$$reportNull$$$0(1);
        }
        String path2 = (virtualFile2 = file2.getVirtualFile()) != null ? MessageUtil.virtualFileToPath(virtualFile2) : defaultValue2;
        return CompilerMessageLocation.create(path2, lineAndColumn.getLine(), lineAndColumn.getColumn(), lineAndColumn.getLineContent());
    }

    @NotNull
    public static String virtualFileToPath(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            MessageUtil.$$$reportNull$$$2(2);
        }
        if (virtualFile2 == null) {
            MessageUtil.$$$reportNull$$$1(2);
        }
        if (virtualFile2 == null) {
            MessageUtil.$$$reportNull$$$0(2);
        }
        if (virtualFile2 instanceof CoreLocalVirtualFile || virtualFile2 instanceof CoreJarVirtualFile) {
            String string = FileUtil.toSystemDependentName((String)virtualFile2.getPath());
            if (string == null) {
                MessageUtil.$$$reportNull$$$0(3);
            }
            if (string == null) {
                MessageUtil.$$$reportNull$$$1(3);
            }
            if (string == null) {
                MessageUtil.$$$reportNull$$$2(3);
            }
            return string;
        }
        String string = virtualFile2.getPath();
        if (string == null) {
            MessageUtil.$$$reportNull$$$0(4);
        }
        if (string == null) {
            MessageUtil.$$$reportNull$$$1(4);
        }
        if (string == null) {
            MessageUtil.$$$reportNull$$$2(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineAndColumn";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/common/messages/MessageUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/common/messages/MessageUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "virtualFileToPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "psiFileToMessageLocation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "virtualFileToPath";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineAndColumn";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/common/messages/MessageUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/common/messages/MessageUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "virtualFileToPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "psiFileToMessageLocation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "virtualFileToPath";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$2(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineAndColumn";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/common/messages/MessageUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/common/messages/MessageUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "virtualFileToPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "psiFileToMessageLocation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "virtualFileToPath";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

