/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclarationKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationWithBody;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirRegularClassKt;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.resolve.FirProvider;
import org.jetbrains.kotlin.fir.resolve.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformerWithSuperTypes;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSpecificTypeResolverTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSupertypeResolverTransformerKt;
import org.jetbrains.kotlin.fir.scopes.FirPosition;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.ScopesKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirErrorTypeRefImpl;
import org.jetbrains.kotlin.fir.visitors.CompositeTransformResult;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J \u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J \u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSupertypeResolverTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "()V", "currentlyComputing", "", "Lorg/jetbrains/kotlin/name/ClassId;", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "firSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "fullyComputed", "resolveSupertypesOrExpansions", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "classLikeDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "transformDeclarationWithBody", "Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "declarationWithBody", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationWithBody;", "data", "", "transformFile", "transformProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "transformRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "transformTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "ResolveSuperTypesTask", "resolve"})
public final class FirSupertypeResolverTransformer
extends FirAbstractTreeTransformer {
    private FirSession firSession;
    private final Set<ClassId> currentlyComputing;
    private final Set<ClassId> fullyComputed;
    private FirFile file;

    @NotNull
    public CompositeTransformResult<FirFile> transformFile(@NotNull FirFile file2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        this.firSession = file2.getFileSession();
        this.file = file2;
        return super.transformFile(file2, data);
    }

    @NotNull
    public CompositeTransformResult<FirDeclaration> transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Void data) {
        FirRegularClass firRegularClass;
        Intrinsics.checkParameterIsNotNull((Object)regularClass, (String)"regularClass");
        FirDeclaration firDeclaration = this.resolveSupertypesOrExpansions(regularClass);
        if (!(firDeclaration instanceof FirRegularClass)) {
            firDeclaration = null;
        }
        if ((firRegularClass = (FirRegularClass)firDeclaration) == null) {
            firRegularClass = regularClass;
        }
        FirRegularClass transformedClass = firRegularClass;
        return super.transformRegularClass(transformedClass, data);
    }

    @NotNull
    public CompositeTransformResult<FirDeclaration> transformTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)typeAlias, (String)"typeAlias");
        FirElement $this$compose$iv = this.resolveSupertypesOrExpansions(typeAlias);
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    @NotNull
    public CompositeTransformResult<FirDeclaration> transformDeclarationWithBody(@NotNull FirDeclarationWithBody declarationWithBody, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declarationWithBody, (String)"declarationWithBody");
        FirElement $this$compose$iv = declarationWithBody;
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    @NotNull
    public CompositeTransformResult<FirDeclaration> transformProperty(@NotNull FirProperty property, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        FirElement $this$compose$iv = property;
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    private final FirDeclaration resolveSupertypesOrExpansions(FirClassLikeDeclaration<?> classLikeDeclaration) {
        ClassId classId = classLikeDeclaration.getSymbol().getClassId();
        if (this.fullyComputed.contains(classId)) {
            return classLikeDeclaration;
        }
        FirSession firSession = this.firSession;
        if (firSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"firSession");
        }
        FirFile firFile = this.file;
        if (firFile == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"file");
        }
        ResolveSuperTypesTask visitor2 = new ResolveSuperTypesTask(firSession, classId, firFile, this.currentlyComputing, this.fullyComputed, classLikeDeclaration);
        FirFile firFile2 = this.file;
        if (firFile2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"file");
        }
        ((CompositeTransformResult)firFile2.accept(visitor2, null)).getSingle();
        return visitor2.getResultingClass();
    }

    public FirSupertypeResolverTransformer() {
        Set set;
        FirSupertypeResolverTransformer firSupertypeResolverTransformer = this;
        boolean bl = false;
        firSupertypeResolverTransformer.currentlyComputing = set = (Set)new LinkedHashSet();
        firSupertypeResolverTransformer = this;
        bl = false;
        firSupertypeResolverTransformer.fullyComputed = set = (Set)new LinkedHashSet();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J \u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J \u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a2\u0006\u0010!\u001a\u00020\"2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010#\u001a\u00020$*\u0006\u0012\u0002\b\u00030\fH\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSupertypeResolverTransformer$ResolveSuperTypesTask;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformerWithSuperTypes;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "requestedClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "currentlyComputing", "", "fullyComputed", "knownFirClassLikeDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/fir/declarations/FirFile;Ljava/util/Set;Ljava/util/Set;Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;)V", "resultingClass", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getResultingClass", "()Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "setResultingClass", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "resolveLoops", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "classId", "resolvedTypesRefs", "resolveNestedClassesSupertypes", "Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "data", "", "transformRegularClass", "transformTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "matchesRequestedDeclaration", "", "resolve"})
    private static final class ResolveSuperTypesTask
    extends FirAbstractTreeTransformerWithSuperTypes {
        @NotNull
        public FirDeclaration resultingClass;
        private final FirSession session;
        private final ClassId requestedClassId;
        private final Set<ClassId> currentlyComputing;
        private final Set<ClassId> fullyComputed;
        private final FirClassLikeDeclaration<?> knownFirClassLikeDeclaration;

        @NotNull
        public final FirDeclaration getResultingClass() {
            FirDeclaration firDeclaration = this.resultingClass;
            if (firDeclaration == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"resultingClass");
            }
            return firDeclaration;
        }

        public final void setResultingClass(@NotNull FirDeclaration firDeclaration) {
            Intrinsics.checkParameterIsNotNull((Object)firDeclaration, (String)"<set-?>");
            this.resultingClass = firDeclaration;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public CompositeTransformResult<FirDeclaration> transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Void data) {
            FirRegularClass firRegularClass;
            Intrinsics.checkParameterIsNotNull((Object)regularClass, (String)"regularClass");
            ClassId classId = FirRegularClassKt.getClassId(regularClass);
            if (!FirSupertypeResolverTransformerKt.access$isOuterClass(classId, this.requestedClassId)) {
                FirElement $this$compose$iv = regularClass;
                boolean $i$f$compose = false;
                return CompositeTransformResult.Companion.single($this$compose$iv);
            }
            ResolveSuperTypesTask this_$iv = this;
            boolean $i$f$withScopeCleanup = false;
            int sizeBefore$iv = FirAbstractTreeTransformerWithSuperTypes.access$getTowerScope$p(this_$iv).getScopes().size();
            boolean bl = false;
            if (this.fullyComputed.contains(classId)) {
                firRegularClass = regularClass;
            } else {
                void $this$mapTo$iv$iv;
                this.addTypeParametersScope(regularClass);
                FirSpecificTypeResolverTransformer transformer = new FirSpecificTypeResolverTransformer(this.getTowerScope(), FirPosition.SUPER_TYPE_OR_EXPANSION, this.session);
                Iterable $this$map$iv = regularClass.getSuperTypeRefs();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FirTypeRef firTypeRef = (FirTypeRef)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    FirTypeRef firTypeRef2 = transformer.transformTypeRef((FirTypeRef)it, data).getSingle();
                    collection.add(firTypeRef2);
                }
                List resolvedTypesRefs = (List)destination$iv$iv;
                List resultingTypeRefs = this.resolveLoops(classId, resolvedTypesRefs);
                firRegularClass = regularClass.replaceSupertypes(resultingTypeRefs);
            }
            FirRegularClass result$iv = firRegularClass;
            int size$iv = FirAbstractTreeTransformerWithSuperTypes.access$getTowerScope$p(this_$iv).getScopes().size();
            int n = size$iv >= sizeBefore$iv ? 1 : 0;
            boolean bl3 = false;
            int n2 = 0;
            if (_Assertions.ENABLED && n == 0) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            n = size$iv - sizeBefore$iv;
            bl3 = false;
            n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it$iv = n2++;
                boolean bl5 = false;
                List<FirScope> list2 = FirAbstractTreeTransformerWithSuperTypes.access$getTowerScope$p(this_$iv).getScopes();
                boolean bl6 = false;
                boolean bl7 = false;
                List<FirScope> it$iv2 = list2;
                boolean bl8 = false;
                it$iv2.remove(it$iv2.size() - 1);
            }
            FirRegularClass transformedClass = result$iv;
            if (this.matchesRequestedDeclaration(regularClass)) {
                this.resultingClass = transformedClass;
                FirElement $this$compose$iv = transformedClass;
                boolean $i$f$compose = false;
                return CompositeTransformResult.Companion.single($this$compose$iv);
            }
            return this.resolveNestedClassesSupertypes(transformedClass, data);
        }

        private final boolean matchesRequestedDeclaration(@NotNull FirClassLikeDeclaration<?> $this$matchesRequestedDeclaration) {
            if (this.knownFirClassLikeDeclaration != null) {
                return Intrinsics.areEqual(this.knownFirClassLikeDeclaration, $this$matchesRequestedDeclaration);
            }
            return Intrinsics.areEqual((Object)$this$matchesRequestedDeclaration.getSymbol().getClassId(), (Object)this.requestedClassId);
        }

        @NotNull
        public CompositeTransformResult<FirDeclaration> transformTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)typeAlias, (String)"typeAlias");
            ClassId classId = typeAlias.getSymbol().getClassId();
            if (this.fullyComputed.contains(classId) || !this.matchesRequestedDeclaration(typeAlias)) {
                FirElement $this$compose$iv = typeAlias;
                boolean $i$f$compose = false;
                return CompositeTransformResult.Companion.single($this$compose$iv);
            }
            ResolveSuperTypesTask this_$iv = this;
            boolean $i$f$withScopeCleanup = false;
            int sizeBefore$iv = FirAbstractTreeTransformerWithSuperTypes.access$getTowerScope$p(this_$iv).getScopes().size();
            boolean bl = false;
            this.addTypeParametersScope(typeAlias);
            FirSpecificTypeResolverTransformer transformer = new FirSpecificTypeResolverTransformer(this.getTowerScope(), FirPosition.SUPER_TYPE_OR_EXPANSION, this.session);
            FirTypeRef resolvedTypesRef = transformer.transformTypeRef(typeAlias.getExpandedTypeRef(), data).getSingle();
            FirTypeRef resultingTypeRef = (FirTypeRef)CollectionsKt.firstOrNull((List)this.resolveLoops(classId, CollectionsKt.listOf((Object)resolvedTypesRef)));
            FirTypeRef firTypeRef = resultingTypeRef;
            if (firTypeRef == null) {
                firTypeRef = resolvedTypesRef;
            }
            FirTypeAlias firTypeAlias = typeAlias.replaceExpandTypeRef(firTypeRef);
            boolean bl2 = false;
            boolean bl3 = false;
            FirTypeAlias it = firTypeAlias;
            boolean bl4 = false;
            this.setResultingClass(it);
            FirTypeAlias result$iv = firTypeAlias;
            int size$iv = FirAbstractTreeTransformerWithSuperTypes.access$getTowerScope$p(this_$iv).getScopes().size();
            int n = size$iv >= sizeBefore$iv ? 1 : 0;
            boolean bl5 = false;
            int n2 = 0;
            if (_Assertions.ENABLED && n == 0) {
                boolean bl6 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            n = size$iv - sizeBefore$iv;
            bl5 = false;
            n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it$iv = n2++;
                boolean bl7 = false;
                List<FirScope> list2 = FirAbstractTreeTransformerWithSuperTypes.access$getTowerScope$p(this_$iv).getScopes();
                boolean bl8 = false;
                boolean bl9 = false;
                List<FirScope> it$iv2 = list2;
                boolean bl10 = false;
                it$iv2.remove(it$iv2.size() - 1);
            }
            FirElement $this$compose$iv = result$iv;
            boolean $i$f$compose = false;
            return CompositeTransformResult.Companion.single($this$compose$iv);
        }

        /*
         * WARNING - void declaration
         */
        private final List<FirTypeRef> resolveLoops(ClassId classId, List<? extends FirTypeRef> resolvedTypesRefs) {
            this.currentlyComputing.add(classId);
            boolean bl = false;
            List resultingTypeRefs = new ArrayList();
            Iterator<? extends FirTypeRef> iterator2 = resolvedTypesRefs.iterator();
            while (iterator2.hasNext()) {
                FirTypeRef superTypeRef;
                block17: {
                    FirSession sessionForSupertype;
                    ClassId superTypeClassId;
                    block16: {
                        boolean bl2;
                        block15: {
                            FirClassLikeDeclaration<?> firClassForSupertype;
                            boolean bl3;
                            block14: {
                                void $this$any$iv;
                                ConeClassLikeType resolvedType;
                                FirTypeRef $this$coneTypeSafe$iv = superTypeRef = iterator2.next();
                                boolean $i$f$coneTypeSafe22 = false;
                                FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
                                if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                                    firTypeRef = null;
                                }
                                FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
                                ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                                if (!(coneKotlinType instanceof ConeClassLikeType)) {
                                    coneKotlinType = null;
                                }
                                if ((ConeClassLikeType)coneKotlinType == null) {
                                    continue;
                                }
                                superTypeClassId = resolvedType.getLookupTag().getClassId();
                                Sequence $i$f$coneTypeSafe22 = FirSupertypeResolverTransformerKt.access$outerClasses(superTypeClassId);
                                Set<ClassId> set = this.currentlyComputing;
                                boolean $i$f$any = false;
                                for (Object element$iv : $this$any$iv) {
                                    ClassId p1 = (ClassId)element$iv;
                                    boolean bl4 = false;
                                    if (!set.contains(p1)) continue;
                                    bl3 = true;
                                    break block14;
                                }
                                bl3 = false;
                            }
                            if (bl3) {
                                resultingTypeRefs.add(new FirErrorTypeRefImpl(this.session, superTypeRef.getPsi(), "Recursion detected: " + FirRendererKt.render(superTypeRef)));
                                continue;
                            }
                            if (((FirSymbolProvider)this.session.getService(Reflection.getOrCreateKotlinClass(FirSymbolProvider.class))).getSessionForClass(superTypeClassId) == null) {
                                continue;
                            }
                            FirClassLikeSymbol<?> firClassLikeSymbol = ((FirSymbolProvider)sessionForSupertype.getService(Reflection.getOrCreateKotlinClass(FirSymbolProvider.class))).getClassLikeSymbolByFqName(superTypeClassId);
                            FirClassLikeDeclaration<Object> firClassLikeDeclaration = firClassForSupertype = firClassLikeSymbol != null ? FirClassLikeDeclarationKt.toFirClassLike(firClassLikeSymbol) : null;
                            if (firClassForSupertype == null) break block16;
                            if (!(firClassForSupertype instanceof FirClass)) break block17;
                            Iterable $this$any$iv = ((FirClass)((Object)firClassForSupertype)).getSuperTypeRefs();
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    FirTypeRef it = (FirTypeRef)element$iv;
                                    boolean bl5 = false;
                                    if (!(!(it instanceof FirResolvedTypeRef))) continue;
                                    bl2 = true;
                                    break block15;
                                }
                                bl2 = false;
                            }
                        }
                        if (!bl2) break block17;
                    }
                    FirProvider provider = (FirProvider)sessionForSupertype.getService(Reflection.getOrCreateKotlinClass(FirProvider.class));
                    FirFile firForSuperClassFile = provider.getFirClassifierContainerFile(superTypeClassId);
                    new ResolveSuperTypesTask(sessionForSupertype, superTypeClassId, firForSuperClassFile, this.currentlyComputing, this.fullyComputed, null, 32, null).transformFile(firForSuperClassFile, null);
                }
                resultingTypeRefs.add(superTypeRef);
            }
            this.fullyComputed.add(classId);
            this.currentlyComputing.remove(classId);
            return resultingTypeRefs;
        }

        /*
         * WARNING - void declaration
         */
        private final CompositeTransformResult<FirDeclaration> resolveNestedClassesSupertypes(FirRegularClass regularClass, Void data) {
            void $this$filterTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            void $this$mapTo$iv;
            ResolveSuperTypesTask this_$iv = this;
            boolean $i$f$withScopeCleanup = false;
            int sizeBefore$iv = FirAbstractTreeTransformerWithSuperTypes.access$getTowerScope$p(this_$iv).getScopes().size();
            boolean bl = false;
            FirProvider firProvider = FirProvider.Companion.getInstance(this.session);
            ClassId classId = regularClass.getSymbol().getClassId();
            Iterable iterable = CollectionsKt.asReversed(SupertypeUtilsKt.lookupSuperTypes(regularClass, false, true, this.session));
            Collection destination$iv = this.getTowerScope().getScopes();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                ConeClassLikeType coneClassLikeType = (ConeClassLikeType)item$iv;
                Collection collection = destination$iv;
                boolean bl2 = false;
                FirNestedClassifierScope firNestedClassifierScope = new FirNestedClassifierScope(it.getLookupTag().getClassId(), FirSymbolProvider.Companion.getInstance(this.session));
                collection.add(firNestedClassifierScope);
            }
            Iterable $this$filterIsInstance$iv = regularClass.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Object object = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FirRegularClass)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FirRegularClass it = (FirRegularClass)element$iv$iv;
                boolean bl3 = false;
                if (!it.isCompanion()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List companionObjects = (List)destination$iv$iv;
            for (FirRegularClass companionObject : companionObjects) {
                object = this.getTowerScope().getScopes();
                FirNestedClassifierScope firNestedClassifierScope = new FirNestedClassifierScope(companionObject.getSymbol().getClassId(), firProvider);
                boolean bl4 = false;
                object.add(firNestedClassifierScope);
            }
            Collection collection = this.getTowerScope().getScopes();
            FirNestedClassifierScope firNestedClassifierScope = new FirNestedClassifierScope(classId, firProvider);
            boolean bl5 = false;
            collection.add(firNestedClassifierScope);
            this.addTypeParametersScope(regularClass);
            CompositeTransformResult result$iv = ResolveSuperTypesTask.super.transformRegularClass(regularClass, data);
            int size$iv = FirAbstractTreeTransformerWithSuperTypes.access$getTowerScope$p(this_$iv).getScopes().size();
            int n = size$iv >= sizeBefore$iv ? 1 : 0;
            boolean bl6 = false;
            int n2 = 0;
            if (_Assertions.ENABLED && n == 0) {
                boolean bl7 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            n = size$iv - sizeBefore$iv;
            bl6 = false;
            n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it$iv = n2++;
                boolean bl8 = false;
                List<FirScope> list2 = FirAbstractTreeTransformerWithSuperTypes.access$getTowerScope$p(this_$iv).getScopes();
                boolean bl9 = false;
                boolean bl10 = false;
                List<FirScope> it$iv2 = list2;
                boolean bl11 = false;
                it$iv2.remove(it$iv2.size() - 1);
            }
            return result$iv;
        }

        public ResolveSuperTypesTask(@NotNull FirSession session, @NotNull ClassId requestedClassId, @NotNull FirFile file2, @NotNull Set<ClassId> currentlyComputing, @NotNull Set<ClassId> fullyComputed, @Nullable FirClassLikeDeclaration<?> knownFirClassLikeDeclaration) {
            Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
            Intrinsics.checkParameterIsNotNull((Object)requestedClassId, (String)"requestedClassId");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull(currentlyComputing, (String)"currentlyComputing");
            Intrinsics.checkParameterIsNotNull(fullyComputed, (String)"fullyComputed");
            super(true);
            this.session = session;
            this.requestedClassId = requestedClassId;
            this.currentlyComputing = currentlyComputing;
            this.fullyComputed = fullyComputed;
            this.knownFirClassLikeDeclaration = knownFirClassLikeDeclaration;
            ScopesKt.addImportingScopes(this.getTowerScope(), file2, this.session);
        }

        public /* synthetic */ ResolveSuperTypesTask(FirSession firSession, ClassId classId, FirFile firFile, Set set, Set set2, FirClassLikeDeclaration firClassLikeDeclaration, int n, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n & 0x20) != 0) {
                firClassLikeDeclaration = null;
            }
            this(firSession, classId, firFile, set, set2, firClassLikeDeclaration);
        }
    }
}

