/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.konan.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.konan.diagnostics.ErrorsNative;
import org.jetbrains.kotlin.resolve.konan.diagnostics.NativeObjCRefinementChecker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010*\u00020\fH\u0002J\u001c\u0010\u0012\u001a\u00020\b*\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0011H\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeObjCRefinementAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "supportedTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "[Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "findRefinesAnnotations", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "reportInvalidAnnotationTargets", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "annotation", "frontend.native"})
@SourceDebugExtension(value={"SMAP\nNativeObjCRefinementAnnotationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeObjCRefinementAnnotationChecker.kt\norg/jetbrains/kotlin/resolve/konan/diagnostics/NativeObjCRefinementAnnotationChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public final class NativeObjCRefinementAnnotationChecker
implements DeclarationChecker {
    @NotNull
    public static final NativeObjCRefinementAnnotationChecker INSTANCE = new NativeObjCRefinementAnnotationChecker();
    @NotNull
    private static final KotlinTarget[] supportedTargets;

    private NativeObjCRefinementAnnotationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        block5: {
            AnnotationDescriptor it;
            Set<KotlinTarget> targets;
            Set unsupportedTargets;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (!(descriptor2 instanceof ClassDescriptor) || ((ClassDescriptor)descriptor2).getKind() != ClassKind.ANNOTATION_CLASS) {
                return;
            }
            Pair<AnnotationDescriptor, AnnotationDescriptor> pair = this.findRefinesAnnotations(descriptor2);
            AnnotationDescriptor objCAnnotation = (AnnotationDescriptor)pair.component1();
            AnnotationDescriptor swiftAnnotation = (AnnotationDescriptor)pair.component2();
            if (objCAnnotation == null && swiftAnnotation == null) {
                return;
            }
            if (objCAnnotation != null && swiftAnnotation != null) {
                KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(swiftAnnotation);
                KtElement reportLocation = ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration;
                context.getTrace().report(ErrorsNative.REDUNDANT_SWIFT_REFINEMENT.on((KtElement)((PsiElement)reportLocation)));
            }
            if (!(!((Collection)(unsupportedTargets = SetsKt.minus(targets = AnnotationChecker.Companion.applicableTargetSet((ClassDescriptor)descriptor2), (Object[])supportedTargets))).isEmpty())) break block5;
            AnnotationDescriptor annotationDescriptor = objCAnnotation;
            if (annotationDescriptor != null) {
                it = annotationDescriptor;
                boolean bl = false;
                INSTANCE.reportInvalidAnnotationTargets(context.getTrace(), declaration, it);
            }
            AnnotationDescriptor annotationDescriptor2 = swiftAnnotation;
            if (annotationDescriptor2 != null) {
                it = annotationDescriptor2;
                boolean bl = false;
                INSTANCE.reportInvalidAnnotationTargets(context.getTrace(), declaration, it);
            }
        }
    }

    private final Pair<AnnotationDescriptor, AnnotationDescriptor> findRefinesAnnotations(DeclarationDescriptor $this$findRefinesAnnotations) {
        AnnotationDescriptor objCAnnotation = null;
        AnnotationDescriptor swiftAnnotation = null;
        for (AnnotationDescriptor annotation2 : $this$findRefinesAnnotations.getAnnotations()) {
            FqName fqName2 = annotation2.getFqName();
            if (Intrinsics.areEqual((Object)fqName2, (Object)NativeObjCRefinementChecker.INSTANCE.getHidesFromObjCFqName())) {
                objCAnnotation = annotation2;
            } else if (Intrinsics.areEqual((Object)fqName2, (Object)NativeObjCRefinementChecker.INSTANCE.getRefinesInSwiftFqName())) {
                swiftAnnotation = annotation2;
            }
            if (objCAnnotation == null || swiftAnnotation == null) continue;
            break;
        }
        return TuplesKt.to(objCAnnotation, swiftAnnotation);
    }

    private final void reportInvalidAnnotationTargets(BindingTrace $this$reportInvalidAnnotationTargets, KtDeclaration declaration, AnnotationDescriptor annotation2) {
        KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotation2);
        KtElement reportLocation = ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration;
        $this$reportInvalidAnnotationTargets.report(ErrorsNative.INVALID_OBJC_REFINEMENT_TARGETS.on((KtElement)((PsiElement)reportLocation)));
    }

    static {
        KotlinTarget[] kotlinTargetArray = new KotlinTarget[]{KotlinTarget.FUNCTION, KotlinTarget.PROPERTY, KotlinTarget.CLASS};
        supportedTargets = kotlinTargetArray;
    }
}

