/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractTerminal;
import org.jline.utils.NonBlockingReader;

public class DumbTerminal
extends AbstractTerminal {
    private final InputStream input;
    private final OutputStream output;
    private final NonBlockingReader reader;
    private final PrintWriter writer;
    private final Attributes attributes;
    private final Size size;

    public DumbTerminal(InputStream in, OutputStream out) throws IOException {
        this("dumb", "dumb", in, out, Charset.defaultCharset().name());
    }

    public DumbTerminal(String name2, String type2, InputStream in, OutputStream out, String encoding) throws IOException {
        this(name2, type2, in, out, encoding, Terminal.SignalHandler.SIG_DFL);
    }

    public DumbTerminal(String name2, String type2, final InputStream in, OutputStream out, String encoding, Terminal.SignalHandler signalHandler) throws IOException {
        super(name2, type2, signalHandler);
        this.input = new InputStream(){

            @Override
            public int read() throws IOException {
                int c;
                block9: {
                    block8: {
                        while (true) {
                            c = in.read();
                            if (DumbTerminal.this.attributes.getLocalFlag(Attributes.LocalFlag.ISIG)) {
                                if (c == DumbTerminal.this.attributes.getControlChar(Attributes.ControlChar.VINTR)) {
                                    DumbTerminal.this.raise(Terminal.Signal.INT);
                                    continue;
                                }
                                if (c == DumbTerminal.this.attributes.getControlChar(Attributes.ControlChar.VQUIT)) {
                                    DumbTerminal.this.raise(Terminal.Signal.QUIT);
                                    continue;
                                }
                                if (c == DumbTerminal.this.attributes.getControlChar(Attributes.ControlChar.VSUSP)) {
                                    DumbTerminal.this.raise(Terminal.Signal.TSTP);
                                    continue;
                                }
                                if (c == DumbTerminal.this.attributes.getControlChar(Attributes.ControlChar.VSTATUS)) {
                                    DumbTerminal.this.raise(Terminal.Signal.INFO);
                                    continue;
                                }
                            }
                            if (c != 13) break block8;
                            if (!DumbTerminal.this.attributes.getInputFlag(Attributes.InputFlag.IGNCR)) break;
                        }
                        if (DumbTerminal.this.attributes.getInputFlag(Attributes.InputFlag.ICRNL)) {
                            c = 10;
                        }
                        break block9;
                    }
                    if (c == 10 && DumbTerminal.this.attributes.getInputFlag(Attributes.InputFlag.INLCR)) {
                        c = 13;
                    }
                }
                return c;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (b == null) {
                    throw new NullPointerException();
                }
                if (off < 0 || len < 0 || len > b.length - off) {
                    throw new IndexOutOfBoundsException();
                }
                if (len == 0) {
                    return 0;
                }
                int c = this.read();
                if (c == -1) {
                    return -1;
                }
                b[off] = (byte)c;
                return 1;
            }
        };
        this.output = out;
        this.reader = new NonBlockingReader(this.getName(), new InputStreamReader(this.input, encoding));
        this.writer = new PrintWriter(new OutputStreamWriter(this.output, encoding));
        this.attributes = new Attributes();
        this.attributes.setControlChar(Attributes.ControlChar.VERASE, 127);
        this.attributes.setControlChar(Attributes.ControlChar.VWERASE, 23);
        this.attributes.setControlChar(Attributes.ControlChar.VKILL, 21);
        this.attributes.setControlChar(Attributes.ControlChar.VLNEXT, 22);
        this.size = new Size();
        this.parseInfoCmp();
    }

    @Override
    public NonBlockingReader reader() {
        return this.reader;
    }

    @Override
    public PrintWriter writer() {
        return this.writer;
    }

    @Override
    public InputStream input() {
        return this.input;
    }

    @Override
    public OutputStream output() {
        return this.output;
    }

    @Override
    public Attributes getAttributes() {
        Attributes attr = new Attributes();
        attr.copy(this.attributes);
        return attr;
    }

    @Override
    public void setAttributes(Attributes attr) {
        this.attributes.copy(attr);
    }

    @Override
    public Size getSize() {
        Size sz = new Size();
        sz.copy(this.size);
        return sz;
    }

    @Override
    public void setSize(Size sz) {
        this.size.copy(sz);
    }

    @Override
    public void close() throws IOException {
    }
}

