// Copyright 2000-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package org.jetbrains.uast.java

import com.intellij.openapi.util.registry.Registry
import com.intellij.psi.*
import com.intellij.psi.impl.source.PsiExtensibleClass
import com.intellij.psi.javadoc.PsiDocComment
import com.intellij.psi.javadoc.PsiDocToken
import org.jetbrains.uast.*
import org.jetbrains.uast.expressions.UInjectionHost
import org.jetbrains.uast.psi.UElementWithLocation
import org.jetbrains.uast.util.ClassSet
import org.jetbrains.uast.util.classSetOf
import org.jetbrains.uast.util.emptyClassSet


private val checkCanConvert = Registry.`is`("uast.java.use.psi.type.precheck")

internal fun canConvert(psiCls: Class<out PsiElement>, targets: Array<out Class<out UElement>>): Boolean {
  if (!checkCanConvert) return true

  if (targets.size == 1) {
    // checking the most popular cases before looking up in hashtable
    when (targets.single()) {
      UElement::class.java -> return uElementClassSet.contains(psiCls)
      UInjectionHost::class.java -> return uInjectionHostClassSet.contains(psiCls)
      UCallExpression::class.java -> return uCallClassSet.contains(psiCls)
    }
  }

  return targets.any { getPossibleSourceTypes(it).contains(psiCls) }
}

internal fun getPossibleSourceTypes(uastType: Class<out UElement>) =
  possibleSourceTypes[uastType] ?: emptyClassSet()

/**
 * For every [UElement] subtype states from which [PsiElement] subtypes it can be obtained.
 *
 * This map is machine generated by `JavaUastMappingsAccountantOverLargeProjectTest`
 */
@Suppress("DEPRECATION")
private val possibleSourceTypes = mapOf<Class<*>, ClassSet<PsiElement>>(
  UAnchorOwner::class.java to classSetOf<PsiElement>(
    PsiAnnotation::class.java,
    PsiAnnotationMethod::class.java,
    PsiAnonymousClass::class.java,
    PsiClassInitializer::class.java,
    PsiEnumConstant::class.java,
    PsiEnumConstantInitializer::class.java,
    PsiExtensibleClass::class.java,
    PsiField::class.java,
    PsiLocalVariable::class.java,
    PsiMethod::class.java,
    PsiParameter::class.java,
    PsiPatternVariable::class.java,
    PsiResourceVariable::class.java,
    PsiTypeParameter::class.java
  ),
  UAnnotated::class.java to classSetOf<PsiElement>(
    PsiAnnotatedJavaCodeReferenceElement::class.java,
    PsiAnnotation::class.java,
    PsiAnnotationMethod::class.java,
    PsiAnonymousClass::class.java,
    PsiArrayAccessExpression::class.java,
    PsiArrayInitializerExpression::class.java,
    PsiArrayInitializerMemberValue::class.java,
    PsiAssertStatement::class.java,
    PsiAssignmentExpression::class.java,
    PsiBinaryExpression::class.java,
    PsiBlockStatement::class.java,
    PsiBreakStatement::class.java,
    PsiClassInitializer::class.java,
    PsiClassObjectAccessExpression::class.java,
    PsiCodeBlock::class.java,
    PsiConditionalExpression::class.java,
    PsiContinueStatement::class.java,
    PsiDeclarationStatement::class.java,
    PsiDoWhileStatement::class.java,
    PsiDocToken::class.java,
    PsiEmptyStatement::class.java,
    PsiEnumConstant::class.java,
    PsiEnumConstantInitializer::class.java,
    PsiExpressionListStatement::class.java,
    PsiExpressionStatement::class.java,
    PsiExtensibleClass::class.java,
    PsiField::class.java,
    PsiForStatement::class.java,
    PsiForeachStatement::class.java,
    PsiIfStatement::class.java,
    PsiImportStaticReferenceElement::class.java,
    PsiInstanceOfExpression::class.java,
    PsiJavaFile::class.java,
    PsiJavaModuleReferenceElement::class.java,
    PsiLabeledStatement::class.java,
    PsiLambdaExpression::class.java,
    PsiLiteralExpression::class.java,
    PsiLocalVariable::class.java,
    PsiMethod::class.java,
    PsiMethodCallExpression::class.java,
    PsiMethodReferenceExpression::class.java,
    PsiNameValuePair::class.java,
    PsiNewExpression::class.java,
    PsiParameter::class.java,
    PsiParenthesizedExpression::class.java,
    PsiPatternVariable::class.java,
    PsiPolyadicExpression::class.java,
    PsiPostfixExpression::class.java,
    PsiPrefixExpression::class.java,
    PsiReferenceExpression::class.java,
    PsiResourceVariable::class.java,
    PsiReturnStatement::class.java,
    PsiSuperExpression::class.java,
    PsiSwitchExpression::class.java,
    PsiSwitchLabelStatement::class.java,
    PsiSwitchLabeledRuleStatement::class.java,
    PsiSwitchStatement::class.java,
    PsiSynchronizedStatement::class.java,
    PsiThisExpression::class.java,
    PsiThrowStatement::class.java,
    PsiTryStatement::class.java,
    PsiTypeCastExpression::class.java,
    PsiTypeElement::class.java,
    PsiTypeParameter::class.java,
    PsiWhileStatement::class.java,
    PsiYieldStatement::class.java
  ),
  UAnnotation::class.java to classSetOf<PsiElement>(
    PsiAnnotation::class.java
  ),
  UAnnotationEx::class.java to classSetOf<PsiElement>(
    PsiAnnotation::class.java
  ),
  UAnnotationMethod::class.java to classSetOf<PsiElement>(
    PsiAnnotationMethod::class.java
  ),
  UAnonymousClass::class.java to classSetOf<PsiElement>(
    PsiAnonymousClass::class.java,
    PsiEnumConstantInitializer::class.java
  ),
  UArrayAccessExpression::class.java to classSetOf<PsiElement>(
    PsiArrayAccessExpression::class.java
    //PsiExpressionStatement::class.java
  ),
  UBinaryExpression::class.java to classSetOf<PsiElement>(
    PsiAssignmentExpression::class.java,
    PsiBinaryExpression::class.java
    //PsiExpressionStatement::class.java
  ),
  UBinaryExpressionWithType::class.java to classSetOf<PsiElement>(
    PsiInstanceOfExpression::class.java,
    PsiTypeCastExpression::class.java
  ),
  UBlockExpression::class.java to classSetOf<PsiElement>(
    PsiBlockStatement::class.java,
    PsiCodeBlock::class.java,
    PsiSynchronizedStatement::class.java
  ),
  UBreakExpression::class.java to classSetOf<PsiElement>(
    PsiBreakStatement::class.java
  ),
  UCallExpression::class.java to classSetOf<PsiElement>(
    PsiAnnotation::class.java,
    PsiArrayInitializerExpression::class.java,
    PsiArrayInitializerMemberValue::class.java,
    PsiAssertStatement::class.java,
    PsiEnumConstant::class.java,
    //PsiExpressionStatement::class.java,
    PsiMethodCallExpression::class.java,
    PsiNewExpression::class.java
  ),
  UCallExpressionEx::class.java to classSetOf<PsiElement>(
    PsiAnnotation::class.java,
    PsiArrayInitializerExpression::class.java,
    PsiArrayInitializerMemberValue::class.java,
    PsiAssertStatement::class.java,
    PsiEnumConstant::class.java,
    //PsiExpressionStatement::class.java,
    PsiMethodCallExpression::class.java,
    PsiNewExpression::class.java
  ),
  UCallableReferenceExpression::class.java to classSetOf<PsiElement>(
    PsiMethodReferenceExpression::class.java
  ),
  UCatchClause::class.java to classSetOf<PsiElement>(
    PsiCatchSection::class.java
  ),
  UClass::class.java to classSetOf<PsiElement>(
    PsiAnonymousClass::class.java,
    PsiEnumConstantInitializer::class.java,
    PsiExtensibleClass::class.java,
    PsiTypeParameter::class.java
  ),
  UClassInitializer::class.java to classSetOf<PsiElement>(
    PsiClassInitializer::class.java
  ),
  UClassInitializerEx::class.java to classSetOf<PsiElement>(
    PsiClassInitializer::class.java
  ),
  UClassLiteralExpression::class.java to classSetOf<PsiElement>(
    PsiClassObjectAccessExpression::class.java
  ),
  UClassTypeSpecific::class.java to classSetOf<PsiElement>(
  ),
  UComment::class.java to classSetOf<PsiElement>(
    PsiComment::class.java,
    PsiDocComment::class.java
  ),
  UContinueExpression::class.java to classSetOf<PsiElement>(
    PsiContinueStatement::class.java
  ),
  UDeclaration::class.java to classSetOf<PsiElement>(
    PsiAnnotationMethod::class.java,
    PsiAnonymousClass::class.java,
    PsiClassInitializer::class.java,
    PsiEnumConstant::class.java,
    PsiEnumConstantInitializer::class.java,
    PsiExtensibleClass::class.java,
    PsiField::class.java,
    PsiLocalVariable::class.java,
    PsiMethod::class.java,
    PsiParameter::class.java,
    PsiPatternVariable::class.java,
    PsiResourceVariable::class.java,
    PsiTypeParameter::class.java
  ),
  UDeclarationEx::class.java to classSetOf<PsiElement>(
    PsiAnnotationMethod::class.java,
    PsiAnonymousClass::class.java,
    PsiClassInitializer::class.java,
    PsiEnumConstant::class.java,
    PsiEnumConstantInitializer::class.java,
    PsiExtensibleClass::class.java,
    PsiField::class.java,
    PsiLocalVariable::class.java,
    PsiParameter::class.java,
    PsiPatternVariable::class.java,
    PsiResourceVariable::class.java,
    PsiTypeParameter::class.java
  ),
  UDeclarationsExpression::class.java to classSetOf<PsiElement>(
    PsiDeclarationStatement::class.java,
    PsiExpressionListStatement::class.java
  ),
  UDoWhileExpression::class.java to classSetOf<PsiElement>(
    PsiDoWhileStatement::class.java
  ),
  UElement::class.java to classSetOf<PsiElement>(
    PsiAnnotatedJavaCodeReferenceElement::class.java,
    PsiAnnotation::class.java,
    PsiAnnotationMethod::class.java,
    PsiAnonymousClass::class.java,
    PsiArrayAccessExpression::class.java,
    PsiArrayInitializerExpression::class.java,
    PsiArrayInitializerMemberValue::class.java,
    PsiAssertStatement::class.java,
    PsiAssignmentExpression::class.java,
    PsiBinaryExpression::class.java,
    PsiBlockStatement::class.java,
    PsiBreakStatement::class.java,
    PsiCatchSection::class.java,
    PsiClassInitializer::class.java,
    PsiClassObjectAccessExpression::class.java,
    PsiCodeBlock::class.java,
    PsiComment::class.java,
    PsiConditionalExpression::class.java,
    PsiContinueStatement::class.java,
    PsiDeclarationStatement::class.java,
    PsiDoWhileStatement::class.java,
    PsiDocComment::class.java,
    PsiDocToken::class.java,
    PsiEmptyStatement::class.java,
    PsiEnumConstant::class.java,
    PsiEnumConstantInitializer::class.java,
    PsiExpressionListStatement::class.java,
    PsiExpressionStatement::class.java,
    PsiExtensibleClass::class.java,
    PsiField::class.java,
    PsiForStatement::class.java,
    PsiForeachStatement::class.java,
    PsiIdentifier::class.java,
    PsiIfStatement::class.java,
    PsiImportStatement::class.java,
    PsiImportStaticReferenceElement::class.java,
    PsiImportStaticStatement::class.java,
    PsiInstanceOfExpression::class.java,
    PsiJavaFile::class.java,
    PsiJavaModuleReferenceElement::class.java,
    PsiKeyword::class.java,
    PsiLabeledStatement::class.java,
    PsiLambdaExpression::class.java,
    PsiLiteralExpression::class.java,
    PsiLocalVariable::class.java,
    PsiMethod::class.java,
    PsiMethodCallExpression::class.java,
    PsiMethodReferenceExpression::class.java,
    PsiNameValuePair::class.java,
    PsiNewExpression::class.java,
    PsiParameter::class.java,
    PsiParenthesizedExpression::class.java,
    PsiPatternVariable::class.java,
    PsiPolyadicExpression::class.java,
    PsiPostfixExpression::class.java,
    PsiPrefixExpression::class.java,
    PsiReferenceExpression::class.java,
    PsiResourceVariable::class.java,
    PsiReturnStatement::class.java,
    PsiSuperExpression::class.java,
    PsiSwitchExpression::class.java,
    PsiSwitchLabelStatement::class.java,
    PsiSwitchLabeledRuleStatement::class.java,
    PsiSwitchStatement::class.java,
    PsiSynchronizedStatement::class.java,
    PsiThisExpression::class.java,
    PsiThrowStatement::class.java,
    PsiTryStatement::class.java,
    PsiTypeCastExpression::class.java,
    PsiTypeElement::class.java,
    PsiTypeParameter::class.java,
    PsiWhileStatement::class.java,
    PsiYieldStatement::class.java
  ),
  UElementWithLocation::class.java to classSetOf<PsiElement>(
    //PsiExpressionStatement::class.java,
    PsiMethodCallExpression::class.java
  ),
  UEnumConstant::class.java to classSetOf<PsiElement>(
    PsiEnumConstant::class.java
  ),
  UEnumConstantEx::class.java to classSetOf<PsiElement>(
    PsiEnumConstant::class.java
  ),
  UExpression::class.java to classSetOf<PsiElement>(
    PsiAnnotatedJavaCodeReferenceElement::class.java,
    PsiAnnotation::class.java,
    PsiArrayAccessExpression::class.java,
    PsiArrayInitializerExpression::class.java,
    PsiArrayInitializerMemberValue::class.java,
    PsiAssertStatement::class.java,
    PsiAssignmentExpression::class.java,
    PsiBinaryExpression::class.java,
    PsiBlockStatement::class.java,
    PsiBreakStatement::class.java,
    PsiClassObjectAccessExpression::class.java,
    PsiCodeBlock::class.java,
    PsiConditionalExpression::class.java,
    PsiContinueStatement::class.java,
    PsiDeclarationStatement::class.java,
    PsiDoWhileStatement::class.java,
    PsiDocToken::class.java,
    PsiEmptyStatement::class.java,
    PsiEnumConstant::class.java,
    PsiExpressionListStatement::class.java,
    PsiExpressionStatement::class.java,
    PsiForStatement::class.java,
    PsiForeachStatement::class.java,
    PsiIfStatement::class.java,
    PsiImportStaticReferenceElement::class.java,
    PsiInstanceOfExpression::class.java,
    PsiJavaModuleReferenceElement::class.java,
    PsiLabeledStatement::class.java,
    PsiLambdaExpression::class.java,
    PsiLiteralExpression::class.java,
    PsiMethodCallExpression::class.java,
    PsiMethodReferenceExpression::class.java,
    PsiNameValuePair::class.java,
    PsiNewExpression::class.java,
    PsiParenthesizedExpression::class.java,
    PsiPolyadicExpression::class.java,
    PsiPostfixExpression::class.java,
    PsiPrefixExpression::class.java,
    PsiReferenceExpression::class.java,
    PsiReturnStatement::class.java,
    PsiSuperExpression::class.java,
    PsiSwitchExpression::class.java,
    PsiSwitchLabelStatement::class.java,
    PsiSwitchLabeledRuleStatement::class.java,
    PsiSwitchStatement::class.java,
    PsiSynchronizedStatement::class.java,
    PsiThisExpression::class.java,
    PsiThrowStatement::class.java,
    PsiTryStatement::class.java,
    PsiTypeCastExpression::class.java,
    PsiTypeElement::class.java,
    PsiWhileStatement::class.java,
    PsiYieldStatement::class.java
  ),
  UExpressionList::class.java to classSetOf<PsiElement>(
  ),
  UField::class.java to classSetOf<PsiElement>(
    PsiEnumConstant::class.java,
    PsiField::class.java
  ),
  UFieldEx::class.java to classSetOf<PsiElement>(
    PsiField::class.java
  ),
  UFile::class.java to classSetOf<PsiElement>(
    PsiJavaFile::class.java
  ),
  UForEachExpression::class.java to classSetOf<PsiElement>(
    PsiForeachStatement::class.java
  ),
  UForExpression::class.java to classSetOf<PsiElement>(
    PsiForStatement::class.java
  ),
  UIdentifier::class.java to classSetOf<PsiElement>(
    PsiIdentifier::class.java,
    PsiKeyword::class.java
  ),
  UIfExpression::class.java to classSetOf<PsiElement>(
    PsiConditionalExpression::class.java,
    //PsiExpressionStatement::class.java,
    PsiIfStatement::class.java
  ),
  UImportStatement::class.java to classSetOf<PsiElement>(
    PsiImportStatement::class.java,
    PsiImportStaticStatement::class.java
  ),
  UInjectionHost::class.java to classSetOf<PsiElement>(
    //PsiExpressionStatement::class.java,
    PsiLiteralExpression::class.java
  ),
  UInstanceExpression::class.java to classSetOf<PsiElement>(
    PsiSuperExpression::class.java,
    PsiThisExpression::class.java
  ),
  UJumpExpression::class.java to classSetOf<PsiElement>(
    PsiBreakStatement::class.java,
    PsiContinueStatement::class.java,
    PsiReturnStatement::class.java,
    PsiYieldStatement::class.java
  ),
  ULabeled::class.java to classSetOf<PsiElement>(
    PsiLabeledStatement::class.java,
    PsiSuperExpression::class.java,
    PsiThisExpression::class.java
  ),
  ULabeledExpression::class.java to classSetOf<PsiElement>(
    PsiLabeledStatement::class.java
  ),
  ULambdaExpression::class.java to classSetOf<PsiElement>(
    PsiLambdaExpression::class.java
  ),
  ULiteralExpression::class.java to classSetOf<PsiElement>(
    //PsiExpressionStatement::class.java,
    PsiLiteralExpression::class.java
  ),
  ULocalVariable::class.java to classSetOf<PsiElement>(
    PsiLocalVariable::class.java,
    PsiResourceVariable::class.java
  ),
  ULocalVariableEx::class.java to classSetOf<PsiElement>(
    PsiLocalVariable::class.java,
    PsiResourceVariable::class.java
  ),
  ULoopExpression::class.java to classSetOf<PsiElement>(
    PsiDoWhileStatement::class.java,
    PsiForStatement::class.java,
    PsiForeachStatement::class.java,
    PsiWhileStatement::class.java
  ),
  UMethod::class.java to classSetOf<PsiElement>(
    PsiAnnotationMethod::class.java,
    PsiMethod::class.java
  ),
  UMethodTypeSpecific::class.java to classSetOf<PsiElement>(
  ),
  UMultiResolvable::class.java to classSetOf<PsiElement>(
    PsiAnnotatedJavaCodeReferenceElement::class.java,
    PsiAnnotation::class.java,
    PsiArrayInitializerExpression::class.java,
    PsiArrayInitializerMemberValue::class.java,
    PsiAssertStatement::class.java,
    PsiDocToken::class.java,
    PsiEnumConstant::class.java,
    //PsiExpressionStatement::class.java,
    PsiImportStatement::class.java,
    PsiImportStaticReferenceElement::class.java,
    PsiImportStaticStatement::class.java,
    PsiJavaModuleReferenceElement::class.java,
    PsiMethodCallExpression::class.java,
    PsiMethodReferenceExpression::class.java,
    PsiNewExpression::class.java,
    PsiReferenceExpression::class.java,
    PsiSuperExpression::class.java,
    PsiThisExpression::class.java
  ),
  UNamedExpression::class.java to classSetOf<PsiElement>(
    PsiNameValuePair::class.java
  ),
  UObjectLiteralExpression::class.java to classSetOf<PsiElement>(
    //PsiExpressionStatement::class.java,
    PsiNewExpression::class.java
  ),
  UParameter::class.java to classSetOf<PsiElement>(
    PsiParameter::class.java,
    PsiPatternVariable::class.java
  ),
  UParameterEx::class.java to classSetOf<PsiElement>(
    PsiParameter::class.java,
    PsiPatternVariable::class.java
  ),
  UParenthesizedExpression::class.java to classSetOf<PsiElement>(
    //PsiExpressionStatement::class.java,
    PsiParenthesizedExpression::class.java
  ),
  UPolyadicExpression::class.java to classSetOf<PsiElement>(
    PsiAssignmentExpression::class.java,
    PsiBinaryExpression::class.java,
    //PsiExpressionStatement::class.java,
    PsiPolyadicExpression::class.java
  ),
  UPostfixExpression::class.java to classSetOf<PsiElement>(
    //PsiExpressionStatement::class.java,
    PsiPostfixExpression::class.java
  ),
  UPrefixExpression::class.java to classSetOf<PsiElement>(
    //PsiExpressionStatement::class.java,
    PsiPrefixExpression::class.java
  ),
  UQualifiedReferenceExpression::class.java to classSetOf<PsiElement>(
    PsiAnnotatedJavaCodeReferenceElement::class.java,
    //PsiExpressionStatement::class.java,
    PsiImportStaticReferenceElement::class.java,
    PsiMethodCallExpression::class.java,
    PsiReferenceExpression::class.java
  ),
  UReferenceExpression::class.java to classSetOf<PsiElement>(
    PsiAnnotatedJavaCodeReferenceElement::class.java,
    PsiDocToken::class.java,
    //PsiExpressionStatement::class.java,
    PsiImportStaticReferenceElement::class.java,
    PsiJavaModuleReferenceElement::class.java,
    PsiMethodCallExpression::class.java,
    PsiMethodReferenceExpression::class.java,
    PsiReferenceExpression::class.java
  ),
  UResolvable::class.java to classSetOf<PsiElement>(
    PsiAnnotatedJavaCodeReferenceElement::class.java,
    PsiAnnotation::class.java,
    PsiArrayInitializerExpression::class.java,
    PsiArrayInitializerMemberValue::class.java,
    PsiAssertStatement::class.java,
    PsiDocToken::class.java,
    PsiEnumConstant::class.java,
    //PsiExpressionStatement::class.java,
    PsiImportStatement::class.java,
    PsiImportStaticReferenceElement::class.java,
    PsiImportStaticStatement::class.java,
    PsiJavaModuleReferenceElement::class.java,
    PsiMethodCallExpression::class.java,
    PsiMethodReferenceExpression::class.java,
    PsiNewExpression::class.java,
    PsiReferenceExpression::class.java,
    PsiSuperExpression::class.java,
    PsiThisExpression::class.java
  ),
  UReturnExpression::class.java to classSetOf<PsiElement>(
    PsiReturnStatement::class.java
  ),
  USimpleNameReferenceExpression::class.java to classSetOf<PsiElement>(
    PsiAnnotatedJavaCodeReferenceElement::class.java,
    PsiDocToken::class.java,
    //PsiExpressionStatement::class.java,
    PsiJavaModuleReferenceElement::class.java,
    PsiReferenceExpression::class.java
  ),
  USuperExpression::class.java to classSetOf<PsiElement>(
    PsiSuperExpression::class.java
  ),
  USwitchClauseExpression::class.java to classSetOf<PsiElement>(
    PsiSwitchLabelStatement::class.java,
    PsiSwitchLabeledRuleStatement::class.java
  ),
  USwitchClauseExpressionWithBody::class.java to classSetOf<PsiElement>(
    PsiSwitchLabelStatement::class.java,
    PsiSwitchLabeledRuleStatement::class.java
  ),
  USwitchExpression::class.java to classSetOf<PsiElement>(
    PsiSwitchExpression::class.java,
    PsiSwitchStatement::class.java
  ),
  UThisExpression::class.java to classSetOf<PsiElement>(
    PsiThisExpression::class.java
  ),
  UThrowExpression::class.java to classSetOf<PsiElement>(
    PsiThrowStatement::class.java
  ),
  UTryExpression::class.java to classSetOf<PsiElement>(
    PsiTryStatement::class.java
  ),
  UTypeReferenceExpression::class.java to classSetOf<PsiElement>(
    PsiTypeElement::class.java
  ),
  UUnaryExpression::class.java to classSetOf<PsiElement>(
    //PsiExpressionStatement::class.java,
    PsiPostfixExpression::class.java,
    PsiPrefixExpression::class.java
  ),
  UVariable::class.java to classSetOf<PsiElement>(
    PsiEnumConstant::class.java,
    PsiField::class.java,
    PsiLocalVariable::class.java,
    PsiParameter::class.java,
    PsiPatternVariable::class.java,
    PsiResourceVariable::class.java
  ),
  UVariableEx::class.java to classSetOf<PsiElement>(
    PsiEnumConstant::class.java,
    PsiField::class.java,
    PsiLocalVariable::class.java,
    PsiParameter::class.java,
    PsiPatternVariable::class.java,
    PsiResourceVariable::class.java
  ),
  UWhileExpression::class.java to classSetOf<PsiElement>(
    PsiWhileStatement::class.java
  ),
  UYieldExpression::class.java to classSetOf<PsiElement>(
    PsiYieldStatement::class.java
  ),
  UastEmptyExpression::class.java to classSetOf<PsiElement>(
    PsiEmptyStatement::class.java
  )
)

private val uElementClassSet = possibleSourceTypes.getValue(UElement::class.java)
private val uInjectionHostClassSet = possibleSourceTypes.getValue(UInjectionHost::class.java)
private val uCallClassSet = possibleSourceTypes.getValue(UCallExpression::class.java)