/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a4\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0018\u0010\u0007\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\t0\b\u001a.\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\n\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0001\u001a\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001H\u0007\u00a8\u0006\u0013"}, d2={"fileNameToResourceName", "", "fileName", "findUnusedResources", "", "Lcom/android/ide/common/resources/usage/ResourceUsageModel$Resource;", "resources", "rootsConsumer", "Lkotlin/Function1;", "", "Ljava/util/function/Consumer;", "isInvalidResourceFieldNameCharacter", "", "c", "", "resourceNameToFieldName", "resourceName", "stripPrefixFromId", "id", "sdk-common"})
@JvmName(name="ResourcesUtil")
public final class ResourcesUtil {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String resourceNameToFieldName(@NotNull String resourceName) {
        Intrinsics.checkParameterIsNotNull((Object)resourceName, (String)"resourceName");
        int n = resourceName.length();
        for (int i = 0; i < n; ++i) {
            char c = resourceName.charAt(i);
            if (!ResourcesUtil.isInvalidResourceFieldNameCharacter(c)) continue;
            char[] buffer = new char[resourceName.length()];
            String string = resourceName;
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            string.getChars(n3, i, buffer, n2);
            buffer[i] = 95;
            int n4 = i + 1;
            n2 = n;
            while (n4 < n2) {
                void j;
                c = resourceName.charAt((int)j);
                buffer[j] = ResourcesUtil.isInvalidResourceFieldNameCharacter(c) ? 95 : (int)c;
                ++j;
            }
            n4 = 0;
            return new String(buffer);
        }
        return resourceName;
    }

    public static final boolean isInvalidResourceFieldNameCharacter(char c) {
        return c == ':' || c == '.' || c == '-';
    }

    @Nullable
    public static final String fileNameToResourceName(@NotNull String fileName) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        int lastExtension = StringsKt.lastIndexOf$default((CharSequence)fileName, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (lastExtension <= 0) {
            string = fileName;
        } else if (StringsKt.endsWith((String)fileName, (String)".9.png", (boolean)true)) {
            if (fileName.length() > ".9.png".length()) {
                String string2 = fileName;
                int n = 0;
                int n2 = fileName.length() - ".9.png".length();
                boolean bl = false;
                String string3 = string2.substring(n, n2);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string = fileName;
            }
        } else {
            String string4 = fileName;
            int n = 0;
            boolean bl = false;
            String string5 = string4.substring(n, lastExtension);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        }
        return string;
    }

    @NotNull
    public static final List<ResourceUsageModel.Resource> findUnusedResources(@NotNull List<? extends ResourceUsageModel.Resource> resources, @NotNull Consumer<List<ResourceUsageModel.Resource>> rootsConsumer) {
        Intrinsics.checkParameterIsNotNull(resources, (String)"resources");
        Intrinsics.checkParameterIsNotNull(rootsConsumer, (String)"rootsConsumer");
        return ResourcesUtil.findUnusedResources(resources, (Function1<? super List<? extends ResourceUsageModel.Resource>, Unit>)((Function1)new Function1<List<? extends ResourceUsageModel.Resource>, Unit>(rootsConsumer){
            final /* synthetic */ Consumer $rootsConsumer;

            public final void invoke(@NotNull List<? extends ResourceUsageModel.Resource> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                this.$rootsConsumer.accept(it);
            }
            {
                this.$rootsConsumer = consumer;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ResourceUsageModel.Resource> findUnusedResources(@NotNull List<? extends ResourceUsageModel.Resource> resources, @NotNull Function1<? super List<? extends ResourceUsageModel.Resource>, Unit> rootsConsumer) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(resources, (String)"resources");
        Intrinsics.checkParameterIsNotNull(rootsConsumer, (String)"rootsConsumer");
        Set seen = Collections.newSetFromMap(new IdentityHashMap());
        Function1<ResourceUsageModel.Resource, Unit> $fun$visit$2 = new Function1<ResourceUsageModel.Resource, Unit>(seen){
            final /* synthetic */ Set $seen;

            public final void invoke(@NotNull ResourceUsageModel.Resource resource) {
                Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
                if (this.$seen.contains(resource)) {
                    return;
                }
                Collection collection = this.$seen;
                boolean bl = false;
                collection.add(resource);
                resource.setReachable(true);
                List<ResourceUsageModel.Resource> list = resource.references;
                if (list != null) {
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ResourceUsageModel.Resource it = (ResourceUsageModel.Resource)element$iv;
                        boolean bl2 = false;
                        ResourceUsageModel.Resource resource2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)resource2, (String)"it");
                        this.invoke(resource2);
                    }
                }
            }
            {
                this.$seen = set;
                super(1);
            }
        };
        Iterable $this$filter$iv = resources;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ResourceUsageModel.Resource it = (ResourceUsageModel.Resource)element$iv$iv;
            boolean bl = false;
            if (!(it.isReachable() || it.isKeep())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List roots = (List)destination$iv$iv;
        rootsConsumer.invoke((Object)roots);
        Iterable $this$forEach$iv = roots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResourceUsageModel.Resource it = (ResourceUsageModel.Resource)element$iv;
            boolean bl = false;
            $fun$visit$2.invoke(it);
        }
        return SequencesKt.toList((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filter((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)resources), (Function1)findUnusedResources.4.INSTANCE), (Function1)findUnusedResources.5.INSTANCE), (Function1)findUnusedResources.6.INSTANCE));
    }

    @Deprecated(message="Use `ResourceUrl.parse` instead and handle wrong resource type, invalid name, trailing whitespace etc.", replaceWith=@ReplaceWith(imports={"com.android.resources.ResourceUrl"}, expression="ResourceUrl.parse(id)?.name ?: id"))
    @NotNull
    public static final String stripPrefixFromId(@NotNull String id) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        if (StringsKt.startsWith$default((String)id, (String)"@+id/", (boolean)false, (int)2, null)) {
            String string2 = id;
            int n = "@+id/".length();
            boolean bl = false;
            String string3 = string2.substring(n);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        } else if (StringsKt.startsWith$default((String)id, (String)"@id/", (boolean)false, (int)2, null)) {
            String string4 = id;
            int n = "@id/".length();
            boolean bl = false;
            String string5 = string4.substring(n);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = id;
        }
        return string;
    }
}

