/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.SvgGradientNode;
import com.android.ide.common.vectordrawable.SvgGroupNode;
import com.android.ide.common.vectordrawable.SvgNode;
import com.android.ide.common.vectordrawable.VdUtil;
import com.android.utils.DecimalUtils;
import com.android.utils.Pair;
import com.android.utils.PositionXmlParser;
import com.google.common.base.Preconditions;
import java.awt.geom.AffineTransform;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class SvgTree {
    private static final Logger logger = Logger.getLogger(SvgTree.class.getSimpleName());
    private static final String HEAD = "<vector xmlns:android=\"http://schemas.android.com/apk/res/android\"";
    private static final String AAPT_BOUND = "xmlns:aapt=\"http://schemas.android.com/aapt\"";
    public static final String SVG_WIDTH = "width";
    public static final String SVG_HEIGHT = "height";
    public static final String SVG_VIEW_BOX = "viewBox";
    private float w = -1.0f;
    private float h = -1.0f;
    private final AffineTransform mRootTransform = new AffineTransform();
    private float[] viewBox;
    private SvgGroupNode mRoot;
    private String mFileName;
    private final List<LogMessage> mLogMessages = new ArrayList<LogMessage>();
    private boolean mHasLeafNode;
    private boolean mHasGradient;
    private final Map<String, SvgNode> mIdMap = new HashMap<String, SvgNode>();
    private final Set<String> mIgnoredIds = new HashSet<String>();
    private final Set<SvgGroupNode> mPendingUseGroupSet = new HashSet<SvgGroupNode>();
    private final Set<SvgGradientNode> mPendingGradientRefSet = new HashSet<SvgGradientNode>();
    private final Map<SvgNode, Pair<SvgGroupNode, String>> mClipPathAffectedNodes = new LinkedHashMap<SvgNode, Pair<SvgGroupNode, String>>();
    private final Map<String, Set<SvgNode>> mStyleAffectedNodes = new HashMap<String, Set<SvgNode>>();
    private final Map<String, String> mStyleClassAttributeMap = new HashMap<String, String>();
    private NumberFormat mCoordinateFormat;

    SvgTree() {
    }

    public float getWidth() {
        return this.w;
    }

    public float getHeight() {
        return this.h;
    }

    public float getScaleFactor() {
        return 1.0f;
    }

    public void setHasLeafNode(boolean hasLeafNode) {
        this.mHasLeafNode = hasLeafNode;
    }

    public void setHasGradient(boolean hasGradient) {
        this.mHasGradient = hasGradient;
    }

    public float[] getViewBox() {
        return this.viewBox;
    }

    public void flatten() {
        this.mRoot.flatten(new AffineTransform());
    }

    public void validate() {
        this.mRoot.validate();
        if (this.mLogMessages.isEmpty() && !this.getHasLeafNode()) {
            this.logError("No vector content found", null);
        }
    }

    public Document parse(Path file, List<String> parseErrors) throws IOException {
        this.mFileName = file.getFileName().toString();
        try {
            BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]));
            return PositionXmlParser.parse((InputStream)inputStream, (boolean)false, parseErrors);
        }
        catch (ParserConfigurationException e) {
            throw new Error("Internal error", e);
        }
    }

    public void normalize() {
        this.mRootTransform.preConcatenate(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -this.viewBox[0], -this.viewBox[1]));
        this.transform(this.mRootTransform);
        logger.log(Level.FINE, "matrix=" + this.mRootTransform);
    }

    private void transform(AffineTransform rootTransform) {
        this.mRoot.transformIfNeeded(rootTransform);
    }

    public void dump() {
        logger.log(Level.FINE, "file: " + this.mFileName);
        this.mRoot.dumpNode("");
    }

    public void setRoot(SvgGroupNode root) {
        this.mRoot = root;
    }

    public SvgGroupNode getRoot() {
        return this.mRoot;
    }

    public void logError(String s, Node node) {
        this.logErrorLine(s, node, SvgLogLevel.ERROR);
    }

    public void logWarning(String s, Node node) {
        this.logErrorLine(s, node, SvgLogLevel.WARNING);
    }

    void logErrorLine(String s, Node node, SvgLogLevel level) {
        Preconditions.checkArgument((!s.isEmpty() ? 1 : 0) != 0);
        int line = node == null ? 0 : SvgTree.getStartLine(node);
        this.mLogMessages.add(new LogMessage(level, line, s));
    }

    public String getErrorMessage() {
        if (this.mLogMessages.isEmpty()) {
            return "";
        }
        Collections.sort(this.mLogMessages);
        StringBuilder result2 = new StringBuilder();
        for (LogMessage message : this.mLogMessages) {
            if (result2.length() != 0) {
                result2.append('\n');
            }
            result2.append(message.getFormattedMessage());
        }
        return result2.toString();
    }

    public boolean getHasLeafNode() {
        return this.mHasLeafNode;
    }

    public boolean getHasGradient() {
        return this.mHasGradient;
    }

    public static int getStartLine(Node node) {
        return PositionXmlParser.getPosition((Node)node).getStartLine() + 1;
    }

    public float getViewportWidth() {
        return this.viewBox == null ? -1.0f : this.viewBox[2];
    }

    public float getViewportHeight() {
        return this.viewBox == null ? -1.0f : this.viewBox[3];
    }

    public void parseDimension(Node nNode) {
        NamedNodeMap a = nNode.getAttributes();
        int len = a.getLength();
        SizeType widthType = SizeType.PIXEL;
        SizeType heightType = SizeType.PIXEL;
        for (int i2 = 0; i2 < len; ++i2) {
            Node n = a.item(i2);
            String name = n.getNodeName().trim();
            String value = n.getNodeValue().trim();
            int subStringSize = value.length();
            SizeType currentType = SizeType.PIXEL;
            String unit = value.substring(Math.max(value.length() - 2, 0));
            if (unit.matches("em|ex|px|in|cm|mm|pt|pc")) {
                subStringSize -= 2;
            } else if (value.endsWith("%")) {
                --subStringSize;
                currentType = SizeType.PERCENTAGE;
            }
            if (SVG_WIDTH.equals(name)) {
                this.w = Float.parseFloat(value.substring(0, subStringSize));
                widthType = currentType;
                continue;
            }
            if (SVG_HEIGHT.equals(name)) {
                this.h = Float.parseFloat(value.substring(0, subStringSize));
                heightType = currentType;
                continue;
            }
            if (!SVG_VIEW_BOX.equals(name)) continue;
            this.viewBox = new float[4];
            String[] strbox = value.split(" ");
            for (int j = 0; j < this.viewBox.length; ++j) {
                this.viewBox[j] = Float.parseFloat(strbox[j]);
            }
        }
        if (this.viewBox == null && this.w > 0.0f && this.h > 0.0f) {
            this.viewBox = new float[4];
            this.viewBox[2] = this.w;
            this.viewBox[3] = this.h;
        } else if ((this.w < 0.0f || this.h < 0.0f) && this.viewBox != null) {
            this.w = this.viewBox[2];
            this.h = this.viewBox[3];
        }
        if (widthType == SizeType.PERCENTAGE && this.w > 0.0f) {
            this.w = this.viewBox[2] * this.w / 100.0f;
        }
        if (heightType == SizeType.PERCENTAGE && this.h > 0.0f) {
            this.h = this.viewBox[3] * this.h / 100.0f;
        }
    }

    public double parseXValue(String value) {
        return SvgTree.parseCoordinateOrLength(value, this.getViewportWidth());
    }

    public double parseYValue(String value) {
        return SvgTree.parseCoordinateOrLength(value, this.getViewportHeight());
    }

    private static double parseCoordinateOrLength(String value, double percentageBase) {
        if (value.endsWith("%")) {
            return Double.parseDouble(value.substring(0, value.length() - 1)) / 100.0 * percentageBase;
        }
        return Double.parseDouble(value);
    }

    public void addIdToMap(String id, SvgNode svgNode) {
        this.mIdMap.put(id, svgNode);
    }

    public SvgNode getSvgNodeFromId(String id) {
        return this.mIdMap.get(id);
    }

    public void addToPendingUseSet(SvgGroupNode useGroup) {
        this.mPendingUseGroupSet.add(useGroup);
    }

    public Set<SvgGroupNode> getPendingUseSet() {
        return this.mPendingUseGroupSet;
    }

    public void addToPendingGradientRefSet(SvgGradientNode node) {
        this.mPendingGradientRefSet.add(node);
    }

    public Set<SvgGradientNode> getPendingGradientRefSet() {
        return this.mPendingGradientRefSet;
    }

    public void addIgnoredId(String id) {
        this.mIgnoredIds.add(id);
    }

    public boolean isIdIgnored(String id) {
        return this.mIgnoredIds.contains(id);
    }

    public void addClipPathAffectedNode(SvgNode child, SvgGroupNode currentGroup, String clipPathName) {
        this.mClipPathAffectedNodes.put(child, (Pair<SvgGroupNode, String>)Pair.of((Object)currentGroup, (Object)clipPathName));
    }

    public Set<Map.Entry<SvgNode, Pair<SvgGroupNode, String>>> getClipPathAffectedNodesSet() {
        return this.mClipPathAffectedNodes.entrySet();
    }

    public void addAffectedNodeToStyleClass(String className, SvgNode child) {
        if (this.mStyleAffectedNodes.containsKey(className)) {
            this.mStyleAffectedNodes.get(className).add(child);
        } else {
            HashSet<SvgNode> styleNodesSet = new HashSet<SvgNode>();
            styleNodesSet.add(child);
            this.mStyleAffectedNodes.put(className, styleNodesSet);
        }
    }

    public void addStyleClassToTree(String className, String attributes) {
        this.mStyleClassAttributeMap.put(className, attributes);
    }

    public String getStyleClassAttr(String classname) {
        return this.mStyleClassAttributeMap.get(classname);
    }

    public Set<Map.Entry<String, Set<SvgNode>>> getStyleAffectedNodes() {
        return this.mStyleAffectedNodes.entrySet();
    }

    public SvgGroupNode findParent(SvgNode node) {
        return this.mRoot.findParent(node);
    }

    public String formatCoordinate(double coordinate) {
        return DecimalUtils.trimInsignificantZeros((String)this.getCoordinateFormat().format(coordinate));
    }

    private NumberFormat getCoordinateFormat() {
        if (this.mCoordinateFormat == null) {
            float viewportWidth = this.getViewportWidth();
            float viewportHeight = this.getViewportHeight();
            this.mCoordinateFormat = VdUtil.getCoordinateFormat(Math.max(viewportHeight, viewportWidth));
        }
        return this.mCoordinateFormat;
    }

    public void writeXml(OutputStream stream) throws IOException {
        if (this.mRoot == null) {
            throw new IllegalStateException("SvgTree is not fully initialized");
        }
        OutputStreamWriter writer = new OutputStreamWriter(stream, StandardCharsets.UTF_8);
        writer.write(HEAD);
        writer.write(System.lineSeparator());
        if (this.getHasGradient()) {
            writer.write("    ");
            writer.write(AAPT_BOUND);
            writer.write(System.lineSeparator());
        }
        writer.write("    ");
        writer.write("android:width=\"");
        writer.write(this.formatCoordinate(this.getWidth() * this.getScaleFactor()));
        writer.write("dp\"");
        writer.write(System.lineSeparator());
        writer.write("    ");
        writer.write("android:height=\"");
        writer.write(this.formatCoordinate(this.getHeight() * this.getScaleFactor()));
        writer.write("dp\"");
        writer.write(System.lineSeparator());
        writer.write("    ");
        writer.write("android:viewportWidth=\"");
        writer.write(this.formatCoordinate(this.getViewportWidth()));
        writer.write("\"");
        writer.write(System.lineSeparator());
        writer.write("    ");
        writer.write("android:viewportHeight=\"");
        writer.write(this.formatCoordinate(this.getViewportHeight()));
        writer.write("\">");
        writer.write(System.lineSeparator());
        this.normalize();
        this.mRoot.writeXml(writer, "  ");
        writer.write("</vector>");
        writer.write(System.lineSeparator());
        writer.close();
    }

    static enum SvgLogLevel {
        ERROR,
        WARNING;

    }

    private static class LogMessage
    implements Comparable<LogMessage> {
        final SvgLogLevel level;
        final int line;
        final String message;

        LogMessage(SvgLogLevel level, int line, String message) {
            this.level = level;
            this.line = line;
            this.message = message;
        }

        String getFormattedMessage() {
            return this.level.name() + (String)(this.line == 0 ? "" : " @ line " + this.line) + ": " + this.message;
        }

        @Override
        public int compareTo(LogMessage other) {
            int cmp = this.level.compareTo(other.level);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Integer.compare(this.line, other.line);
            if (cmp != 0) {
                return cmp;
            }
            return this.message.compareTo(other.message);
        }
    }

    private static enum SizeType {
        PIXEL,
        PERCENTAGE;

    }
}

