/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.mediation;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import com.applovin.impl.mediation.MaxAdWaterfallInfoImpl;
import com.applovin.impl.mediation.MaxAdapterParametersImpl;
import com.applovin.impl.mediation.MaxErrorImpl;
import com.applovin.impl.mediation.MaxNetworkResponseInfoImpl;
import com.applovin.impl.mediation.ads.a;
import com.applovin.impl.mediation.b.c;
import com.applovin.impl.mediation.b.e;
import com.applovin.impl.mediation.b.f;
import com.applovin.impl.mediation.b.g;
import com.applovin.impl.mediation.b.h;
import com.applovin.impl.mediation.d;
import com.applovin.impl.mediation.d.d;
import com.applovin.impl.mediation.g;
import com.applovin.impl.mediation.j;
import com.applovin.impl.sdk.AppLovinBroadcastManager;
import com.applovin.impl.sdk.c.b;
import com.applovin.impl.sdk.e.q;
import com.applovin.impl.sdk.n;
import com.applovin.impl.sdk.r;
import com.applovin.impl.sdk.u;
import com.applovin.impl.sdk.utils.CollectionUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.m;
import com.applovin.impl.sdk.utils.u;
import com.applovin.impl.sdk.x;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxAdListener;
import com.applovin.mediation.MaxAdRevenueListener;
import com.applovin.mediation.MaxAdViewAdListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.MaxMediatedNetworkInfo;
import com.applovin.mediation.MaxNetworkResponseInfo;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.MaxRewardedAdListener;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.sdk.AppLovinSdkUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONObject;

public class MediationServiceImpl
implements AppLovinBroadcastManager.Receiver {
    private final n sdk;
    private final x logger;
    private final j amN;
    private final AtomicReference<JSONObject> amO = new AtomicReference();

    public MediationServiceImpl(n n2) {
        this.sdk = n2;
        this.logger = n2.Ci();
        this.amN = new j(n2);
        AppLovinBroadcastManager.registerReceiver(this, new IntentFilter("com.applovin.render_process_gone"));
    }

    public void loadAd(String string2, @Nullable String string3, MaxAdFormat maxAdFormat, d.a a2, Map<String, Object> map, Map<String, Object> map2, Context context, a.a a3) {
        Object object;
        List<String> list;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("No Ad Unit ID specified");
        }
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        if (a3 == null) {
            throw new IllegalArgumentException("No listener specified");
        }
        if (TextUtils.isEmpty((CharSequence)this.sdk.getMediationProvider())) {
            x.I("AppLovinSdk", "Mediation provider is null. Please set AppLovin SDK mediation provider via AppLovinSdk.getInstance(context).setMediationProvider()");
        }
        if (!this.sdk.isEnabled()) {
            x.G("AppLovinSdk", "Attempted to load ad before SDK initialization. Please wait until after the SDK has initialized, e.g. AppLovinSdk.initializeSdk(Context, SdkInitializationListener).");
        }
        if ((list = this.sdk.getSettings().getInitializationAdUnitIds()) != null && list.size() > 0 && !list.contains(string2)) {
            if (u.b(n.getApplicationContext(), this.sdk)) {
                object = "Ad Unit ID " + string2 + " has not been initialized. When you use selective init, any ad units that you do not explicitly specify are excluded from serving ads for the current session. For more information visit our docs: https://dash.applovin.com/documentation/mediation/android/getting-started/advanced-settings#selective-init";
                if (this.sdk.a(b.aSy).booleanValue()) {
                    throw new RuntimeException((String)object);
                }
                MediationServiceImpl mediationServiceImpl = this;
                if (mediationServiceImpl.logger.FL()) {
                    this.logger.i("MediationService", (String)object);
                }
            }
            object = "uninitialized_ad_unit_id";
            String string4 = (String)object + string2;
            HashMap<String, String> hashMap = CollectionUtils.hashMap("ad_unit_id", string2);
            this.sdk.CN().a(r.a.aFC, (String)object, hashMap, string4);
        }
        this.sdk.BH();
        if (string2.length() != 16 && !string2.startsWith("test_mode") && !this.sdk.getSdkKey().startsWith("05TMD")) {
            x.I("MediationService", "Please double-check the ad unit " + string2 + " for " + maxAdFormat.getLabel() + " : " + Log.getStackTraceString((Throwable)new Throwable("")));
        }
        if (this.sdk.f(maxAdFormat)) {
            x.I("MediationService", "Ad load failed due to disabled ad format " + maxAdFormat.getLabel());
            object = new MaxErrorImpl(-1, "Disabled ad format " + maxAdFormat.getLabel());
            m.a((MaxAdListener)a3, string2, (MaxError)object);
            return;
        }
        this.sdk.Cc();
        m.a(a3, string2, true, true);
        this.sdk.CZ().a(string2, string3, maxAdFormat, a2, map, map2, context, a3);
    }

    public void showFullscreenAd(c c2, Activity activity, a.a a2) {
        if (c2 == null) {
            throw new IllegalArgumentException("No ad specified");
        }
        if (activity == null && MaxAdFormat.APP_OPEN != c2.getFormat()) {
            throw new IllegalArgumentException("No activity specified");
        }
        this.sdk.CA().aN(true);
        com.applovin.impl.mediation.g g2 = this.g(c2);
        long l2 = c2.yt();
        MediationServiceImpl mediationServiceImpl = this;
        if (mediationServiceImpl.logger.FL()) {
            this.logger.g("MediationService", "Showing ad " + c2.getAdUnitId() + " with delay of " + l2 + "ms...");
        }
        AppLovinSdkUtils.runOnUiThreadDelayed(() -> {
            c2.aH(true);
            this.h(c2);
            g2.a((com.applovin.impl.mediation.b.a)c2, activity);
            this.a(c2, a2);
        }, l2);
    }

    public void showFullscreenAd(c c2, ViewGroup viewGroup, Lifecycle lifecycle, Activity activity, a.a a2) {
        if (c2 == null) {
            throw new IllegalArgumentException("No ad specified");
        }
        if (activity == null) {
            throw new IllegalArgumentException("No activity specified");
        }
        this.sdk.CA().aN(true);
        com.applovin.impl.mediation.g g2 = this.g(c2);
        long l2 = c2.yt();
        MediationServiceImpl mediationServiceImpl = this;
        if (mediationServiceImpl.logger.FL()) {
            this.logger.g("MediationService", "Showing ad " + c2.getAdUnitId() + " with delay of " + l2 + "ms...");
        }
        AppLovinSdkUtils.runOnUiThreadDelayed(() -> {
            c2.aH(true);
            this.h(c2);
            g2.a(c2, viewGroup, lifecycle, activity);
            this.a(c2, a2);
        }, l2);
    }

    private com.applovin.impl.mediation.g g(c c2) {
        com.applovin.impl.mediation.g g2 = c2.xU();
        if (g2 == null) {
            this.sdk.CA().aN(false);
            MediationServiceImpl mediationServiceImpl = this;
            if (mediationServiceImpl.logger.FL()) {
                this.logger.h("MediationService", "Failed to show " + c2 + ": adapter not found");
            }
            x.I("MediationService", "There may be an integration problem with the adapter for Ad Unit ID '" + c2.getAdUnitId() + "'. Please check if you have a supported version of that SDK integrated into your project.");
            throw new IllegalStateException("Could not find adapter for provided ad");
        }
        return g2;
    }

    private void h(c c2) {
        if (c2.getFormat() == MaxAdFormat.REWARDED || c2.getFormat() == MaxAdFormat.REWARDED_INTERSTITIAL) {
            com.applovin.impl.mediation.d.h h2 = new com.applovin.impl.mediation.d.h(c2, this.sdk);
            this.sdk.Cj().a((com.applovin.impl.sdk.e.d)h2, q.a.aVN);
        }
    }

    private void a(c c2, a.a a2) {
        this.sdk.CA().aN(false);
        this.a(c2, (MaxAdListener)a2);
        MediationServiceImpl mediationServiceImpl = this;
        if (mediationServiceImpl.logger.FL()) {
            this.logger.f("MediationService", "Scheduling impression for ad manually...");
        }
        this.processRawAdImpression(c2, a2);
    }

    public void destroyAd(MaxAd maxAd) {
        com.applovin.impl.mediation.b.a a2;
        com.applovin.impl.mediation.g g2;
        if (!(maxAd instanceof com.applovin.impl.mediation.b.a)) {
            return;
        }
        MediationServiceImpl mediationServiceImpl = this;
        if (mediationServiceImpl.logger.FL()) {
            this.logger.g("MediationService", "Destroying " + maxAd);
        }
        if ((g2 = (a2 = (com.applovin.impl.mediation.b.a)maxAd).xU()) != null) {
            g2.destroy();
            a2.yi();
        }
        this.sdk.CR().cw(a2.xT());
    }

    public void loadThirdPartyMediatedAd(String string2, com.applovin.impl.mediation.b.a a2, Activity activity, a.a a3) {
        if (a2 == null) {
            throw new IllegalArgumentException("No mediated ad specified");
        }
        MediationServiceImpl mediationServiceImpl = this;
        if (mediationServiceImpl.logger.FL()) {
            this.logger.f("MediationService", "Loading " + a2 + "...");
        }
        this.sdk.CC().a(a2, "WILL_LOAD");
        com.applovin.impl.mediation.g g2 = this.sdk.CS().c(a2);
        if (g2 != null) {
            MaxAdapterParametersImpl maxAdapterParametersImpl = MaxAdapterParametersImpl.a(a2);
            this.sdk.CT().a(a2, activity);
            com.applovin.impl.mediation.b.a a4 = a2.k(g2);
            g2.a(string2, a4);
            a4.yd();
            g2.a(string2, maxAdapterParametersImpl, a4, activity, new a(a4, a3));
        } else {
            String string3 = "Failed to load " + a2 + ": adapter not loaded";
            x.I("MediationService", string3);
            MaxErrorImpl maxErrorImpl = new MaxErrorImpl(-5001, string3);
            this.a(a2, maxErrorImpl, (MaxAdListener)a3);
        }
    }

    public void collectSignal(final String string2, final MaxAdFormat maxAdFormat, final h h2, Context context, final g.a a2) {
        if (h2 == null) {
            throw new IllegalArgumentException("No spec specified");
        }
        if (context == null) {
            throw new IllegalArgumentException("No context specified");
        }
        if (a2 == null) {
            throw new IllegalArgumentException("No callback specified");
        }
        g g2 = this.amN.b(h2, string2, maxAdFormat);
        if (g2 != null) {
            g g3 = g.a(g2);
            a2.b(g3);
            return;
        }
        boolean bl = h2.zd();
        final com.applovin.impl.mediation.g g4 = this.sdk.CS().a(h2, bl);
        if (g4 != null) {
            Activity activity = context instanceof Activity ? (Activity)context : this.sdk.Db();
            MaxAdapterParametersImpl maxAdapterParametersImpl = MaxAdapterParametersImpl.a(h2, string2, maxAdFormat);
            this.sdk.CT().a(h2, activity);
            final long l2 = SystemClock.elapsedRealtime();
            g.a a3 = new g.a(){

                @Override
                public void onSignalCollected(String string22) {
                    MediationServiceImpl.this.logger;
                    if (x.FL()) {
                        MediationServiceImpl.this.logger.f("MediationService", "Signal collection successful from: " + g4.getName() + " for Ad Unit ID: " + string2 + " with signal: \"" + string22 + "\"");
                    }
                    long l22 = SystemClock.elapsedRealtime() - l2;
                    g g2 = g.a(h2, g4, string22, l2, l22);
                    MediationServiceImpl.this.amN.a(g2, h2, string2, maxAdFormat);
                    a2.b(g2);
                    g4.destroy();
                }

                @Override
                public void a(MaxError maxError) {
                    MediationServiceImpl.this.logger;
                    if (x.FL()) {
                        MediationServiceImpl.this.logger.i("MediationService", "Signal collection failed from: " + g4.getName() + " for Ad Unit ID: " + string2 + " with error message: \"" + maxError.getMessage() + "\"");
                    }
                    long l22 = SystemClock.elapsedRealtime() - l2;
                    g g2 = g.a(h2, g4, maxError, l2, l22);
                    MediationServiceImpl.this.a(g2, h2, g4);
                    a2.b(g2);
                    g4.destroy();
                }
            };
            if (h2.zc()) {
                if (this.sdk.CT().b(h2)) {
                    MediationServiceImpl mediationServiceImpl = this;
                    if (mediationServiceImpl.logger.FL()) {
                        this.logger.f("MediationService", "Collecting signal for now-initialized adapter: " + g4.getName());
                    }
                    g4.a(maxAdapterParametersImpl, h2, activity, a3);
                } else {
                    MediationServiceImpl mediationServiceImpl = this;
                    if (mediationServiceImpl.logger.FL()) {
                        this.logger.i("MediationService", "Skip collecting signal for not-initialized adapter: " + g4.getName());
                    }
                    a2.b(g.a(h2, new MaxErrorImpl("Adapter not initialized yet")));
                }
            } else {
                MediationServiceImpl mediationServiceImpl = this;
                if (mediationServiceImpl.logger.FL()) {
                    this.logger.f("MediationService", "Collecting signal for adapter: " + g4.getName());
                }
                g4.a(maxAdapterParametersImpl, h2, activity, a3);
            }
        } else {
            a2.b(g.a(h2, new MaxErrorImpl("Could not load adapter")));
        }
    }

    private void a(c c2, MaxAdListener maxAdListener) {
        Long l2 = this.sdk.a(com.applovin.impl.sdk.c.a.aKN);
        if (l2 <= 0L) {
            return;
        }
        AppLovinSdkUtils.runOnUiThreadDelayed(() -> {
            if (c2.yg().get()) {
                return;
            }
            String string2 = "Ad (" + c2.yS() + ") has not been displayed after " + l2 + "ms. Failing ad display...";
            x.I("MediationService", string2);
            MaxErrorImpl maxErrorImpl = new MaxErrorImpl(-1, string2);
            this.b(c2, maxErrorImpl, maxAdListener);
            this.sdk.CA().ac(c2);
        }, l2);
    }

    public void setCustomPostBodyData(JSONObject jSONObject) {
        this.amO.set(jSONObject);
    }

    public JSONObject getAndResetCustomPostBodyData() {
        return this.amO.getAndSet(null);
    }

    private void a(com.applovin.impl.mediation.b.a a2, MaxError maxError, MaxAdListener maxAdListener) {
        this.a(maxError, a2);
        this.destroyAd(a2);
        m.a(maxAdListener, a2.getAdUnitId(), maxError);
    }

    private void b(com.applovin.impl.mediation.b.a a2, MaxError maxError, MaxAdListener maxAdListener) {
        this.sdk.CC().a(a2, "DID_FAIL_DISPLAY");
        this.a(maxError, a2, true);
        if (a2.yg().compareAndSet(false, true)) {
            m.a(maxAdListener, (MaxAd)a2, maxError);
        }
    }

    public void processWaterfallInfoPostback(String string2, MaxAdFormat maxAdFormat, MaxAdWaterfallInfoImpl maxAdWaterfallInfoImpl, long l2, long l3) {
        if (CollectionUtils.isEmpty(maxAdWaterfallInfoImpl.getPostbackUrls())) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(8);
        CollectionUtils.putStringIfValid("mcode", maxAdWaterfallInfoImpl.getMCode(), hashMap);
        CollectionUtils.putStringIfValid("ad_unit_id", string2, hashMap);
        CollectionUtils.putStringIfValid("ad_format", maxAdFormat.getLabel(), hashMap);
        CollectionUtils.putStringIfValid("name", maxAdWaterfallInfoImpl.getName(), hashMap);
        CollectionUtils.putLongIfValid("request_latency_ms", l3, hashMap);
        CollectionUtils.putLongIfValid("request_start_timestamp_ms", l2, hashMap);
        CollectionUtils.putLongIfValid("wf_latency_ms", maxAdWaterfallInfoImpl.getLatencyMillis(), hashMap);
        List<MaxNetworkResponseInfo> list = maxAdWaterfallInfoImpl.getNetworkResponses();
        ArrayList arrayList = new ArrayList(list.size());
        for (MaxNetworkResponseInfo maxNetworkResponseInfo : list) {
            MaxMediatedNetworkInfo maxMediatedNetworkInfo = maxNetworkResponseInfo.getMediatedNetwork();
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>(5);
            CollectionUtils.putStringIfValid("bcode", ((MaxNetworkResponseInfoImpl)maxNetworkResponseInfo).getBCode(), hashMap2);
            hashMap2.put("name", maxMediatedNetworkInfo.getName());
            CollectionUtils.putLongIfValid("latency_ms", maxNetworkResponseInfo.getLatencyMillis(), hashMap2);
            hashMap2.put("load_state", maxNetworkResponseInfo.getAdLoadState().ordinal());
            MaxErrorImpl maxErrorImpl = (MaxErrorImpl)maxNetworkResponseInfo.getError();
            if (maxErrorImpl != null) {
                HashMap<String, Object> hashMap3 = new HashMap<String, Object>(4);
                hashMap3.put("error_code", maxErrorImpl.getCode());
                hashMap3.put("error_message", maxErrorImpl.getMessage());
                hashMap3.put("third_party_sdk_error_code", maxErrorImpl.getMediatedNetworkErrorCode());
                hashMap3.put("third_party_sdk_error_message", maxErrorImpl.getMediatedNetworkErrorMessage());
                hashMap2.put("error_info", hashMap3);
            }
            arrayList.add(hashMap2);
        }
        hashMap.put("ads_info", arrayList);
        this.a("mwf_info", maxAdWaterfallInfoImpl.getPostbackUrls(), Collections.EMPTY_MAP, hashMap, null, null, false);
    }

    private void d(com.applovin.impl.mediation.b.a a2) {
        this.sdk.CC().a(a2, "DID_LOAD");
        if (a2.xS().endsWith("load")) {
            this.sdk.CC().j(a2);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        long l2 = a2.yb();
        hashMap.put("{LOAD_TIME_MS}", String.valueOf(l2));
        if (a2.getFormat().isFullscreenAd()) {
            u.a a3 = this.sdk.CA().cI(a2.getAdUnitId());
            hashMap.put("{SHOW_ATTEMPT_COUNT}", String.valueOf(a3.FD()));
            hashMap.put("{SHOW_ATTEMPT_TIMESTAMP_MS}", String.valueOf(a3.FC()));
        }
        this.a("load", hashMap, a2);
    }

    private void a(MaxError maxError, com.applovin.impl.mediation.b.a a2) {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        long l2 = a2.yb();
        hashMap.put("{LOAD_TIME_MS}", String.valueOf(l2));
        if (a2.getFormat().isFullscreenAd()) {
            u.a a3 = this.sdk.CA().cI(a2.getAdUnitId());
            hashMap.put("{SHOW_ATTEMPT_COUNT}", String.valueOf(a3.FD()));
            hashMap.put("{SHOW_ATTEMPT_TIMESTAMP_MS}", String.valueOf(a3.FC()));
        }
        this.a("mlerr", hashMap, maxError, a2);
    }

    public void processAdapterInitializationPostback(f f2, long l2, MaxAdapter.InitializationStatus initializationStatus, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("{INIT_STATUS}", String.valueOf(initializationStatus.getCode()));
        hashMap.put("{INIT_TIME_MS}", String.valueOf(l2));
        this.a("minit", hashMap, new MaxErrorImpl(string2), f2);
    }

    public void processRawAdImpression(com.applovin.impl.mediation.b.a a2, a.a a3) {
        Object object;
        this.sdk.CC().a(a2, "WILL_DISPLAY");
        if (a2.xS().endsWith("mimp")) {
            this.sdk.CC().j(a2);
            m.a(a3, (MaxAd)a2);
        }
        if (this.sdk.a(b.aQU).booleanValue()) {
            this.sdk.Cn().a(com.applovin.impl.sdk.d.e.aUp, com.applovin.impl.sdk.d.f.n(a2), System.currentTimeMillis() - this.sdk.Df());
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        if (a2 instanceof c) {
            object = (c)a2;
            hashMap.put("{TIME_TO_SHOW_MS}", String.valueOf(((c)object).ys()));
        }
        object = StringUtils.emptyIfNull(this.sdk.BU());
        hashMap.put("{CUID}", (String)(this.sdk.a(b.aQc) != false ? object : ""));
        this.a("mimp", hashMap, a2);
    }

    public void processViewabilityAdImpressionPostback(e e2, long l2, a.a a2) {
        if (e2.xS().endsWith("vimp")) {
            this.sdk.CC().j(e2);
            m.a(a2, (MaxAd)e2);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("{VIEWABILITY_FLAGS}", String.valueOf(l2));
        hashMap.put("{USED_VIEWABILITY_TIMER}", String.valueOf(e2.yN()));
        String string2 = StringUtils.emptyIfNull(this.sdk.BU());
        hashMap.put("{CUID}", this.sdk.a(b.aQc) != false ? string2 : "");
        this.a("mvimp", hashMap, e2);
    }

    public void processCallbackAdImpressionPostback(com.applovin.impl.mediation.b.a a2, a.a a3) {
        if (a2.xS().endsWith("cimp")) {
            this.sdk.CC().j(a2);
            m.a(a3, (MaxAd)a2);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        String string2 = StringUtils.emptyIfNull(this.sdk.BU());
        hashMap.put("{CUID}", this.sdk.a(b.aQc) != false ? string2 : "");
        this.a("mcimp", hashMap, a2);
    }

    private void a(com.applovin.impl.mediation.b.a a2, a.a a3) {
        this.sdk.CC().a(a2, "DID_CLICKED");
        this.sdk.CC().a(a2, "DID_CLICK");
        if (a2.xS().endsWith("click")) {
            this.sdk.CC().j(a2);
            m.a(a3, (MaxAd)a2);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        String string2 = StringUtils.emptyIfNull(this.sdk.BU());
        hashMap.put("{CUID}", this.sdk.a(b.aQc) != false ? string2 : "");
        this.a("mclick", hashMap, a2);
    }

    public void processAdDisplayErrorPostbackForUserError(MaxError maxError, com.applovin.impl.mediation.b.a a2) {
        this.a(maxError, a2, false);
    }

    private void a(MaxError maxError, com.applovin.impl.mediation.b.a a2, boolean bl) {
        this.a("mierr", Collections.EMPTY_MAP, maxError, a2, bl);
    }

    private void a(g g2, h h2, com.applovin.impl.mediation.g g3) {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("{LOAD_TIME_MS}", String.valueOf(g2.za()));
        CollectionUtils.putStringIfValid("{ADAPTER_VERSION}", g3.getAdapterVersion(), hashMap);
        CollectionUtils.putStringIfValid("{SDK_VERSION}", g3.getSdkVersion(), hashMap);
        this.a("serr", hashMap, g2.getError(), h2);
    }

    private void a(String string2, Map<String, String> map, f f2) {
        this.a(string2, map, null, f2);
    }

    private void a(String string2, Map<String, String> map, MaxError maxError, f f2) {
        this.a(string2, map, maxError, f2, true);
    }

    private void a(String string2, Map<String, String> map, MaxError maxError, f f2, boolean bl) {
        Map<String, String> map2 = CollectionUtils.map(map);
        map2.put("{PLACEMENT}", bl ? StringUtils.emptyIfNull(f2.getPlacement()) : "");
        map2.put("{CUSTOM_DATA}", bl ? StringUtils.emptyIfNull(f2.yX()) : "");
        if (f2 instanceof com.applovin.impl.mediation.b.a) {
            com.applovin.impl.mediation.b.a a2 = (com.applovin.impl.mediation.b.a)f2;
            map2.put("{CREATIVE_ID}", bl ? StringUtils.emptyIfNull(a2.getCreativeId()) : "");
        }
        this.a(string2, null, map2, null, maxError, f2, bl);
    }

    private void a(String string2, List<String> list, Map<String, String> map, @Nullable Map<String, Object> map2, @Nullable MaxError maxError, @Nullable f f2, boolean bl) {
        d d2 = new d(string2, list, map, map2, maxError, f2, this.sdk, bl);
        this.sdk.Cj().a((com.applovin.impl.sdk.e.d)d2, q.a.aVN);
    }

    @Override
    public void onReceive(Intent intent, @Nullable Map<String, Object> map) {
        Object object;
        if ("com.applovin.render_process_gone".equals(intent.getAction()) && (object = this.sdk.CA().FB()) instanceof com.applovin.impl.mediation.b.a) {
            com.applovin.impl.mediation.b.a a2 = (com.applovin.impl.mediation.b.a)object;
            this.a(MaxAdapterError.WEBVIEW_ERROR, a2, true);
        }
    }

    public class a
    implements a.a,
    MaxAdListener,
    MaxAdRevenueListener,
    MaxAdViewAdListener,
    MaxRewardedAdListener {
        private final com.applovin.impl.mediation.b.a amV;
        private a.a amW;

        public a(com.applovin.impl.mediation.b.a a2, a.a a3) {
            this.amV = a2;
            this.amW = a3;
        }

        public void a(a.a a2) {
            this.amW = a2;
        }

        @Override
        public void onAdLoaded(@NonNull MaxAd maxAd) {
            this.a(maxAd, null);
        }

        public void a(@NonNull MaxAd maxAd, @Nullable Bundle bundle) {
            this.amV.S(bundle);
            this.amV.yf();
            MediationServiceImpl.this.d(this.amV);
            m.a(this.amW, maxAd);
        }

        @Override
        public void onAdLoadFailed(@NonNull String string2, @NonNull MaxError maxError) {
            this.amV.yf();
            MediationServiceImpl.this.a(this.amV, maxError, this.amW);
        }

        @Override
        public void onAdDisplayed(@NonNull MaxAd maxAd) {
            this.b(maxAd, null);
        }

        public void b(@NonNull MaxAd maxAd, @Nullable Bundle bundle) {
            this.amV.S(bundle);
            MediationServiceImpl.this.logger;
            if (x.FL()) {
                MediationServiceImpl.this.logger.f("MediationService", "Scheduling impression for ad via callback...");
            }
            MediationServiceImpl.this.processCallbackAdImpressionPostback(this.amV, this.amW);
            MediationServiceImpl.this.sdk.Cm().a(com.applovin.impl.sdk.d.c.aTU);
            MediationServiceImpl.this.sdk.Cm().a(com.applovin.impl.sdk.d.c.aTX);
            if (maxAd.getFormat().isFullscreenAd()) {
                c c2 = (c)maxAd;
                if (c2.yB()) {
                    MediationServiceImpl.this.sdk.CC().a(this.amV, "DID_DISPLAY");
                    MediationServiceImpl.this.sdk.CA().ab(this.amV);
                    m.b(this.amW, maxAd);
                } else {
                    MediationServiceImpl.this.logger;
                    if (x.FL()) {
                        MediationServiceImpl.this.logger.h("MediationService", "Received ad display callback before attempting show" + (c2.xX() ? " for hybrid ad" : ""));
                    }
                }
            } else {
                MediationServiceImpl.this.sdk.CC().a(this.amV, "DID_DISPLAY");
                m.b(this.amW, maxAd);
            }
        }

        @Override
        public void onAdHidden(@NonNull MaxAd maxAd) {
            this.c(maxAd, null);
        }

        public void c(@NonNull MaxAd maxAd, @Nullable Bundle bundle) {
            this.amV.S(bundle);
            MediationServiceImpl.this.sdk.CC().a((com.applovin.impl.mediation.b.a)maxAd, "DID_HIDE");
            long l2 = 0L;
            if (maxAd instanceof c) {
                l2 = ((c)maxAd).yu();
            }
            AppLovinSdkUtils.runOnUiThreadDelayed(() -> {
                if (maxAd.getFormat().isFullscreenAd()) {
                    MediationServiceImpl.this.sdk.CA().ac(maxAd);
                }
                m.c(this.amW, maxAd);
            }, l2);
        }

        @Override
        public void onAdClicked(@NonNull MaxAd maxAd) {
            this.d(maxAd, null);
        }

        public void d(@NonNull MaxAd maxAd, @Nullable Bundle bundle) {
            this.amV.S(bundle);
            MediationServiceImpl.this.a(this.amV, this.amW);
            m.d(this.amW, maxAd);
        }

        @Override
        public void onAdDisplayFailed(@NonNull MaxAd maxAd, @NonNull MaxError maxError) {
            this.a(maxAd, maxError, null);
        }

        public void a(@NonNull MaxAd maxAd, @NonNull MaxError maxError, @Nullable Bundle bundle) {
            this.amV.S(bundle);
            MediationServiceImpl.this.b(this.amV, maxError, this.amW);
            if ((maxAd.getFormat() == MaxAdFormat.REWARDED || maxAd.getFormat() == MaxAdFormat.REWARDED_INTERSTITIAL) && maxAd instanceof c) {
                ((c)maxAd).yx();
            }
        }

        @Override
        public void onRewardedVideoStarted(@NonNull MaxAd maxAd) {
            m.e(this.amW, maxAd);
        }

        @Override
        public void onRewardedVideoCompleted(@NonNull MaxAd maxAd) {
            m.f(this.amW, maxAd);
        }

        @Override
        public void onUserRewarded(@NonNull MaxAd maxAd, @NonNull MaxReward maxReward) {
            this.a(maxAd, maxReward, null);
        }

        public void a(@NonNull MaxAd maxAd, @NonNull MaxReward maxReward, @Nullable Bundle bundle) {
            this.amV.S(bundle);
            m.a((MaxAdListener)this.amW, maxAd, maxReward);
            com.applovin.impl.mediation.d.g g2 = new com.applovin.impl.mediation.d.g((c)maxAd, MediationServiceImpl.this.sdk);
            MediationServiceImpl.this.sdk.Cj().a((com.applovin.impl.sdk.e.d)g2, q.a.aVN);
        }

        @Override
        public void onAdRevenuePaid(@NonNull MaxAd maxAd) {
        }

        @Override
        public void onAdExpanded(@NonNull MaxAd maxAd) {
            this.e(maxAd, null);
        }

        public void e(@NonNull MaxAd maxAd, @Nullable Bundle bundle) {
            this.amV.S(bundle);
            m.g(this.amW, maxAd);
        }

        @Override
        public void onAdCollapsed(@NonNull MaxAd maxAd) {
            this.f(maxAd, null);
        }

        public void f(@NonNull MaxAd maxAd, @Nullable Bundle bundle) {
            this.amV.S(bundle);
            m.h(this.amW, maxAd);
        }

        @Override
        public void onAdRequestStarted(@NonNull String string2) {
        }
    }
}

